/*
 * ----------------------------------------------------------------------------------------------
 *		JAGUAR TOOLBOX APPLICATION PROGRAM INTERFACE
 *		FOR ALL TOS ATARI AND COMPATIBLE
 *
 *	File:		HookJag.c
 *	Author:		FAVARD LAURENT, FunShip(c)
 *	Date:		25 March 1998
 *	Release:	28 October 1998
 *
 *	VERSION : 1.0
 *
 *	Now use its own TRecipient to check if a command is comming from Jaguar
 * ----------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tos.h>
#include <aes.h>

#include	"..\Include\JToolBox.h"
#include	"toolsdef.h"

static	TRecipient			Recipient;
extern	long				IDSempahore;

/*
 * ----------------------------------------------------------------------------------------------
 */

void HookJaguarMessage( void (*UserFonction)(int FrameCode, long SPID, long TPID, int LenghtDatas, TRecipient *Recipient) )
/*
	This fonction check if a frame is arrived and in this case, call the user function given in parameters.
*/
{
	long			SPID, TPID;
    int				L_inCode;
    unsigned int	L_inLenght;
	char			chMessage[100];
	
	Psemaphore( SEM_LOCK, IDSempahore, -1L);
	if( GetFrame( &SPID, &TPID, &L_inCode, &L_inLenght, (void *)&Recipient) != ERR_NO_FRAME )
    {
		switch( L_inCode )
        {
			case	FRAME_USER1:
			case	FRAME_EXCEPTION:
			case	FRAME_DBMSG:
			case	FRAME_MEMSEND:
			case	FRAME_MEMGET:   (*UserFonction)(L_inCode, SPID, TPID, L_inLenght, &Recipient);
                                    break;

			default:				sprintf( chMessage,"[2][ JToolBox | Unexpected Frame received | Code : 0x%X ][Ok]", L_inCode);
									form_alert( 1, chMessage );
									break;

		}
	}
	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
}

