/*
 * ----------------------------------------------------------------------------------------------
 *		JAGUAR TOOLBOX APPLICATION PROGRAM INTERFACE
 *		FOR ALL TOS ATARI AND COMPATIBLE
 *
 *	File:		JToolBox.c
 *	Author:		FAVARD LAURENT, FunShip(c)
 *	Date:		25 March 1998
 *	Release:	29 November 1998
 *
 *	VERSION : 1.0
 *
 * ----------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tos.h>
#include <aes.h>

#include	"..\Include\JToolBox.h"
#include	"toolsdef.h"

/*
 * ----------------------------------------------------------------------------------------------
 *	GLOBAL VARIABLES
 */

int					SessionOpen = FALSE;
TRecipient			Recipient;
long				IDSempahore = 0x41424344L;

/* ---------------------------------------------------------------------------------------------- */
void JTB_Version( TJTBVersion *Version )
{
	strcpy( Version->Version, G_JTOOLBOX_VERSION );
	strcpy( Version->Date, G_JTOOLBOX_DATE );
}

/* ---------------------------------------------------------------------------------------------- */
long JTB_Open( void )
{
	int		inRetour;
	
	if( ( inRetour = (int)Psemaphore( SEM_CREATE, IDSempahore, 0L)) != 0)
	{
		/*switch( inRetour )
		{
			case	ERROR:	break;
			
			case	ERANGE:	
							break;
							
			case	EACCDN:	break;
			
			default:		break;
		}*/
		return	TRUE;
	}
	/*	Il faut librer le smaphore, automatiquement appropri ! */
	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	SessionOpen	=	TRUE;
	return	TRUE;
}

/* ---------------------------------------------------------------------------------------------- */
long JTB_Exit( void )
{
	if( Psemaphore( SEM_DESTROY, IDSempahore, 0L) != 0)
	{
		form_alert(1, "[2][ Unable to kill the sempahore ][]");
		SessionOpen	=	FALSE;
		return	-1L;
	}
	SessionOpen	=	FALSE;
	return	TRUE;
}

/*
 * ----------------------------------------------------------------------------------------------
 */

int Inquire( TJagId *JagIdentification )
{
	long			SPID, TPID;
    int				L_inCode;
    unsigned int	L_inLenght;
	TJagId		   	*L_JagIdentification;

	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_INQUIRE, 0, NULL);
    while( GetFrame( &SPID, &TPID, &L_inCode, &L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
    	;

	if( L_inCode == FRAME_INQUIRE )
    {
        L_JagIdentification	=	(TJagId *)&Recipient;
		*JagIdentification	=	*L_JagIdentification;

		L_inCode	=	JTB_OK;
    }
    else
    	L_inCode	=	JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);

	return	L_inCode;
}

/*
 * ----------------------------------------------------------------------------------------------
 */

int MemoryGet(void *STAddress, TJagMemDesc *JagMemDescriptor)
/*
	This function permit you to do a memory transfer request as Jaguar to ATARI Host under JagOS
    control. For example, download a part of memory to cjeck it... 

*/
{
	long			L_lSPID, L_lTPID;
    int				L_inCode;
    unsigned int	L_inLenght;
    TJagMemDesc 	*L_JagMemDescriptor;

	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_MEMGET,	(unsigned int)sizeof(TJagMemDesc), (void *)JagMemDescriptor);
    while( GetFrame( &L_lSPID, &L_lTPID, &L_inCode,	&L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
    	;

    if( L_inCode == FRAME_MEMGET )
    {
       	L_JagMemDescriptor	=	(TJagMemDesc *)&Recipient;
       	if( L_JagMemDescriptor->StartAddress == JagMemDescriptor->StartAddress )
		{
           	if( L_JagMemDescriptor->Lenght == JagMemDescriptor->Lenght )
           	{
                GetBinaries(TOOLBOX_PID, KERNEL_PID, L_JagMemDescriptor->Lenght, STAddress);
                L_inCode	=	JTB_OK;
           	}
            else
                L_inCode	=	JTB_LENGHT_ERR;
        }
        else
			L_inCode	=	JTB_STARTADR_ERR;
    }
    else
        L_inCode	=	JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);

	return	L_inCode;      
}

/*
 * ----------------------------------------------------------------------------------------------
 */

int MemorySend(void *STAddress, TJagMemDesc *JagMemDescriptor)
/*
	This function permit you to do a memory transfer request as ATARI Host to Jaguar under JagOS
    control. For example, fill a part of memory, upload a program, etc...

*/
{
	long			L_lSPID, L_lTPID;
    int				L_inCode;
    unsigned int	L_inLenght;
    TJagMemDesc 	*L_JagMemDescriptor;

	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_MEMSEND, (unsigned int)sizeof(TJagMemDesc), (void *)JagMemDescriptor);
    while( GetFrame( &L_lSPID, &L_lTPID, &L_inCode,	&L_inLenght, (void *)&Recipient ) == ERR_NO_FRAME )
		;

    if( L_inCode == FRAME_MEMSEND )
	{
       	L_JagMemDescriptor	=	(TJagMemDesc *)&Recipient;
       	if( L_JagMemDescriptor->StartAddress == JagMemDescriptor->StartAddress )
	 	{
           	if( L_JagMemDescriptor->Lenght == JagMemDescriptor->Lenght )
           	{
                SendBinaries(TOOLBOX_PID, KERNEL_PID, L_JagMemDescriptor->Lenght, STAddress);
    		    L_inCode	=	JTB_OK;
           	}
            else
    		    L_inCode	=	JTB_LENGHT_ERR;
        }
        else
	        L_inCode	=	JTB_STARTADR_ERR;
    }
    else
        L_inCode	=	JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);

	return	L_inCode;      
}

/*
 * ----------------------------------------------------------------------------------------------
 */

int LoadAndGo(void *STAddress, TJagProgram *JagProgram)
{
	long			SPID, TPID;
    int				L_inCode;
    unsigned int	L_inLenght;
    TJagProgram 	*L_JagProgram;

	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_PRGSEND, (unsigned int)sizeof(TJagProgram), (void *)JagProgram);
    while( GetFrame( &SPID, &TPID, &L_inCode, &L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
		;

    if( L_inCode == FRAME_PRGSEND )
    {
       	L_JagProgram	=	(TJagProgram *)&Recipient;
       	if( L_JagProgram->TargetAddress == JagProgram->TargetAddress )
		{
           	if( L_JagProgram->Lenght == JagProgram->Lenght )
           	{
           		if( L_JagProgram->StartAddress == JagProgram->StartAddress )
           		{
                    SendBinaries(TOOLBOX_PID, KERNEL_PID, JagProgram->Lenght, STAddress);
    			    L_inCode	=	JTB_OK;
                 }
                 else
    			    L_inCode	=	JTB_STARTADR_ERR;
           	}
            else
		        L_inCode	=	JTB_LENGHT_ERR;
        }
        else
	        L_inCode	=	JTB_TARGETADR_ERR;
    }
    else
        L_inCode	=	JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);

	return	L_inCode;      
}

/*
 * ----------------------------------------------------------------------------------------------
 */

int RunPRG(TJagProgram *JagProgram)
{
	long			SPID, TPID;
    int				L_inCode;
    unsigned int	L_inLenght;

	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_PRGRUN, (unsigned int)sizeof(TJagProgram), (void *)JagProgram);
    while( GetFrame( &SPID, &TPID, &L_inCode, &L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
		;

    L_inCode	=	( L_inCode == FRAME_PRGRUN ) ? JTB_OK : JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);
	return	L_inCode;	   
}


/* ----------------------------------------------------------------------------------------------*/
int MemSend(int Accept, void *STBuffer, TJagMemDesc *JagMemDescriptor)
/*
	This function is used when you want to send a response to the Jaguar which did
    a transfer request as ATARI to Jaguar.

	Transfer asked by the Jaguar:	ATARI Host to Jaguar
    We can accept or refuse this one.	Accept = True  => Transfer accepted
										Accept = False => Transfer refused
*/
{
	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);

	if( Accept )
    {
		SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_ACK, 0, NULL);
		SendBinaries(TOOLBOX_PID, KERNEL_PID, JagMemDescriptor->Lenght, STBuffer);
    }
    else
    {
    	SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_NACK, 0, NULL);
    }

	Psemaphore( SEM_LOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);
	return	JTB_OK;
}

/* ----------------------------------------------------------------------------------------------*/
int MemGet(int Accept, void *STBuffer, TJagMemDesc *JagMemDescriptor)
/*
	This function is used when you want to send a response to the Jaguar which did
    a transfer request as Jaguar to ATARI.

	Transfer asked by the Jaguar:	Jaguar to ATARI Host
    We can accept or refuse this one.	Accept = True  => Transfer accepted
										Accept = False => Transfer refused
*/
{
	graf_mouse(BUSYBEE, NULL);
	Psemaphore( SEM_LOCK, IDSempahore, -1L);

	if( Accept )
    {
		SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_ACK, 0, NULL);
		GetBinaries(TOOLBOX_PID, KERNEL_PID, JagMemDescriptor->Lenght, STBuffer);
    }
    else
    {
    	SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_NACK, 0, NULL);
    }

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	graf_mouse(ARROW, NULL);
	return	JTB_OK;
}

