/*  @(#)PinPoint/main.c, Dirk Haun/Holger Weets, 30.11.1997
 *  @(#)calendar/main.c, Dirk Haun/Holger Weets, 23.08.1998
 *
 *  22.09.1996
 *  30.11.1997  sucht eigenen Namen mit appl_search() und verwendet ihn
 *              fr die inf-Datei, ">>" vor roten Zeilen wird wieder
 *              entfernt (sorry RW ;-), funktioniert auch in Calendar
 *  23.08.1997  Bugfix in calendar: Termine fr morgen/bermorgen/...
 *              wurden u.U. nicht gefunden,
 *              neu in calendar: Kommentarzeilen mit #-Zeichen am Anfang
 */

#include <aes.h>
#include <aesmore.h>
#include <vdi.h>
#include <tos.h>
#include <magic.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <stdlib.h>
#include <vaproto.h>
#include <xacc.h>
#include <xfsl.h>
#include "pinpoint.h"
#define EXTERN extern
#ifdef __PINPOINT__
# include "pinpoint.rh"
#endif
#ifdef __CALENDAR__
# include "calendar.rh"
#endif
#include "stic_dev.h"

#ifdef __PINPOINT__
# define Palloc(a) Malloc(a)
# define Pfree(a)  Mfree(a)
#endif
#ifdef __CALENDAR__
# define Palloc(a) malloc(a)
# define Pfree(a)  free(a)
#endif

#ifndef FALSE
# define TRUE  (1)
# define FALSE (0)
#endif

#define FONT_CHANGED        0x7A18
#define FONT_SELECT         0x7A19
#define FONT_ACK            0x7A1A

#define ACC_ACK             0x0500
#define ACC_TEXT            0x0501
#define ACC_KEY             0x0502

#ifdef __PINPOINT__
# define PROGNAME "PinPoint"
# define FILENAME "pinpoint"
#endif
#ifdef __CALENDAR__
# define PROGNAME "Calendar"
# define FILENAME "calendar"
#endif

#define MAX_LINES 20
#define XBORDER 3
#define YBORDER 2
#define LWIDTH 1
#define LDIST  1
#define LSPACE 2

#define show_mouse()     graf_mouse(257,0L)
#define hide_mouse()     graf_mouse(256,0L)
#define set_mouse(a)     graf_mouse(a,0L)
#define fexists(a)       (Fattrib(a,0,0)>=0)

extern int rc_intersect(GRECT *p1,GRECT *p2);
extern int get_cookie(long cookie,long *val);
extern int appl_xgetinfo(int type,int *out1,int *out2,int *out3,int *out4);
extern int InqMagX(void);

static int    vwk, handle = -1;
static int    gl_apid;
static int    av_server = -1, font_sel = -1;
static GRECT  desk;
static void  *Inf = 0L;
static char   InfPath[128];
static int    Loaded;
static char  *xacc_name = 0L;
static int   *xacc_mem;
static char   my_name[10], my_filename[16];

typedef struct
{
  int   FontID;
  int   FontPts;
  GRECT size;
  int   vektor_font;
} CFG;
static CFG Cfg;

#ifdef __CALENDAR__
typedef struct
{
  int   work,
        more;
  char *none,
       *always;
  char *head[7];
} CALPAR;

static CALPAR Par =
{
  TRUE, /* morgen = nchster Arbeitstag */
  1,    /* 1 Tag voraus */
  "(keine Termine)",
  "Heute ist %G, der %D.%M.%Y",
  { 0L, "%1", "%2", "%3", 0L, 0L, 0L }
};
#endif

static char *lines[MAX_LINES+1];  /* Zeiger auf die Zeilen (+ NULL-Zeiger als Endekennung) */
static int   liney[MAX_LINES];    /* y-Koordinaten der Zeilen */

#ifdef __PINPOINT__
#define XDSC_SIZE 32
const char my_xdsc[] = "XDSC\0\061Notizblock\0\062GT\0XFontAck\0\0\0"; /* fr AV- und XACC-Protokoll */
const char sccsid[]  = "@(#)PinPoint, "__DATE__", Dirk Haun/Holger Weets";
#endif
#ifdef __CALENDAR__
#define XDSC_SIZE 30
const char my_xdsc[] = "XDSC\0\061Kalender\0\062GT\0XFontAck\0\0\0"; /* fr AV- und XACC-Protokoll */
const char sccsid[]  = "@(#)Calendar, "__DATE__", Dirk Haun/Holger Weets";
#endif


void xacc_send (int what, int to)
{
  int msg[8];

  msg[0] = what;
  msg[1] = _GemParBlk.global[2];
  msg[2] = 0;
#ifdef __PINPOINT__
  msg[3] = 0x1101; /* Version 1.1, Msg.Group 1 */
#endif
#ifdef __CALENDAR__
  msg[3] = 0x1000; /* Version 1.0, Msg.Group 0 */
#endif
  *(char**) &msg[4] = xacc_name + strlen (xacc_name) + 1;
  msg[6] = -1;
  msg[7] = 0;
  appl_write (to, 16, msg);
}

void xacc_init (void)
{
  int   i, id, type;
  char *cp, name[10];

  xacc_name = Mxalloc (XDSC_SIZE + 20, 0x43);
  if (xacc_name == (char*) -32L)
  {
    xacc_name = Palloc (XDSC_SIZE + 20);
  }
  if (xacc_name > 0L)
  {
    strcpy (xacc_name, my_name);
    cp = xacc_name;
    while (*cp)
    {
      *cp++ = toupper (*cp);
    }
    cp++;
    strcpy (cp, my_name);
    cp += strlen (cp);
    cp++;
    for (i = 0; i < XDSC_SIZE; i++)
    {
      *cp++ = my_xdsc[i];
    }
    if (appl_search (0, name, &type, &id) == 1)
    {
      do
      {
        xacc_send (ACC_ID, id);
      } while (appl_search (1, name, &type, &id) == 1);
    }
  }
  else
  {
    xacc_name = my_name;
  }
}

void xacc_new (int id, char *name)
{
  int i;

  if (font_sel < 0)
  {
    name += strlen (name) + 1;
    if (strcmp (name, "XDSC") == 0)
    {
      name += 5;
      while (*name)
      {
        if (strcmp (name, "XFontSelect") == 0)
        {
          font_sel = id;
          break;
        }
        else
          name += strlen (name) + 1;
      }
    }
  }

  for (i = 0; i < 64; i++)
    if ((xacc_mem[i] == -1) || (xacc_mem[i] == id))
    {
      xacc_mem[i] = id;
      break;
    }
}

void xacc_exit (void)
{
  int i, msg[8];

  msg[0] = ACC_EXIT;
  msg[1] = _GemParBlk.global[2];
  for (i = 2; i < 8; i++)
    msg[i] = 0;

  for (i = 0; i < 64; i++)
    if (xacc_mem[i] >= 0)
    {
      appl_write (xacc_mem[i], 16, msg);
    }
}

void xacc_bye (int id)
{
  int i;

  for (i = 0; i < 64; i++)
    if (xacc_mem[i] == id)
    {
      xacc_mem[i] = -1;
      break;
    }
  if (id == font_sel)
    font_sel = -1;
}

void av_name (char *to, char *from)
{
  int i;

  for (i = 0; i < 8; i++)
    to[i] = ' ';
  to[9] = '\0';
  for (i = 0; i < 8; i++)
    if ((from[i] == ' ') || (from[i] == '\0'))
      break;
    else
      to[i] = from[i];
}

int find_av (void)
{
  int   av, dummy;
  char *env, name[10];

  av = appl_find ("GEMINI  ");
  if (av < 0)
  {
    av = appl_find ("THING   ");
    if (av < 0)
    {
      av = appl_find ("EASE    ");
      if (av < 0)
      {
        av = appl_find ("MAGXDESK");
        if (av < 0)
        {
          shel_envrn (&env, "AVSERVER");
          if (env)
          {
            av_name (name, env);
            av = appl_find (name);
            if (av < 0)
            {
              env = getenv ("AVSERVER");
              av_name (name, env);
              av = appl_find (name);
              if (av < 0)
                appl_search (2, name, &dummy, &av);
            }
          }
        }
      }
    }
  }

  return (av);
}

int AV_Message (int what, ...)
{
  int      id, msg[8];
  char    *cp;
  va_list  pp;

  va_start (pp, what);
  msg[0] = what;
  msg[1] = _GemParBlk.global[2];
  msg[2] = 0;
  msg[3] = va_arg (pp, int);
  msg[4] = va_arg (pp, int);
  msg[5] = va_arg (pp, int);
  msg[6] = va_arg (pp, int);
  msg[7] = va_arg (pp, int);
  if (what == AV_STARTPROG && ((cp = getenv ("EDITOR")) != 0L))
  {
    msg[5] = msg[3];
    msg[6] = msg[4];
    msg[3] = (int) (((long) cp) >> 16);
    msg[4] = (int) cp;
  }
  else if (what == FONT_SELECT)
  {
    if (font_sel < 0)
      id = av_server;
    else
      id = font_sel;
  }
  else
  {
    if (av_server < 0)
      id = find_av ();
    else
      id = av_server;
  }
  if ((id < 0) && (msg[0] == AV_PROTOKOLL))
    appl_write (0, 16, msg);
  else if (id >= 0)
    appl_write (id, 16, msg);
  va_end (pp);

  return (id);
}

void PageOut (void)
{
  int  cnt, pxy[4], lxy[4];
  CFG *c = &Cfg;

  hide_mouse ();
  pxy[0] = c->size.g_x - XBORDER;
  pxy[1] = c->size.g_y - YBORDER;
  pxy[2] = pxy[0] + c->size.g_w + (2*XBORDER) - 1;
  pxy[3] = pxy[1] + c->size.g_h + (2*YBORDER) - 1;
  v_bar (vwk, pxy);
  pxy[0] = c->size.g_x;
  pxy[1] = c->size.g_y;

  for (cnt = 0; lines[cnt]; cnt++)
  {
    if (lines[cnt][0] == 5)
    {
      vst_color (vwk, (int) lines[cnt][1]);
      if (Cfg.vektor_font)
        v_ftext (vwk, pxy[0], c->size.g_y + liney[cnt], &lines[cnt][2]);
      else
        v_gtext (vwk, pxy[0], c->size.g_y + liney[cnt], &lines[cnt][2]);
      vst_color (vwk, BLACK);
    }
    else if ((lines[cnt][0] <= 0) || (lines[cnt][0] > 3))
    {
      if (Cfg.vektor_font)
        v_ftext (vwk, pxy[0], c->size.g_y + liney[cnt], lines[cnt]);
      else
        v_gtext (vwk, pxy[0], c->size.g_y + liney[cnt], lines[cnt]);
    }
    else
    {
      vsl_type (vwk, 7);
      lxy[0] = pxy[0] - XBORDER;
      lxy[1] = c->size.g_y + liney[cnt] + LSPACE;
      lxy[2] = pxy[2];
      lxy[3] = lxy[1];
      vsl_udsty (vwk, 0xAAAA);
      v_pline (vwk, 2, lxy);

      if (lines[cnt][0] > 1)
      {
        lxy[1] += LWIDTH + LDIST;
        lxy[3] += LWIDTH + LDIST;
        vsl_udsty (vwk, 0x5555);
        v_pline (vwk, 2, lxy);

        if (lines[cnt][0] == 3)
        {
          lxy[1] += LWIDTH + LDIST;
          lxy[3] += LWIDTH + LDIST;
          vsl_udsty (vwk, 0xAAAA);
          v_pline (vwk, 2, lxy);
        }
      }
    }
  }
  show_mouse ();
}

void RedrawDialog(GRECT *b)
{
  int    work[4];
  int   *w = work;
  GRECT  rc;

  wind_get (handle, WF_FIRSTXYWH, &rc.g_x, &rc.g_y, &rc.g_w, &rc.g_h);

  while (rc.g_w && rc.g_h)
  {
    *(GRECT*)w = *b;
    w[0]--;
    w[1]--;
    w[2]++;
    w[3]++;

    rc_intersect (&desk, &rc);         /* mit Bildschirm schneiden */
    if (rc_intersect (&rc, (GRECT*)w))
    {
      w[2] += w[0] - 1;
      w[3] += w[1] - 1;
      vs_clip (vwk, 1, w);
      PageOut ();
    }

    wind_get (handle, WF_NEXTXYWH, &rc.g_x, &rc.g_y, &rc.g_w, &rc.g_h);
  }
}

void vqt_real_extent (int handle, char *string, int *extent)
{
  int i;
  VDIPB v = { _VDIParBlk.contrl, _VDIParBlk.intin, _VDIParBlk.ptsin, _VDIParBlk.intout, _VDIParBlk.ptsout };

  for (i = 0; string[i]; i++)
    _VDIParBlk.intin[i] = string[i];

  _VDIParBlk.ptsin[0] = 0;
  _VDIParBlk.ptsin[1] = 0;
  _VDIParBlk.contrl[0] = 240;
  _VDIParBlk.contrl[1] = 1;
  _VDIParBlk.contrl[3] = i;
  _VDIParBlk.contrl[5] = 4200;
  _VDIParBlk.contrl[6] = handle;

  vdi (&v);

  for (i = 0; i < 8; i++)
    extent[i] = _VDIParBlk.ptsout[i];
}

void window_width (int *w, int *h)
{
  int i, ext[8];
  int width = 0, height = 0, full_height = 0;
  int *nvdip, nvdi = -1;

  for (i = 0; lines[i]; i++)
  {
    if ((lines[i][0] <= 0) || (lines[i][0] > 3))
    {
      if (Cfg.vektor_font)
      {
        if (nvdi < 0)
        {
          if (get_cookie ('NVDI', (long*) &nvdip))
            nvdi = *nvdip;
          else
            nvdi = 0;
        }
        if (nvdi >= 0x0300)
          vqt_real_extent (vwk, lines[i], ext);
        else
          vqt_f_extent (vwk, lines[i], ext);
      }
      else
        vqt_extent (vwk, lines[i], ext);
      if (ext[7] - ext[1] > height)
        height = ext[7] - ext[1];
      if (ext[2] - ext[0] > width)
        width = ext[2] - ext[0];
    }
  }

  for (i = 0; lines[i]; i++)
  {
    liney[i] = full_height;
    if (lines[i][0] == 1)
      full_height += (LWIDTH + 2*LSPACE);
    else if (lines[i][0] == 2)
      full_height += (2*LWIDTH + 2*LSPACE + LDIST);
    else if (lines[i][0] == 3)
      full_height += (3*LWIDTH + 2*LSPACE + 2*LDIST);
    else
      full_height += height + 1;
  }
  *w = width + 1;
  *h = full_height;
}

void SetFont (int draw, int fnt, int points)
{
  CFG   *c = &Cfg;
  int    d;
  GRECT  g;
  long   gd;
  static int vektor_gdos = -1;

  if (fnt == 0)
    fnt = c->FontID;
  if (points <= 0)
    points = c->FontPts;

  gd = vq_vgdos ();
  if (gd != -2L)
  {
    if (vektor_gdos == -1)
    {
      if ((gd == '_FSM') || get_cookie ('FSMC', (long*)&gd))
        vektor_gdos = 1;
      else
        vektor_gdos = 0;
    }

    if ((fnt != 1) && (Loaded == 0))                 /* Fonts schon geladen? */
      Loaded = vst_load_fonts(vwk, 0);               /* Fonts laden */
    vst_font(vwk, fnt);                              /* Font auswhlen */
    if (vektor_gdos && ((fnt < 0) || (fnt > 5000)))  /* Murks, ich wei ... */
    {
      vst_arbpt (vwk, points, &d, &d, &d, &d);
      c->vektor_font = TRUE;
    }
    else
    {
      vst_point(vwk, points, &d, &d, &d, &d);        /* Gre einstellen */
      c->vektor_font = FALSE;
    }
    c->FontID = fnt;
    c->FontPts = points;
  }

  if (handle > 0)
    window_width (&c->size.g_w, &c->size.g_h);

  if (draw)
  {
    wind_calc (WC_BORDER, 0, c->size.g_x - XBORDER, c->size.g_y - YBORDER,
               c->size.g_w + (2 * XBORDER), c->size.g_h + (2 * YBORDER),
               &g.g_x, &g.g_y, &g.g_w, &g.g_h);
    wind_set (handle, WF_CURRXYWH, g.g_x, g.g_y, g.g_w, g.g_h);
    RedrawDialog (&g);
  }
}

#ifdef __PINPOINT__
static void get_time (DOSTIME *t)
{
  int fh;

  if (InfPath[0])
  {
    fh = (int) Fopen (InfPath, 0);
    if (fh > 0)
    {
      Fdatime (t, fh, 0);
      Fclose (fh);
    }
  }
}
#endif

static void cwd (char *path)
{
  strcpy (path, "A:");
  Dgetpath (&path[2], 0);
  path[0] = Dgetdrv () + 'A';
  if (path[strlen (path)] != '\\')
    strcat (path, "\\");
}

void InitPath (void)
{
  char *cp, path[128];

  strcpy (path, my_filename);
  shel_find (path);
  if (path[1] == ':')
    strcpy (InfPath, path);
  else
  {
    cwd (InfPath);
    strcat (InfPath, my_filename);
    if (!fexists (InfPath))
    {
      cp = getenv ("HOME");
      if (cp)
      {
        strcpy (InfPath, cp);
        if (InfPath[strlen (InfPath) - 1] != '\\')
          strcat (InfPath, "\\");
        strcat (InfPath, "defaults\\");
        strcat (InfPath, my_filename);
        if (!fexists (InfPath))
        {
          strcpy (&InfPath[strlen (InfPath) - strlen (my_filename) - 9], my_filename);
        }
      }
    }
  }
}

#ifdef __PINPOINT__
int DoInf (int first)
{
  int            cnt, start = FALSE, rv = FALSE;
  register char *p, *q;
  CFG           *c = &Cfg;
  GRECT          g;

  p = q = Inf;
  cnt = 0;
  lines[cnt++] = p;
  start = TRUE;
  while (*p)
  {
    if ((*p == 13) || (*p == 10))
    {
      if ((*p == 13) && (*(p + 1) == 10))
        p++;
      if (cnt == MAX_LINES)
      {
        lines[cnt] = 0L;
        break;
      }
      *q++ = '\0';
      lines[cnt++] = q;
      *q = '\0';
      start = TRUE;
    }
    else
    {
      if (start)
      {
        if ((*p == '-') || (*p == '_') || (*p == '') || (*p == '=') || (*p == (char)''))
        {
          if ((*p == *(p + 1)) && (*(p + 1) == *(p + 2))) /* drei gleiche Zeichen? */
          {
            if (*p == '')
              *q++ = 3;
            else if (*p == '=')
              *q++ = 2;
            else
              *q++ = 1;
            while ((*p != 10) && (*p != 13) && (*p))
              p++;
            p--;
          }
          else
            *q++ = *p;
        }
        else if ((*p == '>') && (*(p + 1) == '>'))
        {
          *q++ = 5;
          *q++ = RED;
#ifdef __LEAVE_QUOTES_IN__
          *q++ = '>';
          *q++ = '>';
#endif
          p++;
        }
        else
          *q++ = *p;
      }
      else
        *q++ = *p;
      start = FALSE;
    }
    p++;
  }
  while (lines[cnt - 1][0] == '\0')
    cnt--;
  lines[cnt] = 0L;
  *q++ = '\0';
  *q++ = '\0';

  window_width (&c->size.g_w, &c->size.g_h);
  rv=TRUE;

  if(first)
  {
    handle = wind_create (0, desk.g_x, desk.g_y, desk.g_w, desk.g_h);
    if (handle < 0)
      rv = FALSE;
    else
      wind_set (handle, WF_BEVENT, 1, 0, 0, 0);
  }
  if (rv)
  {
    wind_calc (WC_BORDER, 0, c->size.g_x - XBORDER, c->size.g_y - YBORDER, c->size.g_w + (2*XBORDER),
               c->size.g_h + (2*YBORDER), &g.g_x, &g.g_y, &g.g_w, &g.g_h);
    if (first)
      wind_open (handle, g.g_x, g.g_y, g.g_w, g.g_h);
    else
    {
      wind_set (handle, WF_CURRXYWH, g.g_x, g.g_y, g.g_w, g.g_h);
      RedrawDialog (&g);
    }
  }

  return (rv);
}
#endif

#ifdef __CALENDAR__
#define LANG   2
#define MONTH 12
#define DAY    7

#define SECS_PER_MIN    (60L)
#define SECS_PER_HOUR   (3600L)
#define SECS_PER_DAY    (86400L)
#define SECS_PER_YEAR   (31536000L)

static const int
mth_start[13] = { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 };

static const char *month[LANG][MONTH] =
{
  {
    "Januar", "Februar", "Mrz", "April", "Mai", "Juni", "Juli",
    "August", "September", "Oktober", "November", "Dezember"
  },
  {
    "January", "February", "March", "April", "May", "June", "July",
    "August", "September", "October", "November", "December"
  }
};

static const char *day[LANG][DAY] =
{
  {
    "Sonntag", "Montag", "Dienstag", "Mittwoch",
    "Donnerstag", "Freitag", "Samstag"
  },
  {
    "Sunday", "Monday", "Tuesday", "Wednesday",
    "Thursday", "Friday", "Saturday"
  },
};

static int weekday (unsigned int dosdate)
{
  int   y, wday;
  int   mday, mon, year;
  long  s;

  mday = dosdate & 31;
  mon = ((dosdate >> 5) & 15) - 1;
  year = 80 + ((dosdate >> 9) & 255);

  y = (mday - 1) + mth_start[mon] + /* leap year correction */
      ( ( (year % 4) != 0 ) ? 0 : (mon > 1) );

  s = 1 + SECS_PER_MIN + SECS_PER_HOUR + /* feste Uhrzeit "01:01.01" */
      (y * SECS_PER_DAY) + ((year - 70) * SECS_PER_YEAR) +
      ((year - 69) / 4) * SECS_PER_DAY;

  wday = (int) (((s / SECS_PER_DAY) + 4) % 7);

  return (wday);
}

static void make_str (char *to, char *from, unsigned int date)
{
  int mday, mon, year, y, w;
  char *rp, *wp;

  mday = date & 31;
  mon = ((date >> 5) & 15);
  year = 80 + ((date >> 9) & 255);
  w = weekday (date);

  rp = from;
  wp = to;
  while (*rp)
  {
    if (*rp == '%')
    {
      rp++;
      switch (*rp)
      {
        case 'd':
          if (mday > 9)
            *wp++ = (mday / 10) + '0';
          *wp++ = (mday % 10) + '0';
        break;

        case 'm':
          if (mon > 9)
            *wp++ = (mon / 10) + '0';
          *wp++ = (mon % 10) + '0';
        break;

        case 'D':
          *wp++ = (mday / 10) + '0';
          *wp++ = (mday % 10) + '0';
        break;

        case 'M':
          *wp++ = (mon / 10) + '0';
          *wp++ = (mon % 10) + '0';
        break;

        case 'Y':
          y = (year + 1900) / 100;
          *wp++ = (y / 10) + '0';
          *wp++ = (y % 10) + '0';
          /* kein break */
        case 'y':
          y = year % 100;
          *wp++ = (y / 10) + '0';
          *wp++ = (y % 10) + '0';
        break;

        case 'g':
          strcpy (wp, day[0][w]);
          wp += 2; /* 2-Buchstaben-Krzel */
        break;

        case 'e':
          strcpy (wp, day[1][w]);
          wp += 3; /* 3-Buchstaben-Krzel */
        break;

        case 'G':
          strcpy (wp, day[0][w]);
          wp += strlen (wp);
        break;

        case 'E':
          strcpy (wp, day[1][w]);
          wp += strlen (wp);
        break;

        default: *wp++ = *rp;
      }
      rp++;
    }
    else
      *wp ++ = *rp++;
  }
  *wp++ = '\0';
}

static int datematch (unsigned int date, char *line)
{
  int   i, d, dt, m, mn, len;
  char *cp, sh[4];

  d = (date & 0x1f);
  m = ((date >> 5) & 0x0f) ;
  for (i = 0; i < LANG; i++)
  {
    cp = strstr (line, month[i][m - 1]);
    if (cp == 0L)
    {
      strncpy (sh, month[i][m - 1], 3);
      sh[3] = '\0';
      cp = strstr (line, sh);
      if (cp)
        len = 3;
    }
    else
      len = (int) strlen (month[i][m - 1]);
    if (cp)
    {
      cp += len;
      if ((*cp == ' ') || (*cp == '\t'))
      {
        cp++;
        if (isdigit (*cp))
        {
          dt = (*cp++) - '0';
          if (isdigit (*cp))
          {
            dt *= 10;
            dt += (*cp - '0');
            if (dt == d)
              return (TRUE);
          }
        }
      }
      cp -= len;
      cp--;
      while (cp > line)
      {
        if ((*cp == ' ') || (*cp == '\t') || (*cp == '.'))
          cp--;
        else
          break;
      }
      if ((cp >= line) && (isdigit (*cp)))
      {
        dt = *cp - '0';
        if (cp > line)
        {
          cp--;
          if (isdigit (*cp))
            dt += (*cp - '0') * 10;
        }
        if (dt == d)
          return (TRUE);
      }
    }
    else /* kein Monatsname, vielleicht als Ziffern? */
    {
      /* deutsches Datumsformat "dd.mm."? */
      cp = line;
      do
      {
        cp = strchr (cp, '.');
        if (cp && isdigit (*(cp - 1)) && isdigit (*(cp + 1)))
        {
          if ((*(cp + 2) == '.') || (isdigit(*(cp + 2)) && (*(cp + 3) == '.')))
          {
            dt = *(cp - 1) - '0';
            if (isdigit (*(cp - 2)))
              dt += (*(cp - 2) - '0') * 10;
            mn = *(cp + 1) - '0';
            if (isdigit (*(cp + 2)))
            {
              mn *= 10;
              mn += *(cp + 2) - '0';
            }
            if ((dt == d) && (mn == m))
              return (TRUE);
          }
        }
        if (cp)
          cp++;
      }
      while (cp);

      /* amerikanisches Format "mm/dd"? */
      cp = line;
      do
      {
        cp = strchr (cp, '/');
        if (cp && isdigit (*(cp - 1)) && isdigit (*(cp + 1)))
        {
          mn = *(cp - 1) - '0';
          if (isdigit (*(cp - 2)))
            mn += (*(cp - 2) - '0') * 10;
          dt = *(cp + 1) - '0';
          if (isdigit (*(cp + 2)))
          {
            dt *= 10;
            dt += *(cp + 2) - '0';
          }
          if ((dt == d) && (mn == m))
            return (TRUE);
        }
        if (cp)
          cp++;
      }
      while (cp);

    }
  }

  return (FALSE);
}

unsigned int morgen (unsigned int heute, int werktag)
{
  unsigned int d, m, y, v, w, neu;
  static unsigned int md[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

  d = (heute & 0x1f);
  m = ((heute >> 5) & 0x0f);
  y = (heute >> 9) + 1980;
  if (m == 2)
  {
    if ((y % 4) == 0)
    {
      if ((y % 400) == 0)
        v = 29;
      else if ((y % 100) == 0)
        v = 28;
      else
        v = 29;
    }
    else
      v = 28;
  }
  else
    v = md[m - 1];

  if (werktag)
  {
    w = weekday (heute);
    if (w == 6) /* Samstag */
      d += 2;
    else if (w == 5) /* Freitag */
      d += 3;
    else /* sonst, inkl. Sonntag */
      d++;
  }
  else
    d++;
  if (d > v)
  {
    d -= v;
    m++;
    if (m > 12)
    {
      m = 1;
      y++;
    }
  }
  neu = ((y - 1980) << 9) | (m << 5) | d;

  return (neu);
}

static char *make_head (char *pattern, unsigned int date)
{
  char *cp = 0L, str[128];
  static char *xlines[] = { "\1", "\2", "\3" };

  if ((pattern[0] == '%') && ((pattern[1] >= '0') && (pattern[1] <= '3')))
  {
    if (pattern[1] == '0')
      return (0L);
    cp = Palloc (2);
    if (cp)
      strcpy (cp, xlines[pattern[1] - '1' ]);
  }
  else
  {
    make_str (str, pattern, date);
    cp = Palloc (strlen (str) + 1);
    if (cp)
      strcpy (cp, str);
  }
  return (cp);
}

int DoInf (int first)
{
  int           i, cnt, did_head, found = FALSE, rv = FALSE;
  unsigned int  date;
  char         *p, *r;
  CFG          *c = &Cfg;
  GRECT         g;

  if (!first)
  {
    for (i = 0; i < MAX_LINES; i++)
    {
      if (lines[i])
        Pfree (lines[i]);
      lines[i] = 0L;
    }
  }

  date = Tgetdate ();
  cnt = 0;
  if (Par.always)
  {
    lines[cnt] = make_head (Par.always, date);
    if (lines[cnt])
      cnt++;
  }
  for (i = 0; (i <= Par.more) && (cnt < MAX_LINES); i++)
  {
    did_head = FALSE;
    p = Inf;
    while (*p)
    {
      if (*p == '#') /* Kommentarzeile, -dh- 23.08.1998 */
      {
        /* Zeile berspringen */
        while ((*p != 13) && (*p != 10))
          p++;
        while ((*p == 13) || (*p == 10))
          p++;
      }
      else
      {
        r = p;
        while ((*r != 13) && (*r != 10) && (*r != '\0'))
          r++;
        *r = '\0';
        if (datematch (date, p))
        {
          if (!did_head)
          {
            if (Par.head[i])
            {
              lines[cnt] = make_head (Par.head[i], date);
              if (lines[cnt])
              {
                if ((cnt == 0) && ((lines[cnt][0] >= 1) && (lines[cnt][1] <= 3)))
                  free (lines[cnt]);
                else
                  cnt++;
              }
            }
            did_head = TRUE;
          }
          lines[cnt] = Palloc(strlen (p) + 1);
          if (lines[cnt])
          {
            if ((*p == '>') && (*(p + 1) == '>'))
            {
              lines[cnt][0] = 5;
              lines[cnt][1] = RED;
              strcpy (&lines[cnt][2], p + 2);
            }
            else
            {
              strcpy (lines[cnt], p);
            }
            cnt++;
            found = TRUE;
          }
        }
        p += strlen (p) + 1;
        *r = 13; /* 13 oder 10, nur kein Nullbyte, -dh- 23.08.1998 */
        while ((*p == 13) || (*p == 10))
          p++;
      }
    }
    date = morgen (date, Par.work);
  }
  if (cnt > MAX_LINES)
    cnt = MAX_LINES;

  if (!found && (Par.none))
  {
    lines[cnt] = make_head (Par.none, Tgetdate ());
    if (lines[cnt])
      cnt++;
  }
  lines[cnt] = 0L;

  window_width (&c->size.g_w, &c->size.g_h);
  rv=TRUE;

  if(first)
  {
    handle = wind_create (0, desk.g_x, desk.g_y, desk.g_w, desk.g_h);
    if (handle < 0)
      rv = FALSE;
    else
      wind_set (handle, WF_BEVENT, 1, 0, 0, 0);
  }
  if (rv)
  {
    wind_calc (WC_BORDER, 0, c->size.g_x - XBORDER, c->size.g_y - YBORDER, c->size.g_w + (2*XBORDER),
               c->size.g_h + (2*YBORDER), &g.g_x, &g.g_y, &g.g_w, &g.g_h);
    if (first)
      wind_open (handle, g.g_x, g.g_y, g.g_w, g.g_h);
    else
    {
      wind_set (handle, WF_CURRXYWH, g.g_x, g.g_y, g.g_w, g.g_h);
      RedrawDialog (&g);
    }
  }

  Pfree (Inf);
  Inf = 0L;

  return (rv);
}

int ReadCalInf (void)
{
  int    fh, rv = FALSE;
  long   len;
  char  *p, *cp, c, path[128];

  strcpy (path, InfPath);
  strcat (path, ".inf");
  fh = (int) Fopen (path, 0);
  if (fh >= 0)
  {
    len = Fseek (0L, fh, 2);
    Fseek (0L, fh, 0);
    p = (char*) Palloc (len + 2);
    if (p)
    {
      Fread (fh, len, p);
      p[len] = 0;
      p[len + 1] = 0;

      cp = p;
      while (*cp)
      {
        while ((*cp == ' ') || (*cp == '\t'))
          cp++;
        if (*cp != '#')
        {
          c = *cp;
          cp += 2;
          switch (c)
          {
            case '+':
              if ((*cp == 'w') || (*cp == 'W'))
              {
                Par.work = TRUE;
                cp++;
              }
              else
                Par.work = FALSE;
              if ((*cp >= '0') && (*cp <= '6'))
                Par.more = *cp - '0';
            break;

            case '-':
              Par.none = cp;
              while ((*cp != 10) && (*cp != 13) && (*cp != '\0'))
                cp++;
              *cp++ = '\0';
            break;

            case '*':
              Par.always = cp;
              while ((*cp != 10) && (*cp != 13) && (*cp != '\0'))
                cp++;
              *cp++ = '\0';
            break;

            default:
              if ((c >= '0') && (c <= '6'))
              {
                Par.head[c - '0'] = cp;
                while ((*cp != 10) && (*cp != 13) && (*cp != '\0'))
                  cp++;
                *cp++ = '\0';
              }
          }
        }
        while ((*cp != 10) && (*cp != 13) && (*cp != '\0'))
          cp++;
        while ((*cp == 10) || (*cp == 13))
          cp++;
      }

      rv = TRUE;
    }
    Fclose(fh);
  }

  return (rv);
}

#endif

int LoadInf (int first)
{
  int    fh, rv = FALSE;
  long   len;
  char  *p;

  fh = (int) Fopen (InfPath, 0);
  if (fh >= 0)
  {
    len = Fseek (0L, fh, 2);
    Fseek (0L, fh, 0);
    p = (char*) Palloc (len + 2);
    if (p)
    {
      Fread (fh, len, p);
      if (Inf)
        Pfree (Inf);
      Inf = p;
      p[len] = 0;
      p[len + 1] = 0;

      rv = TRUE;
    }
    Fclose(fh);
  }

  if (rv)
    rv = DoInf (first);

  return (rv);
}

void OpenVDI(void)
{
  int           work_in[12], work_out[57], d;
  register int  i;
  CFG          *c = &Cfg;

  /*
   * beim VDI anmelden
   */
  for (i = 0; i < 10; i++)
    work_in[i] = 1;
  work_in[10] = 2;
  vwk = graf_handle (&d, &d, &d, &d);
  v_opnvwk (work_in, &vwk, work_out);
  vst_alignment (vwk, 0, 5, &d, &d);   /* v_gtext links oben */
  SetFont (0, c->FontID, c->FontPts);

  /* Fllmuster vorbereiten */
  vsf_perimeter (vwk, FALSE);
  vsf_color (vwk, 0);
  vsf_interior (vwk, FIS_SOLID);
  vsf_style (vwk, IP_SOLID);
}

static void who_am_i (void)
{
  int   dummy, test, id;
  char *cp, ap_name[16];

  strcpy (my_name, PROGNAME);
  strcpy (my_filename, FILENAME);

  if (appl_xgetinfo (4, &dummy, &dummy, &test, &dummy) && (test & 1))
  {
    if (appl_search (0, ap_name, &dummy, &id))
    {
      do
      {
        if(id == gl_apid)
        {
          cp = strchr (ap_name, ' ');
          if (cp)
          {
            *cp = '\0';
          }
          cp = ap_name;
          while (*cp)
          {
            *cp++ = tolower (*cp);
          }
          strcpy (my_name, ap_name);
          my_name[0] = toupper (my_name[0]);
          strcpy (my_filename, ap_name);
#ifdef __PINPOINT__
          strcat (my_filename, ".inf");
#endif
          break;
        }
      }
      while (appl_search (1, ap_name, &dummy, &id));
    }
  }
}

void SavePar(void)
{
  int   h;
  char *p, path[128];

  p = path;
  strcpy(p, InfPath);
#ifdef __PINPOINT__
  p += strlen (p) - 3;
  strcpy (p, "cfg");
#endif
#ifdef __CALENDAR__
  strcat (p, ".cfg");
#endif
  h = (int) Fcreate (path, 0);
  if (h > 0)
  {
    Fwrite (h, (long) sizeof(CFG), &Cfg);
    Fclose (h);
  }
}

void LoadPar (void)
{
  int   h;
  char *p, path[128];

  p = path;
  strcpy (p, InfPath);
#ifdef __PINPOINT__
  p += strlen (p) - 3;
  strcpy (p, "cfg");
#endif
#ifdef __CALENDAR__
  strcat (p, ".cfg");
#endif
  h = (int) Fopen(path, 0);
  if (h > 0)
  {
    Fread (h, (long) sizeof(CFG), &Cfg);
    Fclose (h);
  }
}

int xfsl_sel (void)
{
  int   id, pt, ret = -1;
  char  headline[32];
  xFSL *x;

  if (get_cookie ('xFSL', (long*) &x) && x && x->xfsl_input)
  {
    id = Cfg.FontID;
    pt = Cfg.FontPts;
    strcpy (headline, my_name);
    strcat (headline, ": Fontauswahl");
    if (x->xfsl_input (vwk, FF_ALL, headline, &id, &pt) == xFS_OK)
    {
      SetFont (1, id, pt);
      ret = 1;
    }
    else
      ret = 0;
  }

  return (ret);
}

int popup (OBJECT *tree,int x,int y)
{
  int     rv;
  MENU    desc, ret;

  if (_GemParBlk.global[0] == 0x399)
    rv = form_popup (tree, x, y);
  else
  {
    desc.mn_tree = tree;
    desc.mn_menu = 0;
    desc.mn_item = 1;
    desc.mn_scroll = 0;
    ret.mn_item = -1;
    menu_popup (&desc, x, y, &ret);
    rv = ret.mn_item;
  }

  return (rv);
}

static void stic_icon(int install)
{
  STIC *a;
  int __magx;

  if (install)
  {
    __magx = InqMagX ();
    if ((__magx < 0x0300)/*|| (colors < 16)*/)
    {
      rs_trindex[ICONS][BIGIC].ob_type = G_ICON;
      rs_trindex[ICONS][SMALLIC].ob_type = G_ICON;
    }
  }
  if(get_cookie ('StIc', (long*) &a) && a)
    a->ext_icon (_GemParBlk.global[2], &rs_trindex[ICONS][BIGIC], &rs_trindex[ICONS][SMALLIC], install);
}

static void rs_init (OBJECT *tree)
{
  int three_d, dummy, i = 0;
  long a;

  if(get_cookie ('STEW', &a) && (appl_xgetinfo (13, &three_d, &dummy, &dummy, &dummy) && (three_d & 1)))
    three_d = TRUE;
  else
    three_d = FALSE;
  for (i = 0; i < NUM_OBS; i++)
  {
    rsrc_obfix (tree, i);
    if (three_d)
      tree[i].ob_flags |= FL3DBAK;
  }
}

int my_alert (char *text, char *more, char *rest)
{
  char msg[128];

  strcpy (msg, "[2][");
  strcat (msg, my_name);
  if (more)
  {
    strcat (msg, text);
    strcat (msg, more);
    strcat (msg, rest);
  }
  else
  {
    strcat (msg, text);
  }
  strcat (msg, " ][ Abbruch ]");

  return (form_alert (1, msg));
}

int main (void)
{
  int          event, candidate, x, y, w, h, fehler = 1;
  char         tail[128];
#ifdef __PINPOINT__
  char        *cp;
  DOSTIME      tload, tnew;
#endif
#ifdef __CALENDAR__
  unsigned int time;
#endif
  EVENT        multi;
  CFG         *c = &Cfg;
  OBJECT      *Popup;

  gl_apid = appl_init();
  Pdomain (1);
  who_am_i ();

  /*   Multitasking-AES           &&  hat appl_search () */
  if ((_GemParBlk.global[1] != 1) && (appl_xgetinfo (4, &x, &x, &y, &x) && (y & 1)))
  {
    shel_read (InfPath, tail);
    if ((tail[0] == '\0') && (tail[1] == '\0') && (strcmp (&tail[2], "AUTO") == 0))
    {
      for (;;)
      {
        appl_search (0, tail, &x, &x);
        if(strcmp (tail, "        ") == 0)
          evnt_timer (500, 0);
        else
          break;
      }
      evnt_timer (1000, 0); /* zustzliche Wartezeit, sonst klappt's nicht */
    }

    xacc_mem = (int*) tail;
    for (x = 0; x < 64; x ++)
      xacc_mem[x] = -1;
    wind_get (0, WF_WORKXYWH, &desk.g_x, &desk.g_y, &desk.g_w, &desk.g_h);
    Popup = rs_trindex[POPUP];
    rs_init (Popup);
    c->FontID = 1;
    c->FontPts = 9;
    c->size.g_x = 4 + XBORDER;
    c->size.g_y = desk.g_y + 4 + YBORDER;
    InitPath ();
    LoadPar ();
#ifdef __CALENDAR__
    ReadCalInf ();
#endif
    OpenVDI ();
    stic_icon (TRUE);
    xacc_init ();
#ifdef __PINPOINT__
    candidate = AV_Message (AV_PROTOKOLL, 0x6, 0, 0, xacc_name); /* kennt VA_START, AV_STARTED */
#endif
#ifdef __CALENDAR__
    candidate = AV_Message (AV_PROTOKOLL, 0, 0, 0, xacc_name);
#endif
    if (LoadInf (TRUE) == 0)
    {
      my_alert (": |Fehler beim Laden der |Datei \"", my_filename, "\".");
      goto ende;
    }
#ifdef __PINPOINT__
    get_time (&tload);
#endif
    AV_Message (AV_ACCWINDOPEN, handle, 0L, 0L);
    wind_set (handle, WF_BOTTOM, 0, 0, 0, 0);

    multi.ev_mflags = MU_BUTTON | MU_MESAG | MU_KEYBD | MU_TIMER;
    multi.ev_mbclicks = 2;
    multi.ev_bmask = 1;
    multi.ev_mbstate = 1;
#ifdef __PINPOINT__
    multi.ev_mthicount = 0;
    multi.ev_mtlocount = 30000; /* 30 sec. */
#endif
#ifdef __CALENDAR__
    time = Tgettime ();
    if (((time >> 11) == 23) && (((time >> 5) & 0x3f) >= 49))
    {
      multi.ev_mthicount = 0;
      multi.ev_mtlocount = 10000; /* 10 sec. */
    }
    else
    {
      multi.ev_mthicount = 4;
      multi.ev_mtlocount = 37856U; /* 5 min. (4*65536+37856) */
    }
#endif

    do
    {
      event = EvntMulti (&multi);
      wind_update (BEG_UPDATE);

      if (event & MU_KEYBD)
        AV_Message (AV_SENDKEY, multi.ev_mmokstate, multi.ev_mkreturn, 0L, 0);

      if (event & MU_MESAG)
      {
        switch (multi.ev_mmgpbuf[0])
        {
          case AP_TERM:
            event=0;
          break;

          case WM_REDRAW:
            RedrawDialog ((GRECT*) &multi.ev_mmgpbuf[4]);
          break;

          case WM_TOPPED:
            wind_set (multi.ev_mmgpbuf[3], WF_TOP, 0, 0, 0, 0);
          break;

          case ACC_ID:
          case ACC_ACC:
            xacc_new (multi.ev_mmgpbuf[1], *(char**) &multi.ev_mmgpbuf[4]);
            if (multi.ev_mmgpbuf[0] == ACC_ID)
              xacc_send (ACC_ACC, multi.ev_mmgpbuf[1]);
          break;

          case ACC_EXIT:
            xacc_bye (multi.ev_mmgpbuf[1]);
          break;

#ifdef __PINPOINT__
          case ACC_TEXT:
            w = 0;
            cp = *(char**) &multi.ev_mmgpbuf[4];
            if (cp && *cp)
            {
              char *mem;

              mem = malloc (strlen (cp) + 1);
              if (mem)
              {
                strcpy (mem, cp);
                if (Inf)
                  Pfree (Inf);
                Inf = mem;
                InfPath[0] = '\0';
                DoInf (FALSE);
                w = 1;
              }
            }
            y = multi.ev_mmgpbuf[1];
            for (x = 2; x < 8; x++)
              multi.ev_mmgpbuf[x] = 0;
            multi.ev_mmgpbuf[0] = ACC_ACK;
            multi.ev_mmgpbuf[1] = _GemParBlk.global[2];
            multi.ev_mmgpbuf[3] = w;
            appl_write (y, 16, multi.ev_mmgpbuf);
          break;
#endif

#ifdef __PINPOINT__
          case ACC_KEY:
            AV_Message (AV_SENDKEY, multi.ev_mmgpbuf[3], multi.ev_mmgpbuf[4], 0L, 0);
          break;
#endif

          case VA_PROTOSTATUS:
            if ((av_server < 0) && ((multi.ev_mmgpbuf[1] == candidate) || (candidate < 0)))
            {
              av_server = multi.ev_mmgpbuf[1];
              AV_Message(AV_ACCWINDOPEN, handle, 0L, 0L);
            }
          break;

          case VA_START:
#ifdef __PINPOINT__
            cp = *(char**) &multi.ev_mmgpbuf[3];
            if (cp)
              strcpy (InfPath, cp);
            AV_Message (AV_STARTED, multi.ev_mmgpbuf[3], multi.ev_mmgpbuf[4], 0L, 0);
            LoadInf (FALSE);
            get_time (&tload);
#endif
#ifdef __CALENDAR__
            AV_Message (AV_STARTED, multi.ev_mmgpbuf[3], multi.ev_mmgpbuf[4], 0L, 0);
            LoadInf (FALSE);
#endif
            wind_set (handle, WF_TOP, 0, 0, 0, 0);
          break;

#ifdef __PINPOINT__
          case VA_DRAGACCWIND:
            cp = *(char**) &multi.ev_mmgpbuf[6];
            if (cp)
              strcpy (InfPath, cp);
            LoadInf (FALSE);
            get_time (&tload);
          break;
#endif

          case FONT_CHANGED:
            SetFont(1, multi.ev_mmgpbuf[4], multi.ev_mmgpbuf[5]);
            y = multi.ev_mmgpbuf[1];
            for (x = 0; x < 8; x++)
              multi.ev_mmgpbuf[x] = 0;
            multi.ev_mmgpbuf[0] = FONT_ACK;
            multi.ev_mmgpbuf[1] = _GemParBlk.global[2];
            multi.ev_mmgpbuf[3] = 1;
            appl_write (y, 16, multi.ev_mmgpbuf);
          break;
        }
      }

      if (event & MU_BUTTON)
      {
        if (wind_find (multi.ev_mmox, multi.ev_mmoy) == handle)
        {
          wind_update (BEG_MCTRL);
          if (multi.ev_mbreturn > 1)       /* Doppelklick */
          {
            evnt_button(1, 3, 0, &x, &x, &x, &x);
            x = popup (Popup, multi.ev_mmox, multi.ev_mmoy);
            switch (x)
            {
              case NOTICE:
                AV_Message(AV_STARTPROG, InfPath, 0L, 0);
              break;

              case RELOAD:
#ifdef __PINPOINT__
                InitPath ();
                LoadInf (FALSE);
                get_time (&tload);
#endif
#ifdef __CALENDAR__
                LoadInf (FALSE);
#endif
              break;

              case SAVEPAR:
                SavePar();
              break;

              case QUIT:
                event = 0;
              break;

              case TOPWIND:
                wind_set (handle, WF_TOP, 0, 0, 0, 0);
              break;

              case FONTSEL:
                if (font_sel >= 0)
                  AV_Message (FONT_SELECT, handle,  c->FontID, c->FontPts, 1, 0);
                else
                  if (xfsl_sel () < 0)
                  {
                    my_alert (": |Kein Fontselektor installiert.", 0L, 0L);
                  }
              break;
            }
          }
          else
          {
            graf_mkstate (&x, &x, &y, &x);
            if (y)
            {
              wind_get (handle, WF_CURRXYWH, &x, &y, &w, &h);
              set_mouse (FLAT_HAND);
              graf_dragbox (w, h, x, y, desk.g_x, desk.g_y, desk.g_w, desk.g_h, &x, &y);
              set_mouse (ARROW);
              wind_set (handle, WF_CURRXYWH, x, y, w, h);
              wind_get (handle, WF_WORKXYWH, &x, &y, &w, &h);
              /* Flche in 'size' ist kleiner(!) als der Arbeitsbereich der Fensters */
              c->size.g_x = x + XBORDER;
              c->size.g_y = y + YBORDER;
              c->size.g_w = w - (2*XBORDER);
              c->size.g_h = h - (2*YBORDER);
            }
            else
              wind_set (handle, WF_TOP, 0, 0, 0, 0);
          }
          wind_update (END_MCTRL);
        }
      }

#ifdef __PINPOINT__
      get_time (&tnew);
      if ((tnew.time != tload.time) || (tnew.date != tload.date))
      {
        LoadInf (FALSE);
        get_time (&tload);
      }
#endif
#ifdef __CALENDAR__
      time = Tgettime ();

      if (multi.ev_mthicount == 0)
      {
        if ((time >> 11) == 0)
        {
          LoadInf (FALSE);
          multi.ev_mthicount = 4;
          multi.ev_mtlocount = 37856U; /* 5 min. (4*65536+37856) */
        }
      }
      else
      {
        if (((time >> 11) == 23) && (((time >> 5) & 0x3f) >= 49))
        {
          multi.ev_mthicount = 0;
          multi.ev_mtlocount = 10000; /* 10 sec. */
        }
      }
#endif
      wind_update (END_UPDATE);
    } while (event);

    fehler = 0;
    AV_Message (AV_ACCWINDCLOSED, handle, 0L, 0L);
    wind_close (handle);
    wind_delete (handle);
ende:
    if (Loaded)
      vst_unload_fonts (vwk, 0);
    v_clsvwk (vwk);
    AV_Message (AV_EXIT, _GemParBlk.global[2], 0L, 0L);
    xacc_exit ();
    stic_icon (FALSE);
  }
  else
  {
    my_alert ("bentigt ein |Multitasking-AES mit appl_search().", 0L, 0L);
  }
  appl_exit ();

  return (fehler);
}
