
#define NULL	((void *) 0l)

typedef struct
{
	int		*hi_on,*hi_off,*lo_on,*lo_off;
} IMAGE;

typedef struct
{
	int		count;
	IMAGE	*image;
} IMAGES;

static int radio_hi_on[] = {
0x0000, 0x03C0, 0x0C30, 0x1008, 0x23C4, 0x27E4, 0x4FF2, 0x4FF2,
0x4FF2, 0x4FF2, 0x27E4, 0x23C4, 0x1008, 0x0C30, 0x03C0, 0x0000 };

static int radio_hi_off[] = {
0x0000, 0x03C0, 0x0C30, 0x1008, 0x2004, 0x2004, 0x4002, 0x4002,
0x4002, 0x4002, 0x2004, 0x2004, 0x1008, 0x0C30, 0x03C0, 0x0000 };

static int radio_lo_on[] = {
0x0FF0, 0x781E, 0xE3C7, 0xCFF3, 0xCFF3, 0xE3C7, 0x781E, 0x0FF0 };

static int radio_lo_off[] = {
0x0FF0, 0x781E, 0xE007, 0xC003, 0xC003, 0xE007, 0x781E, 0x0FF0 };

static int check_hi_on[] = {
0x0000, 0x7FFE, 0x4002, 0x500A, 0x4812, 0x4422, 0x4242, 0x4182,
0x4182, 0x4242, 0x4422, 0x4812, 0x500A, 0x4002, 0x7FFE, 0x0000 };

static int check_hi_off[] = {
0x0000, 0x0000, 0x3FFC, 0x2004, 0x2004, 0x2004, 0x2004, 0x2004,
0x2004, 0x2004, 0x2004, 0x2004, 0x2004, 0x3FFC, 0x0000, 0x0000 };

static int check_lo_on[] =
{ 0x7FFC, 0x701C, 0x4C64, 0x4384, 0x4C64, 0x701C, 0x7FFC ,0x0000 };

static int check_lo_off[] =
{ 0x7FFC, 0x4004, 0x4004, 0x4004, 0x4004, 0x4004, 0x7FFC ,0x0000 };

static int arrow_up_lo_sel[] = {
0x0000, 0x0180, 0x0180, 0x03C0, 0x03C0, 0x07E0, 0x07E0, 0x0000 };
static int arrow_up_lo[] = {
0x0000, 0x0180, 0x0180, 0x0240, 0x0240, 0x0420, 0x07E0, 0x0000};

static int arrow_dn_lo_sel[] = {
0x0000, 0x07E0, 0x07E0, 0x03E0, 0x03C0, 0x0180, 0x0180, 0x0000};
static int arrow_dn_lo[] = {
0x0000, 0x07E0, 0x0420, 0x0240, 0x0240, 0x0180, 0x0180, 0x0000};

static int arrow_right_lo_sel[] = {
0x0000, 0x3C00, 0x3FC0, 0x3FFC, 0x3FC0, 0x3C00, 0x0000 , 0x0000};
static int arrow_right_lo[] = {
0x0000, 0x3C00, 0x23C0, 0x203C, 0x23C0, 0x3C00, 0x0000 , 0x0000};

static int arrow_left_lo_sel[] = {
0x0000, 0x001E, 0x01FE, 0x1FFE, 0x01FE, 0x001E, 0x0000, 0x0000 };
static int arrow_left_lo[] = {
0x0000, 0x001E, 0x01E2, 0x1E02, 0x01E2, 0x001E, 0x0000, 0x0000 };

static int arrow_up_hi_sel[] = {
0x0000, 0x0000, 0x0080, 0x00C0, 0x01C0, 0x01E0, 0x03E0, 0x03F0,
0x07F0, 0x07F8, 0x0FF8, 0x0FFC, 0x1FFC, 0x1FFE, 0x0FFE, 0x0000 };
static int arrow_up_hi[] = {
0x0000, 0x0000, 0x0080, 0x00C0, 0x0140, 0x0160, 0x0220, 0x0230,
0x0410, 0x0418, 0x0808, 0x080C, 0x1004, 0x1FFE, 0x0FFE, 0x0000 };

static int arrow_dn_hi_sel[] = {
0x0000, 0x0000, 0x1FFC, 0x1FFC, 0x1FFC, 0x0FF8, 0x0FF8, 0x07F0,
0x07F0, 0x03E0, 0x03E0, 0x01C0, 0x01C0, 0x0080, 0x0000, 0x0000 };
static int arrow_dn_hi[] = {
0x0000, 0x0000, 0x1FFC, 0x100C, 0x180C, 0x0818, 0x0C18, 0x0430,
0x0630, 0x0260, 0x0360, 0x01C0, 0x01C0, 0x0080, 0x0000, 0x0000 };

static int arrow_left_hi_sel[] = {
0x0000, 0x0000, 0x000C, 0x003E, 0x00FE, 0x03FE, 0x0FFE, 0x3FFE,
0x1FFE, 0x07FE, 0x01FE, 0x007E, 0x001E, 0x0006, 0x0000, 0x0000 };
static int arrow_left_hi[] = {
0x0000, 0x0000, 0x000C, 0x0036, 0x00C6, 0x0306, 0x0C06, 0x3006,
0x1C06, 0x0706, 0x01C6, 0x0076, 0x001E, 0x0006, 0x0000, 0x0000 };

static int arrow_right_hi_sel[] = {
0x0000, 0x0000, 0x3000, 0x3C00, 0x3F00, 0x3FC0, 0x3FF0, 0x3FFC,
0x3FFE, 0x3FF8, 0x3FE0, 0x3F80, 0x3E00, 0x1800, 0x0000, 0x0000 };
static int arrow_right_hi[] = {
0x0000, 0x0000, 0x3000, 0x2C00, 0x2300, 0x20C0, 0x2030, 0x200C,
0x203E, 0x20F8, 0x23E0, 0x2F80, 0x3E00, 0x1800, 0x0000, 0x0000 };

static IMAGE radio_im[] =
{{radio_hi_on,radio_hi_off,radio_lo_on,radio_lo_off}};

static IMAGE check_im[] =
{{check_hi_on,check_hi_off,check_lo_on,check_lo_off}};

static IMAGE arrow_up_im[] =
{{arrow_up_hi_sel,arrow_up_hi,arrow_up_lo_sel,arrow_up_lo}};
static IMAGE arrow_dn_im[] =
{{arrow_dn_hi_sel,arrow_dn_hi,arrow_dn_lo_sel,arrow_dn_lo}};

static IMAGE arrow_left_im[] =
{{arrow_left_hi_sel,arrow_left_hi,arrow_left_lo_sel,arrow_left_lo}};
static IMAGE arrow_right_im[] =
{{arrow_right_hi_sel,arrow_right_hi,arrow_right_lo_sel,arrow_right_lo}};

IMAGES _radios = { 1, radio_im };
IMAGES _checks = { 1, check_im };
IMAGES _cycles = { 0, NULL };
IMAGES _arrows_up	= { 1, arrow_up_im };
IMAGES _arrows_down	= { 1, arrow_dn_im };
IMAGES _arrows_right= { 1, arrow_right_im };
IMAGES _arrows_left	= { 1, arrow_left_im };
