
/* SYNCHRO ANIPLAYER */
/* MEQUIGNON Didier November 1997 */
/* Example with messages VA_START, AV_SENDKEY, and 'AP' */

#include <cpx.h>
#include <string.h>
#include <vdi.h>
#include <tos.h>

/* ressource */

#define MENUBOX 0
#define MENUCMDE 2
#define MENUAPNAME 3
#define MENUPLAY 4
#define MENUPAUSE 5
#define MENUSTOP 6
#define MENUFF 7
#define MENUREW 8
#define MENUCMDEAP 9
#define MENUINFO 10
#define MENUBEJECT 13
#define MENUBSTOP 15
#define MENUBPLAY 17
#define MENUBPAUSE 19
#define MENUBREW 21
#define MENUBFF 23
#define MENUBSAUVE 25
#define MENUBANNULE 26

char *rs_strings[] = {
	"SYNCHRO ANIPLAYER","","",
	"abcdefghijklmnopqrstuvwx","Opt : ________________________","XXXXXXXXXXXXXXXXXXXXXXXX",
	"        ","With : ________","XXXXXXXX",
	"ABCD","Play : ____","XFFF",
	"EFGH","Pause : ____","XFFF",
	"IJKL","Stop : ____","XFFF",
	"HGEF","FF: ____","XFFF",
	"MKJI","REW: ____","XFFF",
	"MNOPQRSTUVWXYZ0123426789","Opt : ________________________","XXXXXXXXXXXXXXXXXXXXXXXX",
	"  MN SEC   ALL MN SEC","","",
	" :     :","","",
	"Save",
	"Cancel" };

long rs_frstr[] = {0};

BITBLK rs_bitblk[] = {
	(int *)0L,2,16,0,0,1,
	(int *)1L,2,16,0,0,1,
	(int *)2L,2,16,0,0,1,
	(int *)3L,2,16,0,0,1,
	(int *)4L,2,16,0,0,1,
	(int *)5L,2,16,0,0,1 };
	
long rs_frimg[] = {0};
ICONBLK rs_iconblk[] = {0};

TEDINFO rs_tedinfo[] = {
	(char *)0L,(char *)1L,(char *)2L,IBM,0,2,0x1180,0,0,32,1,
	(char *)3L,(char *)4L,(char *)5L,IBM,0,0,0x1180,0,0,25,31,	
	(char *)6L,(char *)7L,(char *)8L,IBM,0,0,0x1180,0,0,9,16,
	(char *)9L,(char *)10L,(char *)11L,IBM,0,0,0x1180,0,0,5,12,
	(char *)12L,(char *)13L,(char *)14L,IBM,0,0,0x1180,0,0,5,13,
	(char *)15L,(char *)16L,(char *)17L,IBM,0,0,0x1180,0,0,5,12,
	(char *)18L,(char *)19L,(char *)20L,IBM,0,0,0x1180,0,0,5,9,
	(char *)21L,(char *)22L,(char *)23L,IBM,0,0,0x1180,0,0,5,10,
	(char *)24L,(char *)25L,(char *)26L,IBM,0,0,0x1180,0,0,25,31,	
	(char *)27L,(char *)28L,(char *)29L,SMALL,0,0,0x1600,0,0,22,1,
	(char *)30L,(char *)31L,(char *)32L,IBM,0,0,0x1500,0,0,17,1 };

OBJECT rs_object[] = {
	-1,1,26,G_BOX,FL3DBAK,NORMAL,0x1100L,0,0,32,11,
	2,-1,-1,G_TEXT,FL3DBAK,SELECTED,0L,0,0,32,1,
	3,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,1L,1,1,30,1,
	4,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,2L,1,2,23,1,
	5,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,3L,1,3,12,1,
	6,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,4L,13,3,13,1,
	7,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,5L,1,4,12,1,
	8,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,6L,13,4,9,1,
	9,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,7L,22,4,10,1,
	10,-1,-1,G_FTEXT,EDITABLE|FL3DBAK,NORMAL,8L,1,5,30,1,
	13,11,12,G_BOX,NONE,NORMAL,0xff10f1L,3,6,17,2,
	12,-1,-1,G_TEXT,FL3DBAK,NORMAL,9L,0,0,17,1,
	10,-1,-1,G_TEXT,NONE,NORMAL,10L,0,1,17,1,										/* infos */
	15,14,14,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,NORMAL,0xff1100L,3,9,2,1,				/* eject */
	13,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,0L,0,0,2,1,
	17,16,16,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,SELECTED,0xff1100L,6,9,2,1,			/* stop */
	15,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,1L,0,0,2,1,
	19,18,18,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,NORMAL,0xff1100L,9,9,2,1,				/* play */
	17,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,2L,0,0,2,1,
	21,20,20,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,NORMAL,0xff1100L,12,9,2,1,				/* pause */
	19,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,3L,0,0,2,1,
	23,22,22,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,NORMAL,0xff1100L,15,9,2,1,				/* << */
	21,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,4L,0,0,2,1,
	25,24,24,G_BOX,TOUCHEXIT|FL3DIND|FL3DBAK,NORMAL,0xff1100L,18,9,2,1,				/* >> */
	23,-1,-1,G_IMAGE,TOUCHEXIT,NORMAL,5L,0,0,2,1,
	26,-1,-1,G_BUTTON,SELECTABLE|EXIT|FL3DIND|FL3DBAK,NORMAL,33L,23,7,6,1,			/* Sauve */
	0,-1,-1,G_BUTTON,SELECTABLE|EXIT|LASTOB|FL3DIND|FL3DBAK,NORMAL,34L,23,9,6,1 };	/* Annule */

long rs_trindex[] = {0};
struct foobar {
	int dummy;
	int *image;
	} rs_imdope[] = {0};

unsigned int image_eject[]={
	0x0000,0x0000,0x0000,0x0180,0x03c0,0x07e0,0x0ff0,0x1ff8,
	0x3ffc,0x0000,0x0000,0x3ffc,0x3ffc,0x0000,0x0000,0x0000 };

unsigned int image_stop[]={
	0x0000,0x0000,0x0000,0x0000,0x1ff8,0x1ff8,0x1ff8,0x1ff8,
	0x1ff8,0x1ff8,0x1ff8,0x1ff8,0x0000,0x0000,0x0000,0x0000 };

unsigned int image_play[]={
	0x0000,0x0000,0x0000,0x2000,0x3c00,0x3f80,0x3ff0,0x3ffe,
	0x3ffe,0x3ff0,0x3f80,0x3c00,0x2000,0x0000,0x0000,0x0000 };

unsigned int image_pause[]={
	0x0000,0x0000,0x0000,0x1e78,0x1e78,0x1e78,0x1e78,0x1e78,
	0x1e78,0x1e78,0x1e78,0x1e78,0x1e78,0x0000,0x0000,0x0000 };

unsigned int image_rew[]={
	0x0000,0x0000,0x0000,0x0204,0x060c,0x0e1c,0x1e3c,0x3e7c,
	0x3e7c,0x1e3c,0x0e1c,0x060c,0x0204,0x0000,0x0000,0x0000 };

unsigned int image_ff[]={
	0x0000,0x0000,0x0000,0x2040,0x3060,0x3870,0x3c78,0x3e7c,
	0x3e7c,0x3c78,0x3870,0x3060,0x2040,0x0000,0x0000,0x0000 };

#define NUM_STRINGS 35	/* nbre de chanes */
#define NUM_FRSTR 0		/* chaines form_alert */
#define NUM_IMAGES 0
#define NUM_BB 6		/* nbre de BITBLK */
#define NUM_FRIMG 0
#define NUM_IB 0		/* nbre d'ICONBLK */
#define NUM_TI 11		/* nbre de TEDINFO */
#define NUM_OBS 27		/* nbre d'objets */
#define NUM_TREE 1		/* nbre d'arbres */ 

#define TREE1 0

#define ID_CPX (long)'SANI'
#define ITEMPS 1000L	/* mS */
#define VA_START 0x4711
#define AV_SENDKEY 0x4710
#define STOP 0
#define PLAY 1
#define PAUSE 2
#define FF 3
#define REW 4

typedef struct
{
	long ident;
	union
	{
		long l;
		int i[2];
		char c[4];
	} v;
} COOKIE;

typedef struct
{
	char name[10];
	char play[4];
	char pause[4];
	char stop[4];
	char ff[4];
	char rew[4];
	char cmde[25];
	char cmde_app[25];
} KEYS_PRG;

typedef struct
{
	int width;
	int height;
	int planes;
	int frames_second;
	long total_frames;
	long id_picture_compression;	/* cvid for example */
	int quality;	/* B0: mono(0)/stereo(1)  B1: 8 bits(0)/16 bits(1) */
	unsigned int frequency_file;
	unsigned int frequency_machine;
	long total_samples;
	long id_sound_compression;		/* ima4 for example */
	int version_player;				/* version of Aniplayer */
	long count_seconds;
	long num_frame;
	int reserve[12];
} INFO_ANIM;

/* prototypes */

int CDECL cpx_call(GRECT *work);
void CDECL cpx_draw(GRECT *clip);
void CDECL cpx_wmove(GRECT *work);
void CDECL cpx_timer(int *event);
void CDECL cpx_key(int kstate,int key,int *event);
void CDECL cpx_button(MRETS *mrets,int nclicks,int *event);
int CDECL cpx_hook(int event,int *msg,MRETS *mrets,int *key,int *nclicks);
void CDECL cpx_close(int flag);
OBJECT *adr_tree(int no_arbre);
CPXNODE *get_header(long id);
void change_objc(int objc,int state,GRECT *clip);
void aff_objc(int objc,GRECT *clip);
void move_cursor(void);
void wait_end_clic(void);
unsigned long code_key(int status);
unsigned int code_scan_code(char key);
void send_message_app(int type,int key,char *path);
void send_message_start(char *path);
void send_message_key(int key);
void send_message_info(void);
void eject(void);
void stop(void);
void play(void);
void pause(void);
void rew(void);
void ff(void);
void conv_digit(char *chaine,int valeur);
void conv_hexa(char *chaine,int valeur);
unsigned long get_hexa(char *chaine);

/* variables globales VDI */

int vdi_handle,work_in[11]={1,1,1,1,1,1,1,1,1,1,2},work_out[57];
int errno;
 
/* variables globales */

XCPB *Xcpb;
GRECT *Work;
CPXNODE *head;
CPXINFO	cpxinfo={cpx_call,cpx_draw,cpx_wmove,cpx_timer,cpx_key,cpx_button,0,0,cpx_hook,cpx_close};
int id_app=0,send_info,count_send,ed_objc,new_objc,ed_pos,new_pos,load,first,start,status,old_status=-1;
int message[8];
char path_ani[80],path_app[80],name_ani[12],name_app[12];
CPXINFO* CDECL cpx_init(XCPB *xcpb)

{
	Xcpb=xcpb;
	return(&cpxinfo);
}

int CDECL cpx_call(GRECT *work)

{
	KEYS_PRG *header;
	OBJECT *dma_tree;
	TEDINFO *t_edinfo;
	BITBLK *b_itblk;
	register char *p;
	if(!(Xcpb->SkipRshFix))
	{
		(*Xcpb->rsh_fix)(NUM_OBS,NUM_FRSTR,NUM_FRIMG,NUM_TREE,rs_object,rs_tedinfo,rs_strings,rs_iconblk,rs_bitblk,rs_frstr,rs_frimg,rs_trindex,rs_imdope);
		rs_object[MENUINFO].ob_y+=4;
		b_itblk=rs_object[MENUBEJECT+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_eject;
		b_itblk=rs_object[MENUBSTOP+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_stop;
		b_itblk=rs_object[MENUBPLAY+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_play;
		b_itblk=rs_object[MENUBPAUSE+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_pause;
		b_itblk=rs_object[MENUBREW+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_rew;
		b_itblk=rs_object[MENUBFF+1].ob_spec.bitblk;
		b_itblk->bi_pdata=(int *)image_ff;
	}
	if((id_app=appl_find("XCONTROL"))<=0
	 && (id_app=appl_find("ZCONTROL"))<=0)
		return(0);
	if((vdi_handle=Xcpb->handle)>0)
	{
		v_opnvwk(work_in,&vdi_handle,work_out);
		if(vdi_handle<=0 || (head=get_header(ID_CPX))==0)
			return(0);
	}
	else
		return(0);
	if(work_out[13]<16)	/* nbre de couleurs */
	{
		t_edinfo=(TEDINFO *)rs_object[MENUINFO+1].ob_spec.tedinfo;
		t_edinfo->te_color=0x1000;
		t_edinfo=(TEDINFO *)rs_object[MENUINFO+2].ob_spec.tedinfo;
		t_edinfo->te_color=0x1000;
	}
	rs_object[MENUBOX].ob_x=work->g_x;
	rs_object[MENUBOX].ob_y=work->g_y;
	rs_object[MENUBOX].ob_width=work->g_w;
	rs_object[MENUBOX].ob_height=work->g_h;
	header=(KEYS_PRG *)head->cpxhead.buffer;
	t_edinfo=(TEDINFO *)rs_object[MENUCMDE].ob_spec.tedinfo;
  	strcpy(t_edinfo->te_ptext,header->cmde);
	t_edinfo=(TEDINFO *)rs_object[MENUAPNAME].ob_spec.tedinfo;
  	strcpy(t_edinfo->te_ptext,header->name);
	t_edinfo=(TEDINFO *)rs_object[MENUPLAY].ob_spec.tedinfo;
	strcpy(t_edinfo->te_ptext,header->play);
	t_edinfo=(TEDINFO *)rs_object[MENUPAUSE].ob_spec.tedinfo;
	strcpy(t_edinfo->te_ptext,header->pause);
	t_edinfo=(TEDINFO *)rs_object[MENUSTOP].ob_spec.tedinfo;
	strcpy(t_edinfo->te_ptext,header->stop);	
	t_edinfo=(TEDINFO *)rs_object[MENUFF].ob_spec.tedinfo;
	strcpy(t_edinfo->te_ptext,header->ff);
	t_edinfo=(TEDINFO *)rs_object[MENUREW].ob_spec.tedinfo;
	strcpy(t_edinfo->te_ptext,header->rew);
	t_edinfo=(TEDINFO *)rs_object[MENUCMDEAP].ob_spec.tedinfo;
  	strcpy(t_edinfo->te_ptext,header->cmde_app);
	ed_pos=ed_objc=0;
	cpx_draw(work);
	ed_objc=MENUAPNAME;
	status=STOP;
	count_send=send_info=load=first=start=0;
	objc_edit(rs_object,ed_objc,0,&ed_pos,ED_INIT);
	new_objc=ed_objc;
	new_pos=ed_pos;
	Work=work;
	(*Xcpb->Set_Evnt_Mask)(MU_KEYBD|MU_BUTTON|MU_TIMER,0L,0L,ITEMPS);
	return(1);					/* le CPX n'est pas termin */
}

void CDECL cpx_draw(GRECT *clip)

{
	aff_objc(0,clip);
}

void CDECL cpx_wmove(GRECT *work)

{
	rs_object[MENUBOX].ob_x=work->g_x;
	rs_object[MENUBOX].ob_y=work->g_y;
	rs_object[MENUBOX].ob_width=work->g_w;
	rs_object[MENUBOX].ob_height=work->g_h;
}

int CDECL cpx_hook(int event,int *msg,MRETS *mrets,int *key,int *nclicks)

{
	static long old_num_frame=-1;
	INFO_ANIM *info; 
	register char *p;
	register long total_time;
	register TEDINFO *t_edinfo;
	if(mrets && key && nclicks);
	if(send_info && (event & MU_MESAG) && msg[0]=='AP')
	{
		info=*((INFO_ANIM **)(&msg[3]));
		if(info->num_frame==old_num_frame)
			status=PAUSE;
		else
			status=PLAY;
		if(!info->id_picture_compression && !info->id_sound_compression)
			status=STOP;
		if(start && status==PLAY)
		{
			send_message_app(VA_START,0,path_app);
			start=0;
		}
		t_edinfo=(TEDINFO *)rs_object[MENUINFO+2].ob_spec.tedinfo;
		p=t_edinfo->te_ptext;
		if(status==STOP)
		{
			conv_digit(&p[1],0);
			conv_digit(&p[4],0);
			conv_digit(&p[11],0);
			conv_digit(&p[14],0);		
		}
		else
		{		
			total_time=info->total_frames/info->frames_second;
			conv_digit(&p[1],(int)(info->count_seconds/60L));
			conv_digit(&p[4],(int)(info->count_seconds%60L));
			conv_digit(&p[11],(int)(total_time/60L));
			conv_digit(&p[14],(int)(total_time%60L));
		}
		aff_objc(MENUINFO,Work);
		if(status!=old_status)
		{
			switch(status)
			{
			case PLAY:
				change_objc(MENUBSTOP,NORMAL,Work);
				change_objc(MENUBPLAY,SELECTED,Work);
				change_objc(MENUBPAUSE,NORMAL,Work);
				break;
			case PAUSE:
				change_objc(MENUBSTOP,NORMAL,Work);
				change_objc(MENUBPLAY,NORMAL,Work);
				change_objc(MENUBPAUSE,SELECTED,Work);
				break;				
			default:
				change_objc(MENUBSTOP,SELECTED,Work);
				change_objc(MENUBPLAY,NORMAL,Work);
				change_objc(MENUBPAUSE,NORMAL,Work);
			}
		}
		old_num_frame=info->num_frame;
		old_status=status;
		send_info=0;
		count_send=0;	
	}
	return(0);
}

void CDECL cpx_timer(int *event)

{

	if(*event);
	if(!send_info || count_send<5)
	{
		send_message_info();
		send_info=1;
		count_send++;
	}
}

void CDECL cpx_key(int kstate,int key,int *event)

{
	register int i,dial;
	register TEDINFO *t_edinfo;
	if(kstate);
	if(*event);
	dial=form_keybd(rs_object,ed_objc,ed_objc,key,&new_objc,&key);
	if(!key && dial)
	{
		if(new_objc)
		{
			t_edinfo=(TEDINFO *)rs_object[new_objc].ob_spec.tedinfo;
			for(i=0;t_edinfo->te_ptext[i];i++);
			new_pos=i;				/* curseur en fin de champ */
		}
	}
	else
	{
		if(rs_object[ed_objc].ob_flags & EDITABLE)
		{	/* si le formulaire un champ ditable */
			switch(key & 0xff00)
			{
			case 0x6100:			/* undo */
				eject();
				key=0;				/* touche traite */
				break;
			case 0x7300:			/* ctrl + gauche */
				new_objc=ed_objc;	/* mme champ */
				new_pos=0;			/* curseur  gauche */
				key=0;				/* code trait */
				break;
			case 0x7400:			/* ctrl + droite */
				new_objc=ed_objc;	/* mme champ */
				key=0;				/* touche traite */
				t_edinfo=(TEDINFO *)rs_object[new_objc].ob_spec.tedinfo;
				for(i=0;t_edinfo->te_ptext[i];i++);
				new_pos=i;			/* curseur en fin de champ */
			}
		}
	}
	if(key>0)
	{
		objc_edit(rs_object,ed_objc,key,&ed_pos,ED_CHAR);	/* dite le champ de texte courant */
		new_objc=ed_objc;
		new_pos=ed_pos;
	}
	if(dial)						/* si 0 => new_objc contient l'objet EXIT */
		move_cursor();
	else
	{
		change_objc(new_objc,NORMAL,Work);
		*event=1;					/* fin */
		cpx_close(0);
	}	
}

void CDECL cpx_button(MRETS *mrets,int nclicks,int *event)

{
	KEYS_PRG *header;
	GRECT menu;
	register TEDINFO *t_edinfo;
	register int i,j,ret,objc_clic,pos_clic;
	int x,y,m,k,xoff,yoff,attrib[10];
	if((objc_clic=objc_find(rs_object,0,2,mrets->x,mrets->y))>=0)
	{
		if(form_button(rs_object,objc_clic,nclicks,&new_objc))
		{
			if(new_objc>0)
			{
				objc_offset(rs_object,objc_clic,&xoff,&yoff);
				t_edinfo=(TEDINFO *)rs_object[objc_clic].ob_spec.tedinfo;
				vqt_attributes(vdi_handle,attrib);
				/* attrib[8] = largeur du cadre des caractres */
				for(i=0;t_edinfo->te_ptmplt[i];i++);	/* longueur chaine masque */
				if((pos_clic=rs_object[objc_clic].ob_width-i*attrib[8])>=0)
				{
					switch(t_edinfo->te_just)
					{
					case TE_RIGHT: 			/* justifi  droite */
						pos_clic=mrets->x-xoff-pos_clic;
						break;
					case TE_CNTR:			/* centr */
						pos_clic=mrets->x-xoff-pos_clic/2;
						break;
					case TE_LEFT:			/* justifi  gauche */
					default:
						pos_clic=mrets->x-xoff;
					}
				}
				else
					pos_clic=mrets->x-xoff;
				new_pos=-1;
				pos_clic/=attrib[8];		/* position caractre cliqu */
				j=-1;
				do
				{
					if(t_edinfo->te_ptmplt[++j]=='_')
						new_pos++;
				}
				while(j<i && j<pos_clic);	/* fin si curseur en fin de chaine ou position caractre cliqu */
				if(j>=i)
					new_pos=-1;						/* curseur en fin de chane */
				else
				{
					j--;
					while(t_edinfo->te_ptmplt[++j]!='_' && j<i);
					if(j>=i)
						new_pos=-1;					/* curseur en fin de chane */
				}
				for(i=0;t_edinfo->te_ptext[i];i++);	/* longueur chaine texte */
				if(new_pos<0 || i<new_pos)
					new_pos=i;
			}
			move_cursor();
		}
		else
		{
			switch(objc_clic)
			{
			case MENUBEJECT:
			case MENUBEJECT+1:
				eject();
				break;
			case MENUBSTOP:
			case MENUBSTOP+1:
				stop();
				break;
			case MENUBPLAY:
			case MENUBPLAY+1:
				play();
				break;
			case MENUBPAUSE:
			case MENUBPAUSE+1:
				pause();
				break;
			case MENUBREW:
			case MENUBREW+1:
				rew();
				break;
			case MENUBFF:
			case MENUBFF+1:
				ff();
				break;
			case MENUBSAUVE:
				change_objc(MENUBSAUVE,NORMAL,Work);
				if((*Xcpb->XGen_Alert)(SAVE_DEFAULTS))
				{
					header=(KEYS_PRG *)head->cpxhead.buffer;
					t_edinfo=(TEDINFO *)rs_object[MENUCMDE].ob_spec.tedinfo;
  					strcpy(header->cmde,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUAPNAME].ob_spec.tedinfo;
  					strcpy(header->name,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUPLAY].ob_spec.tedinfo;
  					strcpy(header->play,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUPAUSE].ob_spec.tedinfo;
  					strcpy(header->pause,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUSTOP].ob_spec.tedinfo;
  					strcpy(header->stop,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUFF].ob_spec.tedinfo;
  					strcpy(header->ff,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUREW].ob_spec.tedinfo;
  					strcpy(header->rew,t_edinfo->te_ptext);
					t_edinfo=(TEDINFO *)rs_object[MENUCMDEAP].ob_spec.tedinfo;
  					strcpy(header->cmde_app,t_edinfo->te_ptext);				
					if(((*Xcpb->Save_Header)(head))==0)
						(*Xcpb->XGen_Alert)(FILE_ERR);
				}
				break;
			case MENUBANNULE:
				change_objc(MENUBANNULE,NORMAL,Work);
				*event=1;	/* end */
				cpx_close(0);
			}
		}
	}
}

void CDECL cpx_close(int flag)

{
	int x,y,m,k;
	if(flag);
	objc_edit(rs_object,ed_objc,0,&ed_pos,ED_END);
	v_clsvwk(vdi_handle);
}

OBJECT *adr_tree(int no_arbre)

{
	register int i,arbre;
	if(!no_arbre)
		return(rs_object);
	for(i=arbre=0;i<NUM_OBS;i++)
	{
		if(rs_object[i].ob_flags & LASTOB)
		{
			arbre++;
			if(arbre==no_arbre)
				return(&rs_object[i+1]);
		}
	}
	return(0L);
}

CPXNODE *get_header(long id)

{
	register CPXNODE *p;
	p=(CPXNODE *)(*Xcpb->Get_Head_Node)();	/* pointeur header 1er CPX */
	do
	{
		if(p->cpxhead.cpx_id==id)
			return(p);
	}
	while(p->vacant && (p=p->next)!=0);		/* plus de headers */
	return(0L);
}

void change_objc(int objc,int state,GRECT *clip)

{
	rs_object[objc].ob_state=state;
	aff_objc(objc,clip);
}

void aff_objc(int objc,GRECT *clip)

{
	register GRECT *rect;
	register int curseur=0;
	wind_update(BEG_UPDATE);
	if(objc==MENUBOX)
	{
		objc_edit(rs_object,ed_objc,0,&ed_pos,ED_END);		/* efface le curseur */
		curseur=1;
	}
	rect=(GRECT *)(*Xcpb->GetFirstRect)(clip);
	while(rect)
	{
		objc_draw(rs_object,objc,2,PTRS(rect));
		rect=(GRECT *)(*Xcpb->GetNextRect)();
	}
	if(curseur)
		objc_edit(rs_object,ed_objc,0,&ed_pos,ED_END);		/* affiche le curseur */
	wind_update(END_UPDATE);
}

void move_cursor(void)

{
	if(new_objc>0 && (ed_objc!=new_objc || ed_pos!=new_pos))
	{
		objc_edit(rs_object,ed_objc,0,&ed_pos,ED_END);		/* efface le curseur */
		ed_pos=new_pos;
		objc_edit(rs_object,new_objc,0,&ed_pos,ED_CHAR);	/* positionne le curseur */
		objc_edit(rs_object,new_objc,0,&ed_pos,ED_END);		/* affiche le curseur */
		ed_objc=new_objc;									/* nouveau champ */
		ed_pos=new_pos;										/* nouvelle position curseur */
	}
}

void wait_end_clic(void)

{
	int x,y,m,k;
	do
		graf_mkstate(&x,&y,&m,&k);
	while(m);
}

unsigned long code_key(int status)

{
	register TEDINFO *t_edinfo;
	switch(status)
	{
	case PLAY:
		t_edinfo=(TEDINFO *)rs_object[MENUPLAY].ob_spec.tedinfo;
		break;
	case PAUSE:
		t_edinfo=(TEDINFO *)rs_object[MENUPAUSE].ob_spec.tedinfo;
		break;
	case FF:
		t_edinfo=(TEDINFO *)rs_object[MENUFF].ob_spec.tedinfo;
		break;
	case REW:
		t_edinfo=(TEDINFO *)rs_object[MENUREW].ob_spec.tedinfo;
		break;
	default:
		t_edinfo=(TEDINFO *)rs_object[MENUSTOP].ob_spec.tedinfo;
	}
	switch(strlen(t_edinfo->te_ptext))
	{
	case 0:
		return(0);
	case 1:
		return(code_scan_code(t_edinfo->te_ptext[0]));
	default:	
		return(get_hexa(t_edinfo->te_ptext));
	}
}

unsigned int code_scan_code(char key)

{
	KEYTAB *tab;
	register unsigned int i;
	tab=Keytbl((void *)-1,(void *)-1,(void *)-1);
	for(i=0;i<128;i++)
	{
		if(tab->shift[i]==key)
			break;
		if(tab->unshift[i]==key)
			break;
		if(tab->capslock[i]==key)
			break;
	}
	i<<=8;		/* scan-code */
	return(i | (unsigned int)key);
}

void send_message_app(int type,int key,char *path)

{
	static char buf[128];
	register int id;
	register TEDINFO *t_edinfo;	
	t_edinfo=(TEDINFO *)rs_object[MENUAPNAME].ob_spec.tedinfo;
	if((key || path) && (id=appl_find(t_edinfo->te_ptext))>0)
	{
		message[0]=type;
		message[1]=id_app;
		message[2]=0;
		if(path==0)
		{
			message[3]=0;
			message[4]=key;
		}
		else
		{
			t_edinfo=(TEDINFO *)rs_object[MENUCMDEAP].ob_spec.tedinfo;
			strcpy(buf,t_edinfo->te_ptext);	
			strcat(buf,path);			
			*((char **)(&message[3]))=buf;
		}
		message[5]=message[6]=message[7]=0;
		appl_write(id,16,message);
	}
}

void send_message_start(char *path)

{
	static char buf[128];
	register int id;
	register TEDINFO *t_edinfo;	
	if((id=appl_find("ANIPLAY "))>0)
	{
		t_edinfo=(TEDINFO *)rs_object[MENUCMDE].ob_spec.tedinfo;
		strcpy(buf,t_edinfo->te_ptext);	
		strcat(buf,path);		
		message[0]=VA_START;
		message[1]=id_app;
		message[2]=0;
		*((char **)(&message[3]))=buf;
		message[5]=message[6]=message[7]=0;
		appl_write(id,16,message);
	}
	else
		form_alert(1,"[2][No communication|with ANIPLAY][Cancel]");
}

void send_message_key(int key)

{
	register int id;
	if((id=appl_find("ANIPLAY "))>0)
	{
		message[0]=AV_SENDKEY;
		message[1]=id_app;
		message[2]=message[3]=0;
		message[4]=key;
		message[5]=message[6]=message[7]=0;
		appl_write(id,16,message);
	}
}

void send_message_info(void)

{
	register int id;
	if((id=appl_find("ANIPLAY "))>0)
	{
		message[0]='AP';
		message[1]=id_app;
		message[2]=message[3]=message[4]=message[5]=message[6]=message[7]=0;
		appl_write(id,16,message);
	}
}

void eject(void)

{
	int ret;
	register int car;
	register TEDINFO *t_edinfo;	
	change_objc(MENUBEJECT,SELECTED,Work);
	send_message_key(0x6100);	/* UNDO */
	evnt_timer(100,0);
	path_ani[0]=Dgetdrv()+'A';path_ani[1]=':';Dgetpath(path_ani+2,Dgetdrv()+1);
	strcat(path_ani,"\\");strcat(path_ani,"*.*");
	strcpy(path_app,path_ani);
	fsel_exinput(path_ani,name_ani,&ret,"Video for Aniplayer");
    if(path_ani[0]>='A' && path_ani[0]<='Z')
	{
		car=strlen(path_ani)-1;	
		while(path_ani[car]!='\\')
			path_ani[car--]=0;
		Dsetdrv(path_ani[0]-'A');Dsetpath(path_ani+2);
		strcat(path_ani,name_ani);
	}
	if(ret)
	{
		ret=0;
		t_edinfo=(TEDINFO *)rs_object[MENUAPNAME].ob_spec.tedinfo;
		if(appl_find(t_edinfo->te_ptext)>0)
		{
			fsel_exinput(path_app,name_app,&ret,"File for Application");
		    if(path_app[0]>='A' && path_app[0]<='Z')
			{
				car=strlen(path_app)-1;	
				while(path_app[car]!='\\')
					path_app[car--]=0;
				Dsetdrv(path_app[0]-'A');Dsetpath(path_app+2);
				strcat(path_app,name_app);
			}
		}
		change_objc(MENUBSTOP,NORMAL,Work);
		if(ret)
		{
			change_objc(MENUBPLAY,SELECTED,Work);
			change_objc(MENUBPAUSE,NORMAL,Work);
			send_message_start(path_ani);
			send_message_info();
			send_info=1;
			count_send++;
			start=1;
			status=old_status=PLAY;
		}
		else
		{
			change_objc(MENUBPLAY,NORMAL,Work);
			change_objc(MENUBPAUSE,SELECTED,Work);
			send_message_start(path_ani);
			*path_app=0;
			send_message_key('.');
			evnt_timer(100,0);
			send_message_key('.');				/* affiche la 1re image */
			send_message_app(AV_SENDKEY,(int)code_key(PAUSE),0);
			status=old_status=PAUSE;
		}
		load=first=1;
	}
	else
	{
		change_objc(MENUBSTOP,SELECTED,Work);
		change_objc(MENUBPLAY,NORMAL,Work);
		change_objc(MENUBPAUSE,NORMAL,Work);	
		status=old_status=STOP;
		load=0;
	}
	change_objc(MENUBEJECT,NORMAL,Work);
}

void stop(void)

{
	change_objc(MENUBSTOP,SELECTED,Work);
	change_objc(MENUBPLAY,NORMAL,Work);
	change_objc(MENUBPAUSE,NORMAL,Work);
	send_message_key(0x6100);	/* UNDO */
	send_message_app(AV_SENDKEY,(int)code_key(STOP),0);
	wait_end_clic();
	status=old_status=STOP;
}

void play(void)

{
	change_objc(MENUBSTOP,NORMAL,Work);
	change_objc(MENUBPLAY,SELECTED,Work);
	change_objc(MENUBPAUSE,NORMAL,Work);
	if(load && status==STOP)
	{
		send_message_start(path_ani);
		if(*path_app)
		{
			send_message_info();
			send_info=1;
			count_send++;
			start=1;
		}
	}
	else
	{
		send_message_key(' ');
		if(first)
		{
			send_message_key(0x4b34);			/* SHIFT +   (-10S) */
			first=0;
		}
		send_message_app(AV_SENDKEY,(int)code_key(PLAY),0);
	}
	wait_end_clic();
	status=old_status=PLAY;
}

void pause(void)

{
	change_objc(MENUBSTOP,NORMAL,Work);
	change_objc(MENUBPLAY,NORMAL,Work);
	change_objc(MENUBPAUSE,SELECTED,Work);
	send_message_key('.');
	send_message_app(AV_SENDKEY,(int)code_key(PAUSE),0);
	wait_end_clic();
	status=old_status=PAUSE;
}

void rew(void)

{
	change_objc(MENUBREW,SELECTED,Work);
	send_message_key(0x4b34);			/* SHIFT +   (-10S) */
	send_message_app(AV_SENDKEY,(int)code_key(REW),0);
	wait_end_clic();	
	change_objc(MENUBREW,NORMAL,Work);

}

void ff(void)

{
	change_objc(MENUBFF,SELECTED,Work);
	send_message_key(0x4d36);			/* SHIFT +   (+10S) */
	send_message_app(AV_SENDKEY,(int)code_key(FF),0);
	wait_end_clic();
	change_objc(MENUBFF,NORMAL,Work);
}

void conv_digit(char *chaine,int valeur)

{
	if(valeur>99)
		chaine[0]=chaine[1]='?';
	else
	{
		chaine[0]=(char)(valeur/10+16);
		chaine[1]=(char)(valeur%10+16);
	}
}

unsigned long get_hexa(char *chaine)

{
	register char *p;
	register int err,i,j;
	register long val;
	p=chaine;
	j=strlen(chaine);
	for(err=i=0;i<j && p[i];i++)
	{
		if(!((p[i]>='0' && p[i]<='9') || (p[i]>='A' && p[i]<='F')))
			err=1;
	}
	if(err || (i & 1) || i<2)
		return(0);
	else
	{
		val=0;
		for(i=0;i<j;i++)
		{
			val<<=4;
			if(p[i]>='0' && p[i]<='9')
				val |= (p[i] & 0xf);
			else
				val |= (p[i]-'A'+10);
		}
	}
	return(val);
}
