#include	<aes.h>
#include	<portab.h>
#include	<stddef.h>
#include	<tos.h>
#include	"..\ass_prg\res.h"
#include	"..\ass_prg\icb.h"
#include	"acc_com.h"


static BYTE acc_name[] = "NOVA_COL";/* Accessoryname */
static WORD message[8];					/* Messagepuffer */


/******************************************************************/
/* Name: GetResAdr																*/
/* Funktion: Adresse der Auflsungen bestimmen, die dieselbe		*/
/*				 virtuelle Auflsung und dieselbe Farbanzahl besitzen	*/
/* Parameter:																		*/
/*		WORD ap_id: ID der eigenen Applikation (wird von appl_init	*/
/*						geliefert)													*/
/* Funktionsergebnis:															*/
/*		RESOLUTION *: Zeiger auf Auflsungstabelle oder NULL			*/
/******************************************************************/
RESOLUTION	*GetResAdr(WORD ap_id)
{
	WORD	acc_id;							/* ID des NOVA-Accessories */
	
	acc_id = appl_find(acc_name);		/* Acc.-ID bestimmen */
	if (acc_id < 0)						/* Accessory gefunden? */
		return(NULL);						/* nein, also keine Auflsungen */

												/* Meldung fr Acc. aufbauen */
												/* Kennung eintragen */
	message[0] = message[3] = IM_COM;
	message[1] = ap_id;					/* eigene ID eintragen */
	message[2] = 0;						/* Meldung nur 8 Words */
	message[4] = GET_RESADR;			/* Befehl: Auflsungsadresse lesen */
												/* Meldung an Accessory senden */
	appl_write(acc_id, (WORD)sizeof(message), message);
	evnt_mesag(message);					/* auf Abtwort warten */
												/* Zeiger zurckliefern */
	return(*(RESOLUTION **)(&message[3]));
}


/******************************************************************/
/* Name: SetRes																	*/
/* Funktion: neue reale Auflsung setzen (virtuell beibehalten)	*/
/* Parameter:																		*/
/*		WORD ap_id: ID der eigenen Applikation (wird von appl_init	*/
/*						geliefert)													*/
/*		WORD index: Index der gewnschten Auflsung in der Tabelle	*/
/******************************************************************/
void	SetRes(WORD ap_id, WORD index)
{
	WORD	acc_id;							/* ID des NOVA-Accessories */
	
	acc_id = appl_find(acc_name);		/* Acc.-ID bestimmen */
	if (acc_id < 0)						/* Accessory gefunden? */
		return;								/* nein, also Abbruch */

												/* Meldung fr Acc. aufbauen */
												/* Kennung eintragen */
	message[0] = message[3] = IM_COM;
	message[1] = ap_id;					/* eigene ID eintragen */
	message[2] = 0;						/* Meldung nur 8 Words */
	message[4] = SET_RES;				/* Befehl: Auflsung setzen */
	message[5] = index;					/* Index der neuen Auflsung */
												/* Meldung an Accessory senden */
	appl_write(acc_id, (WORD)sizeof(message), message);
}


/******************************************************************/
/* Name: GetICB																	*/
/* Funktion: Bestimmen der Adresse des NOVA-Control-Blocks		*/
/*				 Achtung: nur im User-Modus aufrufen						*/
/* Funktionswert:																	*/
/*		Adresse des Control-Blocks oder NULL								*/
/******************************************************************/
ICB *GetICB(void)
{
	LONG	save_ssp;
	LONG	*c;
	
	save_ssp = Super(0L);
													/* Start der Cookie-Liste */
	if ((c = *(LONG **)(0x5A0)) == NULL)
	{
		Super((void *)save_ssp);			/* Supervisormodus ausschalten */
		return(NULL);
	}
													/* suchen, bis Listenende oder */
	while ((*c != 0) && (*c != 'IMNE'))	/* gesuchter Cookie */
		c += 2;
	
	Super((void *)save_ssp);				/* Supervisormodus ausschalten */

	if (*c == 0)
		return(NULL);
	else
		return((ICB *)c[1]);
}
