OVERVIEW		4/27/91

Dvips is a program for converting TeX .dvi files to PostScript.  The
resulting PS files can be processed by the GhostScript PS language
interpreter, which was recently ported to the ST.  Dvips supports the
inclusion of PS graphics in TeX/LaTeX files, and this is one of it's
greatest strengths.  The combination of TeX and dvips can be very
powerful.  It also supports PS fonts and virtual fonts (if you know
what those are). Here is some info about dvips (version 5.47) for the
ST.

WHAT IS NEEDED?

In order to run dvips, you will need the dvips executable and some
support files, the TeX font metrics (.tfm files), and a whole bunch of
compressed 300 dot/inch (or whatever the resolution of your output
device is) font files.  The font files are not included in dvips, and
will either have to be made with metafont (this is not recommended),
or "stolen" from some machine which already has them.  I got my fonts
from my Sun4 at work. In the standard TeX distribution, these font
files generally have names that look like 'fontname.300pk' The 'pk'
on the end specifies that the font files are compressed. There is
a problem with keeping this name convention on the ST, but that will
be discussed later.

The source and binaries are distributed in seperate archives.  The
binary distribution contains:

.\
dvips.ttp		the executable
afm2tfm.ttp		converts adobe font metric files (postscript fonts)
			to TeX font metrics
.\ps
tex.pro			postscript prolog files, needed
texc.pro		for dvips output
texps.pro
special.pro
finclude.pro
config.ps		a startup file used to customize dvips--this
			can also be named dvips.rc and put in the
			HOME directory.
manta.ps		a postscript graphic file used in an example
			of how to include ps graphics in tex.
.\doc
dvips.doc		an ascii reproduction of the unix manual page
dvips.tex		the main documentation
   .
   .			various readme and help files
   .

.\tex
psincl.tex		an example of how to include ps graphics in
			a tex file -- uses manta.ps
			just type 'latex psincl' and 'dvips psincl',
			then send psincl.ps to a postscript printer
			(or ghostscript)
epsf.tex
epsf.sty		tex macro files which are needed for various
   .			features of dvips -- see the docs

.\contrib		some LaTex drawing improvements for use with dvips

Dvips looks for the files it needs to run in certain default paths.
A path for dvips is a comma or semicolon sepatared list of directories.
Font search paths are a little more general than this. More on this
later. Dvips was compiled with certain default paths, some of which
are listed below. These paths can be changed with either environment
variables or by entries in a config.ps or dvips.rc file. See the docs
for more details.

 PATH for WHAT		   DEFAULT		ENVIRONMENT VARIABLE

tex font metrics	'.,d:\tex\tfm'		     TEXFONTS
pk fonts		'.,d:\dvips\fonts'	     TEXPKS
configuration files	'.,d:\dvips\ps'
.tex files		'd:\tex\macros'

Now, suppose that dvips wants the font cmr10.300pk. This font name
cannot exist on the ST, since there are more than three characters
after the '.'. On the ST, this file will be named cmr10.300. If
cmr10.300 is in d:\dvips\fonts, then dvips will find it and be happy.
The only problem is that some information about what is in the file
has been lost (the fact that they are compressed 'pk' files). There
are several ways around this problem.

1) Ignore it. This is my favorite. I know what is in these files.
2) Put the fonts in d:\dvips\fonts\pk	(my second favorite).
3) Use some different directory structure (I don't like this one).

Unfortunately, everyone who has written a program for the ST which
uses TeX 'pk' has taken route 3. This has resulted in a lot of
painful renaming of zillions of font files, and incompatibilities
between different programs which use these fonts. Fortunately, the
authors of dvips provide a flexible method for changing the way
in which dvips looks for fonts. With the default path given above,
dvips will look for d:\dvips\fonts\cmr10.300. But several
metacharacters can be placed in the search path to change this.
These characters are preceeded by a %, and have the following values:

%f	the font name
%d	the dots/inch, usually 300
%p	the font format, always 'pk'

So, setting TEXPKS to 'd:\dvips\%f\%d%p' will cause dvips to look for
the cmr10.300pk font in the file d:\dvips\cmr10\300pk.  This
flexibility would be welcome in other programs.  See the docs for more
details.

If dvips can't find a 'pk' font that it needs, it normally (under
unix) tries to make one from the TeX 'tfm' font metrics using
metafont.  I don't have the metafont distribution, so I don't know how
difficult it would be to get this feature to work on the ST (probably
not too difficult).

Dvips should run fine on a 512K machine, but you will probably want
a hard drive to hold all the fonts.

USAGE

Once you get everything set up right, just type

dvips [options] filename[.dvi]

on the command line. The postscript output will be written in
'filename.ps'. See the docs for the available 'options'.

BUGS and LIMITATIONS

I know of no ST specific bugs in dvips, but many features are not
tested. Automatic font generation and virtual fonts are two of them.
The unix version of dvips supports unix pipes. It can be used as
a filter and can pipe output directly to a printer or another
program (like ghostscript). I do not know if this can be made to
work on the ST (perhaps under MiNT).

A small note about the dvips.tex documentation file.  The included
file dvipsmac.tex requires some logo fonts that none of my machines
have. Therefore I commented out references to these fonts so that
I could process the file. If your output looks funny or is missing
something, this may be the reason.

COMPILING the SOURCE

The source distribution contains the original dvips 5.47 source plus
an additional directory (.\atari) containing the source files which
were modified for the ST.  To compile the source, modify the makefile
to suit your needs, overwrite the original files with the atari
versions, and type 'make dvips'.  I am assuming that you have gnu make
and gcc (I used version 1.37).  Actually, the Atari versions of the
source should also compile correctly on unix and MSDOS machines, but I
would rather keep it sepatate.

Tim Gallivan
National Center for Supercomputing Applications
University of Illinois
timothyg@ncsa.uiuc.edu
