/***************************************************************************
****  Treiber fr 24 Nadeldrucker																				****
***************************************************************************/

/* evt. mu der Rand (LINKS) angepat werden, also:
 * Dazu als Faustregel: 1Byte = 8Pixel = (8/360)" = (1/45)" ~ 0.564444444mm 
 * Das heit: Grafik jetzt ca. 4mm zu weit links, Rand um 6 erhhen, 
 * denn 7*0.564 = 3.9511111mm
 * (Diese Formel gilt natrlich nur bei 360 DPI.)
 * Fr den oberen Rand gilt 1mm ~ 14 ({25.4/360}mm = 1 Zeile)
 * (Wenn man diese Datei an einen anderen Drucker anpat, dann diese 
 *  bitte entsprechend umbennen (z.B. BREEZE360.C, dann wre z.B. 
 *  HOEHE=???, LINKS=??? und an mich senden, BITTE!)
 */

#define OBEN 0		/* Oberer Rand */
#define LINKS 0	/* Linker Rand 0 Bytes */



/* Vertikaler Vorschub um 1/360"; je nach Drucker unterschiedlich! */

#define STEP_360 		"\034\063"	/* NEC & Star */

#if 0
#define STEP_360 		"\033\053"	/* EPSON LQ */
#define STEP_360 		"\033\x5D"	/* Oki */
#endif

#define WEITE 4896L		/* max. Breite einer Grafikseite */
#define HOEHE -1L			/* max. Hoehe */



#include "24nadel.c"
/* 24-Standarttreiber */
/* geaendert durch Marcus Haebler */

/* email: prissi@marie.physik.tu-berlin.de
 * Post:  Markus Pristovsek
 *        Boumannstrae 66
 *        W1000 Berlin 28
 */


/* bersicht ber alle 24 Nadeldrucker, noch ohne Genehmigung von S. Lindner 
 * Man suche sich hier seinen Drucker

  Firma |Drucker |   Auflsung   |Breite| Hhe | Font-Ordner | Inf-Datei
        |        |  Horiz./Vert. |      |      |             |
  ------+--------+-------+-------+------+------+-------------+-----------
  NEC   | P6     |  180  |  180  | 1440 | -1   | RES180.NEC  | P6_LOW
  NEC   | P6     |  180  |  360  | 1440 | -1   | RES180.NEL  | P6_LMED
  NEC   | P6     |  360  |  180  | 2880 | -1   | RES360.NEL  | P6_MED
  NEC   | P6     |  360  |  360  | 2880 | -1   | RES360.NEC  | P6_HIGH
  NEC   | P7     |  180  |  180  | 2448 | -1   | RES180.NEC  | P6_LOW
  NEC   | P7     |  180  |  360  | 2448 | -1   | RES180.NEL  | P6_LMED
  NEC   | P7     |  360  |  180  | 4896 | -1   | RES360.NEL  | P6_MED
  NEC   | P7     |  360  |  360  | 4896 | -1   | RES360.NEC  | P6_HIGH
  ------+--------+-------+-------+------+------+-------------+-----------
  EPSON | LQ500  |  180  |  180  | 1440 | -1   | RES180.LQL  | LQ500_LO
  EPSON | LQ500  |  360  |  180  | 2880 | -1   | RES360.LQM  | LQ500_ME
  EPSON | LQ500  |  360  |  360  | 2880 | -1   | RES360.LQH  | LQ500_HI
  EPSON | LQ800  |  180  |  180  | 1440 | -1   | RES180.LQL  | LQ800_LO
  EPSON | LQ800  |  360  |  180  | 2880 | -1   | RES360.LQL  | LQ800_ME
  EPSON | LQ800  |  360  |  360  | 2880 | -1   | RES360.LQH  | LQ800_HI
  EPSON | LQ1000 |  180  |  180  | 2448 | -1   | RES180.LQL  | LQ1000_L
  EPSON | LQ1000 |  360  |  180  | 4896 | -1   | RES360.LQM  | LQ1000_M
  EPSON | LQ1000 |  360  |  360  | 4896 | -1   | RES360.LQH  | LQ1000_H
  EPSON | LQ550  |  180  |  180  | 1440 | -1   | RES180.LQL  | LQ550_LO
  EPSON | LQ550  |  360  |  180  | 2880 | -1   | RES360.LQM  | LQ550_ME
  EPSON | LQ550  |  360  |  360  | 2880 | -1   | RES360.LQH  | LQ550_HI
  EPSON | LQ550  |  180  |  180  | 1440 | -1   | RES180.LQL  | LQ550_LO
  EPSON | LQ550  |  360  |  180  | 2880 | -1   | RES360.LQL  | LQ550_ME
  EPSON | LQ550  |  360  |  360  | 2880 | -1   | RES360.LQH  | LQ550_HI
  EPSON | LQ1050 |  180  |  180  | 2448 | -1   | RES180.LQL  | LQ1050_L
  EPSON | LQ1050 |  360  |  180  | 4896 | -1   | RES360.LQM  | LQ1050_M
  EPSON | LQ1050 |  360  |  360  | 4896 | -1   | RES360.LQH  | LQ1050_H
*/