/*************************************************************************
****  Hier der speziell an den Stylus 800-Drucker von Epson angepate ****
****  24-Nadeltreiber. (Wie schn wre es, wenn alle neuen Drucker    ****
****  HPCL knnten...)                                                ****
*************************************************************************/

#include <portab.h>

#include "mintbind.h"
#include "treiber.h"

/** Vorlufige Parameter */
#define MAX_DPI	360L
#define	WEITE	2880L
#define HOEHE	-1L
#define OBEN	0L
#define LINKS	0L


#ifdef FAST_PRN
#define WRITE(i,j) ((th>0)?(Fwrite(th,i,j)):(print_block(i,j)))
#endif


/* Reset + NLQ + Einheit 1/MAX_DPI" + Zeilenabstand 48/MAX_DPI" */
UBYTE	*INIT 	= "  \033@\033x\001\033(U\001\000\012\033$\000\000\033(V\002\000\000\000";
UBYTE	*H_STEP	=	"\033$xx";
UBYTE	*V_STEP	=	"\033(v\002\000xx";
UBYTE	*GRAFIK	= "\033*";


struct
{
	UBYTE	modus;
	WORD	h_dpi;
	WORD	v_dpi;
	WORD	t;
} modus[13]=
{
	{ 0, 60, 60, 1 },
	{ 4, 80, 60, 1 },
	{ 6, 90, 60, 1 },
	{ 1, 120, 60, 1 },	/*+*/
	{ 3, 240, 60, 1 },	/*+*/
	{ 32, 60, 180, 3 },
	{ 38, 90, 180, 3 },
	{ 33, 220, 180, 3 },
	{ 39, 180, 180, 3 },
	{ 40, 360, 180, 3 },	/*+*/
	{ 71, 180, 360, 6 },
	{ 73, 360, 360, 6 }
};
/*+* heit: Kann keine nebeneinanderliegenden Punkte drucken! */

/* Zwischenspeicher fr eine Zeile */
static UBYTE	tmp[WEITE*6L+5L];



WORD	drucke( UBYTE *p, LONG weite, LONG max_zeile, LONG h_dpi, LONG v_dpi )
{
	extern char	tmp_file[256]; /* In Datei drucken? */
	extern long	max_puffer_laenge;

	LONG	max_spalte, zeile, lz, links, linker_rand, rechts;
	LONG	len, i, d_modus, bits_per_row;
	WORD	th=0;

#ifdef FAST_PRN
	/* Fr viel Geschwindigkeit = sinnvoll groer Puffer */
	max_puffer_laenge = WEITE*6L+256L;
	if(  tmp_file[0]>0  ||  open_printer()<0  )
#endif
		th = (WORD)get_tempfile( "sls" );
	if(  th<0  )
		return -1;

	if(  v_dpi<200	)
	{
		if(  v_dpi<80  )
			v_dpi = 60;
		else
			v_dpi = 180;
	}
	else
		v_dpi = MAX_DPI;

	for(  d_modus=0;  d_modus<12;  d_modus++  )
		if(  (h_dpi*90)/100<modus[d_modus].h_dpi  &&  v_dpi==modus[d_modus].v_dpi  )
			break;
	h_dpi = modus[d_modus].h_dpi;
	bits_per_row = 8*modus[d_modus].t;
	d_modus = modus[d_modus].modus;

		/* Ab hier wird es ernst */
	if(  weite<(WEITE*h_dpi)/360L  )
		max_spalte = (weite+7)/8;
	else
		max_spalte = (WEITE*h_dpi)/(MAX_DPI*8L);

		/* Diverse Variablen initialisieren */
	zeile = 0;
	weite = (weite+15L)/16L;
	weite *= 2;
	p += weite*OBEN + LINKS;	/* Nicht druckbare Rnder*/
	max_zeile -= OBEN;
	if(  HOEHE>0	&&	(max_zeile*v_dpi)/MAX_DPI>HOEHE  )
		max_zeile = HOEHE;

	for(  linker_rand=0;	ist_next_leer( p+linker_rand, weite, max_zeile )  &&  linker_rand<max_spalte;  linker_rand++  )
		;
	if(  linker_rand==max_spalte  )
	{	/* Leerseite */
		WRITE( 1L, "\014" );
		return th;
	}

		/* Reset + LQ-Mode */
	WRITE( 24L, INIT );

	/* Endlich drucken */
	lz = 0;
	max_zeile--;
	while(	zeile<max_zeile )
	{
		/* Leerzeilen berspringen */
		while(  zeile<max_zeile  &&  ist_leerzeile( p, max_spalte )  )
		{
			lz++;
			zeile++;
			p += weite;
		}

		if(  zeile>=max_zeile  )
		{
			lz = lz+(max_zeile-zeile)-bits_per_row;
			if(  lz>0  )
				break;
		}

		if(	 lz!=0  )
		{	/* Leerzeilen berspringen */
			i = (lz*MAX_DPI)/v_dpi;
			V_STEP[5] = (UBYTE)i;
			V_STEP[6] = (UBYTE)(i>>8);
			WRITE( 7L, V_STEP );
		}

			/* Rnder feststellen */
		for(	rechts=max_spalte-1;	ist_next_leer( p+rechts, weite, bits_per_row )	&&	rechts>linker_rand;  rechts--  )
			;
		rechts++;
		for(  links=linker_rand;	ist_next_leer( p+links, weite, bits_per_row )	&&	links<rechts;  links++  )
			;
		if(	links>0	)
		{	/* Linker Rand */
			i = (links*8L*MAX_DPI)/h_dpi;
			H_STEP[2] = (UBYTE)i;
			H_STEP[3] = (UBYTE)(i>>8);
			WRITE( 4L, H_STEP );
		}

		len = rechts-links;
		tmp[0] = '\033';
		tmp[1] = '*';
		tmp[2] = (UBYTE)d_modus;
		tmp[3] = (UBYTE)((len%32)*8);
		tmp[4] = (UBYTE)(len>>5);

		block_it( tmp+5, p+links, len, weite, bits_per_row/8 );
		WRITE( 5L+len*bits_per_row, tmp );
		p += weite*bits_per_row;
		zeile += bits_per_row;
		lz = bits_per_row;
 }

		/* Ende Seite */
	if(  1!=WRITE( 1L, "\014" )  )
	{
		/* Platz reichte nicht aus */
		if(  th>0  )
			Fclose( th );
		th = -1;
	}

	if(  tmp_file[0]==0  )
		flush_block();
	return th;
}
/* 17.8.93 */

