; REMBRANDT 3.0 -   Dbug II
;
; Module de gestion des drivers RIM. (1.0)
;
; - Localisation et comptage des fichiers RIM prsents dans le rpertoire
; - Evaluation de la place mmoire ncssaire pour les charger en entier
; - Rservation d'un bloc mmoire de la bonen taille
; - Chargement des RIM dans le buffer:
;     Si il n'est pas du type [READ_IMG,_VDI] on ne le mmorise pas.
;
;EN-TETE DES RIMS:
; dc.b "READ_IMG"     Driver de lecture d'image
; dc.b "_VDI"         Qui les traite au format VDI
; dc.w 0              0->RIM Total, 1-> RIM Partiel, 2-> RIM gnrateur
; dc.b "DEGA_PAC"     Ici c'est du Degas compact
; dc.w 100            Numro de version
; dc.b "Image Degas Compact          ",0,0  30 caractres dcrivant la fonction de ce fichier RIM, suivis de 2 octets nuls. 
; bra teste_fichier   	Vrification du fichier
; bra extrait_palette
; bra traite_fichier
;
; [Nb: La DTA (Disk Transfert Area) de Rembrandt est en MY_DTA]
;
 rsreset
rim_type_driver		rs.l 2  ["READ_IMG"]
rim_format_driver	rs.l 1	["_VDI"]
rim_type_chargement	rs.w 1	0=Total / 1=Partiel
rim_identifiant		rs.l 2  ["DEGA_PAC"] ou ["ARTDIREC"] ou...
rim_num_version		rs.w 1  commence  $0100
rim_type_fichier	rs.b 32
rim_routine_teste	rs.l 1
rim_routine_palette	rs.l 1
rim_routine_image	rs.l 1

 ifeq _main_part
 <pREMB_xxx.S>q doit tre assembl !!!
 END
 endc
 
 section TEXT

exc
execute_driver_rim
 pea table_mfdb				La taille de paramtrage
 move.l extension,-(sp)			Extension du fichier
 move.l taille_fichier,-(sp)		Taille du fichier 
 move.l taille_fichier,-(sp)		Taille charge (=taille fichier)
 move.l buffer_fichier,-(sp)		Adresse du fichier source
 clr -(sp)				Code=0 (1er appel) (Si on avait Code=1, cela serait un autre appel...)
 move.l adresse_rim,a0			Adresse du driver RIM
 jsr rim_routine_teste(a0)		Appelle la routine de test +56
 lea 22(sp),sp
 tst d0
 bne.s .fichier_reconnu
 boite_alerte #1,#alert_image_non_reconnue
 bra .error_exec

.fichier_reconnu
 cmp #1,d0
 bne.s .ya_assez_d_infos
 boite_alerte #1,#alert_pas_asser_info
 bra .error_exec
 
.ya_assez_d_infos
 bsr get_info_rim

 cmp #2,d0
 bne.s .ya_pas_palette
;
; On traite la palette
;
;** Get_palette() **
;retour%=C:driver%+60(code&,     L:adr_source%,    L:size_source%, 
;L:adr_destination%, L:nombre_couleurs%,L:adr_MFDB%)
;Avec le saut de 60 on saute sur la routine de rcupration de  la 
;palette.
;
;Valeurs de retour%:
;0  ->  Erreur.  Donnes ne correspondant pas    la  palette,  ou 
;palette absente de ce fichier.
;1 -> Quantit de donnes trop faible.  Rappel:  l encore le  PRG 
;Appelant doit charger au moins 512 octets. Pour un RIMs total, il 
;faut envoyer le totalit des donnes.
;2 -> Succs.
;
;code&  Comme pour Test_file() 
;
;adr_source%  Adresse    laquelle le PRG Appelant    dpos  les 
;donnes.
;
;size_source% Taille de ces donnes
;
;adr_destination%  Adresse   partir de laquelle la  routine  doit 
;dposer la palette aprs traitement.
;
;nombre_couleur%  c'est le nombre de couleurs que le PRG  Appelant 
;veut  voir traiter par la routine.  Il est ainsi possible que  le 
;PRG  ne demande que les premires couleurs de la palette.  Si  le 
;PRG  veut une couleur sur deux,  il est de sa  responsabilit  de 
;demander toutes les couleurs et de les traiter ensuite.
;
;A  l'appel le PRG doit remplir a nouveau la MFDB en placant  dans 
;le  premier  long  mot de celle-ci la taille du  fichier  sur  le 
;disque.  En  retour,  le  RIM aura rempli cette MFDB  comme  pour 
;l'appel  TEST_FILE(),  c'est  dire dans le premier long  mot  le 
;"seek"  pour les donnes de l'image et dans les octets  14-17  la 
;taille de ces donnes.
;     Si  le fichier ne comporte pas de palette ou bien si le  PRG 
;ne veut pas de traitement de celle-ci,  il doit nanmoins appeler 
;cette routine afin de connaitre le seek et la taille des  donnes 
;composant  l'image.  Il  suffit  pour cela de  faire  l'appel  en 
;donnant 0 comme nombre de couleurs  traiter.
;
;     Le format des couleurs est trs important:  tant donn  que 
;nous  travaillons au format VDI,  la routine devra  dposer  dans 
;adr_destination%,  les  couleurs dans l'ordre et avec  le  codage 
;VDI.  Ce  codage est du type RGB,  mais avec des valeurs de  0   
;1000,  tenant  chacune sur un mot.  Ainsi un vert 362 devra  tre 
;cod comme ceci:
;(3*1000)/7=428
;(6*1000)/7=857
;(2*1000)/7=285
;Donc au format VDI: 428-857-285
;     Il  faut  galement  faire attention au  fait  que  certains 
;fichiers peuvent contenir un codage de palette prvu pour le STE, 
;et donc avoir des composantes notes de 0  F et pas de 0  7. Il 
;faudra alors faire:
;(valeur_composante_system*1000)/15=valeur composante.VDI
;     L'adresse destination pointera donc sur une zone destine   
;recevoir  les couleurs au format VDI c'est  dire avec un  codage 
;sur 3 mots (6 octets) par couleur.

 pea table_mfdb			Adresse MFDB
 moveq #0,d0
 move nombre_couleurs,d0
 move.l d0,-(sp)		Nombre de couleurs
 move.l #adresse_palette+4,adresse_palette
 pea adresse_palette+4		Adresse de la palette finale
 move.l mfdb_taille_palette,-(sp)	Taille de la palette
 move.l buffer_fichier,a0	Adresse de la palette source
 add.l mfdb_seek,a0
 pea (a0)
 clr -(sp)			Code
 move.l adresse_rim,a0		Adresse du driver RIM
 jsr rim_routine_palette(a0)
 lea 22(sp),sp
 tst d0
 beq .error_exec

.ya_pas_palette

;** Do_file() **
;retour%=C:driver%+64(code&,     L:adr_source%,    L:size_source%, 
;L:adr_MFDB%)
;Avec le saut de 64 on saute sur la routine traite_fichier

;Valeur possible pour retour%:
;0 -> Erreur (fichier abim, mauvais type etc...)
;1  -> Toutes les donnes fournies ont t traites,  il  faut  en 
;recharger d'autres.  Mais attention,  toutes les lignes du buffer 
;"standard"  n'ont  pas t remplies,  le PRG Appelant  doit  donc 
;recharger   des   donnes,    mais   ne   doit   pas   faire   de 
;Transform_form().
;2 -> Toutes les lignes du buffer "standard" ont t remplies.  Le 
;PRG Appelant doit donc faire un Transform_form() mais ne doit pas 
;recharger  de  donnes  dans le buffer "source"  car  toutes  ces 
;donnes n'ont pas t lues.
;3 -> C'est le cas de 1 ET de 2 en mme temps:  toutes les donnes 
;ont t lues,  et en plus toutes les lignes du buffer  "standard" 
;ont   t  remplies.   Le  PRG  Appelant  doit  donc   faire   un 
;Transform_form() et en plus il doit recharger des donnes dans le 
;buffer  "source".  C'est le seul cas qui doit normalement  arriv 
;avec  les RIMs "total" puisque ceux-ci reoivent la totalit  des 
;informations.
;
;code& 0->Premier appel, sinon code&=1.
;
;adr_source%  Adresse  des donnes  du  fichier.
;
;size_source%  Taille de ces donnes.
;
;adr_MFBD%  Adresse  de la structure MFDB  dfinissant  le  buffer 
;"standard" dans lequel on doit tranfrer les donnes de l'image.
;Cette  structure a t modifie par le PRG Appelant  et  contient 
;dsormais  l'adresse du buffer "standard" dans les deux  premiers 
;mots:
;     DC.L      adresse du buffer standard
;     DC.W      320     ; sa largeur en pixels
;     DC.W      200     ; son nombre de ligne
;     DC.W      80      ; la largeur d'un plan en mot
;     DC.W      0       ; inutilis par la routine
;     DC.W      4       ; nombre de plans
;     DC.W      0       ; rserv     
;     DC.W      0       ; rserv     
;     DC.W      0       ; rserv
;
;     La  routine  va donc devoir dposer les donnes  de  l'image 
;dans  le  buffer "standard",  en faisant attention au  nombre  de 
;ligne  de  celui-ci,  et  sa largeur en mot,  qui  permettra  de 
;sauter  du lieu de dpot des donnes plan1 au lieu de  dpot  des 
;donnes plan2 etc...  Ainsi,  si le buffer standard fait 5 lignes 
;de haut et que la largeur d'un plan en mot est de 40, la distance 
;sparant  le dbut de la premire ligne plan1,  du dbut  de  la 
;premire ligne plan2 sera de (40*2)*5=400 octets. Il faut refaire 
;ce  calcul  aprs chaque Transform_form()  du  PRG  Appelant.  En 
;effet,  si l'image fait par exemple 250 lignes,  et que la  place 
;mmoire  disponible permet de rserver un buffer standard de  120 
;lignes,  le PRG Appelant demandera  la routine, 2 oprations sur 
;120  lignes  et pour terminer une opration  sur  10  lignes.  La 
;structure  MFDB  dfinissant  le  buffer  "standard"  sera   donc 
;diffrent lors du troisime appel. Cela ne vaut que pour les RIMs 
;partiel.  En  effet,  le  PRG  appelant   la  responsabilit  de 
;rserver  un  buffer assez gros pour recevoir  l'image  une  fois 
;traite.

 move mfdb_largeur_image,d0
 mulu mfdb_hauteur_image,d0	Nombre de pixels de l'image
 lsr.l #3,d0			/8 -> Nombre d'octets par plan
 mulu nombre_plans,d0		Nombre d'octets total composant l'image
 lea buffer_dpacking,a0	Rserve un bloc pour que le RIM crive
 bsr.l rserve_bloc		l'image au format VDI...
 bmi erreur_mmoire_dpacking
 
 pea table_mfdb			Adresse MFDB
 move.l taille_fichier,-(sp)	Taille du fichier 
 move.l buffer_fichier,a0	Adresse de l'image
 add.l mfdb_seek,a0
 pea (a0)
 clr -(sp)			Code
 move.l buffer_dpacking,mfdb_adresse_buffer
 move.l adresse_rim,a0		Adresse du driver RIM
 jsr rim_routine_image(a0)
 lea 14(sp),sp
 tst d0

 lea buffer_fichier,a0
 bsr.l libre_bloc

 bsr recode_palette_vdi
 bsr.l prpare_buffer_image
 bsr transforme_image_vdi
    
.fin_exec
 moveq #0,d0
 rts

.error_exec
 moveq #-1,d0
 rts

;
; Rcupre les infos de la MFDB
;
get_info_rim
 movem.l d0-a6,-(sp)
 move mfdb_largeur_image,d0
 add d0,d0
 move d0,largeur_image

 move mfdb_hauteur_image,d0
 move d0,hauteur_image

 move mfdb_nombre_plans,d1
 move d1,nombre_plans
 subq #1,d1
 moveq #2,d0
 lsl d1,d0
 move d0,nombre_couleurs

 move mfdb_largeur_plan,d0
 add d0,d0
 move d0,largeur_plan		Largeur d'un plan en octets...
 movem.l (sp)+,d0-a6
 rts



transforme_image_vdi
 move.l adresse_palette,a0	La palette TrueBidouille !
 move.l buffer_dpacking,a1	L'image  convertir
 move.l fichier,a2		Le buffer pour stocker l'image

 move largeur_plan,d0		largeur d'un plan en mot
 mulu hauteur_image,d0		La taille totale d'un plan en octets.
     
 move.l d0,d4
 lsr.l d4			Nombre de mots  traiter.

 move nombre_plans,d2
 subq #1,d2
  
.bloc_suivant

 moveq #16-1,d6			Il y  16 pixels par bloc
.pixel_suivant
 move.l a1,a3			Dbut du bloc du premier plan.
 move d2,d7			Le nombre de plans (de 1  n)
 moveq #0,d3			La couleur est mise  0
.plan_suivant
 roxl.w (a3)			Teste le bit
 addx d3,d3			Mmorise le bit
 add.l d0,a3			Passe au plan suivant.
 dbra d7,.plan_suivant
 and #%11111111,d3
 move d2,d7			Le nombre de plans (de 1  n)
 moveq #0,d5
.plan_suivant2
 roxr d3
 addx d5,d5
 dbra d7,.plan_suivant2
 move (a0,d5.w*2),(a2)+		Affiche le pixel
 dbra d6,.pixel_suivant

 addq #2,a1			Passe au bloc suivant (2*nombre de plans)

 subq.l #1,d4
 bne .bloc_suivant		Passe au multiple de 16 suivant...
 moveq #0,d0
 rts


 

 
chargement_rim_choisi
 move.l adresse_drivers_rim,a5
 move numro_rim_courant,d0
 mulu #50,d0
 add d0,a5			Dbut de la zone d'infos du RIM.

 lea adresse_rim,a0		Descripteur
 move.l 34(a5),d0		Taille du fichier
 bsr.l rserve_bloc
 bne erreur_rim_mmoire

 move.l adresse_nom_rim,a0	Recopie le nom  la fin du chemin d'accs
 move.l 38(a5),(a0)+
 move.l 42(a5),(a0)+
 move.l 46(a5),(a0)+ 
 
 move #1,-(sp)			Ouvre en lecture
 pea chemin_drivers_rim		Nom du fichier
 move #$3d,-(sp)		> FOPEN
 trap #1
 addq #8,sp
 tst d0
 bmi erreur_rim_chargement
 move d0,handle

 move.l adresse_rim,-(sp)	Adresse de chargement du RIM
 move.l 34(a5),-(sp)		56 octets  charger
 move handle,-(sp)
 move #$3f,-(sp)		> FREAD
 trap #1
 lea 12(sp),sp
 tst.l d0
 bmi erreur_rim_chargement

 move handle,-(sp)		On ferme le fichier
 move #$3e,-(sp)		> FCLOSE
 trap #1
 addq #4,sp
 tst d0
 bmi erreur_rim_chargement

 move.l #execute_driver_rim,adresse_routine_chargement

 move.l a5,adresse_txt_chargement
 moveq #0,d0
 rts
 


;
; On commence par compter les RIM, on value la place mmoire ncssaire...
; En bref, on fait un recensement !
;
charge_drivers_rim
 sf flag_drivers_rim
 tst.b flag_utiliser_rim
 bne.s .effectue_chargement_rim
 rts
 
.effectue_chargement_rim
 clr position_slection_rim


 move #0,-(sp)			Fichier normal
 pea chemin_drivers_rim
 move #$4e,-(sp)		> FSFIRST
 trap #1
 addq #8,sp
 tst d0
 bne erreur_rim_absent

 moveq #0,d7
 moveq #0,d6
 lea my_dta,a6

.compte_drivers_rim
 addq #1,d7			Un driver de plus
 add.l #50,d6			Rajoute 50 octets pour mmoriser l'info
 move #$4f,-(sp)		> FSNEXT
 trap #1
 addq #2,sp
 tst d0
 beq.s .compte_drivers_rim

 move d7,nombre_drivers_rim	Mmorise le nombre de RIM
 move.l d6,taille_drivers_rim	Ainsi que la place totale maximale occupe

 move.l taille_drivers_rim,d0	On essaye de rserver un bloc de la taille ncssaire
 lea adresse_drivers_rim,a0	pour pouvoir stocker les RIM de faon confortable...
 bsr.l rserve_bloc
 bmi erreur_rim_mmoire

;
; On charge les RIM maintenant !
;
 move #0,-(sp)			Fichier normal
 pea chemin_drivers_rim
 move #$4e,-(sp)		> FSFIRST
 trap #1
 addq #8,sp
 tst d0
 bne erreur_rim_chargement

.continue_chargement
 lea chemin_drivers_rim,a6	Recherche le dbut du nom du fichier
.cherche_fin_chemin
 cmp.b #'*',(a6)+
 bne.s .cherche_fin_chemin
 subq #1,a6
 move.l a6,adresse_nom_rim
 
 move.l adresse_drivers_rim,a5	Adresse du buffer de chargement des RIM
 move nombre_drivers_rim,d7	Nombre de fichiers  charger...
 subq #1,d7	
.boucle_chargement_rim
 move.l my_dta+26,d6		Mmorise la taille du RIM en cours de chargement.
 move.l d6,d5			Pour le chargement -->

 lea my_dta+30,a0		Recopie le nom  la fin du chemin d'accs
 move.l (a0)+,(a6)
 move.l (a0)+,4(a6)
 move.l (a0)+,8(a6)
 
 move #1,-(sp)			Ouvre en lecture
 pea chemin_drivers_rim		Nom du fichier
 move #$3d,-(sp)		> FOPEN
 trap #1
 addq #8,sp
 tst d0
 bmi erreur_rim_chargement
 move d0,handle

 pea buffer_entete_rim		Adresse de chargement
 pea 56.w			56 octets  charger
 move handle,-(sp)
 move #$3f,-(sp)		> FREAD
 trap #1
 lea 12(sp),sp
 tst.l d0
 bmi erreur_rim_chargement

 move handle,-(sp)		On ferme le fichier
 move #$3e,-(sp)		> FCLOSE
 trap #1
 addq #4,sp
 tst d0
 bmi erreur_rim_chargement

 lea buffer_entete_rim,a0
 cmp.l #'READ',rim_type_driver(a0)	RIM de chargement image ???
 bne .ignore_rim
 cmp.l #'_IMG',rim_type_driver+4(a0)
 bne .ignore_rim
 cmp.l #'_VDI',rim_format_driver(a0)	Uniquement au format VDI
 bne .ignore_rim
 tst rim_type_chargement(a0)		0=Total / 1=Partiel
 bne .ignore_rim

 lea rim_type_fichier(a0),a1		Recopie la dsignation du driver
 rept 8
 move.l (a1)+,(a5)+			(32 octets)
 endr
 move rim_num_version(a0),(a5)+		Ainsi que le numro de version
 move.l d6,(a5)+			Taille du fichier driver  
 move.l (a6),(a5)+			Ainsi que son nom
 move.l 4(a6),(a5)+
 move.l 8(a6),(a5)+
 bra.s .rim_suivant  

.ignore_rim
 subq #1,nombre_drivers_rim

.rim_suivant  
 move #$4f,-(sp)		> FSNEXT	Prpare le chargement du prochain
 trap #1			fichier RIM.
 addq #2,sp
 tst d0
 dbne d7,.boucle_chargement_rim

 st flag_drivers_rim
 
; lea adresse_nombre_rim,a0
; move nombre_drivers_rim,d0	Nombre de drivers
; ext.l d0
; jsr inscrit_chaine
; move.b #'',(a0)
; boite_alerte #1,#alert_nombre_rim
    
 moveq #0,d0
 rts



erreur_rim_absent
 boite_alerte #1,#alert_rim_absent
 moveq #-1,d0
 rts

erreur_rim_mmoire
 boite_alerte #1,#alert_rim_mmoire
 moveq #-1,d0
 rts

erreur_rim_chargement
 boite_alerte #1,#alert_rim_chargement	On prvient l'utilisateur que ca merde...
 lea adresse_drivers_rim,a0		et on libre la mmoire rserve.
 jsr libre_bloc
 moveq #-1,d0
 rts

 section BSS

;adr_MFBD%  Adresse  de  la structure MFDB que  la  routine  devra 
;remplir si elle reconnait le format du fichier qu'on lui propose.
;
;     La structure MFDB est une liste de quelques octets dcrivant 
;l'image.  Cette structure est utilise dans les oprations GEM de 
;copie  d'image  et son remplissage doit tre fait  avec  le  plus 
;grand  soin.  Notre routine devra donc remplir  cette  structure, 
;afin de communiquer au PRG appelant le maximum d'informations sur 
;l'image  telle qu'elle sera une fois lue.  Voici par  exemple  la 
;structure  MFDB qui devra tre renvoye par une routine  traitant 
;des images au format Nochrome:
;     DC.L      4       ; seek palette   
;     DC.W      320     ; largeur de l'image en pixels
;     DC.W      200     ; hauteur de l'image en pixels
;     DC.W      20      ; largeur d'un plan en mot
;     DC.W      0       ; les donnes sont au format standard
;     DC.W      4       ; nombre de plans
;     DC.L      32      ; nbr d'octets de la palette     
;     DC.W      0       ; rserv
;             
;Normalement,  la MFDB ne doit pas donner le "seek" pour atteindre 
;la palette,  ni la taille des donnes de celle-ci. Normalement le 
;premier  long  mot devrait contenir l'adresse  de  l'image,  mais 
;comme  c'est au PRG Appelant de rserver un bloc mmoire et  donc 
;de  connaitre cette adresse,  nous en profitons pour  communiquer 
;des informations. La connaissance du saut ncessaire pour pointer 
;dans le fichier sur les donnes de la palette,  permettra au  PRG 
;appelant  de  faire un SEEK sur ce fichier,  et donc  de  ne  pas 
;charger de donnes inutiles.  S'il n'y a pas de palette,  il faut 
;mettre 0 pour le seek et la taille puisque le code de retour sera 
;3 au lieu de 2.

table_mfdb
mfdb_adresse_buffer
mfdb_seek		ds.l 1	seek palette 
mfdb_largeur_image	ds.w 1	largeur de l'image en pixels
mfdb_hauteur_image	ds.w 1	hauteur de l'image en pixels
mfdb_largeur_plan	ds.w 1	largeur d'un plan en mot
mfdb_type_format	ds.w 1	les donnes sont au format standard
mfdb_nombre_plans	ds.w 1	nombre de plans
mfdb_taille_palette	ds.l 1	nbr d'octets de la palette 
mfdb_rserv		ds.w 1	rserv
			ds.l 500	Par scurit pour l'instant

flag_drivers_rim	ds.w 1	Indique si les RIM sont disponibles

adresse_nom_rim		ds.l 1
 
nombre_drivers_rim	ds.w 1	Nombre de drivers en mmoire
nombre_drivers		ds.w 1

taille_drivers_rim	ds.l 1	Taille totale occupe par le buffer les contenant
adresse_drivers_rim	ds.l 1	Descripteur du bloc contenant les entetes de drivers RIM
adresse_rim		ds.l 1	Descripteur du bloc du RIM courant.

buffer_entete_rim	ds.b 56	Pour charger le dbut du RIM

position_slection_rim	ds.w 1
numro_rim_courant	ds.w 1
numro_driver_courant	ds.w 1

  