; Copyright 1999 Tomas Berndtsson, <tomas@nocrew.org>

  	include	macros.s
	include	colours.s

VLM_MODULE	=	0
GFXMODE	=	%100110100
SHOWVBL	=	0

XRES	=	320
YRES	=	240
DOTS	=	128
STARTY	=	0

COLS	=	3

	ifne	VLM_MODULE
	opt	nodebug
	output	d:\sound\whip!\vlm\cascade.vlm
	include	vlmserv.s
	endc

	text

	ifne	VLM_MODULE

	dc.b	"VLM2"
	dc.l	infotext
	dc.l	settings
	dc.l	init
	dc.l	deinit
	dc.l	main

	else
	
	bsr.w	init
	vsync

	endc

	ifne	VLM_MODULE
	nop
	endc
	nop
main
	bsr	scrswap

	ifne	SHOWVBL
	move.l	scrp,a3
	move.w	$468.w,d7
	subq.w	#1,d7
.vsl
	move.l	#$ffffffff,(a3)+
	move.l	#$00000000,(a3)+
	dbra	d7,.vsl

	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	endc

;	not.l	$ffff9800.w

	ifne	VLM_MODULE
	vlm_wait_vbl
	else
	vsync
	endc

;	not.l	$ffff9800.w

	
	lea	dotpos,a2
	lea	dotspeed,a4
	move.l	savedp,a6
	lea	tcfadetab,a5
fadeold
	move.l	(a6)+,a3	
	tst.l	a3
	beq.s	fadeold
	bmi.s	.nomoreclr

	tst.l	option_track
	bne.s	.dotrack
	clr.l	(a3)
	clr.l	640(a3)
	clr.l	-4(a6)
	bra.s	fadeold
.dotrack
	moveq	#0,d0
	move.w	(a3),d0
	move.w	(a5,d0.l*2),(a3)
	move.w	(a3),640(a3)
	move.w	2(a3),d0
	move.w	(a5,d0.l*2),2(a3)
	move.w	2(a3),642(a3)
	tst.l	(a3)
	bne.s	fadeold
	clr.l	-4(a6)
	bra.s	fadeold
.nomoreclr
	move.l	savedp,a6

	bsr	fixspec
;	bsr	fixvol
	move.l	scrp,a3

	move.l	left_spec_p,a0
	move.l	right_spec_p,a1
	bsr	docolumn

	cmp.w	#15,steps
	blt	.nomore

;	bsr	fixspec
;	bsr	fixvol
	move.l	left_spec_p,a0
	move.l	right_spec_p,a1
	bsr	docolumn

	cmp.w	#30,steps
	blt	.nomore

;	bsr	fixspec
;	bsr	fixvol
	move.l	left_spec_p,a0
	move.l	right_spec_p,a1
	bsr	docolumn

;	move.l	#-1,(a6)

	move.w	#30,steps
.nomore
	addq.w	#1,steps
	
	ifne	VLM_MODULE

	rts
	
	else

	cmp.b	#$3b,$fffffc02.w
	bne	main

slu
	stdexit
	pea	0.w
	trap	#1

	endc


fixspec
	ifne	VLM_MODULE
	vlm_get_left_spec left_spec_p
	vlm_get_right_spec right_spec_p
	else
	move.l	#fake_left_spec,left_spec_p
	move.l	#fake_right_spec,right_spec_p
	endc
	rts

fixvol
	ifne	VLM_MODULE
	vlm_get_left_volume left_volume+2
	vlm_get_right_volume right_volume+2
	else
	move.w	#32767,left_volume+2
	move.w	#65535,right_volume+2
	endc
	clr.w	left_volume
	clr.w	right_volume
	rts

docolumn
	move.w	#STARTY,d7
dl
left
	move.l	(a2),d0
	bne.s	.placed
	move.w	d7,d0
	mulu.w	#320,d0
	moveq	#0,d1
	move.w	(a0)+,d1
	sub.l	option_sense,d1
	bpl.s	.notneg
	clr.l	d1
.notneg
;	add.l	left_volume,d1
	lsr.l	#8,d1
	lsr.w	#5,d1
	move.w	d1,(a4)
	clr.w	2(a4)
.placed	
	move.w	(a4)+,d2
	lea	xspdcoltab_l,a5
	move.l	(a5,d2.w*8),d1
	move.l	4(a5,d2.w*8),d6
	move.w	(a4),d2
	addq.w	#1,(a4)+
	lea	yspeedtab,a5
	add.l	(a5,d2.w*4),d1
	add.l	d0,d1
	cmp.l	#239*320,d1
	blt.s	.not_out
	clr.l	(a2)+
	bra.s	.no_dot
.not_out
	move.l	d1,(a2)+
	lea	(a3,d1.l*2),a5
	or.l	d6,(a5)
	or.l	d6,640(a5)

.testnext	tst.l	(a6)+
	bmi.s	.found
	bne.s	.testnext
.found	move.l	a5,-4(a6)

;	move.l	a5,(a6)+

.no_dot	

right
	move.l	(a2),d0
	bne.s	.placed
	move.w	d7,d0
	mulu.w	#320,d0
	add.l	#318,d0
	moveq	#0,d1
	move.w	(a1)+,d1
	sub.l	option_sense,d1
	bpl.s	.notneg
	clr.l	d1
.notneg
;	add.l	right_volume,d1
	lsr.l	#8,d1
	lsr.w	#5,d1
	move.w	d1,(a4)
	clr.w	2(a4)
.placed	
	move.w	(a4)+,d2
	lea	xspdcoltab_r,a5
	move.l	(a5,d2.w*8),d1
	move.l	4(a5,d2.w*8),d6
	move.w	(a4),d2
	addq.w	#1,(a4)+
	lea	yspeedtab,a5
	add.l	(a5,d2.w*4),d1
	add.l	d0,d1
	cmp.l	#239*320,d1
	blt.s	.not_out
	clr.l	(a2)+
	bra.s	.no_dot
.not_out
	move.l	d1,(a2)+
	lea	(a3,d1.l*2),a5
	or.l	d6,(a5)
	or.l	d6,640(a5)

.testnext	tst.l	(a6)+
	bmi.s	.found
	bne.s	.testnext
.found	move.l	a5,-4(a6)

;	move.l	a5,(a6)+

.no_dot	

	addq.w	#1,d7
	cmp.w	#DOTS+STARTY,d7
	bne	dl

	rts


init	
	ifne	VLM_MODULE

	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16
	
	else

	super
	stdinit	#-1,#-1,#GFXMODE

	clr.l	$ffff9800.w

	lea	fake_left_spec,a0
	lea	fake_right_spec,a1
	move.w	#128-1,d7
.ssl
	move.w	d7,d6
	asl.w	#8,d6
	asl.w	#1,d6
	or.w	#$01ff,d6
	move.w	d6,(a0)+
	move.w	d6,(a1)+
	dbra	d7,.ssl

	endc
	
	lea	dotpos,a0
	move.w	#DOTS*2*2-1,d7
.cdpl
	clr.l	(a0)+
	dbra	d7,.cdpl

	lea	saved1,a0
	lea	saved2,a1
	moveq	#-1,d0
	move.w	#DOTS*COLS*32*2+1-1,d7
.sl
	move.l	d0,(a0)+
	move.l	d0,(a1)+
	dbra	d7,.sl

	clr.w	steps

	rts

deinit
	rts

scrswap
	ifeq	VLM_MODULE
	move.l	scrp,-(sp)
	move.l	scrp+4,scrp
	move.b	1(sp),$ffff8201.w
	move.b	2(sp),$ffff8203.w
	move.b	3(sp),$ffff820d.w
	move.l	(sp)+,scrp+4

	else

	move.l	scrp,tmpscrp
	move.l	scrp+4,scrp
	move.l	tmpscrp,scrp+4
	vlm_set_scradr tmpscrp

	endc

	move.l	savedp,d0
	move.l	savedp+4,savedp
	move.l	d0,savedp+4

	rts

	data

scrp	dc.l	scr1,scr2
savedp	dc.l	saved1,saved2

	ifne	VLM_MODULE
infotext	dc.b	'CASCADE',0
	dc.b	'Author:  NoBrain/NoCrew',0
	dc.b	'Version: 0.42',0
	dc.b	'Date:    1999-06-17',0
	dc.b	0
	even
	
settings	dc.l	2

	dc.l	par1name
	dc.l	1
option_track	dc.l	1
	dc.l	0

	dc.l	par2name
	dc.l	3
option_sense	dc.l	$dce
	dc.l	par2struct

par1name	dc.b	'CASCADE TRACKING',0
par2name	dc.b	'SENSITIVITY',0
	even

par2struct	dc.l	0,32767

	else

option_track	dc.l	1
option_sense	dc.l	$dce
		
	endc
	
tcfadetab	incbin	'tcfade.tab'
yspeedtab	incbin	'yspeed.tab'

xspdcoltab_r	dc.l	-0,(R00+G00+B00)*65536+R00+G00+B00
	dc.l	-1,(R01+G08+B02)*65536+R01+G04+B18
	dc.l	-2,(R02+G16+B04)*65536+R02+G08+B20
	dc.l	-3,(R03+G24+B06)*65536+R03+G12+B22
	dc.l	-4,(R04+G32+B08)*65536+R04+G16+B18
	dc.l	-5,(R05+G40+B10)*65536+R05+G20+B14
	dc.l	-6,(R06+G48+B12)*65536+R06+G24+B10
	dc.l	-7,(R07+G63+B14)*65536+R06+G48+B12


xspdcoltab_l	dc.l	0,(R00+G00+B00)*65536+R00+G00+B00
	dc.l	1,(R00+G02+B18)*65536+R04+G04+B02
	dc.l	2,(R03+G04+B20)*65536+R08+G08+B04
	dc.l	3,(R06+G06+B22)*65536+R12+G12+B06
	dc.l	4,(R09+G08+B18)*65536+R16+G16+B08
	dc.l	5,(R12+G10+B14)*65536+R20+G20+B10
	dc.l	6,(R15+G12+B10)*65536+R24+G24+B12
	dc.l	7,(R24+G24+B12)*65536+R31+G40+B14


	bss

	ifne	VLM_MODULE
tmpscrp	ds.l	1
service_struct ds.l	1
	endc
	
	ifeq	VLM_MODULE
fake_left_spec	ds.w	128
fake_right_spec	ds.w	128
	stdbss
	endc

steps	ds.w	1

left_spec_p	ds.l	1
right_spec_p	ds.l	1
left_volume	ds.l	1
right_volume	ds.l	1


dotpos	ds.l	DOTS*COLS*2
dotspeed	ds.l	DOTS*COLS*2*2

saved1	ds.l	DOTS*COLS*32*2+1
saved2	ds.l	DOTS*COLS*32*2+1

scr1	ds.w	XRES*YRES
scr2	ds.w	XRES*YRES
