
dspmod33_init:		equ	28
dspmod33_off:		equ	32
dspmod33_playeron:	equ	36
dspmod33_playeroff:	equ	40
dspmod33_playmusic:	equ	44
dspmod33_playtime:	equ	48
dspmod33_modtype:	equ	52
dspmod33_fx:		equ	56
dspmod33_not_used:	equ	60
dspmod33_flags:		equ	61
dspmod33_surrounddelay:	equ	62
dspmod33_dsptracks:	equ	64
dspmod33_playinfos:	equ	66
dspmod33_samplesets:	equ	70


dspmod33_interpolation:	equ	0
dspmod33_surround:	equ	0


; dspmod33 - April 27, 1999
; by bITmASTER of TCE
;
; Additional patches and fixes by Noring/NoCrew
; and Evil/DHS, thanks to Earx/FUN for tips.
;
; There was an error in dspmod32 with FastRam machines.
; The DMA-Playbuffer was allocated to FastRam and
; caused random ST-RAM overwrites (one 8k block).
;
; Use this routine from the VBL or a Timer. It can
; be anything between 50-100 Hz (maybe more as well).
;
; This file assembles right off with Devpac and
; Assemble.


	section	text

begin:

	move.l	4(sp),a5				;address to basepage
	move.l	$0c(a5),d0				;length of text segment
	add.l	$14(a5),d0				;length of data segment
	add.l	$1c(a5),d0				;length of bss segment
	add.l	#$1000,d0				;length of stackpointer
	add.l	#$100,d0				;length of basepage
	move.l	a5,d1					;address to basepage
	add.l	d0,d1					;end of program
	and.l	#-2,d1					;make address even
	move.l	d1,sp					;new stackspace
	move.l	d0,-(sp)				;mshrink()
	move.l	a5,-(sp)				;
	move.w	d0,-(sp)				;
	move.w	#$4a,-(sp)				;
	trap	#1					;
	lea	12(sp),sp				;

	move.w	#0,-(sp)				;mxalloc() - reserve stram only
	move.l	#8000,-(sp)				;for dma playbuffer
	move.w	#$44,-(sp)				;
	trap	#1					;
	addq.l	#8,sp					;
	tst.l	d0					;check if there is stram enough
	beq.w	exit_nostram				;nope
	move.l	d0,dspmod33_dma_pointer			;store address of stram buffer




	bsr.w	dspmod33_supervisor_in			;enter supervisor for inits

	bsr.w	dspmod33_start				;init dspmod
	bsr.w	dspmod33_play_module			;start player
	move.l	#dspmod33_vbl,$04d2.w			;place routine on vbl

	bsr.w	dspmod33_supervisor_out			;exit supervisor - inits done



	move.w	#7,-(sp)				;wait for keypress
	trap	#1					;
	addq.l	#2,sp					;



	bsr.w	dspmod33_supervisor_in			;enter supervisor for restore

	clr.l	$04d2.w					;remove vbl routine
	bsr.w	dspmod33_stop				;stop player and restore dsp

	bsr.w	dspmod33_supervisor_out			;exit supervisor - restore done



exit_nostram:
	clr.w	-(sp)					;terminate program
	trap	#1					;






;
; subroutines
;


dspmod33_supervisor_in:
	clr.l	-(sp)					;enter supervisormode
	move.w	#32,-(sp)				;
	trap	#1					;
	addq.l	#6,sp					;
	move.l	d0,dspmod33_save_stack			;
	rts

dspmod33_supervisor_out:
	move.l	dspmod33_save_stack,-(sp)		;exit supervisor
	move.w	#32,-(sp)				;
	trap	#1					;
	addq.l	#6,sp					;
	rts



dspmod33_play_module:
	lea.l	dspmod33_mod,a0				;address to module
	lea.l	dspmod33_voltab4,a1			;4channel volumetable
	bsr.w	dspmod33_player+dspmod33_modtype	;check mod type
	cmp.w	#4,d0					;if 4, start module
	beq.s	.four					;
	lea.l	dspmod33_voltab8,a1			;otherwise, use 8channel table
.four:	lea.l	dspmod33_mod,a0				;address to module
	bsr.w	dspmod33_player+dspmod33_playeron 	;start playing

	ifne	dspmod33_surround
	bchg    #0,dspmod33_player+dspmod33_flags 	;toggle surround on/off
	endc

	ifne	dspmod33_interpolation
	bchg    #1,dspmod33_player+dspmod33_flags 	;toggle interpolation on/off
	endc

	rts



dspmod33_vbl:
	bsr.w	dspmod33_player+44			;call player
	rts



dspmod33_start:	
	bsr.w	dspmod33_player+dspmod33_init 		;install player

	move.w	#$200b,$ffff8932.w 			;DSP-Out-> DAC & DMA-In
	clr.b	$ffff8900.w     			;no DMA-Interrupts
	clr.b	$ffff8936.w     			;record 1 track
	move.b	#$40,$ffff8921.w 			;16 Bit

	move.b	#$80,$ffff8901.w 			;select record-frame-register
	move.l	dspmod33_dma_pointer,d0			;
	move.l	d0,d1					;
	move.b	d1,$ffff8907.w  			;Basis Low
	lsr.l	#8,d1					;
	move.b	d1,$ffff8905.w  			;Basis Mid
	lsr.l	#8,d1					;
	move.b	d1,$ffff8903.w  			;Basis High
	add.l	#8000,d0				;
	move.l	d0,d1					;
	move.b	d1,$ffff8913.w  			;End Low
	lsr.l	#8,d1					;
	move.b	d1,$ffff8911.w  			;End Mid
	lsr.l	#8,d1					;
	move.b	d1,$ffff890f.w  			;End High

	move.b	#$b0,$ffff8901.w 			;repeated record

	rts


dspmod33_stop:
	clr.b	$ffff8901.w     			;DMA-Stop
	bsr.w	dspmod33_player+dspmod33_playeroff	;stop module
	bsr.w	dspmod33_player+dspmod33_off		;dsp system off
	bsr.w	dspmod33_fix				;load new dsp bootstrap (bugfix)
	rts


dspmod33_fix:	
	include	'dsp_fix.s'				;NoCrew DSP bootstrap-code replacement




	section	data

	even

dspmod33_voltab4:
	dc.w $7fff,$7fff,$7fff,$7fff
	dc.w 0,0,0,0
	even


dspmod33_voltab8:
	dc.w $3fff,$3fff,$3fff,$3fff
	dc.w $3fff,$3fff,$3fff,$3fff
	even


dspmod33_player:
	incbin 'dspmod.tce'
	even


dspmod33_mod:						;module - can be 4-8 channels
	incbin 'sruot.mod'
	even


	section	bss

dspmod33_dma_pointer:	ds.l	1
dspmod33_save_stack:	ds.l	1