#include <aes.h>
#include <tos.h>
#include <ext.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mp2audio.h"
#include "libshoe.h"
#include "decoder.h"
#include "stream.h"
#include "replay.h"
#include "window.h"
#include "mp2info.h"

/* Function from mp2audio.c */
extern void unix2dos(char *path);

/* Functions from mp2event.c */
extern void do_formstuff(int obj_id);
extern int quit_program(void);
extern char *do_selectfile(char *);
extern void do_play(void);
extern void do_stop(void);
extern void do_pause(void);
extern void do_loop(void);
extern void do_ff(void);
extern void do_info(void);
extern void do_shoe(void);
extern void set_title(char *title);
extern void set_subtitle(char *subtitle);
extern long calc_time(void);

/* Function from console.c */
extern Byte *notify_console(char *msg);
extern void print_line(char *text);
extern void clear_console(void);
extern void prompt_console(int, int);

/* Global variable from mp2audio.c */
extern int replay, count_dir, dom;
extern long ext;

/* Global variables from mp2file.c */
extern char path[512], filename[512];

/* Global variables from mp2event.c */
extern int looping;
extern int fgexit, display_time;

Byte *bif_notify_gc(Byte *args)
{
	return notify_console(TP(args)?"gc":""), args;
}

Byte *bif_panic(Byte *msg)
{
	Byte panicmsg[1024];

	sprintf(panicmsg, "[1][%s][OK]", msg);
	form_alert(1, panicmsg);
	exit(1);
	return msg;
}

Byte *bif_date(Byte *args)
{
	Byte *r;
	unsigned int y, m, d, t;
	
	args = args;		/* Fool Pure C. */	
	t = Tgetdate();
	y = (t >> 9) + 1980;
	m = (t >> 5) & 0xf;
	d = t & 0x1f;
	sprintf(r = mem(1+4+1+2+1+2+1+1), "(%d %d %d)", y, m, d);
	return r;
}

Byte *bif_time(Byte *args)
{
	Byte *r;
	unsigned int h, m, s, t;
	
	args = args;		/* Fool Pure C. */	
	t = Tgettime();
	h = t >> 11;
	m = (t >> 5) & 0x3f;
	s = (t & 0x1f) * 2;
	sprintf(r = mem(1+2+1+2+1+2+1+1), "(%d %d %d)", h, m, s);
	return r;
}

Byte *bif_pwd(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	return memdup(path);
}

Byte *bif_cd(Byte *args)
{
	char *s, old_dir[512];
	int old_drv;
	
/*	s = decode_string(EVAL(args)); */
	s = EVAL(args);

	old_drv = Dgetdrv();
	Dgetpath(old_dir, 0);

	Dsetdrv((char)tolower((int)path[0])-'a');
	Dsetpath(path);
	
	if(strlen(s) >= 2 && s[1] == ':')
		Dsetdrv((char)tolower((int)s[0])-'a');
	Dsetpath(s);
	
	path[0] = 'A' + (char)Dgetdrv();
	path[1] = ':';
	Dgetpath(path+2, 0);
	strcat(path, "\\");
	
	Dsetdrv(old_drv);
	Dsetpath(old_dir);

	return bif_pwd("()");
}

static int match_substring(const Byte *s, const Byte *pat)
{
	Byte *n, sub[1024];

	while(*s && *pat) {
		switch(*pat) {
		case '?':
			s++;
			break;
		case '*':
			if(!pat[1])
				return 1;
			strcpy(sub, pat+1);
			n = strpbrk(sub, "?*");
			if(n == NULL)
				n = &sub[strlen(sub)];
			*n = '\0';
			n = strstr(s, sub);
			if(n == NULL)
				return 0;
			s = n;
			break;
		default:
			if(*s++ != *pat)
				return 0;
		}
		pat++;
	}
	
	if((*s && !*pat) || (!*s && *pat))
		return 0;

	return 1;
}

Byte *bif_ls(Byte *args)
{
	int ok=1;
	long err, dirhandle;
	char *r, *dir, *name;
	DTA *old_dta, pdta;
	DIRBUF dirbuf, *dirptr;
	XATTR atr, *atrptr;
	
/*	args = decode_string(EVAL(args)); */
	args = EVAL(args);

	if(dom) {
		dir = memdup(path);
		dir[strlen(dir)-1] = '\0';
		dirptr = &dirbuf;
		atrptr = &atr;
		name = dirptr->fname;
		dirhandle = Dopendir(dir, 0);
		mem(512);
		strcpy(dir, path);
		if (dirhandle > 0) {
			err = Dreaddir((int)sizeof(dirbuf), dirhandle, (void *)dirptr);
			if(!err && match_substring(dirptr->fname, NILP(args)?"*":args)) {
				if(Fxattr(0,strcat(dir, dirptr->fname), (void *)atrptr) == 0)
					ok = (((atrptr->mode & S_IFMT) == S_IFREG) ||
							((atrptr->mode & S_IFMT) == S_IFDIR) || 
							((atrptr->mode & S_IFMT) == S_IFLNK));
			} else
				ok = 0;
			strcpy(dir, path);
		} else {
			return ERR;
		}
	} else {
		old_dta = Fgetdta();
		Fsetdta(&pdta);

		dir = memdup(path);
		mem(strlen(NILP(args)?"*.*":args)+1);
		strcat(dir,NILP(args)?"*.*":args);
		err = (long)Fsfirst(dir, FA_SUBDIR | FA_HIDDEN | FA_SYSTEM);
		name = pdta.d_fname;
	}
		
	*(r = mem(3)) = '\0';
	strcat(r, "(");
	while(!err) {
		if(ok) {
			mem(strlen(name)+1);
			strcat(r, name);
			strcat(r, " ");
		}
		if(dom) {
			err = Dreaddir((int)sizeof(dirbuf), dirhandle, (void *)dirptr);
			if(!err && match_substring(dirptr->fname, NILP(args)?"*":args)) {
				if(Fxattr(0,strcat(dir, dirptr->fname), (void *)atrptr) == 0)
					ok = (((atrptr->mode & S_IFMT) == S_IFREG) || 
							((atrptr->mode & S_IFMT) == S_IFDIR) || 
							((atrptr->mode & S_IFMT) == S_IFLNK));
			} else
				ok = 0;
			strcpy(dir, path);
		} else {
			err = (long)Fsnext();
		}
	}
	if(strlen(r) > 1)
		r[strlen(r)-1] = ')';
	else
		strcat(r, ")");

	if(dom)
		Dclosedir(dirhandle);
	else
		Fsetdta(old_dta);

	return r;
}

Byte *bif_load(Byte *args)
{
	int fp;
	Byte *r;
	long fret, length;

/*	fret = Fopen(decode_string(EVAL(args)), FO_READ); */
	fret = Fopen(EVAL(args), FO_READ);
	if(fret < 0) return F;

	fp = (int)fret;
	length = filelength(fp);
	Fread(fp, length, r = mem(length+1));
	r[length] = '\0';
	Fclose(fp);

	parse_eval(r);
	return T;
}

Byte *bif_exit(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	return quit_program()?T:F;
}

Byte *bif_mp2_load(Byte *args)
{
	char *filename;

/*	file = args = decode_string(EVAL(args)); */
	filename = args = EVAL(args);
	if(FP(args))
		return F;
	if(!strchr(args, '\\')) {
		filename = memdup(path);
		mem(strlen(args));
		strcat(filename, args);
	}
	do_stop();
	if(stream_open(filename) < 0)
		return F;
	return T;
}

Byte *bif_mp2_play(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_play();
	return T;
}

Byte *bif_mp2_stop(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_stop();
	return T;
}

Byte *bif_mp2_pause(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_pause();
	return replay_pausep()?T:F;
}

Byte *bif_mp2_loop(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_loop();
	return looping?T:F;
}

Byte *bif_mp2_fast_forward(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_ff();
	return T;
}

Byte *bif_mp2_window_info(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_info();
	return T;
}

Byte *bif_mp2_window_console(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	do_shoe();
	return T;
}

Byte *bif_mp2_select(Byte *args)
{
	char *pattern = dom?"*.mp?":"*.MP?";

	return memdup(((args=do_selectfile(NILP(args)?
	       pattern:EVAL(args)))!=0)?args:F);
}

Byte *bif_mp2_type(Byte *args)
{
	Byte *s;

	args = args;		/* Fool Pure C. */	
	sprintf(s=mem(128+strlen(filename)),
	    "((filename %s) "
		"(layer 2) (bitrate %ld) (frequency %ld) "
		"(filelength %ld) (timelength %ld))",
		filename,
		mp2info.bitrate, mp2info.sample_frequency,
		mp2info.filelength, mp2info.timelength);

	return s;
}

Byte *bif_mp2_loadedp(Byte *args)
{
	args = args;
	return stream_loadedp()?T:F;
}

Byte *bif_mp2_playp(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	return replay?T:F;
}

Byte *bif_mp2_pausep(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	return replay_pausep()?T:F;
}

Byte *bif_mp2_loopp(Byte *args)
{
	args = args;		/* Fool Pure C. */	
	return looping?T:F;
}

Byte *bif_mp2_play_time(Byte *args)
{
	Byte *buf;

	args = args;		/* Fool Pure C. */	

	buf = mem(16);
	sprintf(buf, "%ld", calc_time());
	
	return buf;
}

Byte *bif_print(Byte *args)
{
	args = EVAL(args);
/*	print_line(decode_string(args)); */
	print_line(args);
	prompt_console(0, -1);
	return args;
}

Byte *bif_mp2_clear_console(Byte *args)
{
	args = args;
	clear_console();
	return T;
}

Byte *bif_mp2_close_window(Byte *args)
{
	args = args;
	window_close(-1);
	return T;
}

Byte *bif_mp2_switch_window(Byte *args)
{
	args = args;
	window_switch();
	return T;
}

Byte *bif_mp2_display_time(Byte *args)
{
	if(NILP(args))
		return (display_time = !display_time)!=0?T:F;
	return (display_time = TP(EVAL(args)))!=0?T:F;
}

Byte *bif_mp2_external_clock(Byte *args)
{
	char *arg, *new;

	if(!LISTP(args))
		return ERR;

	arg = memdup(args);
	arg++;
	arg[strlen(arg)-1] = '\0';
	
	{	
	DUAL_EVAL(arg, {
		ext0 = atol(a);
		ext1 = atol(b);

		if(ext0 != 44100L && ext0 != 48000L)
			ext0 = 0;
		if(ext1 != 44100L && ext1 != 48000L)
			ext1 = 0;

		new = mem(20);
		sprintf(new, "(%ld %ld)", ext0, ext1);

		arg = new;
	});
	}
}


Byte *bif_mp2_external_clockp(Byte *args)
{
	char *s;
	
	args = args;

	s = mem(20);
	sprintf(s, "(%ld %ld)", ext0, ext1);

	return s;
}

Byte *bif_mp2_countdown(Byte *args)
{
	if(NILP(args))
		return (count_dir = !count_dir)!=0?T:F;
	return (count_dir = TP(EVAL(args)))!=0?T:F;
}

Byte *bif_mp2_title(Byte *args)
{
	if(NILP(args))
		return set_title(""), memdup("");
/*	return set_title(decode_string(args = EVAL(args))), args; */
	args = EVAL(args);
	set_title(args);
	return args;
}

Byte *bif_mp2_subtitle(Byte *args)
{
	if(NILP(args)) {
		set_subtitle("");
		return memdup("");
	}
/*	return set_subtitle(decode_string(args = EVAL(args))), args; */
	args = EVAL(args);
	set_subtitle(args);
	return args;
}

Byte *bif_mp2_dsp_load(Byte *args)
{
	Byte *s;

	args = args;		/* Fool Pure C. */	
	sprintf(s = mem(128), "(%ld %ld)",
	        decoder_current_load(), decoder_average_load());
	return s;
}

Byte *bif_mp2_place_window_control(Byte *args)
{
	DUAL_EVAL(args, 
		{window_move(WIND_CTRL, (int)atol(a), (int)atol(b)); args=T;});
}

Byte *bif_mp2_place_window_info(Byte *args)
{
	DUAL_EVAL(args, 
		{window_move(WIND_INFO, (int)atol(a), (int)atol(b)); args=T;});
}

Byte *bif_mp2_place_window_console(Byte *args)
{
	DUAL_EVAL(args, 
		{window_move(WIND_SHOE, (int)atol(a), (int)atol(b)); args=T;});
}

void call_control_key(char c)
{
	static char s[] = "(mp2-control-x)";
	s[sizeof(s)-3] = c;
	eval(s);
}

void load_bifs(void)
{
	bif("notify-gc",  bif_notify_gc);
	bif("panic",      bif_panic);
	/* bif("error", bif_error); */

	bif("ls",         bif_ls);
	bif("pwd",        bif_pwd);
	bif("cd",         bif_cd);
	bif("time",       bif_time);
	bif("date",       bif_date);
	bif("load",       bif_load);
	bif("exit",       bif_exit);

	bif("print",      bif_print);

	bif("mp2-load",         bif_mp2_load);
	bif("mp2-play",         bif_mp2_play);
	bif("mp2-stop",         bif_mp2_stop);
	bif("mp2-pause",        bif_mp2_pause);
	bif("mp2-loop",         bif_mp2_loop);
	bif("mp2-fast-forward", bif_mp2_fast_forward);
	bif("mp2-select",       bif_mp2_select);

	bif("mp2-type",         bif_mp2_type);
	bif("mp2-play-time",    bif_mp2_play_time);

	bif("mp2-loaded?", bif_mp2_loadedp);
	bif("mp2-play?",   bif_mp2_playp);
	bif("mp2-pause?",  bif_mp2_pausep);
	bif("mp2-loop?",   bif_mp2_loopp);

	bif("mp2-window-info",    bif_mp2_window_info);
	bif("mp2-window-console", bif_mp2_window_console);

	bif("mp2-clear-console", bif_mp2_clear_console);
	bif("mp2-close-window",  bif_mp2_close_window);
	bif("mp2-switch-window", bif_mp2_switch_window);

	bif("mp2-display-time", bif_mp2_display_time);
	bif("mp2-countdown",    bif_mp2_countdown);
	bif("mp2-title",        bif_mp2_title);
	bif("mp2-subtitle",     bif_mp2_subtitle);

	bif("mp2-external-clock", bif_mp2_external_clock);
	bif("mp2-external-clock?", bif_mp2_external_clockp);

	bif("mp2-dsp-load", bif_mp2_dsp_load);

	bif("mp2-place-window-control", bif_mp2_place_window_control);
	bif("mp2-place-window-info", bif_mp2_place_window_info);
	bif("mp2-place-window-console", bif_mp2_place_window_console);
}
