/* binary2c.c
 *
 * COPYRIGHT (c) 1998 by Fredrik Noring.
 *
 * Convert binary files to C blocks.
 */

#include <stdio.h>

int main(int argc, char **argv)
{
	int state = 1, c, oc = EOF, n = 0;
	FILE *stream_in, *stream_out, *stream_template;

	if(argc-1 != 3) {
		fprintf(stderr,
		        "Binary To C converter.\n"
		        "Usage: binary2c <binary file> <output file> <template>\n\n"
		        "The instance of `$' in the template will be\n"
		        "substituted with the contents of the binary\n"
		        "file represented as a character array.");
		return 1;
	}

	stream_in = fopen(argv[1], "rb");
	stream_out = fopen(argv[2], "w");
	stream_template = fopen(argv[3], "r");

	if(!stream_in || !stream_out || !stream_template) {
		fprintf(stderr, "ERR: File error.\n");
		return 1;
	}

	while(state)
		switch(state) {
		case 1:   /* Read template. */
			c = fgetc(stream_template);
			if(c == EOF)
				state = 0;
			else if(c == '$')
				state = 2;
			else
				fputc(c, stream_out);
			break;
		case 2:   /* Read input file. */
			c = fgetc(stream_in);
			if(c == EOF) {
				fprintf(stream_out, "0x%02x", oc);
				state = 1;
			} else if(oc != EOF)
				fprintf(stream_out, "0x%02x%s", oc, (n++%10)==9?",\n":", ");
			oc = c;
		}

	fclose(stream_template);
	fclose(stream_out);
	fclose(stream_in);
	
	return 0;
}
