*-----------------------------------------------------------ENGLISH.M-1.00--*
*                            Q U i N C Y                                    *
*                            _-_-_-_-_-_                                    *
*              8 tracks digital audio recorder for Falcon030                *
*                                                                           *
*                           DEMO VERSION                                    *
*                                                                           *
*                            PARX, 1996                                     *
*---------------------------------------------------------------------------*

                            SHORT MANUAL
                            ~~~~~~~~~~~~
                          

CONFIGURATION
=============

QUiNCY works with all Falcon030 screen resolutions, from monochrome to True 
Color. However :
- 640*400 pixels are needed to see the whole windows.
- your are STRONGLY ADVISED to avoid using more than 16 colors. 
- 3 MO of RAM are needed. Avoid installing too much accessories or utilities.

CONNECTIONS
===========

Plug a source (microphone, guitar, synth...) into the Falcon030 AUDIO input. 
WARNING, be sure that the source level matches the input sensitivity. 
Connect the Falcon030 AUDIO output to a stereo amp (AUX or CD).
If you have a MIDI synth, connect the Falcon030 MIDI OUT to the synth MIDI IN. 

CREATE A TAPE
=============

The first thing to do is to create a tape (Menu 'File', 'Create Tape'). In the 
'Create Tape' window, select the file location and name, the sampling 
frequency, the number of tracks, the tape duration.

If you have a SCSI disk, you'd better work with it. QUiNCY can work with an 
IDE disk too, but works better with a SCSI one.

RECORD
======

To record track 1, connect your source into the LEFT AUDIO input. Odd tracks 
(1, 3, 5 & 7) receive LEFT input, even tracks receive RIGHT input.

Select track 1 little REC button. Click on PAUSE, then on RECORD. If you 
switch on Monitoring ('Monitor' frame), VUmeters show input signal level. 

Release PAUSE, recording starts.

When terminated, QUiNCY goes into 'REPLAY' mode :
- the just recorded tape part is shown in the COMMAND BAR (the black 
  rectangle above the command deck),
- the 'Monitor' frame is replaced by a 'REPLAY' frame.

While you are in REPLAY mode, the sound you have recorded is not yet 
'written' onto tape, but kept in a temporary file.

To hear your take, rewind (press 0 on the numeric pad), then click on PLAY.

To keep your take, click on the 'KEEP' icon in the 'REPLAY' frame.

TRACKS 'REC' BUTTONS
==================

The state of the little 'REC' button at the bottom of each track specifies the 
sound origin for that track.

              *-----------------------------*------------------------*
              |       REC released          |    REC  selected       |
*-------------|-----------------------------|------------------------|
| NORMAL mode |  what is on tape            |  sound source          |
|-------------|-----------------------------|------------------------|
| REPLAY mode |  what was on tape before    |  what has just been    |
|             |   recording                 |   recorded             |
*-------------*-----------------------------*----------------------- *

So, in REPLAY mode, you can compare your last recording (to be listened with 
the REC button selected) with what was on the track before recording (REC 
released). This allows to make a take without running the risk of loosing the 
previous take, compare the two takes, then decide to keep the last take 
('KEEP') or give it up ('GIVE UP').

TAPE POSITIONING
================

To move the (read/write) head, you can :

- use the forward or rewind keys. With right mouse button, speed is twice the 
normal speed; with left mouse button, speed increases progressively.

- click directly on the command bar.

- press + or - key on numeric pad (moves forwards/backwards 1 second).

This works the same when tape is running.

You can create up to 9 marks on the tape (for ex. start of verse, start of 
chorus...). To place a mark, press a SHIFT key, then type a digit from 1 to 9 
on the numeric pad : the mark is created at the head position. Now, when 
you'll type this digit, the head will move to the mark position. To delete a 
mark, type CONTROL+digit.

LOCATORS
========

Locators are special marks indicated by two yellow triangles in the command 
bar. To place the LEFT locator  (resp. RIGHT ), press the LEFT SHIFT key 
(resp. RIGHT SHIFT) and click on the command bar. You can also forward/rewind 
the locators by pressing the corresponding SHIFT key, then clicking on the 
forward/rewind keys.

Locators are only in effect when the LIMITED key (two opposite triangles) is 
selected.

When recording, locators locate Punch In/Punch Out points : recording begins
at locator  and ends at locator .

When playing, locators effect depend on the CYCLE key (two cycling arrows) 
state :
- CYCLE released : playing stops at 
- CYCLE selected : playing loops between the two locators.

MIXING TABLE
============

You can choose ('Use' frame) between :
- Two globals effects, with setting of effect send for each track (EFF1 & 
  EFF2), and setting of effect return ('Mix' frame).
- Two +- 12 dB filters (Bass and Treble) for each track.

To select an effect (1 or 2), use the pop-up menu in the 'Effects' frame. When 
selecting an effect, a window with effect settings opens automatically.

This is the general scheme:

              LEFT       RIGHT
               ^           ^
               |           |
               |           |
           --------    -------- 
          |  add   |  |  add   |
           --------    -------- 
            |   | |     |  | | 
            |   | *-----|--|-*-----------------*
            |   |       |  |                   |
            |   *-------|--*-------*           |
            |           |          |           |
            |L          |R         |           |
        --------------------    -------     ------- 
       |        MAIN        |  | EFF 1 |   | EFF 2 |    Mix
        --------------------    -------     ------- 
            |           |          |           |     
            |           |          |           |
            |           |       -------     ------- 
            |           |      | eff 1 |   | eff 2 |    Effects
            |           |      | module|   | module|
            |           |       -------     ------- 
            |           |          |           |
            |           |          |           |
        --------    --------    --------    -------- 
       |  add   |  |  add   |  |  add   |  |  add   |
        --------    --------    --------    -------- 
        ||||||||    ||||||||    ||||||||    |||||||| 
        |.......    |.......    |.......    |....... 
        |.......    |.......    |.......    |....... 
        |           |           |           |
        |   *-------*           |           |
        |   |                   |           |
        |L  |R                  |           |
       -------               -------     -------
      |  PAN  |             | EFF1  |   | EFF2  |        Track
       -------               -------     -------
          |            /        |           |
          *-------*---*  O------*-----------*
                  |
                  |
          *-------*-----------------*         
          |                         |
       -------     -------          |
      |       |<--| TREBL |         |
      |       |    -------          |
      |FILTERS|                     |
      |       |    -------          |
      |       |<--| BASS  |         |
       -------     -------          |
          |                         |
          *-----O | O---------------*
                  |
               ------- 
              | LEVEL |
               -------
                  |
                  |
                  ^

The two switches (at LEVEL output and EFF1&2 input) are controled together by 
'Effects/Equalizer' selection in the 'Use' frame.

Track settings and 'Input'/'Ouput' settings can be controlled by pairs by 
using the right mouse button.

REMIX
=====

When the 'Remix' button is selected, the sound coming into the Falcon030 
inputs (2 tracks) is replaced by the sound coming from the mixing table
(2 tracks too).

This allows to 'reduce' several tracks, with mixing, into one or two tracks.
Note that destination track(s) (REC button selected) do(es) not need to be 
different from mixed tracks. So, for example, you can:
- remix tracks 1 to 4 onto tracks 1 and 2,
- remix track 1 onto itself, adding equalization or effects.
Of course, if you keep ('REPLAY' frame) the remix, one or two original tracks 
are lost. However, with REPLAY mode you can listen to the result before any 
irreversible action.

SHORTCUTS
=========

Globaly, numeric pad keys may be used for tape positionning.
Here are the functions associated to numeric pad :

ENTER     PLAY

.         PAUSE

0 or
SPACE     STOP if playing, total rewind elsewhere

(         go to  locator

)         go to  locator

/         CYCLE on/off

Shift /   locators on/off

*         RECORD

+         time display : forward 1 second
          metric display: go to next bar.

-         time display : backward 1 second
          metric display: go to previous bar.

Shift 1-9 Create mark 1-9

1-9       go to mark 1-9

Ctrl 1-9  clear mark 1-9

Other shortcuts for QUiNCY window:

F1-F8        SOLO track 1-8

Shift F1-F8  MUTE track 1-8

Ctrl F1-F8   REC  track 1-8

Insert       switch counters SHOW mode (time/metric).

All these shortcuts work even if QUiNCY window is not on top, or even closed.

'DISK' WINDOW
=============

* 'Record into Folder'
When recording, QUiNCY does not write at once the recorded sound onto tape, 
but first into Falcon memory, then into a temporary file that has the same 
name as the tape, with .TMP extension.

Temporary file is created when mounting the tape, with a sufficient size to 
record during the whole tape lenght. If 'Current' button is selected, this 
file is created in the same folder as the tape. If 'Fixed' is selected, the 
file will be created in the path given in the button just below. The temporary 
file is deleted when discardind the tape.

If there is not enough free space on disk to create the TMP file, QUiNCY warns 
you. In this case, TMP file is not created, and you cannot record. You should 
then indicate to QUiNCY where (on what disk unit) it may find sufficient disk 
space.

To change this path, click on the button below 'Fixed', file selector is 
called and you can choose the new path - doing this automatically select the 
'Fixed' option.

* 'Clipboard'
Do you know the Clipboard ? It's a folder named C:\CLIPBRD that softwares use 
to exchange informations, with well-known Copy and Paste functions. QUiNCY 
manages these editing functions ('Editor' window), and by the way uses the 
Clipboard.

Unfortunately, the Clipboard is in principle located on unit C:\ which is 
often a small size unit. It may be possible that free disk space on C:\ is 
insufficient to contain these big files that D2D produces.

QUiNCY allows to change Clipboard location. After changing it, all softwares 
will take into account this new location, even after you've leaved QUiNCY.
And this will last until you change the location again (with QUiNCY or with a 
CPX), or reboot the computer. So, be careful with that.

EDITOR WINDOW
=============

This window shows graphically the tape contents : sound is displayed with 
curves. If you've mounted a 2 tracks tape, you can see these two tracks. If 
your tape has more than 2 tracks, you can select the displayed tracks by 
clicking on the 1 to 8 small buttons at leftside (note that you can display 
the same track twice).

While QUiNCY is plotting the curves, you can interrupt it by pressing the 
'Esc' key.

To select a block, press the mouse bouton and move the mouse. With the left 
button, you select a one-track block; with the right button, block contains 
the two displayed tracks.

All operations given in the 'Editor' window affect only the selected block :
- Copy, Clear, Export, Analyze, Fade, Level act on the block,
- Paste, Import : import begins at the start of block.

At the top of the window, there are two lines of small buttons (labels on the 
first, couters on the second). Besides giving information, these button have 
positionning functions, using drag & drop.

For example, click on the head position counter and keep the mouse button 
pressed. A ghost frame appears, it stands for the head position value. Move 
the mouse rightward to the left locator position counter, and drop : the left 
locator (which has 'received' a new value) moves to the head position. There 
are many possibilities, just try them. You can also make a drag&drop with the 
first line buttons : select a block, then drag 'BLOCK' onto 'DISPLAYED', the 
displayed range of tape now covers exactly the selection.

COUNTERS EDITING
================

All counters (QUiNCY and Editor windows) can be changed by keyboard action.
Double-click on a counter : a white cursor appears. Type the desired value, 
then Return to validate.
To cancel a counter edition, just click on it.

MIDI WINDOW
===========

From this window, you can load a MIDIFile. Once the file is loaded, the 
'MIDIFile' frame shows the MIDI tracks.

To let the MIDIFile play, you need to select the 'MIDIFile' button in the 
'Output' frame. In the track list, little LEDs allow to mute tracks.

If the 'MIDI Clock' button is selected, QUiNCY sends on MIDI OUT clock 
messages to synchronize an external sequencer (note that CYCLE playing does 
not work on the external sequencer).

The 'Metronome' button allows to send to synth notes messages on every beat of 
the tune.

Last, the 'Silence!' button sends 'All Notes Off' message on all MIDI 
channels.

TROUBLESHOOTING
===============

Globaly, QUiNCY needs availability of all Falcon030 resources (memory, CPU, 
bus).

You should never use more than 16 colors with QUiNCY. Best results are 
obtained in black & white, 640x480 pixels.

If you get the message 'Disk time out' :
- Verify the disk fragmentation, and clean it if necessary.
  QUiNCY gibes informations about file fragmentation. A fragmented disk really 
  reduces preformance.
- Try to increase avalaible free memory, and select 'large' buffers. You 
  should have a value of 100 % as 'got' memory ('Disk' window).
- Avoid 'moving things' on screen : close the 'Editor' window, switch off 
  VUmeters.
- Do not move the mouse (use keyboard), or do it slowly.

Here are some known problems :

- Track 8 is furtively heard in track 1.
  This occurs sometimes, with a 49 kHz 8 tracks tape, when using large screen 
  display. It is a Falcon bus overflow problem. Work in 640x480 mode, with 16 
  colors maximum.

- When recording from external digital input (DSP port), incoming sound cannot 
  be heard.
  QUiNCY cannot play at the same time the sound coming out of the tape and the 
  sound coming in the external digital inputs. You should amplify your source 
  by another mean. 

- When using external digital input (resp. output), global level settings 
  (those from 'Input' (resp. 'Output') frame) do not work.
  These settings only work with on-board analogic input/output.

- The mouse 'jumps'.
  It is a Falcon bus overflow problem. Work in 640x480 mode, with 16 
  colors maximum.


QUiNCY is published by
======================

PARX
9, rue du pin dor
53000 - LAVAL
FRANCE
tel (33)43.56.92.76
fax (33)43.56.80.47

NesT    : 90:8/0
AtariNet: 51:900/0
Internet: herve@parx.frmug.fr.net
