VLM_MODULE:	=	1
SHOWVBL:	=	0

******** OBJECT EQUS ********

tunnelxblocks:	=	20
tunnelwidth:	=	tunnelxblocks*16
tunnelyblocks:	=	100/8
tunneldistance:	=	$5000

		RSRESET
camparam1:	RS.W	1
camparam2:	RS.W	1
camparam3:	RS.W	1
camparam4:	RS.W	1
camtblsize:	RS.W	1

	TEXT

	IFNE	VLM_MODULE
	OPT	D-
	OUTPUT	E:\WHIP!\VLM\RAYTUN.VLM
	ELSE
	COMMENT	HEAD=%101
	INCBIN	MINIWHIP.BIN
	ENDC

	DC.B	"VLM2"
	DC.L	infotext
	DC.L	settings
	DC.L	init
	DC.L	deinit
	DC.L	main

	INCLUDE	VLMSERV.S
	INCLUDE	FIMATH.I
	TEXT
	INCLUDE	FSCR.I
	TEXT

main:	bsr	scrswap

* Do left spectrum shit...
	movea.l	service_struct,a1
	movea.l	16(a1),a1
	jsr	(a1)
	moveq	#128-1,d7
	lea	leftspec_tbl,a1
	lea	pal16d_tbl,a2
	moveq	#0,d0

.leftspecloop:
	move.b	(a0),d0
	addq	#2,a0
	move.l	(a2,d0.l*4),(a1)+
	dbra	d7,.leftspecloop
	
* Do right spectrum shit..
	movea.l	service_struct,a1
	movea.l	20(a1),a1
	jsr	(a1)
	moveq	#128-1,d7
	lea	rightspec_tbl+128*4,a1
	lea	pal16d_tbl,a2
	moveq	#0,d0

.rightspecloop:
	move.b	(a0),d0
	addq	#2,a0
	move.l	(a2,d0.l*4),-(a1)
	dbra	d7,.rightspecloop

	lea	cam_tbl,a4
	lea	sine_tbl,a2
	move.w	$4bc.w,d0
	move.w	d0,d1
	lsr.w	#4,d0
	lsr.w	#2,d1
	;move.w	d1,camparam4(a4)
	Do_SinModulo	d1
	Get_SinCos	a2,d1,d0,d1
	asr.w	#4,d0
	asr.w	#3,d1
	move.w	d0,camparam1(a4)
	move.w	d1,camparam2(a4)
	asr.w	#1,d1
	eori.w	#$8000,d1
	Do_SinModulo	d1
	Get_Sin	a2,d1,d0
	asr.w	#2,d0
	move.w	$4bc.w,d1
	lsl.w	#5,d1
	move.w	d1,camparam3(a4)

	lea	grid_tbl,a1
	lea	cam_tbl,a4
	bsr	CALC_FASTRAYTUNNEL

	lea	leftspec_tbl,a5
	lea	grid_tbl,a1
	bsr	PLOT_RAYTUNNEL

	IFNE	SHOWVBL

	movea.l	scr,a3
	move.w	$4bc.w,d7
	move.w	.old4bc(pc),d6
	move.w	d7,.old4bc
	sub.w	d6,d7
	subq.w	#1,d7
	cmpi.w	#50,d7
	bhs.s	.end_showvbl

.vsl:	move.l	#$ffff0000,(a3)+
	dbra	d7,.vsl

.end_showvbl:
	moveq	#0,d0
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+

	ENDC
	
	rts

.old4bc:
	DC.W	0

init:	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x100x16

	lea	pal32_tbl,a0
	lea	flowinstr_tbl,a1
	lea	pal16d_tbl,a2
	bsr	MAKE_COLORFLOWD

	lea	multiply_tbl,a0
	bsr	CALC_MULTIPLYTABLE

	lea	length_tbl,a0
	bsr	CALC_LENGTHTABLE

	lea	cam_tbl,a0
	move.w	#0,camparam1(a0)
	move.w	#0,camparam2(a0)
	move.w	#0,camparam3(a0)
	move.w	#0,camparam4(a0)
	
	lea	scr1,a0
	bsr	CLEAR_320100TSCR
	lea	scr2,a0
	bsr	CLEAR_320100TSCR
	lea	scr3,a0
	bsr	CLEAR_320100TSCR
	rts

deinit:	rts

* <UNIT><GRaDiaToR><UNIT>
* INPUT: a0: 32 bitch output palette
*        a1: colorflow instruction table
*        a2: 16bit*2 output palette
MAKE_COLORFLOWD:
	movea.l	a0,a3
	move.w	(a1)+,d7
	moveq	#0,d0
	move.w	(a1)+,d0
	moveq	#1,d6
	lsl.w	d0,d6
	move.w	d7,d5
	mulu.w	d6,d5
	move.w	d5,(a0)+
	subq.w	#1,d6
	move.w	d6,d5
	subq.w	#1,d7

.biglop:
	move.l	(a1)+,d1
	move.l	(a1),d2
	moveq.l	#0,d3
	move.l	d3,d4
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
	move.l	a0,a6
.lop1:	swap	d3
	move.b	d3,3(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop1
	move.w	d5,d6
	move.l	a6,a0
	moveq	#0,d3
	move.l	d3,d4
	swap	d1
	swap	d2
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
.lop2:	swap	d3
	move.b	d3,1(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop2
	move.l	a6,a0
	move.w	d5,d6
	moveq.l	#0,d3
	move.l	d3,d4
	swap	d1
	swap	d2
	rol.l	#8,d1
	rol.l	#8,d2
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
.lop3:	swap	d3
	move.b	d3,(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop3
	move.w	d5,d6
	dbra	d7,.biglop

	movea.l	a3,a1			* truepal (32 bit)
	move.l	a2,a0			* realpal (16 bit)
	move.w	(a1)+,d7

.loop:	moveq	#0,d0
	move.b	(a1)+,d0
	andi.b	#%11111000,d0
	lsl.w	#8,d0
	moveq	#0,d1
	move.b	(a1)+,d1
	andi.b	#%11111100,d1
	lsl.w	#3,d1
	moveq	#0,d2
	addq.l	#1,a1
	move.b	(a1)+,d2
	lsr.w	#3,d2
	or.w	d2,d0
	or.w	d1,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	dbra	d7,.loop

	rts

* INPUT: a0: tableaddress
CALC_LENGTHTABLE:
	lea	256(a0),a1
	lea	((256*255).l,a0),a2
	lea	((256*255).l,a1),a3
	move.l	#1200<<16,d5			* Radius of tunnel.

	moveq	#-128,d7

.yloop:	moveq	#-128,d6
	move.w	d7,d0
	muls.w	d7,d0
	movea.l	d0,a6
	
.xloop:	move.w	d6,d1
	muls.w	d6,d1
	add.l	a6,d1
	subq.l	#1,d1
	bsr	CALC_ATARISQRT
	move.l	d5,d2
	divu.l	d0,d2
	move.b	d2,(a0)+
	move.b	d2,-(a3)
	move.b	d2,-(a1)
	move.b	d2,(a2)+
	addq.w	#1,d6
;	cmpi.w	#128,d6
	bne.s	.xloop

	lea	128(a0),a0
	lea	384(a1),a1
	lea	-384(a2),a2
	lea	-128(a3),a3
	addq.w	#1,d7
;	cmpi.w	#128,d7
	bne.s	.yloop

	rts

* INPUT: a0: tableaddress
CALC_MULTIPLYTABLE:
	moveq	#-128,d7

.yloop:	moveq	#-128,d6

.xloop:	move.w	d6,d0
	muls.w	d7,d0
	add.w	d0,d0
	subq.w	#1,d0
	move.w	d0,(a0)+
	addq.w	#1,d6
	cmpi.w	#128,d6
	bne.s	.xloop

	addq.w	#1,d7
	cmpi.w	#128,d7
	bne.s	.yloop
	rts

* INPUT: a1: address of gridtable
*        a4: address of cameratable
CALC_FASTRAYTUNNEL:

		RSRESET
.x0:		RS.L	1
.y0:		RS.L	1
.z0:		RS.L	1
.x1:		RS.L	1
.y1:		RS.L	1
.z1:		RS.L	1
.x2:		RS.L	1
.y2:		RS.L	1
.z2:		RS.L	1
.dx:		RS.L	1
.dy:		RS.W	1
.dz:		RS.W	1
.cornertblsize:	RS.W	1

	Do_SinModulo	camparam1(a4)
	Do_SinModulo	camparam2(a4)
	lea	sine_tbl,a0
	move.w	#tunnelxblocks*1900,d7	* x end value
	move.w	#-tunnelxblocks*1900,d0	* x start value
	swap	d7
	move.w	#tunnelyblocks*1900,d7	* y end value
	move.w	#-tunnelyblocks*1900,d1	* y start value
	lea	.corner_tbl(pc),a5

* Precalculate 3d-transformations of the corner, so you can interpolate all the
* coordinates between those.
* Calculate (x0,y0,z0) upperleft corner of grid.
	move.w	#tunneldistance,d2	* Screen distance by observer (ie. focal lenght!)
	move.w	camparam1(a4),d3	* Rotates ray on X axis.
	Get_SinCos	a0,d3,d3,d4	* Get sin(a) and cos(a).
	move.w	d3,d5
	move.w	d4,d6
	muls.w	d2,d3			* z*sin
	muls.w	d1,d4			* y*cos
	muls.w	d1,d5			* y*sin
	muls.w	d2,d6			* z*cos
	add.l	d5,d6			* Z
	sub.l	d3,d4			* Y
	add.l	d6,d6
;	add.l	d4,d4
	swap	d6
	move.l	d4,.y0(a5)
	move.w	camparam2(a4),d3	* Rotate ray on Y axis.
	Get_SinCos	a0,d3,d3,d4 	* Get sin(b) and cos(b).
	move.w	d3,d5
	move.w	d4,d2
	muls.w	d0,d3			* x*sin
	muls.w	d6,d5			* Z*sin
	muls.w	d0,d2			* x*cos
	muls.w	d6,d4			* Z*cos
	add.l	d2,d5			* X
	sub.l	d3,d4			* Z
;	add.l	d5,d5
;	add.l	d4,d4
	move.l	d5,.x0(a5)		* Store X.
	move.l	d4,.z0(a5)		* Store Z.
* Calculate (x2,y2,z2) lower left corner of grid.
	move.w	#tunneldistance,d2	* Screen distance by observer (ie. focal lenght!)
	move.w	camparam1(a4),d3	* Rotates ray on X axis.
	Get_SinCos	a0,d3,d3,d4	* Get sin(a) and cos(a).
	move.w	d3,d5
	move.w	d4,d6
	muls.w	d2,d3			* z*sin
	muls.w	d7,d4			* y*cos
	muls.w	d7,d5			* y*sin
	muls.w	d2,d6			* z*cos
	add.l	d5,d6			* Z
	sub.l	d3,d4			* Y
	add.l	d6,d6
;	add.l	d4,d4
	swap	d6
	move.l	d4,.y2(a5)
	move.w	camparam2(a4),d3	* Rotate ray on Y axis.
	Get_SinCos	a0,d3,d3,d4 	* Get sin(b) and cos(b).
	move.w	d3,d5
	move.w	d4,d2
	muls.w	d0,d3			* x*sin
	muls.w	d6,d5			* Z*sin
	muls.w	d0,d2			* x*cos
	muls.w	d6,d4			* Z*cos
	add.l	d2,d5			* X
	sub.l	d3,d4			* Z
;	add.l	d5,d5
;	add.l	d4,d4
	move.l	d5,.x2(a5)		* Store X.
	move.l	d4,.z2(a5)		* Store Z.
* Calculate (x1,y1,z1) upper right corner of grid.
	move.w	#tunneldistance,d2	* Screen distance by observer (ie. focal lenght!)
	swap	d7
	move.w	camparam1(a4),d3	* Rotates ray on X axis.
	Get_SinCos	a0,d3,d3,d4	* Get sin(a) and cos(a).
	move.w	d3,d5
	move.w	d4,d6
	muls.w	d2,d3			* z*sin
	muls.w	d1,d4			* y*cos
	muls.w	d1,d5			* y*sin
	muls.w	d2,d6			* z*cos
	add.l	d5,d6			* Z
	sub.l	d3,d4			* Y
	add.l	d6,d6
;	add.l	d4,d4
	swap	d6
	move.l	d4,.y1(a5)
	move.w	camparam2(a4),d3	* Rotate ray on Y axis.
	Get_SinCos	a0,d3,d3,d4 	* Get sin(b) and cos(b).
	move.w	d3,d5
	move.w	d4,d2
	muls.w	d7,d3			* x*sin
	muls.w	d6,d5			* Z*sin
	muls.w	d7,d2			* x*cos
	muls.w	d6,d4			* Z*cos
	add.l	d2,d5			* X
	sub.l	d3,d4			* Z
;	add.l	d5,d5
;	add.l	d4,d4
	move.l	d5,.x1(a5)		* Store X.
	move.l	d4,.z1(a5)		* Store Z.

* Interpolate all the coordinates in the grid and do the texture-calculation.
	movea.l	a1,a3
	move.w	camparam3(a4),-(sp)
* Do xloop-increment initialization.
	movem.l	.x0(a5),d4-d6
	movem.l	.x1(a5),d0-d2
	sub.l	d4,d0
	sub.l	d5,d1
	sub.l	d6,d2
	movea.l	d4,a0
	movea.l	d5,a1
	movea.l	d6,a2
	divs.l	#tunnelxblocks,d0
	divs.l	#tunnelxblocks,d1
	divs.l	#tunnelxblocks,d2
	asr.l	#8,d5
	move.w	d5,d4
	swap	d4
	swap	d5
	swap	d6
	movem.l	d4-d6,(a5)
	asr.l	#8,d1
	move.w	d1,d0
	swap	d0
	swap	d1
	swap	d2
	move.l	d0,a4
	move.l	d1,d3
	move.l	d2,a6
* Do yloop-increment initialization.
	movem.l	.x2(a5),d0-d2
	sub.l	a0,d0
	sub.l	a1,d1
	sub.l	a2,d2
	divs.l	#tunnelyblocks,d0
	divs.l	#tunnelyblocks,d1
	divs.l	#tunnelyblocks,d2
	asr.l	#8,d1
	move.w	d1,d0
	swap	d0
	swap	d1
	swap	d2
	move.l	d0,.dx(a5)
	move.w	d1,.dy(a5)
	move.w	d2,.dz(a5)
	
	moveq	#tunnelyblocks,d7
	lea	length_tbl+32768+128,a0
	lea	multiply_tbl+(32768+128)*2,a1
	lea	atan2_tbl+(32768+128)*2,a2
	move.w	(sp)+,d2

.yloop:	swap	d7
	move.w	#tunnelxblocks,d7	* x loopcounter

* t = r / sqrt(x^2 + y^2)
* v = t * z
* u = atan2(y, x)

* a0	LUT	lut[(a<<8)+b] = r / sqrt(a^2 + b^2)
* a1	LUT	lut[(a<<8)+b] = a * b
* a2	LUT	lut[(a<<8)+b] = (atan2(b, a)/PI) << 8
* a3	tunneltab
* d4	x,y	yy00XXxx
* d5	y	......YY
* d6	z	....ZZzz
* a4	dx,dy	yy00XXxx
* d3	dy	......YY
* a6	dz	....ZZzz
* d0,d1: trashed.

.xloop:	move.w	d4,d0			* 2   Combine x & y vectors.
	move.b	d5,d0			* 2
	move.w	(a2,d0.w*2),(a3)+	* 12? u = atan2(y, x)
	add.l	a4,d4			* 4?  / Interpolate
	addx.b	d3,d5			* 2   | direction-
	dbra	d7,.xloop

	movem.l	(a5),d4-d6
	add.l	.dx(a5),d4
	move.w	.dy(a5),d0
	addx.w	d0,d5
	add.w	.dz(a5),d6
	movem.l	d4-d6,(a5)

	swap	d7
	dbra	d7,.yloop

	rts

.corner_tbl:
	DS.B	.cornertblsize

* INPUT: a1: address of (u,v) grid
*        a5: address of texture
PLOT_RAYTUNNEL:
	movea.l	scr,a0
	lea	(tunnelxblocks+1)*2(a1),a2
	lea	320-tunnelwidth(a0),a0
	moveq	#tunnelyblocks-1,d7	* y loop counter
	moveq	#0,d0

.scanlineloop:
	moveq	#tunnelwidth/16-1,d6	* x loop counter
	
.square:
	move.w	(a2)+,d1		* u4
	move.w	(a1)+,d3		* u1
	move.w	(a2),d2			* u3
	move.w	(a1),d4			* u2
	sub.w	d3,d1			* u4-u1
	sub.w	d4,d2			* u3-u2
	lsl.w	#3,d1			* / sign-extend
	lsl.w	#3,d2			* | to prevent
	asr.w	#3,d1			* | carry-errors..
	asr.w	#3,d2			* \
	lsl.w	#3,d3			* / Multiply start U's by 8.
	lsl.w	#3,d4			* \ (instead of dividing dU's by 8)
	movea.l	d3,a3
	movea.l	d4,a4
	moveq	#8-1,d5

.Yspan:	move.w	a3,d3			* uL,vL
	move.w	a4,d4			* uR,vR
	sub.w	a3,d4			* uR-uL
	asr.w	#3,d4

	REPT	8
	move.w	d3,d0
	lsr.w	#8,d0
	move.l	(a5,d0.l*4),(a0)+	* put doublepixel on screen
	add.w	d4,d3			* u+du
	ENDR

	lea	(320-16)*2(a0),a0	* next span
	add.l	d1,a3			* uL+duL
	add.l	d2,a4			* ur+duR
	dbra	d5,.Yspan

	lea	(-8*320+16)*2(a0),a0	* next nice little square
	dbra	d6,.square

	addq	#2,a1
	addq	#2,a2
	lea	((320-tunnelwidth)+320*7)*2(a0),a0
	dbra	d7,.scanlineloop
	rts

scrswap:
	lea	scr,a0
	move.l	(a0)+,d0
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
	move.l	d0,d1
	lsr.w	#8,d0
	move.l	d0,$ffff8200.w
	move.b	d1,$ffff820d.w
	rts

	DATA

atan2_tbl:
	INCBIN	ATAN2TBL.DAT
sine_tbl:
	INCBIN	SINUS.DAT

scr:	DC.L	scr1,scr2,scr3

settings:
	DC.L	0

flowinstr_tbl:
	DC.W	(.end-.start)/4
	DC.W	4
.start:	DC.L	$00000000	;DC.L	$00000000
	DC.L	$1f000000	;DC.L	$003f0000
	DC.L	$3f000000	;DC.L	$007f0000
	DC.L	$5f000000	;DC.L	$3fdf0000
	DC.L	$7f000000	;DC.L	$7fff0000
	DC.L	$9f000000	;DC.L	$dfff0000
	DC.L	$bf000000	;DC.L	$ffff0000
	DC.L	$df000000	;DC.L	$ffff003f
	DC.L	$ff00003f	;DC.L	$ffff007f
	DC.L	$ff00007f	;DC.L	$ffff00bf
	DC.L	$ff0000bf	;DC.L	$ffff00ff
	DC.L	$ff0000ff	;DC.L	$ffff00ff
	DC.L	$ff3f00ff	;DC.L	$ffff00ff
	DC.L	$ff7f00ff	;DC.L	$ffff00ff
	DC.L	$ffbf00ff	;DC.L	$ffff00ff
	DC.L	$ffff00ff	;DC.L	$ffff00ff
	DC.L	$ffff00ff	;DC.L	$ffff00ff
.end:

infotext:
	DC.B	"FREE SPECTRAL TUNNEL",0
	DC.B	"Author:  eARx/fUN InD.",0
	DC.B	"Version: 1.0",0
	DC.B	"Date:    16-08-1999",0
	DC.B	0
	EVEN
	
	BSS

pal32_tbl:
	DS.L	256
pal16d_tbl:
	DS.L	256
tuntextureadr:
	DS.L	1
grid_tbl:
	DS.L	(tunnelxblocks+1)*(tunnelyblocks+1)
multiply_tbl:
	DS.W	1<<16
length_tbl:
	DS.B	1<<16
raytunstarttime:
	DS.W	1
cam_tbl:
	DS.B	camtblsize

service_struct:
	DS.L	1
	
leftspec_tbl:
	DS.L	128
rightspec_tbl:
	DS.L	128

	DS.W	1

scr1:	DS.W	320*100
scr2:	DS.W	320*100
scr3:	DS.W	320*100