; Copyright 1999 Tomas Berndtsson <tomas@nocrew.org>

  	include	macros.s

VLM_MODULE	=	1
GFXMODE	=	%100110100
SHOWVBL	=	0

XRES	=	320
YRES	=	256
SCRXRES	=	320
SCRYRES	=	240

; estimated values
MAXDOTSPERLINE =	500
NRLINES	=	256

DEFAULT_ROT	=	1
DEFAULT_LINES	=	1
DEFAULT_LEFT_TYPE  =	0
DEFAULT_RIGHT_TYPE =	0

	ifne	VLM_MODULE
	opt	nodebug,atari
	output	d:\sound\whip!\vlm\sparkle.vlm
	include	vlmserv.s
	endc

	text

	ifne	VLM_MODULE

	dc.b	"VLM2"
	dc.l	infotext
	dc.l	settings
	dc.l	init
	dc.l	deinit
	dc.l	main

	else
	
	bsr.w	init
	vsync

	endc

	nop
main
	bsr	scrswap

	ifne	SHOWVBL
	move.l	scrp,a3
	move.w	$468.w,d7
	subq.w	#1,d7
.vsl
	move.l	#$ffffffff,(a3)+
	move.l	#$00000000,(a3)+
	dbra	d7,.vsl

	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	endc

	ifne	VLM_MODULE
	vlm_wait_vbl
	else
	vsync
	endc

	bsr	clrlines

	move.l	scrp,a0
	move.l	savedp,a1
	lea	sincos,a2
	lea	pal,a4

	move.l	option_rot,d1
	move.l	rotate_sin,d0
	lea	(a2,d0.l*4),a2
	add.l	d1,d0
	and.l	#255,d0
	move.l	d0,rotate_sin

left
	ifne	VLM_MODULE
	tst.l	option_left_type
	bne.w	.not_spectrum
	vlm_get_left_spec a5
	sub.w	#12042,2(a5)
	bpl.s	.nonegspec
	clr.w	2(a5)
.nonegspec
	bra.s	.go_on
.not_spectrum
	vlm_get_left_osci a5
	lea	fake_left_spec,a3
	bsr	fixosci
	lea	fake_left_spec,a5
.go_on
	else
	lea	fake_left_spec,a5
	endc

	move.w	#128,d7
	move.l	option_lines,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3
.ll
	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1,d0
	add.w	y1,d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawline
	dbra	d7,.ll

right
	ifne	VLM_MODULE
	tst.l	option_right_type
	bne.w	.not_spectrum
	vlm_get_right_spec a5
	bra.s	.go_on
.not_spectrum
	vlm_get_right_osci a5
	lea	fake_right_spec,a3
	bsr	fixosci
	lea	fake_right_spec,a5
.go_on
	else
	lea	fake_right_spec,a5
	endc

	
	move.w	#128,d7
	move.l	option_lines,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3
.rl
	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1,d0
	add.w	y1,d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawline
	dbra	d7,.rl

	move.l	#-1,(a1)+


	ifne	VLM_MODULE

	rts
	
	else

	cmp.b	#$3b,$fffffc02.w
	bne	main

slu
	stdexit
	pea	0.w
	trap	#1

	endc

init	
	ifne	VLM_MODULE

	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16
	
	else

	super
	stdinit	#-1,#-1,#GFXMODE

	lea	fake_left_spec,a0
	lea	fake_right_spec,a1
	move.w	#128-1,d7
.cfsl
	move.w	d7,d0
	addq.w	#1,d0
	asl.w	#7,d0
	move.w	d0,(a0)+
	asl.w	#1,d0
	move.w	d0,(a1)+
	dbra	d7,.cfsl

	endc

	move.l	#scr1,a0
	bsr	clrscr
	move.l	#scr2,a0
	bsr	clrscr

	move.l	#-1,saved1
	move.l	#-1,saved2

	rts

deinit
	rts

scrswap
	ifeq	VLM_MODULE
	move.l	scrp,-(sp)
	move.l	scrp+4,scrp
	move.b	1(sp),$ffff8201.w
	move.b	2(sp),$ffff8203.w
	move.b	3(sp),$ffff820d.w
	move.l	(sp)+,scrp+4

	else

	move.l	scrp,tmpscrp
	move.l	scrp+4,scrp
	move.l	tmpscrp,scrp+4
	vlm_set_scradr	tmpscrp

	endc

	move.l	savedp,-(sp)
	move.l	savedp+4,savedp
	move.l	(sp)+,savedp+4

	rts


drawline
	movem.l	d0-7/a2,-(sp)

	move.w	x1,d0
	cmp.w	x2,d0
	bgt.s	.x1min
	move.w	x2,d1
	bra.s	.go1
.x1min
	move.w	x2,d0
	move.w	x1,d1
.go1
	move.w	y1,d2
	cmp.w	y2,d2
	bgt.s	.y1min
	move.w	y2,d3
	bra.s	.go2
.y1min
	move.w	y2,d2
	move.w	y1,d3
.go2

;; d0=minx, d1=maxx, d2=miny, d3=maxy

	move.w	d1,d4
	sub.w	d0,d4	; dx
	move.w	d3,d5
	sub.w	d2,d5	; dy
	
	cmp.w	d4,d5
	bgt	yslope
xslope
	move.l	#640,d6
	cmp.w	x1,d0
	bne.s	.x1notmin
	move.w	y1,d1
	cmp.w	y2,d1
	blt.s	.nonegstep1
	neg.l	d6
.nonegstep1
	bra.s	.consts
.x1notmin
	move.w	y2,d1
	cmp.w	y1,d1
	blt.s	.nonegstep2
	neg.l	d6
.nonegstep2

.consts
	add.w	d5,d5	; d5 = c1=2*dy
	move.w	d5,d3
	sub.w	d4,d3	; d3 = p=2*dy-dx
	move.w	d4,d7
	add.w	d7,d7	; d7 = 2*dx

	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	
	tst.w	d3
.linel
	bpl.s	.pneg
	
	move.l	a2,(a1)+
	or.w	d0,(a2)+
	add.w	d5,d3
	dbra	d4,.linel

	bra	linedone
.pneg
	move.l	a2,(a1)+
	or.w	d0,(a2)+
	add.l	d6,a2
	sub.w	d7,d3
	add.w	d5,d3
	dbra	d4,.linel


	bra	linedone

yslope
	moveq	#2,d6
	cmp.w	y1,d2
	bne.s	.x1notmin
	move.w	x1,d0
	cmp.w	x2,d0
	blt.s	.nonegstep1
	neg.l	d6
.nonegstep1
	bra.s	.consts
.x1notmin
	move.w	x2,d0
	cmp.w	x1,d0
	blt.s	.nonegstep2
	neg.l	d6
.nonegstep2

.consts
	add.w	d4,d4	; d4 = c1=2*dx
	move.w	d4,d3
	sub.w	d5,d3	; d3 = p=2*dx-dy
	move.w	d5,d7
	add.w	d7,d7	; d7 = 2*dy

	move.w	d2,d1
	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	
	tst.w	d3
.linel
	bpl.s	.pneg

	move.l	a2,(a1)+
	or.w	d0,(a2)
	add.w	#640,a2
	add.w	d4,d3
	dbra	d5,.linel

	bra	linedone
.pneg
	move.l	a2,(a1)+
	or.w	d0,(a2)
	add.w	#640,a2
	add.l	d6,a2
	sub.w	d7,d3
	add.w	d4,d3
	dbra	d5,.linel


linedone	
	movem.l	(sp)+,d0-7/a2
	rts

fixosci
	move.w	#128-1,d7
.fol
	move.w	(a5)+,d0
	ext.l	d0
	move.w	(a5)+,d1
	ext.l	d1
	add.l	d0,d1
	asr.l	#2,d1
	add.l	#$8000,d1
	move.w	d1,(a3)+
	dbra	d7,.fol

	rts

clrscr
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	sub.l	a1,a1
	sub.l	a2,a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a5,a5
	add.l	#SCRXRES*SCRYRES*2+24*2,a0
	move.w	#SCRXRES*SCRYRES/24-1,d7
.cl
	movem.l	d0-6/a1-5,-(a0)
	dbra	d7,.cl
	rts
		

clrlines
	move.l	savedp,a1
.cll
	move.l	(a1)+,a2
	tst.l	a2
	bmi.s	.done
	clr.w	(a2)
	bra.s	.cll		
.done
	rts




	data

scrp	dc.l	scr1+16*SCRXRES,scr2+16*SCRXRES
savedp	dc.l	saved1,saved2


	ifne	VLM_MODULE
infotext	dc.b	'SPARKLING LINES',0
	dc.b	'Author:  NoBrain/NoCrew',0
	dc.b	'Version: 0.42',0
	dc.b	'Date:    1999-06-20',0
	dc.b	0
	even
	
settings	dc.l	4

	dc.l	parrotname
	dc.l	3
option_rot	dc.l	DEFAULT_ROT
	dc.l	parrotstruct

	dc.l	parlinesname
	dc.l	3
option_lines	dc.l	DEFAULT_LINES
	dc.l	parlinesstruct

	dc.l	parltypename
	dc.l	2
option_left_type	dc.l	DEFAULT_LEFT_TYPE
	dc.l	type_struct

	dc.l	parrtypename
	dc.l	2
option_right_type	dc.l	DEFAULT_RIGHT_TYPE
	dc.l	type_struct

parrotname	dc.b	'ROTATION SPEED',0
parlinesname	dc.b	'GRANULARITY',0
parltypename	dc.b	'LEFT CHANNEL TYPE',0
parrtypename	dc.b	'RIGHT CHANNEL TYPE',0
	even

parrotstruct	dc.l	0,257
parlinesstruct dc.l	0,3
type_struct	dc.l	2
	dc.b	'SPECTRUM',0
	dc.b	'OSCILLOSCOPE',0
	even
		
	else

option_rot	dc.l	DEFAULT_ROT
option_lines	dc.l	DEFAULT_LINES
option_left_type	dc.l	DEFAULT_LEFT_TYPE
option_right_type	dc.l	DEFAULT_RIGHT_TYPE

	endc

rotate_sin	dc.l	0

x1	dc.w	160
y1	dc.w	120
x2	dc.w	319
y2	dc.w	199


sincos	incbin	sico256.tab
	incbin	sico256.tab
pal	incbin	line256.pal

	bss

	ifne	VLM_MODULE
tmpscrp	ds.l	1
service_struct ds.l	1
	endc
	
	ifeq	VLM_MODULE
	stdbss
	endc
fake_left_spec	ds.w	128
fake_right_spec	ds.w	128
saved1	ds.l	NRLINES*MAXDOTSPERLINE
saved2	ds.l	NRLINES*MAXDOTSPERLINE

scr1	ds.w	XRES*YRES
scr2	ds.w	XRES*YRES
