*******************************************************************************
*** Filename: PAL_NTSC.S			     Last changed: 94.01.29 ***
***									    ***
*** Description:   Changes PAL/NTSC mode in all Falcon030 video modes.	    ***
***		   Version 1.0.						    ***
***									    ***
*** Technical information:   Uses XBIOS #88, Vsetmode to change the	    ***
***			     vertical frequency.			    ***
***									    ***
*** Compatibility:   Falcon030 machines only.				    ***
***									    ***
*** Coded by:   Power/New Beat, Daniel Hedberg in Devpac Version 3.10.	    ***
*******************************************************************************

 output	 a:\pal_ntsc.tos


Section Text

*** GET THE TYPE OF THE ACTIVE MONITOR ****************************************

 move.w	 #$59,-(sp)		#89 VgetMonitor
 trap	 #14			Call XBIOS
 addq.l	 #2,sp			Correct the stack
 cmp.w	 #0,d0			Check if a monochrome monitor is connected
 bne.s	 not_monochrome		If no, branch to not_monochrome
 pea	 msg_error_mono		The address of the character string
 move.w	 #$09,-(sp)		#09 Cconws
 trap	 #1			Call GEMDOS
 addq.l	 #6,sp			Correct the stack
 bsr.w	 crawcin		Wait for a key
 bra.w	 exit			Exit the program
not_monochrome:
 cmp.w	 #2,d0			Check if a VGA monitor is connected
 bne.s	 not_VGA		If no, branch to not_VGA
 pea	 msg_error_VGA		The address of the character string
 move.w	 #$09,-(sp)		#09 Cconws
 trap	 #1			Call GEMDOS
 addq.l	 #6,sp			Correct the stack
 bsr.w	 crawcin		Wait for a key
 bra.w	 exit			Exit the program
not_VGA:

*** GET THE VIDEO MODE ********************************************************

 move.w	 #-1,-(sp)		Get the video mode
 move.w	 #$58,-(sp)		#88 Vsetmode
 trap	 #14			Call XBIOS
 addq.l	 #4,sp			Correct the stack

*** CHANGE PAL/NTSC MODE ******************************************************

 bchg	 #5,d0			Change the PAL flag
 move.w	 d0,-(sp)		Set the video mode
 move.w	 #$58,-(sp)		#88 Vsetmode
 trap	 #14			Call XBIOS
 addq.l	 #4,sp			Correct the stack

*** EXIT **********************************************************************

exit:
 clr.w	 -(sp)			#00 Pterm0
 trap	 #1			Call GEMDOS


************ SUBROUTINE: Wait for a key ***************************************

crawcin:
 move.w	 #$07,-(sp)		#07 Crawcin
 trap	 #1			Call GEMDOS
 addq.l	 #2,sp			Correct the stack
 rts


Section Data

msg_error_mono:		dc.b	27,"E",27,"p Error! ",27,"q",13,10,10,"You can"
			dc.b	"'t change PAL/NTSC mode on a monochrome monit"
			dc.b	"or!",0 
msg_error_VGA:		dc.b	27,"E",27,"p Error! ",27,"q",13,10,10,"You can"
			dc.b	"'t change PAL/NTSC mode on a",13,10,"VGA moni"
			dc.b	"tor!",0

 end
