OKAMI NEWSREADER MANUAL PAGES

NAME
	oexpire: message extermination program

SYNOPSIS
	oexpire { options } { groups-RE }

DESCRIPTION
	oexpire expires messages on all `groups', where `groups' can be 
	regular expressions. If no groups are specified, all messages in all 
	newsgroups named in onews.def are expired.
	
	oexpire reads its configuration file (`oexpire.inf' by default, set 
	in o.inf) to get the expiration criteria for the newsgroups to be 
	expired. It then loads the newsgroups' index files and internally 
	marks all messages that are to be deleted, either because their 
	"killed" flag is set or because they match the newsgroups' 
	expiration criteria. The marked messages are either removed from the 
	message directory (SMF database), or from the DBF database files. 
	New index files are created consisting only	of entries for the 
	remaining messages and the thread index	file (.tix) is expired.

	DBF Reorganization

	In DBF database files, a single file contains all the messages of 
	the	newsgroup. When a message is deleted, it is not removed from the 
	file, but its space is marked as unused, to be re-used by successive 
	imports. Only when the message at the end of the file is deleted, 
	does the file shrinks. Since normally expiration takes place on a 
	regular basis, there is no danger for the database file to get 
	fragmented and grow to infinity. Even if many messages are imported 
	and deleted every day, the size of the database file should remain 
	constant once it has reached a certain size, since consecutive 
	unused entries are joined into one empty area. It is, however. 
	always possible to reorganize the database file, eliminating all 
	unused entries. Reorganization takes a good deal of time and 
	requires at least the size of the database file to be available on 
	disk. For that reason, it is not recommended to reorganize the 
	database after every expiration. Default is to reorganize the 
	database if more than 100 entries are unused. This can be changed 
	with the -R option, which also allows for the reorganization to be 
	turned off completely.

OPTIONS
	-W
	  Prints a message and waits one second before beginning
	  expiration. If within that time the ESC key was pressed,
	  terminates without further action.
	-I
	  Uses the message file date for expiration. The default is
	  to use the import date.
	-r
	  Deletes all messages that have the "read" flag set. Use this
	  if you are in extreme need of disk space.
	-K
	  Deletes the newsgroup completely, removing all message, data-
	  base and index files and empty directories and removing the
	  newsgroup from the onews.def and news.def files
	-e
	  Normally, oexpire deletes newsgroups that are empty after
	  expiration. With -e, those empty newsgroups will be kept.
	-R nitems
	  Reorganizes the DBF database if more than `nitems' entries
	  are left unused. See "DBF reorganization" above. Special
	  values for `nitems' are:
			0	reorganizes always
			-1	reorganizes never
		`nitems' can be given in one of the following formats:
			- a number, then reorg takes place when at least
			  that number of entries is unused
			- a number followed by a percent sign, then reorg
			  takes place when at least that percentage of the
			  DBF size is unused
			- a number followed by a `k' or 'K', then reorg
			  takes place when that number of kilobytes are
			  unused
	  The default value for `nitems' is 80%.
	-d n
	  Sets the day limit for the expiration of read messages to
	  `n' days, overriding the setting in oexpire.inf.
	-u n
	  Sets the day limit for the expiration of unread messages to
	  `n' days, overriding the setting in oexpire.inf.
	-s n
	  Sets the size limit for expiration to `n' bytes, overriding the
	  setting in oexpire.inf.
	-m n
	  Sets the number limit for expiration to `n' messages per
	  newsgroup, overriding the setting in oexpire.inf.
	-k
	  Ignores the expiration criteria and removes only messages that
	  have the "killed" flag already set.
	-f
	  Removes all messages that are in the index but the corresponding
	  message file resp. DBF entry is missing.
	  WARNING: For SMF, this requires a lot of separate disk accesses 
	  and so is rather slow.
	-i
	  Removes all messages that are in the DBF database but not in
	  the index file. This works for DBF databases only.
	  Killing is done "silently" here, i.e. oexpire might print "no
	  work" although messages did get removed from the DBF. In its
	  output oexpire only counts those messages that were removed
	  from the index.
	-M
	  Does not expire mail groups.
	-T
	  Does not expire threads. Use this only if you do not create
	  threads at all or you will never get the deleted entries
	  out of your thread index files.
	-Y net
	  Expires only newsgroups from networks specified in `net':
			u	Usenet
			m	Mausnet
	  The default is to expire all newsgroups without regard to their
	  network.
	-P
	  Prints expiration criteria only. Does not expire anything. Pays
	  no attention to the options -d,u,s,m.
	-h
	  waits for key press after program termination
	-L n
	  sets log level to n (-1 means no logging)
	-v
	  prints version number only
	-F file
	  uses `file' as o.inf configuration file
	-c
	  Clear all `new' flags
	-!
	  Clean thread.
	-?
       Prints usage summary only.

ENVIRONMENT
	O_INF
	  name of default o.inf file

FILES
	o.inf
	oexpire.inf
	onews.def

SEE ALSO
	- The documentation of the oexpire.inf file, contained as a
	  comment block in the file itself.
	- The manual page for the DBF database.

BUGS
	No known bugs (anymore).

HISTORY
	13-11-93  created
	21-03-94  changed -R default from 100 to 80%
	20-05-94  added option -i
	17-06-94  added option -e
	13-10-94  -f can be used for DBF too
  05-07-97  Regular expressions for `groups' <josdb>

AUTHORS
	Wolfram Rsler <wr@bara.oche.de>
	Jos den Bekker <josdb@xs4all.nl>
  
DATE
	Nov 10 1997
