OKAMI NEWSREADER MANUAL PAGES

NAME
	oexport: Usenet/Internet news and mail export program

SYNOPSIS
	oexport { options }

DESCRIPTION
	oexport reads all messages in the Outbound pseudo newsgroup and
	processes them as follows:
	1. if a message has the "killed" flag set, is is discarded.
	2. if a message has the "protected" flag set, it is ignored.
	3. if a message is marked for being sent via Usenet, it is
	moved from the Outbound pseudo newsgroup into the message queue
	of the UUCP software system from where it will be picked up
	and sent into the Net at the next UUCP poll.
	Optionally, a SOUP packet can be created from the exported
	messages.

	For every message being sent, oexport generates a Usenet header
	containing the following fields:

		To			[1] [6]
		Path			[2]
		Newsgroups		[2]
		Distribution		[2] [3]
		From
		Message-ID
		Subject
		Control			[4]
		Keywords		[3]
		Summary			[3]
		Follow-up To		[3]
		Reply-To		[3]
		References		[3]
		Cc			[3] [6]
		Organization		[3] [5]
		X-Software		[5]
		Date
		Mime-Version		[5]
		Content-Type		[5]
		Content-Transfer-Encoding [5]
		Lines

	[1] mail only
	[2] news only
	[3] only if not empty
	[4] only for automatically generated Control messages
	[5] fixed text
	[6] alias names are expanded

	If "Add Signature" is on for the message, a signature is constructed
	according to the signature configuration file named in o.inf (sigs.inf
	by default) and appended to the message, prefixed by a line consisting
	only of "-- ".
	Alias names are expanded according to the alias definition file, the
	name of which must be defined in o.inf.

	UUCP:
	oexport creates two files in the message queue for each exported
	message, their names being An.X (the X file) and An.D (the D file),
	where n is a 7-digit decimal number that is alike on both files.
	The D file contains the message text (including the header), and
	the X file contains information about the message type (mail or
	news), its destination adress (for mail) and the name of the
	corresponding D file.

  SOUP:
  A REPLIES and a MAIL.MSG and/or NEWS.MSg file are created according 
  to the SOUP convention. Both MAIL.MSG and NEWS.MSG are in binary 
  mode.
  
  NOS:
  For each message a file n.TXT and a corresponding file n.NWK (news) 
  or n.WRK (mail), where n is the same number, are created. The number 
  in spool\mqueue\sequence.seq is set accordingly.
  
	Exported messages are removed from the Outbound pseudo newsgroup. 
	Copies are imported in the pseudo newsgroup Outbound.archive.user

OPTIONS

	-M x
	  set mode to `x' (u = UUCP, s = SOUP, n = NOS)

	-d f
	  create SOUP files in `f'

	-s
	  silent mode (no output unless something gets exported)

	-m
	  force MIME encoding of headers

	-U
	  do not pack files in SOUP mode

	-c n
	  set umlaut conversion to `n'

	-h
	  hold screen

	-L n
	  set log level to `n'

	-v
	  print version number & exit (implies -L-1)

	-F f
	  use file `f' as config file

	-?
		print usage summary only.

ENVIRONMENT
	O_INF
		name of default o.inf file

FILES
	o.inf
	sigs.inf
	alias
	An.X
	An.D
	REPLIES
	NEWS.MSG
	MAIL.MSG
	n.NWK
	n.WRK

SEE ALSO
	- The documentation of the signature configuration file (sigs.inf),
	  contained as a comment block in the file itself.
	- The documentation of the alias file, contained as a comment block
	  in the file itself.
	- The documentation for using SOUP with O (osoup.doc).

HISTORY
	28.10.94 wr	Added SOUP support
  08.08.95 josdb Pack routine for SOUP mode
  17.07.96 josdb OutbToArchive
  03.09.96 NOS support

AUTHORS
	Wolfram Rsler <wr@bara.oche.de>
  Jos den Bekker <josdb@xs4all.nl>
  
DATE
	Nov 10 1997

