OKAMI NEWSREADER MANUAL PAGES

NAME
	ofind: msgbase search & find

SYNOPSIS
	ofind { options } { group-RE }

DESCRIPTION
	ofind searches all newsgroups that match any of the specified
	regular expressions (all groups if no regex is given) according
	to the given Options and perfoms specified actions.
	The principle idea is similar to the Unix "find" command: you
	speficy where to look, what to look for and what to do with
	what was found.

OPTIONS

	There are 3 sets of options:

		- General options, controlling the overall behaviour of
		  the program. These consist of single letters.
		- Match options, controlling what ofind searches for.
		  These consist of lower-case letters.
		- Action options, specifying what to do with the msgs
		  that were found. These consist of lower-case letters,
		  beginning with an upper-case letter.

	When using more than one match option, options are considered to
	be concatenated by logical "and". Options are evaluated left to
	right.

	Specifying string patters

		All string search patterns are regular expressions like in
		egrep or the newsreader's "magic" search mode. Use \ to
		quote special characters, i.e. dots in newsgroup names.

	Specifying flags

		Specify flags by a string consisting of one or more of:
			r	read		p	protected
			a	answered	n	new
			k	killed		x	crossposted
			l	locked
		E.g., use "rak" to specify flags read, answered and killed.

	Specifying numbers

		Numbers beginning with a + match all numbers that are greater
		or equal.
		Numbers beginning with a - match all numbers that are less or
		equal.
		Without + or -, matches exactly.
		E.g., "+100" matches all numbers >=100, "-20" matches all
		numbers <=20, and "50" matches 50 only.
    
    ofind.ttp version U... uses the GNU getopt_long() function, 
    which distinguishes between so-called `long' and `short' options. 
    Short options are the familiar ones, preceded by a single hyphen 
    (`-'), while long options are preceded by a double hyphen (`--'). 
    The argument of a long option may be concatenated to the option 
    itself with a `=' sign, or separated from it with a blank. The 
    arguments of short options may be separated from the option with a 
    blank or concatenated. So

                       -f file is equivalent to -ffile
    and
                       --subj=Okami is equivalent to --subj Okami
                       
	=== general options ===

	-f file
		Reads options from file as if they were entered on the
		command line.
	-o file
		Sends output to `file', overwriting if `file' already
		exists.
	-a file
		Like -o, but appends to `file'.
	-1
		Quits after the first matching msg was found.
	-h
		Waits for key press after program termination.
	-L n
		Sets log level to n (-1 means no logging).
	-v
		Prints version number only.
	-F file
		Uses `file' as o.inf configuration file.
	-c
		Prints usage summary of general options and exists.
	-m
		Prints usage summary of match options and exists.
	-p
		Prints usage summary of action options and exists.

	=== Match options ===

	--subj re
		Matches all msgs with subjects that match the regex `re'.
	--aut re
		Matches all msgs with author names that match the regex `re',
		using the author name from the index file.
	--adr re
		Matches all msgs with author e-mail addresses that match the
		regex `re'.
	--real re
		Matches all msgs with author real names that match the regex `re'.
	--grp re
		Matches all msgs with newsgroups that match the regex `re'.
	--mid re
		Matches all msgs with a msg id that matches the regex `re'.
	--msg re
		Matches all msgs with a msg text matching regex `re'. This
		is like "egrep re" on the msg text.
	--flgs f
		Matches all msgs with flags in `f' set.
		See "specifying flags" above.
	--flgc f
		Matches all msgs with flags in `f' clear.
		See "specifying flags" above.
	--eday n
		Matches all msgs with days since input matching n.
		See "specifying numbers" above.
	--iday n
		Matches all msgs with days since import matching n.
		See "specifying numbers" above.
	--fnr n
		Matches all msgs with file number matching n.
		See "specifying numbers" above.
	--xposted
		Matches all crossposted messages.
		Checks the msg header, not the index file.


	=== Action options ===

	--Subj
		Prints the subject.
	--Aut
		Prints the author name (as in index).
	--Adr
		Prints the author's e-mail address.
	--Real
		Prints the author's real name.
	--Mid
		Prints the msg id.
	--Grp
		Prints the newsgroup. (once for every msg found)
	--Ngrp
		Prints the newsgroup. (once for every newsgroup sought)
	--Msg
		Prints the msg text.
	--Outf
		Prints the msg in Mausnet Outfile format.
	--Fnam
		Prints the full filename of the msg. This works with SMF
		database newsgroups only.
	--Flg
		Prints the msg flags.
	--Sflg f
		Sets the msg flags specified in `f'.
		See "specifying flags" above.
	--Cflg f
		Clears the msg flags specified in `f'.
		See "specifying flags" above.
	--Xpost
		Flag settings affect crossposted msgs too. Use this with
		--Sflg and --Cflg when desired.
	--Etime HH:MM
		Sets the input time to HH:MM. Useful on the Outbound newsgroup
		if you want to keep secret the times you spend reading news.
	--Mpd
		Prints the average number of msgs per day, calculated over the
		last 30 days.
	--Dbfstat
		Prints DBF usage statistics. For DBF newsgroups only.
	--Repi
		Repair index file
  --Rept
    Repair lost thread index file
    N.B.: If the index file and the thread file are both lost, only 
    the index files needs to be repaired, as in that case the thread 
    index file will be rebuilt automatically.
	--Shi s
		Show data index file according to parameter `s'.
		l = list all entries, s = statistics only
	--Sht s
	  Idem, for thread index file.
  --Soi m
    Sort index according to sort key `m'.
    s = subject, n = name, d = date, i = import date, m = message number
  --Sot k
    Sort thread index according to sort key `k'.
    t = tid, m = message id, p = pointer of message
    IMPORTANT: the thread index must be tid sorted for all O modules, 
    except oimport. So make sure, if you change the sorting, to change 
    it back to tid before you start oexpire or the GEM modeule. (In 
    general: this option is only for users who know exactly what 
    they're doing.)
	--Rodef
		Reconstruct onews.def
	--Rnews
		Print message in rnews format.
	--Soup
		Print message in binary SOUP file format.
		
EXAMPLE
	Search all Atari newsgroups for msgs that have "Amiga" in their
	subject, and set these msgs to "killed".

		ofind --subj Amiga --Sflg k atari

	Or: write the following line into a file called "ofind.dat":

		--subj Amiga --Sflg k

	and run the command

		ofind -f ofind.dat atari

	You may construct a script file with more than one match condition,
	thus using ofind as a flexible twit filter.

	The order in which options are given is significant:

		ofind --sflg p --Subj

	means "print the subject of all msgs with the 'protected' flag set",
	whereas

		ofind --Subj --sflg p

	means "print the subject of all msgs, then check if they have the
	'protected' flag set". Since "--sflg p" is followed by no action,
	nothing special happens to the matched messages.

ENVIRONMENT
	O_INF
		name of default o.inf file

FILES
	o.inf

AUTHORS
	Wolfram Rsler <wr@bara.oche.de>
  Jos den Bekker <josdb@xs4all.nl>
  
DATE
	Nov 10 1997
