OKAMI NEWSREADER MANUAL PAGES

NAME
	oimport: import module

SYNOPSIS
	oimport { options } { groups }

DESCRIPTION
	oimport imports news from individual message files, from rnews 
	format files, and from SOUP packets, as well as mail from Unix mail 
	spool files and SOUP packet files.
	
	In UUCP mode, news is imported for `groups'. If no groups are 
	specified, import takes place for all newsgroups in the `news.def' 
	file. For each newsgroup the appropriate news directory is searched 
	for files with numeric names (e.g. if the base news directory is 
	h:/news and the newsgroup is alt.okami, oimport looks for files 
	named h:/news/alt/okami/1, h:/news/alt/okami/123 etc.).

  In SOUP mode, all news messages are imported for all newsgroups in 
  the packet. So `groups' is without effect here. If necessary, the 
  appropriate directory hierarchy for each newsgroup is created 
  automatically.
  
  In NOS mode, news is imported from the downloaded rnews file 
  (usually `batch.txt'), so `groups' is also without effect here. Only 
  messages for active groups (see o.inf) are imported in the 
  appropriate newsgroup files, the rest is relegated to the `junk' 
  group.
	
	In UUCP and NOS mode, oimport will look for mailbox files of all 
	users in the passwd file. For UUCP these are the files 
	../var/mail/user, and for NOS the files ../spool/mail/user.txt. The 
	mailbox files must be Unix type mail spool file (with the exception 
	that CRLFs are allowed as EOL markers. The messages are imported 
	into the pseudo newsgroup Mail.user (where `user' is the user name).

  In SOUP packets there is always only one mail file. This will be 
  imported for the current user (as set in the environment variable 
  $LOGNAME, or in the variable "logname" in o.inf).

	oimport reads the messages in, scans their header (which is ended by 
	the first blank line of the file and must conform to the standard 
	RFC1036 Internet mail/news header), creates an appropriate entry in 
	the newsgroup's index file (.idx), inserts the message into the 
	newsgroup's thread index file (.tix) and, if desired, moves the 
	message into the DBF database (.dbf and .dbi). If the file is 
	already in the index file, it is ignored (i.e. not re-imported and 
	not moved anywhere).

OPTIONS
	-M
    x set mode to `x' (u = UUCP, s = SOUP, n = NOS)

	-p
    don't delete files after import

	-c
	  clear `new' flags in all newsgroups prior to import

	-d f
	  import SOUP files from directory `f' (AREAS and *.MSG files)

	-U
	  do not try to unpack compressed SOUP packet files

	-S f
	  unpack and import special (compressed) SOUP packet file `f'

	-q
	  quiet mode: no output to screen from packer program

	-r f
	  import rnews file `f' (`-' = stdin)

	-m f
	  import mailbox file `f' (`-' = stdin)

	-u x
	  import mail for user `x'
	  Mail from a SOUP packet and from an ad hoc mailbox file will be 
	  imported for user `x', and in UUCP and NOS mode only mail for user 
	  `x' will be imported.

	-h
	  hold screen

	-L n
	  set log level to `n', -1: no logging

	-v
	  print version number & exit (implies -L-1)

	-F f
	  use file `f' as config file

	-?
		print usage summary only.

ENVIRONMENT
	O_INF
		name of default o.inf file

FILES
	o.inf

BUGS
  Please report if you find any.
  
SEE ALSO
	The instructions in o.inf, osoup.doc.

AUTHORS
	Wolfram Rsler <wr@bara.oche.de>
  Jos den Bekker <josdb@xs4all.nl>
  
DATE
	Nov 10 1997

