; votemgr will search its home directory for the file called VOTEMGR.CTL
;
; VOTEMGR.CTL structure
;
;      . general options
;      . receipt text files
;      . voting definition block structure
;
;
; Note: paths MUST be terminated with a backslash '\'
;
; Notation:     <...>   one item
;               {...}   one or more items
;               [<...>] optional item
;
;
; ---------------------------------------------------------------------
; general options
; ---------------------------------------------------------------------

; user name
; USERCODE <1stname lastname>
usercode Your Name

; user key
; USERKEY <the keynumber you received from Harrie Beuvink on 2:283/705.0>
userkey NONE

; your address in complete 4-D!!!!
; ADDRESS zone:net/node.point
; {ADDRESS zone:net/node.point}
address 2:283/705.0
address 90:5/0.0

; the name of your net mailarea
; NETMAIL  <path>
netmail c:\msgs\0025

; receipt message status
; p-private; k-kill; h-hold; c-crash; s-sent; d-direct
; note that if you don't want votemgr to send messages you must flag
; them as SENT
; NOTE: you may also overrule this keyword in a voting definition block.
; [STATUS   {pkhcsd}]
status p

; if you want to erase processed messages. default is to flag them Rcvd
; note that those messages subject to be moved will -not- be erased
; even if you set killprocessed.
; [KILLPROCESSED]
killprocessed

; ---------------------------------------------------------------------
; receipt text files
; ---------------------------------------------------------------------
; these files should contain plain vanilla ASCII texts
;
;

; "Regards," heading
; The sysopname will be written by VoteMGR-ST after this file.
; [SIGNOFFTXT <file_spec>]
signofftxt sign_off.txt

; "list of active votings" heading
; [ACTIVETXT <file_spec>]
ACTIVETXT active.txt

; "general helpfile" text
; [HELPTXT <file_spec>]
HELPTXT help.txt

; "You made the next error(s)" string.
; Will be placed at the start of the error message.
; [ERRORSTRING <string>]
ERRORSTRING Your vote isn't processed! You made the next error(s):

; "list of valid choices" heading
; [CHOICESTXT <file_spec>]
CHOICESTXT choices.txt

; "return receipt" text
; [RECEIPTTXT <file_spec>]
RECEIPTTXT receipt.txt

; "you have already voted" text
; [DUPLICATETXT <file_spec>]
duplicatetxt duplic.txt

; "not a valid entry" text
; [ERRCHOICETXT <file_spec>]
errchoicetxt errchoi.txt

; "not an active voting" text
; [ERRVOTTXT <file_spec>]
errvottxt errvot.txt

; "no password used" text
; [NOPWTXT <file_spec>]
nopwtxt nopw.txt

; "not validated for this voting" text
; [ERRVOTTXT <file_spec>]
errvaltxt errval.txt

; "ballot received too late"
; [TOOLATETXT <file_spec>]
toolatetxt toolate.txt

; "ballot received too soon"
; [TOOSOONTXT <file_spec>]
toosoontxt toosoon.txt

; "received the same entries within a multi-choice vote"
; Only used within a multi-choice vote.
; [DUPENTRYTXT <file_spec>]
dupentrytxt dupentry.txt

; received the same keyword in a multi-choice vote.
; Only used within a multi-choice vote.
; [KEYWORDUNIQUETXT <file_spec>]
keyworduniquetxt uni_keyw.txt

; received the same choice in a multi-choice vote.
; Only used within a multi-choice vote.
; [CHOICEUNIQUETXT> <file_spec>]
choiceuniquetxt uni_choi.txt

; ---------------------------------------------------------------------
; voting definition block structure
; ---------------------------------------------------------------------
; this block can be repeated as many as 25 times, defining 25 different
; votings IF YOU REGISTRATE THIS SOFTWARE.

; Unregistrated users can only run ONE voting. Only the first 
; voting definition in this block will be used.

; definition block starter
; electname must be a valid DOS file name (max 8 chars)
; DEFINE <electname>
DEFINE pgp-1

; receipt message status
; p-private; k-kill; h-hold; c-crash; s-sent; d-direct
; note that if you don't want votemgr to send messages you must flag
; them as SENT.
; NOTE: if you don't use this keyword in this voting definition block, then
; it will take the default as installed by the general options.
; [STATUS   {pkhcsd}]
status p

; validate statements allow you to specify who is allowed to vote.
; ALL macro is supported; read documentation for more details on this.
;
; VALIDATE <address [{address}]>
; [{VALIDATE <address [{address}]>}]
validate 2:282/all.0 2:283/all.0 2:284/all.0
validate 2:500/149.6058
validate 2:2802/188.0

; reject statements allow you to specify who is -not- allowed to vote.
; this statement is used to make exceptions to global validations.
; ALL macro is supported.
;
; REJECT <address [{address}]>
; [{REJECT <address [{address}]>}]
reject 2:283/705.0 2:284/412.0

; area tag of the echomail area for which packets will be created
; [AREA <area_tag>]
area c:\msgs\0049

; your originline
; [ORIGINLINE <origin_line>]
originline # democracy made easy : VoteMGR-ST #

; first day of ballot processing (ballots received previous to this
; date will be ignored, and addressee will be notified)
; FROMDATE <dd.mm.yyyy>
fromdate 07.05.1994

; last day of ballot processing (ballots received after this date will
; be ignored, and addressee will be notified)
; TODATE <dd.mm.yyyy>
todate 22.07.1994

; hides names and addresses when reporting results FOR THIS VOTING
; [PRIVATE]
private

; description of the voting to be displayed when listed
; [INFOTXT <file_spec>]
infotxt pgp_info.txt

; heading for results. this text defaults to INFOTXT
; [RESULTTXT <file_spec>]
resulttxt pgp_resu.txt

; list of valid choices for the voting. only one choice per line.
; choices can contain spaces ' '.
; up to 100 different choices can be defined.
; If you don't use the keyword MAXCHOICE within a defenition
; the vote will be a "single-choice" vote. The voter must write
; a netmail like "[choice] ![my sercret password]"
; BEGINCHOICES
; ...
; ENDCHOICES
BEGINchoices
      yes
      no
ENDchoices

   ----------------------------------
   Optional for multi-choice votes
   ----------------------------------

 ; From: User Name
 ; to  : Votemgr-ST
 ; Subj: DECIDE
 ; ------------------------------------------------
 ; ![password]
 ; <keyword> choice
 ; [<keyword> choice]
 ;   ....
 ; [<keyword> choice]
 ;
 ; A password is a string, starting with a "!" and CAN
 ; contain spaces ' '. (ie. "! my security password")
 ;
 ; A keyword is a string not containing spaces ' '. (ie. "chairman")
 ;
 ; a choice can be anything. (ie. "Carlos Terre")


 ; For a multi-choice vote NUMBER MUST BE BIGGER THAN 1 (ONE) !!!!
 ; MAXCHOICES is the maximal number of entries a voter may do in one vote.
 ; [MAXCHOICES number]


 ;BEGINchoices
 ;
 ;       NOTE: you have to define ALL the possible combinations!!!!
 ;
 ;       chairman Carlos Terre
 ;       chairman Miquel Piulats
 ;       chairman Tirs Abril
 ;       chairman Harrie Beuvink
 ;       chairman Andre van Duin
 ;
 ;       secretary Carlos Terre
 ;       secretary Miquel Piulats
 ;       secretary Tirs Abril
 ;       secretary Jan Jans
 ;
 ;       treasurer Carlos Terre
 ;       treasurer Miquel Piulats
 ;
 ;ENDchoices 


 ; If the keywords must be unique, so in this case only one chairman,
 ; one secretary or one treasurer can be choosen, you must use:
 ; <UNIQUEKEYWORD>


 ; If the choices must be unique, so only unique names in this vote,
 ; you must use:
 ; <UNIQUECHOICE>


 ; When the you want to give the vote a certain weight you can use the
 ; BEGINCOUNT/ENDCOUNT statement as shown here.
 ; In this case, the voters first entry will have four points, the seccond
 ; two points en the third entry one point.
 ; The principal is the same as used with the European Song Contest.
 ;
 ; Begincount
 ;   4
 ;   2
 ;   1
 ; Endcount


 ; definition block END marker
 ; ENDDEF
ENDDEF

; You can define more than one voting definitionblocks if you have
; registrated this software.

DEFINE        tweedeling
status        pc
validate      2:282/all.all 2:283/all.all
reject        2:283/705.0
area          c:\msgs\gossip_d
originline    # democracy made easy : VoteMGR-ST #
fromdate      14.06.1994
todate        28.07.1994
private
infotxt       twee_inf.txt
resulttxt     borresul.txt
maxchoices    3
uniquekeyword
uniquechoice
begincount
   4
   2
   1
endcount
BEGINchoices
; NOTE: you have to define ALL the possible combinations!!!!
     chairman    Miquel Piulats
     chairman    Andre van Duin
     secretary   Carlos Terre
     secretary   Tirs Abril
     secretary   Jan Jans
     treasurer   Carlos Terre
     treasurer   Miquel Piulats
ENDchoices 

ENDDEF

; ---------------------------------------------------------------------
