; Player for Syntheticsounds in MadMax Format.
; Runs on any monitor, any machine (STE/E/TT/F030), uses Timer-A for proper
; 50Hz VBL-emulation (even can handle some SID voice tunes (e.g.
; BigAlecs ones).
; Can handle informations from an SNDH Header (name of composer, number of
; tunes).

; Doesnt use anything like XBRA, so your memory keeps shrinking if you run
; several tunes resident (normal play: no probs!).

; Coded at one afternoon (the code looks like that!): 15.2.1992
; Updates:    End of 92.
; F030-patch: 3.3.97
; ICE-Depack: 1.5.97
; VBL-Mode  : 15.8.97
; BETA-HEAVY BUG FIX: 6.1.98

; By the way: Done by BDCannibal (knaus@ruf.uni-freiburg.de)

speed           EQU 246         ; 245.76 (Timer-Wert fuer 50Hz IRQ)

MAX_HEADER      EQU 200         ; Bis Byte ~ wird SNDH gesucht.
SPACE_DEPACK    EQU 50000       ; Buffer fr ICE Depack (max. Size File)

                OPT D-,O+
                OUTPUT 'E:\MAD_PLAY.TTP','f:\test\new\newblip\demox.snd"'

; Commandozeile auslesen, restlichen Speicher freigeben und Tune laden.

                movea.l 4(SP),A0
                lea     $80(A0),A0      ; Commandline
                move.b  (A0)+,D7        ; leer ?
                beq     endend

                ext.w   D7              ; Anzahl Buchstaben
                subq.w  #1,D7
                lea     filename(PC),A1
loop:           move.b  (A0)+,(A1)+
                dbra    D7,loop

                clr.b   (A1)            ; Schlubyte

                movea.l 4(SP),A6        ; Erst ntig, nachdem man Filegr. kennt

                pea     dta(PC)         ; DTA-Buffer einrichten
                move.w  #$1A,-(SP)      ; Datei einlesen
                trap    #1
                addq.w  #6,SP

                clr.w   -(SP)           ; Nur normale Dateien
                pea     filename(PC)
                move.w  #$4E,-(SP)
                trap    #1
                addq.w  #8,SP

                tst.w   D0
                beq.s   found

                pea     fault1(PC)
fault_out:      move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP
                bra     ende

found:          move.l  $0C(A6),D0
                add.l   $14(A6),D0
                add.l   $1C(A6),D0
                add.l   #$0400,D0
                lea     dta(PC),A0
;                add.l   26(A0),D0       ; Gre des Files dazuaddieren
                move.l  D0,resident     ; wird gebraucht, wenn das Teil resident
; gemacht werden soll !
                move.l  D0,-(SP)
                move.l  A6,-(SP)
                clr.w   -(SP)
                move.w  #$4A,-(SP)
                trap    #1
                lea     12(SP),SP

                tst.w   D0
                beq.s   no_mem_f

suck_it:        pea     fault5(PC)
                bra     fault_out

no_mem_f:       move.l  dta+26(PC),D0   ; Speicher fr Sound allocieren.
                addi.l  #SPACE_DEPACK,D0
                move.l  D0,-(SP)
                move.w  #$48,-(SP)
                trap    #1
                addq.l  #4,SP

                tst.l   D0
                ble.s   suck_it

                move.l  D0,sound

                clr.w   -(SP)           ; nur lesen
                pea     filename(PC)
                move.w  #$3D,-(SP)
                trap    #1
                addq.w  #6,SP

                tst.l   D0
                bpl.s   ok1

                pea     fault2(PC)
                bra.s   fault_out

ok1:            move.l  sound(PC),-(SP)
                move.l  dta+26(PC),-(SP) ; Dateigre
                move.w  D0,D7
                move.w  D7,-(SP)
                move.w  #$3F,-(SP)
                trap    #1
                lea     12(SP),SP

                tst.l   D0
                bpl.s   ok2

                pea     fault3(PC)
                bra     fault_out

ok2:            move.w  D7,-(SP)
                move.w  #$3E,-(SP)
                trap    #1
                addq.w  #4,SP

                movea.l sound(PC),A0    ; File ggf. entpacken.
                bsr     ice_depack2

                lea     txt1(PC),A0     ; Text modifizieren
                lea     dta+30(PC),A1   ; Filenamen.
                moveq   #11,D0          ; max. 12 Buchstaben
loop2:          move.b  (A1)+,D1
                beq.s   clr_rest
                move.b  D1,(A0)+
                dbra    D0,loop2

clr_rest:       tst.w   D0
                bmi.s   noclrrest

clr_rest_lp:    move.b  #' ',(A0)+
                dbra    D0,clr_rest_lp

noclrrest:      lea     txt2(PC),A0
                move.l  dta+26(PC),D0   ; Dateilnge
                move.w  #10000,D2
                REPT 4
                divu    D2,D0
                add.b   #'0',D0
                move.b  D0,(A0)+
                clr.w   D0
                swap    D0
                divu    #10,D2
                ENDR
                add.b   #'0',D0
                move.b  D0,(A0)

                pea     starttxt(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.w  #6,SP

                bsr     test_sndh       ; Testen, ob SNDH Header vorhanden.

; ****************************************************************************

                clr.l   -(SP)
                move.w  #$20,-(SP)
                trap    #1
                addq.w  #6,SP

                move.l  D0,saver

                lea     saver+4(PC),A0  ; alle bentigten Vektoren retten
                move.w  $FFFF8242.w,(A0)+
                move    SR,(A0)+
                move.w  $0484.w,(A0)+
                move.b  $FFFFFA19.w,(A0)+
                move.b  $FFFFFA17.w,(A0)+
                move.b  $FFFFFA13.w,(A0)+
                move.b  $FFFFFA07.w,(A0)+
                move.b  $FFFFFA1F.w,(A0)+
                move.b  $FFFFFA19.w,(A0)+
                move.l  $0134.w,(A0)+
                move.l  $70.w,(A0)+     ; Manche Tunes brauchen Timer-AA

                clr.b   backgrd

                bclr    #0,$0484.w      ; Tastaturklick aus (nur bei Backgrd.)
                move.w  #$00,$FFFF8242.w ; fr alle Farbmonis !
                clr.b   $FFFFFA19.w     ; Timer A stoppen

                moveq   #1,D0           ; Song 1 (SNDH wird erhofft)
                movea.l sound(PC),A0
                jsr     (A0)            ; Soundinit

;***
                tst.b   use_vbl         ; Braucht Tune den Timer-A ?
                beq.s   def_use_tima

                move.l  #vbl,$70.w
                bra.s   start_it

def_use_tima:   move    #$2700,SR       ; Interrupts sperren und Timer A init.
                move.l  #timer_a,$0134.w
                bclr    #3,$FFFFFA17.w
                bset    #5,$FFFFFA13.w
                bset    #5,$FFFFFA07.w
                move.b  #speed,$FFFFFA1F.w
                move.b  #7,$FFFFFA19.w  ; Timer mit Vorteiler 1:200 starten

start_it:       stop    #$2300

loopy:          move.w  #$0B,-(SP)      ; Tastaturbuffer leeren.
                trap    #1
                addq.l  #2,SP
                tst.w   D0
                beq.s   mainloop
                move.w  #7,-(SP)
                trap    #1
                addq.l  #2,SP
                bra.s   loopy

mainloop:       move.w  counter(PC),D0  ; Nur alle 50 Hz.
wait_timer_a:   cmp.w   counter(PC),D0
                beq.s   wait_timer_a

                bsr     volumeter       ; Frs Auge.

                move.w  #$0B,-(SP)      ; Tasten ???
                trap    #1
                addq.l  #2,SP

                tst.w   D0
                beq.s   mainloop

                move.w  #7,-(SP)
                trap    #1
                addq.w  #2,SP

                swap    D0              ; Scancode

                cmp.b   #$39,D0         ; Ende ? (Space)
                beq     end
                cmp.b   #$28,D0         ; Resident halten (K) ?
                beq     resi
                cmp.b   #$0B,D0         ; 1-0 ?
                bgt.s   mainloop
                sub.b   #$02,D0
                bmi.s   mainloop

                ext.w   D0
                addq.w  #1,D0

                tst.w   anz_songs       ; Wenn kein SNDH Header vorh.: alles
                beq.s   all_keys        ; moeglich.

                cmp.w   anz_songs(PC),D0 ; Zu weit ?
                bgt.s   mainloop

all_keys:       movea.l sound(PC),A0
                jsr     (A0)            ; neuer Sound installieren
                bra.s   mainloop

; Aufruf im VBL, damit Samplerouts keinen Stress machen.
get_volume:     lea     volume(pc),a0
                lea     $ffff8800.w,a1

                moveq   #8,d1
                moveq   #2,d7
get_vol:        moveq   #$0f,d0
                move.b  d1,(a1)
                and.b   (a1),d0
                move.b  d0,(a0)+
                addq.w  #1,d1
                dbra    d7,get_vol

                rts

; Volumeter: Code genauso lcherlich wie das Ding aussieht...
volumeter:      movem.l D0-A6,-(SP)

                lea     volume(pc),a6

                moveq   #2,D7
out_loop:       moveq   #0,d0
                move.b  (a6)+,d0
                add.w   D0,D0
                add.w   D0,D0
                move.l  volm(PC,D0.w),D0
                move.l  D0,-(SP)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP
                dbra    D7,out_loop

                pea     curs_up(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

                movem.l (SP)+,D0-A6
                rts

; Volumeterstrings (kein Stress bei Umwandlung...)
volm:           DC.L vol0,vol1,vol2,vol3
                DC.L vol4,vol5,vol6,vol7
                DC.L vol8,vol9,vola,volb
                DC.L volc,vold,vole,volf

resi:           st      backgrd

                clr.w   -(SP)           ; Programm beenden und resident halten
                move.l  resident(PC),-(SP)
                move.w  #$31,-(SP)
                trap    #1

vorspul:        move.w  #$0700,$FFFF8240.w
                movem.l D0-A6,-(SP)
spieler:        movea.l sound(PC),A0
                jsr     8(A0)           ; Sound playen

                move.w  #50,D0
lp1:            move.w  #5,D1
lp2:            dbra    D1,lp2
                dbra    D0,lp1

                move.w  #-1,-(SP)
                move.w  #11,-(SP)
                trap    #13
                addq.w  #4,SP

                btst    #0,D0
                bne.s   spieler

                movem.l (SP)+,D0-A6
                bra     mainloop

end:            moveq   #0,D0           ; All SNDH Files should get
                movea.l sound(PC),A0    ; that (at least a rts)
                jsr     4(A0)

                move.l  sound(PC),-(SP) ; Soundspeicher freigeben.
                move.w  #$49,-(SP)
                trap    #1
                addq.l  #6,SP

                pea     ping(PC)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP

                move    #$2700,SR
                lea     saver(PC),A0
                move.l  (A0)+,-(SP)     ; alter Stack
                move.w  (A0)+,$FFFF8242.w
                move    (A0)+,SR
                move.w  (A0)+,$0484.w
                move.b  (A0)+,$FFFFFA19.w
                move.b  (A0)+,$FFFFFA17.w
                move.b  (A0)+,$FFFFFA13.w
                move.b  (A0)+,$FFFFFA07.w
                move.b  (A0)+,$FFFFFA1F.w
                move.b  (A0)+,$FFFFFA19.w
                move.l  (A0)+,$0134.w
                move.l  (A0)+,$70.w
                move.l  #$080000,$FFFF8800.w ; Ton aus Geppard !
                move.l  #$090000,$FFFF8800.w
                move.l  #$0A0000,$FFFF8800.w
                move    #$2300,SR

                move.w  #$20,-(SP)      ; zurck in den User-Mode
                trap    #1
                addq.w  #6,SP

endend:         clr.w   -(SP)
                trap    #1

ende:           move.w  #7,-(SP)        ; wird nach den Fehlermeldungen ange-
                trap    #1              ; sprungen
                addq.w  #2,SP
                clr.w   -(SP)
                trap    #1

vbl:            movem.l D0-A6,-(SP)
                bsr     get_volume

                movea.l sound(PC),A0
                jsr     8(A0)
                movem.l (SP)+,D0-A6
                addq.w  #1,counter
                rte

timer_a:        movem.l D0-A6,-(SP)

                bsr     get_volume

                movea.l sound(PC),A0
                jsr     8(A0)           ; Sound spielen

;                tst.b   backgrd         ; Luft Musik im Hauptprogramm ???
;                bne.s   end_tima

end_tima:       movem.l (SP)+,D0-A6
                move.b  #%11011111,$FFFFFA0F.w ; da SEI
                move.b  #speed,$FFFFFA1F.w

                addq.w  #1,counter
                rte

test_sndh:      ;PART 'SNDH test und Infos ausgeben'
                move.l  #'COMM',D0      ; Composer Tag
                bsr     search_sndh
                beq     no_sndh

                lea     composer(PC),A6
                bsr     print
                movea.l D0,A6
                bsr     print

                move.l  #'TITL',D0      ; Title
                bsr     search_sndh
                beq     no_sndh

                lea     title(PC),A6
                bsr     print
                movea.l D0,A6
                bsr     print

                move.l  #'RIPP',D0      ; Ripper
                bsr     search_sndh
                beq     no_sndh

                lea     ripp(PC),A6
                bsr     print
                movea.l D0,A6
                bsr     print

                move.l  #'CONV',D0      ; Konvertierung
                bsr     search_sndh
                beq     no_sndh

                lea     conversion(PC),A6
                bsr     print
                movea.l D0,A6
                bsr     print

                move.w  #'##',D0
                bsr     search_sndh_w
                beq     no_sndh

                move.w  D0,anz

                move.w  #$FF,D1
                and.w   D0,D1           ; 10^0
                lsr.w   #8,D0           ; 10^1

                subi.b  #'0',D0
                subi.b  #'0',D1
                mulu    #10,D0
                add.w   D1,D0
                move.w  D0,anz_songs

                lea     songs(PC),A6
                bsr     print

                move.w  #'!V',D0        ; Konvertierung
                bsr     search_sndh_w
                beq.s   no_tim_sndh2

                lea     vbl_mode(PC),A6
                bsr     print

                st      use_vbl

;                movea.l D0,A6
;                bsr     print
no_tim_sndh2:   bra     no_sndh

search_sndh:    movea.l sound(PC),A5
                move.w  #MAX_HEADER-1,D7
                move.l  (A5)+,D1
_search_sndh:   cmp.l   D0,D1
                beq.s   wow2
                lsl.l   #8,D1
                move.b  (A5)+,D1
                dbra    D7,_search_sndh
                moveq   #0,D0
                rts
wow2:           move.l  A5,D0
                rts

search_sndh_w:  movea.l sound(PC),A5
                move.w  #MAX_HEADER-1,D7
                move.w  (A5)+,D1
_search_sndh_w: cmp.w   D0,D1
                beq.s   wow_w
                lsl.w   #8,D1
                move.b  (A5)+,D1
                dbra    D7,_search_sndh_w
                moveq   #0,D0
                rts
wow_w:          move.b  (A5)+,D0
                lsl.w   #8,D0
                move.b  (A5)+,D0
                rts


composer:       DC.B 'Composer:   ',0
title:          DC.B 13,10,'Title:      ',0
ripp:           DC.B 13,10,'Ripped:     ',0
conversion:     DC.B 13,10,'Conversion: ',0
songs:          DC.B 13,10,'Songs:      '
anz:            DC.B 'xx',13,10,13,10,0
vbl_mode:       DC.B 'VBL-Mode:   active (switch your monitor to 50HZ)'
filler:         DC.B 13,10,13,10,0 ; } (ZWEI ZEILEN NICHT TRENNEN!!!).
                EVEN

print:          movem.l D0-D2/A0-A2,-(SP)
                pea     (A6)
                move.w  #9,-(SP)
                trap    #1
                addq.l  #6,SP
                movem.l (SP)+,D0-D2/A0-A2
no_sndh:        rts
                ;ENDPART
ice_depack2:    ;>PART 'ICE Depacker'
;********************************************* Unpacking routine of PACK-ICE
; a0 = Adress of packed data
; "bsr" or "jsr" to ice_decrunch_2 with register a0 prepared.
                link    A3,#-120
                movem.l D0-A6,-(SP)
                lea     120(A0),A4
                movea.l A4,A6
                bsr     .getinfo
                cmpi.l  #'ICE!',D0
                bne     .not_packed
                bsr.s   .getinfo
                lea     -8(A0,D0.l),A5
                bsr.s   .getinfo
                move.l  D0,(SP)
                adda.l  D0,A6
                movea.l A6,A1

                moveq   #119,D0
.save:          move.b  -(A1),-(A3)
                dbra    D0,.save
                movea.l A6,A3
                move.b  -(A5),D7
                bsr.s   .normal_bytes
                movea.l A3,A5


                bsr     .get_1_bit
                bcc.s   .no_picture
                move.w  #$0F9F,D7
                bsr     .get_1_bit
                bcc.s   .ice_00
                moveq   #15,D0
                bsr     .get_d0_bits
                move.w  D1,D7
.ice_00:        moveq   #3,D6
.ice_01:        move.w  -(A3),D4
                moveq   #3,D5
.ice_02:        add.w   D4,D4
                addx.w  D0,D0
                add.w   D4,D4
                addx.w  D1,D1
                add.w   D4,D4
                addx.w  D2,D2
                add.w   D4,D4
                addx.w  D3,D3
                dbra    D5,.ice_02
                dbra    D6,.ice_01
                movem.w D0-D3,(A3)
                dbra    D7,.ice_00
.no_picture:
                movem.l (SP),D0-A3

.move:          move.b  (A4)+,(A0)+
                subq.l  #1,D0
                bne.s   .move
                moveq   #119,D0
.rest:          move.b  -(A3),-(A5)
                dbra    D0,.rest
.not_packed:
                movem.l (SP)+,D0-A6
                unlk    A3
                rts

.getinfo:       moveq   #3,D1
.getbytes:      lsl.l   #8,D0
                move.b  (A0)+,D0
                dbra    D1,.getbytes
                rts

.normal_bytes:
                bsr.s   .get_1_bit
                bcc.s   .test_if_end
                moveq   #0,D1
                bsr.s   .get_1_bit
                bcc.s   .copy_direkt
                lea     .direkt_tab+20(PC),A1
                moveq   #4,D3
.nextgb:        move.l  -(A1),D0
                bsr.s   .get_d0_bits
                swap    D0
                cmp.w   D0,D1
                dbne    D3,.nextgb
.no_more:       add.l   20(A1),D1
.copy_direkt:
                move.b  -(A5),-(A6)
                dbra    D1,.copy_direkt
.test_if_end:
                cmpa.l  A4,A6
                bgt.s   .strings
                rts

.get_1_bit:
                add.b   D7,D7
                bne.s   .bitfound
                move.b  -(A5),D7
                addx.b  D7,D7
.bitfound:
                rts

.get_d0_bits:
                moveq   #0,D1
.hole_bit_loop:
                add.b   D7,D7
                bne.s   .on_d0
                move.b  -(A5),D7
                addx.b  D7,D7
.on_d0:         addx.w  D1,D1
                dbra    D0,.hole_bit_loop
                rts


.strings:       lea     .length_tab(PC),A1
                moveq   #3,D2
.get_length_bit:
                bsr.s   .get_1_bit
                dbcc    D2,.get_length_bit
.no_length_bit:
                moveq   #0,D4
                moveq   #0,D1
                move.b  1(A1,D2.w),D0
                ext.w   D0
                bmi.s   .no_ber
.get_ber:
                bsr.s   .get_d0_bits
.no_ber:       move.b  6(A1,D2.w),D4
                add.w   D1,D4
                beq.s   .get_offset_2


                lea     .more_offset(PC),A1
                moveq   #1,D2
.getoffs:       bsr.s   .get_1_bit
                dbcc    D2,.getoffs
                moveq   #0,D1
                move.b  1(A1,D2.w),D0
                ext.w   D0
                bsr.s   .get_d0_bits
                add.w   D2,D2
                add.w   6(A1,D2.w),D1
                bpl.s   .depack_bytes
                sub.w   D4,D1
                bra.s   .depack_bytes


.get_offset_2:
                moveq   #0,D1
                moveq   #5,D0
                moveq   #-1,D2
                bsr.s   .get_1_bit
                bcc.s   .less_40
                moveq   #8,D0
                moveq   #$3F,D2
.less_40:       bsr.s   .get_d0_bits
                add.w   D2,D1

.depack_bytes:
                lea     2(A6,D4.w),A1
                adda.w  D1,A1
                move.b  -(A1),-(A6)
.dep_b:         move.b  -(A1),-(A6)
                dbra    D4,.dep_b
                bra     .normal_bytes


.direkt_tab:
                DC.L $7FFF000E,$FF0007,$070002,$030001,$030001
                DC.L 270-1,15-1,8-1,5-1,2-1

.length_tab:
                DC.B 9,1,0,-1,-1
                DC.B 8,4,2,1,0

.more_offset:
                DC.B 11,4,7,0   ; Bits lesen
                DC.W $011F,-1,$1F ; Standard Offset

ende_ice_decrunch_2:
;************************************************** end of unpacking routine
                ;ENDPART

starttxt:                               ;DC.B 27,'f',27,'E'
                DC.B 13,10
                DC.B 'Soundchipplayer v. 0.49 by BDCannibal/AURA (6.1.98).'
                DC.B 13,10,13,10
txt:            DC.B 'Playing File:   '
txt1:           DC.B 'XXXXXXXX.XXX ('
txt2:           DC.B 'XXXXX',' Bytes)',13,10,13,10,27,'f',27,'b9',0
                EVEN

vol0:           DC.B '[               ]',13,10,0
vol1:           DC.B '[*              ]',13,10,0
vol2:           DC.B '[**             ]',13,10,0
vol3:           DC.B '[***            ]',13,10,0
vol4:           DC.B '[****           ]',13,10,0
vol5:           DC.B '[*****          ]',13,10,0
vol6:           DC.B '[******         ]',13,10,0
vol7:           DC.B '[*******        ]',13,10,0
vol8:           DC.B '[********       ]',13,10,0
vol9:           DC.B '[*********      ]',13,10,0
vola:           DC.B '[**********     ]',13,10,0
volb:           DC.B '[***********    ]',13,10,0
volc:           DC.B '[************   ]',13,10,0
vold:           DC.B '[************',27,'b1','*  ',27,'b9',']',13,10,0
vole:           DC.B '[************',27,'b1','** ',27,'b9',']',13,10,0
volf:           DC.B '[************',27,'b1','***',27,'b9',']',13,10,0
curs_up:        DC.B 27,'A',27,'A',27,'A',0

fault1:         DC.B 27,'E','Datei nicht gefunden...',0
fault2:         DC.B 27,'E','Datei konnte nicht geffnet werden...',0
fault3:         DC.B 27,'E','Datei konnte nicht korrekt gelesen werden...',0
fault5:         DC.B 27,'E','Fehler bei der Speicherreservierung...',0
ping:           DC.B 7,0

use_vbl:        DC.B 0          ; VBL benutzen ?
volume:         dc.b 0,0,0      ; Buffer fur Lautstaerken (Volumeter)
                EVEN
anz_songs:      DC.W 0

                BSS
                EVEN
counter:        DS.W 1
resident:       DS.L 1
backgrd:        DS.B 2
saver:          DS.B 44
filename:       DS.B 258
dta:            DS.B 44
graf:           DS.L 1
sound:          DS.L 1
                END
