/* MPEG Audio layer 2 decoder. */

#include <tos.h>
#include <vdi.h>
#include <aes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "version.h"
#include "mp2audio.h"
#include "mp2info.h"
#include "configs.h"

#include "mp2ctrl.rsh"	/* rsc file */
#include "mp2ctrl.rh"
#include "window.h"

#include "libshoe.h"
#include "stream.h"
#include "replay.h"

/* global variables */
int time_slice=DEFAULT_TIME_SLICE,count_dir=DEFAULT_COUNT_DIR;
int replay = 0, quit;
int app_id, acc_id, vdi_id;
int dom;
WINDFORM windforms[5];
WINDHANDLELIST *windhandles = NULL;

extern int _app;

/* global variables from mp2file.c */
extern char path[512];

/* Function in this module. */
static void setup_rsrc(int nbpl);
extern void unix2dos(char *);

/* Functions from mp2event.c */
extern void main_event_loop(void);
extern void unquote(char *);

/* Function from bifs.c */
extern void load_bifs(void);

#pragma warn -par
int main(int argc, char *argv[])
{
	int wchar,hchar,wbar,hbar;
	int work_in[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 };
	int work_out[57];
	int tmp_id, button;

	if(_app) {
		int sndlocked, dsplocked;
		
		sndlocked = locksnd()!=1?1:0;
		dsplocked = Dsp_Lock()!=0?1:0;
		
		if(sndlocked && dsplocked) {
			button = form_alert(1,"[1][The audio subsystem|and the DSP "
			                      "are already in use!]"
			                      "[ Quit | Force ]");
			if(button == 1)
				return -129;
			unlocksnd();
			locksnd();
			Dsp_Unlock();
			Dsp_Lock();			
		} else if(dsplocked) {
			button = form_alert(1,"[1][The DSP is already in use!]"
										 "[ Quit | Force ]");
			if(button == 1)
				return -130;
			Dsp_Unlock();
			Dsp_Lock();
		} else if(sndlocked) {
			button = form_alert(1,"[1][The audio subsystem|"
										 "is already in use!]"
										 "[ Quit | Force ]");
			if(button == 1)
				return -131;
			unlocksnd();
			locksnd();
		}
	}

	dom = (Pdomain(1) == 0) ? 1 : 0;

	/* Default path is current. */
	path[0] = 'A' + (char)Dgetdrv();
	path[1] = ':';
	Dgetpath(path+2, 0);
	strcat(path, "\\");

	if((app_id = appl_init()) >= 0) {
	/* Run external clock detection. */
		external_clock();

		stream_set_buffer(DEFAULT_BLOCK_SIZE*1024L);
		if(!stream_get_buffer()) {
			form_alert(1,"[1][Not enough memory!][OK]");
			appl_exit();
			return 1;
		}
		
		if(!_app || _GemParBlk.global[0] >= 0x0400)
			tmp_id = menu_register(app_id, "  MP2 Audio ");
		if(!_app)
			acc_id = tmp_id;		
		
		work_in[0]=vdi_id=graf_handle(&wchar,&hchar,&wbar,&hbar);
		v_opnvwk(work_in,&vdi_id,work_out);
		if(vdi_id > 0) {
			vq_extnd(vdi_id,1,work_out);
			setup_rsrc(work_out[4]);
			
			/* Load application specific Shoe bifs. */
			load_bifs();
			
			/* Load Shoe bootstrap code. */
			parse_eval("(load \"mp2audio.sho\")");
			
			if(_app) {
				window_create(WIND_CTRL);
				graf_mouse(ARROW,NULL);

				if(argc > 1) {
					char tmp[1024];

					strcpy(tmp, "(mp2-hook-dragumdroppum \"");
					unquote(argv[1]);
					strcat(tmp, argv[1]);
					strcat(tmp, "\")");
					parse_eval(tmp);
				}

				main_event_loop();
				replay_stop();
	
				v_clsvwk(vdi_id);
			} else if (acc_id >= 0)
				main_event_loop();
		}

		/* This restores at least the keyclick.        */
		soundcmd(4,1);		/* Set Adder-In -> Matrix. */
		soundcmd(5,3);		/* ADC input -> PSG.       */
		soundcmd(6,3);		/* STE prescaler 160.      */

		appl_exit();
		
		stream_close();
		stream_free_buffer();
	}

	Dsp_Unlock();
	unlocksnd();
	return 0;
}
#pragma warn .par

/* Initialize resource structures. */
static void setup_rsrc(int nbpl)
{
	int ob;
	char ver[64];
	
	for(ob = 0; ob < NUM_OBS; ob++)
		rsrc_obfix(rs_object,ob);

	switch(nbpl) {
		case 1:
		case 2:
			windforms[WIND_CTRL].formtree=rs_trindex[FORM_CTRL1];
			windforms[WIND_INFO].formtree=rs_trindex[FORM_INFO1];
			windforms[WIND_SHOE].formtree=rs_trindex[FORM_SHOE];
			break;
		case 4:
		default:
			windforms[WIND_CTRL].formtree=rs_trindex[FORM_CTRL4];
			windforms[WIND_INFO].formtree=rs_trindex[FORM_INFO4];
			windforms[WIND_SHOE].formtree=rs_trindex[FORM_SHOE];
	}

	strcpy(windforms[WIND_CTRL].wind_title,"");
	strcpy(windforms[WIND_INFO].wind_title,"Info");
	strcpy(windforms[WIND_SHOE].wind_title,"      Shoe Console      ");
	strcpy(ver,"Version ");
	strcat(ver,VERSION_TEXT);
	strcpy(windforms[WIND_INFO].formtree[INFO_VERSION].ob_spec.tedinfo->te_ptext,ver);
	windforms[WIND_CTRL].windkind=(MOVER | CLOSER | NAME);
	windforms[WIND_INFO].windkind=(MOVER | CLOSER | NAME);
	windforms[WIND_SHOE].windkind=(MOVER | CLOSER | NAME);
	windforms[WIND_CTRL].firstobj=CTRL_FIRST;
	windforms[WIND_INFO].firstobj=INFO_FIRST;
	windforms[WIND_SHOE].firstobj=SHOE_FIRST;
	windforms[WIND_CTRL].objdepth=2;
	windforms[WIND_INFO].objdepth=1;
	windforms[WIND_SHOE].objdepth=0;
	windforms[WIND_CTRL].has_opened=0;
	windforms[WIND_INFO].has_opened=0;
	windforms[WIND_SHOE].has_opened=0;
}

/* Convert filenames from unix to ST format. */
void unix2dos(char *path)
{
	int i = 0;
	char tmp[512];

	if(path[0] == '/') {
		strcpy(tmp,&path[1]);
		strcpy(path,"U:\\");
		strcat(path,tmp);
		while(path[i]) {
			if(path[i] == '/')
				path[i] = '\\';
			i++;
		}
	}
	if(path[strlen(path)-1] != '\\')
		path[strlen(path)-1] = '\\';
}
