
	OPT	D-
	OUTPUT	E:\WHIP!\VLM\DOTBOX.VLM

******** OBJECT EQUATES ********

boxwidth:	=	45<<8
boxsteps:	=	14
boxpoints:	=	boxsteps*boxsteps*boxsteps

boxcolorstep:	=	64/boxsteps

*** VLM STRUCTURE **************************************************************

	DC.B	"VLM2"			* vlm module type
	DC.L	info_txt		* pointer to infotext
	DC.L	settings_tbl		* pointer to settings-structure
	DC.L	init			* pointer to init routine
	DC.L	deinit			* pointer to deinit routine
	DC.L	main			* pointer to mainloop routine

******** OBJECT LIBRARIES ********

	INCLUDE	FIMATH.I
	TEXT

* SERVICE ROUTINES PROVIDED BY THE CALLING PROGRAM

* INPUT: a0: new vbl subroutine
set_vblrout:
	movea.l	service_struct,A1
	movea.l	(A1),A1
	jsr	(A1)
	rts

wait_vbl:
	movea.l	service_struct,A1
	movea.l	4(A1),A1
	jsr	(A1)
	rts

* INPUT: a0: new screen adress
set_scradr:
	movea.l	service_struct,A1
	movea.l	8(A1),A1
	jsr	(A1)
	rts

* INPUT: d0.l: number of the wanted resolution
set_resolution:
	movea.l	service_struct,A1
	movea.l	12(A1),A1
	jsr	(A1)
	rts

get_left_spec:
	movea.l	service_struct,A1
	movea.l	16(A1),A1
	jsr	(A1)			* Returns in a0 the adress of left spec.
	rts

get_right_spec:
	movea.l	service_struct,A1
	movea.l	20(A1),A1
	jsr	(A1)			* Returns in a0 the adress of right spec.
	rts

get_left_volume:
	movea.l	service_struct,A1
	movea.l	24(A1),A1
	jsr	(A1)			* Returns in d0 the left volume value.
	rts

get_right_volume:
	movea.l	service_struct,A1
	movea.l	28(A1),A1
	jsr	(A1)			* Returns in d0 the right volume value.
	rts

get_left_osci:
	movea.l	service_struct,A1
	movea.l	32(A1),A1
	jsr	(A1)			* Returns in a0 the adress of osci data.
	rts

get_right_osci:
	movea.l	service_struct,A1
	movea.l	36(A1),A1
	jsr	(A1)			* Returns in a0 the adress of osci data.
	rts

service_struct:
	DC.L	0			* Must be set in 'init'.

********************************************************************************
info_txt:
	DC.B	"DOTBOX (FRONT 242)",0
	DC.B	"author:  EarX/fun",0
	DC.B	"version: 1.0",0
	DC.B	"date:    21-06-1999",0
	DC.B	0
	EVEN

settings_tbl:
	DC.L	3

	DC.L	rotxname_txt
	DC.L	3
rotxspeed:
	DC.L	7
	DC.L	slider_tbl

	DC.L	rotyname_txt
	DC.L	3
rotyspeed:
	DC.L	7
	DC.L	slider_tbl

	DC.L	rotzname_txt
	DC.L	3
rotzspeed:
	DC.L	7
	DC.L	slider_tbl

slider_tbl:
	DC.L	0
	DC.L	16

rotxname_txt:
	DC.B	"X ROTATION SPEED",0
rotyname_txt:
	DC.B	"Y ROTATION SPEED",0
rotzname_txt:
	DC.B	"Z ROTATION SPEED",0

* INPUT: a0: service structure
init:	move.l	a0,service_struct

	lea	scr,a1
	lea	scr_buf,a0
	move.l	#320*100*2,d0
	move.l	a0,(a1)+
	adda.l	d0,a0
	move.l	a0,(a1)+
	adda.l	d0,a0
	move.l	a0,(a1)+

	bsr	CALC_XYLOOKUPTABLE
	bsr	CALC_FIRECOLORS

	lea	fire_buf,a0
	moveq	#84/4-1,d7
	moveq	#0,d0
.loop:	move.l	d0,(a0)+
	dbra	d7,.loop

	move.l	#$ef56a71c,random

	moveq	#2,D0			* Set resolution to 320x100.
	bsr	set_resolution
	rts

deinit:
	rts

main:
;	movea.l	scr,a0
;	movea.l	scr+4,a1
;	bsr	BLUR_320100
	bsr	PLOT_FIRE

	lea	orgaxis_tbl,a0
	bsr	get_left_volume
	move.w	d0,d1
	bsr	get_right_volume
	move.w	d0,d2
	move.w	d1,d0
	add.w	d2,d0
	lsr.w	#3,d0
	lsr.w	#2,d1
	lsr.w	#2,d2
	move.w	d0,(a0)
	move.w	d1,6+2(a0)
	move.w	d2,6*2+4(a0)

	move.w	$4bc.w,d0
	move.w	d0,d1
	move.w	d0,d2
	mulu.w	rotxspeed+2,d0
	lsr.l	#3,d0
	mulu.w	rotyspeed+2,d1
	lsr.l	#3,d1
	mulu.w	rotzspeed+2,d2
	lsr.l	#3,d2
	movem.w	d0-d2,.rot_tbl
	bsr	PLOT_DOTBOX

;	lea	.rot_tbl(pc),a1
;	bsr	PLOT_ROTATION

	lea	scr,a1
	movea.l	(a1)+,a0
	move.l	(a1)+,d1
	move.l	(a1),-4(a1)
	move.l	a0,(a1)
	move.l	d1,-8(a1)
	bsr	set_scradr
	rts				* end of the mainroutine

.rot_tbl:
	DS.W	3
.volume:
	DC.W	0

******** SUBROUTINES ********

CALC_FIRECOLORS:
	lea	firecolor_tbl,a0
	moveq	#0,d0
	move.l	#%00000000001000000000000000100000,d1
	move.l	#%00001000000000000000100000000000,d2
	moveq	#64/2-1,d7

.loop:	addq	#4,a0
	move.l	d0,(a0)+
	add.l	d1,d0
	addq	#4,a0
	move.l	d0,(a0)+
	add.l	d2,d0
	add.l	d1,d0
	dbra	d7,.loop

	move.w	#64-1,d7
	lea	-64*8(a0),a0
	lea	4(a0),a1
	movea.l	a1,a2

.doubleloop:
	move.l	(a1),d0
	moveq	#64-1,d6

.innerloop:
	move.l	d0,(a0)+
	move.l	(a2),(a0)+
	addq	#8,a2
	dbra	d6,.innerloop

	lea	-64*8(a2),a2
	lea	192*8(a0),a0
	addq	#8,a1
	dbra	d7,.doubleloop
	rts

CALC_XYLOOKUPTABLE:
	lea	xylookup_tbl,a0
	moveq	#0,d1

.yloop:	moveq	#0,d0
	move.b	d1,d3
	ext.w	d3
	addi.w	#50,d3
	cmpi.w	#100,d3
	blo.s	.yonscreen
	moveq	#0,d7
	moveq	#-1,d2
.clrloop:
	move.w	d2,(a0)+
	addq.b	#1,d7
	bne.s	.clrloop
	bra.s	.endy
.yonscreen:
	mulu.w	#320,d3

.xloop:	move.b	d0,d2
	ext.w	d2
	addi.w	#80,d2
	cmpi.w	#160,d2
	blo.s	.xonscreen
	move.w	#-1,(a0)+
	bra.s	.endx
.xonscreen:
	ext.l	d2
	add.l	d2,d2
	add.l	d3,d2
	move.w	d2,(a0)+
.endx:	addq.b	#1,d0
	bne.s	.xloop

.endy:	addq.b	#1,d1
	bne.s	.yloop
	rts

PLOT_TESTXY:
	movea.l	scr,a0
	lea	xylookup_tbl,a1
	move.w	#$30f0,d0
	moveq	#0,d1
	move.w	(a1,d0.w*2),d1
	bmi.s	.rts
	move.w	#$ffff,(a0,d1.l*2)
.rts	rts

PLOT_FIRE:
	lea	firecolor_tbl,a4
	lea	fire_buf,a1
	lea	84(a1),a2
	lea	84(a2),a3
	movea.l	scr,a0
	lea	640(a0),a5
	moveq	#100-1,d7
	move.l	#%11111100111111001111110011111100,d5
	moveq	#0,d4

.yloop:	moveq	#80/4-1,d6

.xloop:	move.l	(a1)+,d0
	add.l	d0,d0
	add.l	(a3)+,d0
	add.l	(a2)+,d0
	;add.l	-2(a1),d0
	and.l	d5,d0
	lsr.l	#2,d0
	move.l	d0,-3(a2)
	move.l	d0,d1
	swap	d1
	move.l	(a4,d1.w*8),(a0)+
	move.l	(a4,d1.w*8),-(a5)
	move.l	4(a4,d1.w*8),(a0)+
	move.l	4(a4,d1.w*8),-(a5)
	move.l	(a4,d0.w*8),(a0)+
	move.l	(a4,d0.w*8),-(a5)
	move.l	4(a4,d0.w*8),(a0)+
	move.l	4(a4,d0.w*8),-(a5)
	dbra	d6,.xloop

	addq	#4,a1
	addq	#4,a2
	addq	#4,a3
	lea	80*4(a0),a0
	lea	640(a0),a5
	dbra	d7,.yloop

* Calculate new baseline of fire.
	bsr	get_left_osci
	movea.l	a0,a2
	bsr	get_right_osci
	lea	12*2(a0),a0
	lea	12*2(a2),a2
	lea	fire_buf,a1
	moveq	#102-1,d7

.intlop:
	move.b	(a0),d0
	add.b	(a2),d0
	lsr.b	#1,d0
	move.b	d0,(a1)
	addq	#2,a0
	addq	#2,a2
	lea	84(a1),a1
	dbra	d7,.intlop
	rts

* INPUT: a1: address of rotationtable
PLOT_ROTATION:
	movea.l	scr,a0
	move.w	(a1)+,d7
	Do_SinModulo	d7
	mulu.w	#((1<<16)*320)/sintbllen,d7
	swap	d7
	move.w	d7,d6
	subq.w	#1,d7
	bmi.s	.endplotx

.loop:	move.w	#$f800,(a0)+
	dbra	d7,.loop

	move.w	#320-1,d7
	sub.w	d6,d7
	bmi.s	.skipclr1
	moveq	#0,d0
.clrloop1:
	move.w	d0,(a0)+
	dbra	d7,.clrloop1
.skipclr1:
.endplotx:

	movea.l	scr,a0
	adda.l	#320*2,a0
	move.w	(a1)+,d7
	Do_SinModulo	d7
	mulu.w	#((1<<16)*320)/sintbllen,d7
	swap	d7
	move.w	d7,d6
	subq.w	#1,d7
	bmi.s	.endploty

.loop2:	move.w	#$03c0,(a0)+
	dbra	d7,.loop2

	move.w	#320-1,d7
	sub.w	d6,d7
	bmi.s	.skipclr2
	moveq	#0,d0
.clrloop2:
	move.w	d0,(a0)+
	dbra	d7,.clrloop2
.skipclr2:
.endploty:

	movea.l	scr,a0
	adda.l	#320*2*2,a0
	move.w	(a1)+,d7
	Do_SinModulo	d7
	mulu.w	#((1<<16)*320)/sintbllen,d7
	swap	d7
	move.w	d7,d6
	subq.w	#1,d7
	bmi.s	.endplotz

.loop3:	move.w	#$001f,(a0)+
	dbra	d7,.loop3

	move.w	#320-1,d7
	sub.w	d6,d7
	bmi.s	.skipclr3
	moveq	#0,d0
.clrloop3:
	move.w	d0,(a0)+
	dbra	d7,.clrloop3
.skipclr3:
.endplotz:
	rts


* INPUT: d0.w: X angle (a)
*        d1.w: Y angle (b)
*        d2.w: Z angle (c)
PLOT_DOTBOX:
* 1> rotate 3 axis.
	Do_SinModulo	d0
	Do_SinModulo	d1
	Do_SinModulo	d2
	movea.w	d0,a3
	movea.w	d1,a4
	movea.w	d2,a5
	lea	sine_tbl,a2
	lea	orgaxis_tbl,a1
	lea	.rotaxis_tbl(pc),a0

* Do all rotations for X coordinate:
* X := + x*cos(b)*cos(c)
*      - y*cos(b)*sin(c)
*      + z*sin(b)
	Get_SinCos	a2,d1,d3,d4
	Get_SinCos	a2,d2,d5,d6
	muls.w	d4,d6				* / cos(b)*sin(c)
	add.l	d6,d6				* |
	swap	d6				* \
	muls.w	d4,d5				* / cos(b)*sin(c)
	add.l	d5,d5				* |
	swap	d5				* \
	moveq	#3-1,d7
.xrotloop:
	movem.w	(a1)+,d0-d2
	muls.w	d6,d0
	muls.w	d5,d1
	muls.w	d3,d2
	add.l	d2,d0
	sub.l	d1,d0
	add.l	d0,d0
	swap	d0
	move.w	d0,(a0)
	addq	#6,a0
	dbra	d7,.xrotloop
	
* Do all rotations for Y coordinate:
* Y := + x*(sin(a)*sin(b)*cos(c)+cos(a)*sin(c))
*      + y*(cos(a)*cos(c)-sin(a)*sin(b)*sin(c))
*      - z*sin(a)*cos(b)
	lea	-3*6(a1),a1
	lea	-3*6+2(a0),a0
	Get_SinCos	a2,a3,d0,d1
	Get_Sin		a2,a4,d2
	Get_SinCos	a2,a5,d4,d5
	muls.w	d0,d2
	add.l	d2,d2
	swap	d2
	muls.w	d2,d5
	add.l	d5,d5
	swap	d5
	muls.w	d1,d4
	add.l	d4,d4
	swap	d4
	add.w	d4,d5
	move.w	d5,d3
	;Get_SinCos	a2,a3,d0,d1
	Get_Sin		a2,a4,d2
	Get_SinCos	a2,a5,d4,d5
	muls.w	d1,d5
	add.l	d5,d5
	swap	d5
	muls.w	d0,d2
	add.l	d2,d2
	swap	d2
	muls.w	d2,d4
	add.l	d4,d4
	swap	d4
	sub.w	d4,d5
	Get_Cos		a2,a4,d4
	muls.w	d0,d4
	add.l	d4,d4
	swap	d4
	moveq	#3-1,d7
.yrotloop:
	movem.w	(a1)+,d0-d2
	muls.w	d3,d0
	muls.w	d5,d1
	muls.w	d4,d2
	sub.l	d2,d0
	add.l	d1,d0
	add.l	d0,d0
	swap	d0
	move.w	d0,(a0)
	addq	#6,a0
	dbra	d7,.yrotloop

* Do all rotations for Z coordinate:
* Z := + x*(sin(a)*sin(c)-cos(a)*sin(b)*cos(c))
*      + y*(cos(a)*sin(b)*sin(c)+sin(a)*cos(c))
*      + z*cos(a)*cos(b)
	lea	-3*6(a1),a1
	lea	-3*6+2(a0),a0
	Get_SinCos	a2,a3,d0,d1
	Get_Sin		a2,a4,d2
	Get_SinCos	a2,a5,d4,d5
	muls.w	d0,d4
	add.l	d4,d4
	swap	d4
	muls.w	d2,d1
	add.l	d1,d1
	swap	d1
	muls.w	d1,d5
	add.l	d5,d5
	swap	d5
	sub.w	d5,d4
	move.w	d4,d3
	;Get_SinCos	a2,a3,d0,d1
	Get_Sin		a2,a4,d2
	Get_SinCos	a2,a5,d4,d5
	muls.w	d1,d2
	add.l	d2,d2
	swap	d2
	muls.w	d2,d4
	add.l	d4,d4
	swap	d4
	muls.w	d0,d5
	add.l	d5,d5
	swap	d5
	add.w	d4,d5
	Get_Cos		a2,a4,d4
	muls.w	d1,d4
	add.l	d4,d4
	swap	d4
	moveq	#3-1,d7
.zrotloop:
	movem.w	(a1)+,d0-d2
	muls.w	d3,d0
	muls.w	d6,d1
	muls.w	d4,d2
	add.l	d2,d0
	add.l	d1,d0
	add.l	d0,d0
	swap	d0
	move.w	d0,(a0)
	addq	#6,a0
	dbra	d7,.zrotloop

* 2> Calculate start corner vertex.
	lea	.rotaxis_tbl(pc),a0
	moveq	#0,d0
	movea.l	d0,a1
	movea.l	d0,a2
	movea.l	d0,a3
	suba.w	(a0)+,a1
	suba.w	(a0)+,a2
	suba.w	(a0)+,a3
	suba.w	(a0)+,a1
	suba.w	(a0)+,a2
	suba.w	(a0)+,a3
	suba.w	(a0)+,a1
	suba.w	(a0)+,a2
	suba.w	(a0)+,a3
	move.l	a1,d0
	move.l	a2,d1
	move.l	a3,d2
	add.w	d0,d0	;asr.w	#1,d0
	add.w	d1,d1	;asr.w	#1,d1
	add.w	d2,d2	;asr.w	#1,d2
	movem.w	d0-d2,.startvertex_tbl

* 3> Calculate fixedpoint step values to interpolate between corners.
	lea	.rotaxis_tbl(pc),a1
	lea	.stepaxis_tbl(pc),a0
	moveq	#3*3-1,d7
.calcsteploop:
	move.w	(a1)+,d0
	ext.l	d0
	divs.w	#boxsteps-1,d0
	lsl.w	#2,d0
	move.w	d0,(a0)+
	dbra	d7,.calcsteploop

* 4> Calculate the positions of all points in the box and plot them!
	movea.l	scr,a0
	lea	gradient_dat,a5
	lea	xylookup_tbl,a6
	lea	.stepaxis_tbl(pc),a1
	lea	.startvertex_tbl(pc),a2
 	movem.w	(a1),d3-d4
	addq	#6,a1
	moveq	#boxsteps-1,d7
	movem.w	(a2),a3-a4
	moveq	#0,d2
	moveq	#0,d5

.zloop:	swap	d7
	move.w	#boxsteps-1,d7
	move.l	a3,d0
	move.l	a4,d1

.yloop:	moveq	#boxsteps-1,d6

.xloop:	move.w	d1,d5
	move.w	d0,d2
 	lsr.w	#8,d2
	move.b	d2,d5
	move.w	(a6,d5.l*2),d2
	bmi.s	.noplot
	move.l	(a5),(a0,d2.l*2)
.noplot:
	add.w	d3,d0
	add.w	d4,d1
	dbra	d6,.xloop

	lea	boxcolorstep*2(a5),a5
	movem.w	(a1),d0-d1
	adda.l	d0,a3
	adda.l	d1,a4
	move.l	a3,d0
	move.l	a4,d1
	dbra	d7,.yloop

	lea	2*((boxcolorstep-1)*64+(64-boxcolorstep*boxsteps))(a5),a5
	movem.w	(a2),a3-a4
	movem.w	6(a1),d0-d1
	adda.l	d0,a3
	adda.l	d1,a4
	movem.w	a3-a4,(a2)
	swap	d7
	dbra	d7,.zloop 

	rts

.rotaxis_tbl:
	DS.W	3*3
.stepaxis_tbl:
	DS.W	3*3
.startvertex_tbl:
	DS.W	3

* INPUT: a0: destination screenaddress
*        a1: source screenaddress
BLUR_320100:
	move.w	#5*100-1,d7
	move.l	#%01111011111011110111101111101111,d6
	moveq	#4*4,d5
.loop:	REPT	8
	movem.l	(a1)+,d0-d3
	lsr.l	#1,d0
	and.l	d6,d0
	lsr.l	#1,d1
	and.l	d6,d1
	lsr.l	#1,d2
	and.l	d6,d2
	lsr.l	#1,d3
	and.l	d6,d3
	movem.l	d0-d3,(a0)
	adda.l	d5,a0
	ENDR
	dbra	d7,.loop
	rts

******** DATA SECTION ********

	DATA

orgaxis_tbl:
	DC.W	boxwidth,0,0
	DC.W	0,boxwidth,0
	DC.W	0,0,boxwidth
gradient_dat:
	INCBIN	GRADIENT.RAW
sine_tbl:
	INCBIN	SINUS.DAT

******** RESERVED SECTION ********

	BSS

	DS.W	1
scr:	DS.L	3
scr_buf:
	DS.W	320*100*3
xylookup_tbl:
	DS.W	256*256
firecolor_tbl:
	DS.L	2*64*256
fire_buf:
	DS.B	102*84				* Y*X