r_1b	=	1
r_2b	=	2
r_4b	=	4
r_8b	=	8
r_true	=	16
x320	=	320
x640	=	640
y200	=	200	
y400	=	400

super	macro

	clr.l	-(sp)
	move.w	#$20,-(sp)
	trap	#1
	addq.l	#6,sp

	endm

user	macro

	move.l	\1,-(sp)
	move.w	#$20,-(sp)
	trap	#1
	addq.l	#6,sp

	endm
	
lgres	macro
	
	move.w	#0,-(sp)
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	lea	12(sp),sp
	
	endm
	
medres	macro
	
	move.w	#1,-(sp)
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	lea	12(sp),sp
	
	endm

slut	macro

	move.w	#\1,$ffff8240.w
	move.w	#\2,$ffff8246.w
	move.b	#7,$484.w
	bset	#1,$ffff820a.w

	medres

	clr.w	-(sp)
	trap	#1
	
	endm
	
vsync	macro

	clr.w	$468.w
	tst.w	$468.w
	dc.w	$67fa
	
	endm
	
savemfp	macro
	
	move.l	a1,-(sp)
	
	lea	\1,a1
	
	move.l	$70.w,(a1)+
	move.l	$120.w,(a1)+
	move.l	$68.w,(a1)+
	move.b	$fffffa01.w,(a1)+
	move.b	$fffffa03.w,(a1)+
	move.b	$fffffa05.w,(a1)+
	move.b	$fffffa07.w,(a1)+
	move.b	$fffffa09.w,(a1)+
	move.b	$fffffa0b.w,(a1)+
	move.b	$fffffa0d.w,(a1)+
	move.b	$fffffa0f.w,(a1)+
	move.b	$fffffa11.w,(a1)+
	move.b	$fffffa13.w,(a1)+
	move.b	$fffffa15.w,(a1)+
	move.b	$fffffa17.w,(a1)+
	move.b	$fffffa19.w,(a1)+
	move.b	$fffffa1b.w,(a1)+
	move.b	$fffffa1d.w,(a1)+
	move.b	$fffffa1f.w,(a1)+
	move.b	$fffffa21.w,(a1)+
	move.b	$fffffa23.w,(a1)+
	move.b	$fffffa25.w,(a1)+
	move.b	$fffffa27.w,(a1)+
	move.b	$fffffa29.w,(a1)+
	move.b	$fffffa2b.w,(a1)+
	move.b	$fffffa2d.w,(a1)+
	move.b	$fffffa2f.w,(a1)+

	move.l	(sp)+,a1

	endm
	
loadmfp	macro
	
	move.l	a1,-(sp)
	
	lea	\1,a1
	
	move.l	(a1)+,$70.w
	move.l	(a1)+,$120.w
	move.l	(a1)+,$68.w
	move.b	(a1)+,$fffffa01.w
	move.b	(a1)+,$fffffa03.w
	move.b	(a1)+,$fffffa05.w
	move.b	(a1)+,$fffffa07.w
	move.b	(a1)+,$fffffa09.w
	move.b	(a1)+,$fffffa0b.w
	move.b	(a1)+,$fffffa0d.w
	move.b	(a1)+,$fffffa0f.w
	move.b	(a1)+,$fffffa11.w
	move.b	(a1)+,$fffffa13.w
	move.b	(a1)+,$fffffa15.w
	move.b	(a1)+,$fffffa17.w
	move.b	(a1)+,$fffffa19.w
	move.b	(a1)+,$fffffa1b.w
	move.b	(a1)+,$fffffa1d.w
	move.b	(a1)+,$fffffa1f.w
	move.b	(a1)+,$fffffa21.w
	move.b	(a1)+,$fffffa23.w
	move.b	(a1)+,$fffffa25.w
	move.b	(a1)+,$fffffa27.w
	move.b	(a1)+,$fffffa29.w
	move.b	(a1)+,$fffffa2b.w
	move.b	(a1)+,$fffffa2d.w
	move.b	(a1)+,$fffffa2f.w

	move.l	(sp)+,a1

	endm

clickoff	macro

	clr.b	$484.w
	
	endm
	
clickon	macro

	move.b	#7,$484.w
	
	endm
	
slump	macro

	movem.l	a0-a6,-(sp)

	move.w	#17,-(sp)
	trap	#14
	addq.l	#2,sp
	
	movem.l	(sp)+,a0-a6
	
	endm
	
print	macro
	
	movem.l	d0-3/a0-3,-(sp)
	move.l	\1,a3
	moveq	#0,d3

om_igen\@
	move.b	(a3)+,d3
	move.w	d3,-(sp)
	move.w	#2,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp

	tst.b	(a3)
	bne	om_igen\@
	movem.l	(sp)+,d0-3/a0-3
	
	endm
	
synclock	macro

	move.l	d0,-(sp)
	
	move.b	$ffff8209.w,d0
	dc.w	$67fa
	not	d0
	lsl	d0,d0

	move.l	(sp)+,d0
	
	endm

pvsync	macro

	move.w	#\1,$ffff8240.w

	clr.w	$468.w
	tst.w	$468.w
	dc.w	$67fa
	
	move.w	#\2,$ffff8240.w
	
	endm

pvsl	macro

	move.w	#\1,$ffff8240.w

	clr.w	$468.w
	tst.w	$468.w
	dc.w	$67fa

	move.l	d0,-(sp)
	
	move.b	$ffff8209.w,d0
	dc.w	$67fa
	not	d0
	lsl	d0,d0

	dcb	\3/4,$4e71

	move.l	(sp)+,d0
	
	move.w	#\2,$ffff8240.w
	
	endm
	
spslut	macro
	clr.w	-(sp)
	move.l	\1,-(sp)
	move.w	#$31,-(sp)
	trap	#1
	endm
		
mshrink	macro
	move.l	4(sp),a5
	move.l	$c(a5),d0
	add.l	$14(a5),d0
	add.l	$1c(a5),d0
	add.l	#$1000,d0
	add.l	#$100,d0
	move.l	a5,d1
	add.l	d0,d1
	and.l	#-2,d1
	move.l	d1,sp
	move.l	d0,-(sp)
	move.l	a5,-(sp)
	move.w	d0,-(sp)
	move.w	#$4a,-(sp)
	trap	#1
	lea	12(sp),sp
	endm
	
lvsync	macro
	clr.w	$468.w
.wl\@	cmp.w	#\1,$468.w
	bne.s	.wl\@
	endm
	
aeslist	macro
aes_pb	dc.l	control,global,int_in,int_out,addr_in,addr_out
global	ds.w	7
	dc.l	0,0,0,0
control	ds.w	12
int_in	ds.w	30
int_out	ds.w	45
addr_in	ds.l	2
addr_out	ds.l	1	
	endm

vdilist	macro
vdi_pb	dc.l	contrl,intin,ptsin,intout,ptsout
contrl	ds.w	12
intin	ds.w	30
ptstin	ds.w	30
intout	ds.w	45
ptstout	ds.w	12
	endm
	
opta	macro
	
	opt	o+
	opt	a+
	opt	ow-
	
	endm

mulu_tab	macro	

tmp	set	0
	rept	\2
	dc.\0	tmp*\1
tmp	set	tmp+1
	endr
	endm

mulu_tab_l	macro	

tmp	set	0
	rept	\2
	dc.l	tmp*\1
tmp	set	tmp+1
	endr
	endm

dots_tab	macro
dots
tmp	set	$8000
	rept	16
	dc.w	tmp
tmp	set	tmp/2
	endr
	endm

plot	macro
	movem.l	a2-a5/d0-d2,-(sp)
	lea	mulu,a2
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	lea	dots,a4
	add.w	d2,d2
	move.w	(a4,d2),d2
	or.w	d2,\4*2(a5)
	movem.l	(sp)+,a2-a5/d0-d2
	endm

xplot	macro
	movem.l	a2-a5/d0-d2,-(sp)
	lea	mulu,a2
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	lea	dots,a4
	add.w	d2,d2
	move.w	(a4,d2),d2
	eor.w	d2,\4*2(a5)
	movem.l	(sp)+,a2-a5/d0-d2
	endm

eplot	macro
	movem.l	a2-a5/d0-d2,-(sp)
	lea	mulu,a2
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	lea	dots,a4
	add.w	d2,d2
	move.w	(a4,d2),d2
	not	d2
	and.w	d2,\4*2(a5)
	movem.l	(sp)+,a2-a5/d0-d2
	endm

sluta	macro
	medres
	clr.w	-(sp)
	trap	#1
	endm
	
picmove	macro
	movem.l	a0-a1/d0,-(sp)
	move.l	\1,a0
	move.l	\2,a1
	move.w	#7999,d0
loop\@	move.l	(a0)+,(a1)+
	dbra	d0,loop\@
	movem.l	(sp)+,a0-a1/d0
	endm

fastcopy	macro
	movem.l	a0-a1/d0,-(sp)
	move.l	\1,a0
	move.l	\2,a1
	move.w	#\3/4-1,d0
loop\@	move.l	(a0)+,(a1)+
	dbra	d0,loop\@
	ifne	\3-(\3/4)*4=0
	moveq	#\3-(\3/4)*4-1,d0
loop2\@	move.b	(a0)+,(a1)+
	dbra	d0,loop2\@
	endc
	movem.l	(sp)+,a0-a1/d0
	endm
	
copy	macro
	movem.l	a0-a1/d0,-(sp)
	move.l	\1,a0
	move.l	\2,a1
	move.l	#\3,d0
loop\@	move.b	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	loop\@
	movem.l	(sp)+,a0-a1/d0
	endm
	
	
alert	macro
	move.w	#52,control
	move.w	#1,control+2
	move.w	#1,control+4
	move.w	#1,control+6
	move.w	#0,control+8
	move.w	#\4,int_in
	move.l	#set_alert\@,addr_in
	move.l	#aes_pb,d1
	move.w	#200,d0
	trap	#2
	move.w	int_out,d0
	bra.w	klart\@
	
set_alert\@	dc.b	'[\1]'
	dc.b	'[\2]'
	dc.b	'[\3]'
	dc.b	0
	even
klart\@
	endm
	
fileselect	macro
	movem.l	d1/d7/a0-1,-(sp)
	move.w	#90,control
	move.w	#0,control+2
	move.w	#2,control+4
	move.w	#2,control+6
	move.w	#0,control+8
	move.l	#set_file1\@,addr_in
	move.l	#set_file2\@,addr_in+4
	move.l	#aes_pb,d1
	move.w	#200,d0
	trap	#2
	move.w	int_out+2,d0
	beq.w	klart\@
	move.l	\3,a0
	lea	set_file1\@,a1
	move.w	#200,d7
loop\@	move.b	(a1)+,(a0)+
	cmp.b	#'*',(a1)
	dbeq	d7,loop\@
	lea	set_file2\@,a1
	move.w	#200,d7
loop2\@	move.b	(a1)+,(a0)+
	dbeq	d7,loop2\@
	bra.w	klart\@

set_file1\@	dc.b	'\1',0
	dcb.l	50,0
set_file2\@	dc.b	'\2',0
	dcb.l	50,0
	even
klart\@	
	movem.l	(sp)+,d1/d7/a0-1
	endm
	
rsc_load	macro
	move.w	#110,control
	move.w	#0,control+2
	move.w	#1,control+4
	move.w	#1,control+6
	move.w	#0,control+8
	move.l	#rsc_name\@,addr_in
	move.l	#aes_pb,d1
	move.w	#200,d0
	trap	#2
	move.w	int_out,d0
	move.l	global+10,a0
	bra.w	klart\@

rsc_name\@	dc.b	'\1',0
	even
klart\@	
	endm

char	macro
	move.w	\1,-(sp)
	move.w	#2,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp
	endm

pr_esc	macro
	move.w	#$1b,-(sp)
	move.w	#2,-(sp)
	move.w	#3,-(sp)
	trap	#13
	move.w	#'\1',-(sp)
	move.w	#2,-(sp)
	move.w	#3,-(sp)
	trap	#13
	lea	12(sp),sp
	endm

wait_key	macro
	move.w	#8,-(sp)
	trap	#1
	addq.l	#2,sp
	endm
	
wait_keys	macro
ch_l\@
	cmp.b	#\1,$fffffc02.w
	bne.s	ch_l\@
	endm

hexdecasc	macro

	movem.l	a0/d0-d4,-(sp)

	move.l	\1,a0
	add.l	#6,a0
	moveq	#0,d0	
	move.w	\2,d0
	move.w	d0,d1
	moveq	#2,d4
loop\@
	divu	#100,d1
	swap	d1
	move.w	d1,d0
	lsr.l	#8,d1
	lsr.l	#8,d1
	move.l	d0,d2
	divu	#10,d2
	move.w	d2,d3
	swap	d2
	move.w	d2,d0
	add.w	#$30,d0
	add.w	#$30,d3
	move.b	d0,-(a0)
	move.b	d3,-(a0)
	dbra	d4,loop\@
	
	movem.l	(sp)+,a0/d0-d4
	
	endm

color	macro
	ifne	\2
	move.w	#\2,$ffff8240+(\1*2).w
	else
	clr.w	$ffff8240+(\1*2).w
	endc
	endm

get_palette	macro

	movem.l	d0-7/a0-1,-(sp)
	move.l	\1,a0
	lea	$ffff8240.w,a1
	movem.l	(a0)+,d0-7
	movem.l	d0-7,(a1)
	movem.l	(sp)+,d0-7/a0-1
	endm
	
mem_reserve	macro
	movem.l	d1/a0-1,-(sp)
	move.l	\1,-(sp)
	move.w	#72,-(sp)
	trap	#1
	addq.l	#6,sp
	movem.l	(sp)+,d1/a0-1
	endm

pause	macro
	move.l	d0,-(sp)
	move.w	#\1,d0
loop\@
	dbra	d0,loop\@
	move.l	(sp)+,d0
	endm	
	
slg	macro
	clr.w	-(sp)
	move.l	\1,-(sp)
	move.l	\2,-(sp)
	move.w	#5,-(sp)
	trap	#14
	lea	$c(sp),sp
	endm

smed	macro
	move.w	#1,-(sp)
	move.l	\1,-(sp)
	move.l	\2,-(sp)
	move.w	#5,-(sp)
	trap	#14
	lea	$c(sp),sp
	endm

point	macro

	movem.l	a2-a5/d1-d3,-(sp)
	
	lea	mulu,a2
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	eor.w	#15,d2
	
*	lea	dots,a4
*	add.w	d2,d2
*	move.w	(a4,d2),d2

	move.l	(a5),d1
	move.l	4(a5),d3
	lsr.l	d2,d1
	lsr.l	d2,d3
	moveq	#0,d0

	swap	d1
	and.w	#1,d1
	beq	not1\@
	addq.w	#1,d0
not1\@
	swap	d1
	and.w	#1,d1
	beq	not2\@
	addq.w	#2,d0
not2\@
	swap	d3
	and.w	#1,d3
	beq	not3\@
	addq.w	#4,d0
not3\@
	swap	d3
	and.w	#1,d3
	beq	not4\@
	addq.w	#8,d0
not4\@
	movem.l	(sp)+,a2-a5/d1-d3
	
	endm	
	
scrn	macro

scrn	
tmp	set	0
	
	rept	20
	
	dc.w	tmp,$8000,tmp,$4000,tmp,$2000,tmp,$1000
	dc.w	tmp,$800,tmp,$400,tmp,$200,tmp,$100
	dc.w	tmp,$80,tmp,$40,tmp,$20,tmp,$10
	dc.w	tmp,$8,tmp,$4,tmp,$2,tmp,$1
	
tmp	set	tmp+8
	
	endr

	endm
	
pset	macro
	movem.l	a2-5/d0-4,-(sp)
	move.w	\4,d3
	ext.l	d3
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	lea	mulu,a2
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	lea	dots,a4
	add.w	d2,d2
	move.w	(a4,d2),d2
	move.w	d2,d4
	not.w	d4
	and.w	d4,(a5)
	and.w	d4,2(a5)
	and.w	d4,4(a5)
	and.w	d4,6(a5)
	btst.l	#0,d3
	beq.s	e0\@
	or.w	d2,(a5)
e0\@	btst.l	#1,d3
	beq.s	e1\@
	or.w	d2,2(a5)
e1\@	btst.l	#2,d3
	beq.s	e2\@
	or.w	d2,4(a5)
e2\@	btst.l	#3,d3
	beq.s	e3\@
	or.w	d2,6(a5)
e3\@	movem.l	(sp)+,a2-5/d0-4
	endm

ppset	macro

	movem.l	a0-3/d0-7,-(sp)
	
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a1
	lea	mulu,a0
	add.w	d0,d0
	move.w	(a0,d0),d0		
	add.w	d0,a1
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a1
	and.w	#$f,d2
	eor.w	#15,d2
	move.l	(a1),d1
	move.l	4(a1),d3
	lsr.l	d2,d1
	lsr.l	d2,d3
	
	move.w	\5,d4
	move.w	\4,d5
	move.l	\6,a2
	add.w	d4,d4
	move.w	(a0,d4),d4		
	add.w	d4,a2
	move.w	d5,d6
	and.w	#$fff0,d5
	asr.w	#1,d5
	add.w	d5,a2
	and.w	#$f,d6
	lea	dots,a3
	add.w	d6,d6
	move.w	(a3,d6),d6
	move.w	d6,d7
	not.w	d7

	and.w	d7,(a2)
	and.w	d7,2(a2)
	and.w	d7,4(a2)
	and.w	d7,6(a2)

	swap	d1
	and.w	#1,d1
	beq	not1\@
	or.w	d6,(a2)
not1\@
	swap	d1
	and.w	#1,d1
	beq	not2\@
	or.w	d6,2(a2)
not2\@
	swap	d3
	and.w	#1,d3
	beq	not3\@
	or.w	d6,4(a2)
not3\@
	swap	d3
	and.w	#1,d3
	beq	not4\@
	or.w	d6,6(a2)
not4\@
	movem.l	(sp)+,a0-3/d0-7
	
	endm	


clrpoint	macro
	movem.l	a2-5/d0-3,-(sp)
	lea	mulu,a2
	move.w	\2,d0
	move.w	\1,d1
	move.l	\3,a5
	add.w	d0,d0
	move.w	(a2,d0),d0		
	add.w	d0,a5
	move.w	d1,d2
	and.w	#$fff0,d1
	asr.w	#1,d1
	add.w	d1,a5
	and.w	#$f,d2
	lea	dots,a4
	add.w	d2,d2
	move.w	(a4,d2),d2
	move.w	d2,d3
	not.w	d3
	and.w	d3,(a5)
	and.w	d3,2(a5)
	and.w	d3,4(a5)
	and.w	d3,6(a5)
	movem.l	(sp)+,a2-5/d0-3
	endm
	
mod	macro
	move.w	d1,-(sp)
	move.l	\1,d1
	divu.w	#\2,d1
	swap	d1
	move.w	d1,\1
	move.w	(sp)+,d1
	endm

load	macro
	movem.l	d0-1/a0,-(sp)
	move.w	#2,-(sp)
	move.l	\1,-(sp)
	move.w	#$3d,-(sp)
	trap	#1
	addq.l	#8,sp
	
	move.w	d0,d1
	bmi.s	.f\@
	
	move.l	\2,-(sp)
	move.l	\3,-(sp)
	move.w	d1,-(sp)
	move.w	#$3f,-(sp)
	trap	#1
	lea	$c(sp),sp
	
	cmp.l	\3,d0
	bne.s	.f\@
	
	move.w	d1,-(sp)
	move.w	#$3e,-(sp)
	trap	#1
	addq.l	#4,sp
	
.f\@	movem.l	(sp)+,d0-1/a0
	endm

save	macro
	movem.l	d0-1/a0,-(sp)
	clr.w	-(sp)
	move.l	\1,-(sp)
	move.w	#$3c,-(sp)
	trap	#1
	addq.l	#8,sp
	
	move.w	d0,d1
	bmi.s	.f\@
	
	move.l	\2,-(sp)
	move.l	\3,-(sp)
	move.w	d1,-(sp)
	move.w	#$40,-(sp)
	trap	#1
	lea	$c(sp),sp
	
	cmp.l	\3,d0
	bne.s	.f\@
	
	move.w	d1,-(sp)
	move.w	#$3e,-(sp)
	trap	#1
	addq.l	#4,sp

.f\@	movem.l	(sp)+,d0-1/a0
	endm

get_dta	macro
	movem.l	d1/a1,-(sp)
	move.w	#47,-(sp)
	trap	#1
	addq.w	#2,sp
	movem.l	(sp)+,d1/a1
	endm

exist	macro
	movem.l	d1/a1,-(sp)
	move.w	#%01100,-(sp)	
	move.l	\1,-(sp)
	move.w	#78,-(sp)
	trap	#1
	addq.w	#8,sp
	movem.l	(sp)+,d1/a1
	endm
		
s50hz	macro
	bset	#1,$ffff820a.w
	endm

s60hz	macro
	bclr	#1,$ffff820a.w
	endm
	
changehz	macro
	bchg	#1,$ffff820a.w
	endm
	
inc	macro
	addq.\0	#1,\1
	endm

dec	macro
	subq.\0	#1,\1
	endm
	
dma_init	macro
	move.l	\1,-(sp)
	move.b	1(sp),$ffff8903.w
	move.b	2(sp),$ffff8905.w
	move.b	3(sp),$ffff8907.w
	move.l	\2,(sp)
	move.b	1(sp),$ffff890f.w
	move.b	2(sp),$ffff8911.w
	move.b	3(sp),$ffff8913.w
	addq.w	#4,sp
	move.b	\3,$ffff8921.w
	endm
	
dma_setm	macro
	move.l	d0,-(sp)
	move.w	\1,d0
	asr.w	#1,d0
	add.w	#40,d0
	move.w	#%11111111111,$ffff8924.w	
	or.w	#%10011000000,d0
	move.w	d0,$ffff8922.w
	move.l	(sp)+,d0	
	endm


dma_setl	macro
	move.l	d0,-(sp)
	move.w	\1,d0
	asr.w	#1,d0
	add.w	#20,d0
	move.w	#%11111011111,$ffff8924.w	
	or.w	#%10101000000,d0
	move.w	d0,$ffff8922.w
	move.l	(sp)+,d0	
	endm

dma_setr	macro
	move.l	d0,-(sp)
	move.w	\1,d0
	asr.w	#1,d0
	add.w	#20,d0
	move.w	#%11111011111,$ffff8924.w	
	or.w	#%10100000000,d0
	move.w	d0,$ffff8922.w
	move.l	(sp)+,d0	
	endm

dma_sett	macro
	move.l	d0,-(sp)
	move.w	\1,d0
	asr.w	#1,d0
	add.w	#6,d0
	move.w	#%11111001111,$ffff8924.w	
	or.w	#%10010000000,d0
	move.w	d0,$ffff8922.w
	move.l	(sp)+,d0	
	endm

dma_setb	macro
	move.l	d0,-(sp)
	move.w	\1,d0
	asr.w	#1,d0
	add.w	#6,d0
	move.w	#%11111001111,$ffff8924.w	
	or.w	#%10001000000,d0
	move.w	d0,$ffff8922.w
	move.l	(sp)+,d0	
	endm

mute_on	macro
	move.w	#%11111000011,$ffff8924.w	
	move.w	#%10000000000,$ffff8922.w
	endm

mute_off	macro
	move.w	#%11111000011,$ffff8924.w	
	move.w	#%10000000001,$ffff8922.w
	endm

ldbra	macro
	dec.l	\1
	bne.\0	\2
	endm
	
hkk	macro
	jsr.\0	\1
	endm
	
skk	macro
	bsr.\0	\1
	endm
	
clrmem	macro
	movem.l	d0/a0-a1,-(sp)
	move.l	/1,a0
	move.w	/2,d0
loop\@
	move.l	(a0)+,a1
	clr.w	(a1)+
	dbra	d0,loop\@
	movem.l	(sp)+,d0/a0-a1
	endm

grayscale	macro
	dc.w	$000,$888,$111,$999,$222,$aaa,$333,$bbb
	dc.w	$444,$ccc,$555,$ddd,$666,$eee,$777,$fff
	endm

redscale	macro
	dc.w	$000,$800,$100,$900,$200,$a00,$300,$b00
	dc.w	$400,$c00,$500,$d00,$600,$e00,$700,$f00
	endm

greenscale	macro
	dc.w	$000,$080,$010,$090,$020,$0a0,$030,$0b0
	dc.w	$040,$0c0,$050,$0d0,$060,$0e0,$070,$0f0
	endm

bluescale	macro
	dc.w	$000,$008,$001,$009,$002,$00a,$003,$00b
	dc.w	$004,$00c,$005,$00d,$006,$00e,$007,$00f
	endm

standard	macro
	dc.w	$fff,$f00,$0f0,$ff0,$00f,$f0f,$0ff,$555
	dc.w	$333,$f33,$3f3,$ff3,$33f,$f3f,$3ff,$000
	endm

pr_num	macro
	
x\@	=	\2
y\@	=	\3
antal\@	=	\4
tmp\@	=	\6	*bitplan

	movem.l	a0-a5/d0-d4/d6,-(sp)

	lea	num,a0
	lea	table,a2
	lea	mulu,a4
	move.l	\5,a1
	
	move.l	\1,d0

	moveq	#antal\@-1,d6
loop\@
	move.w	d6,d2
	move.l	d0,d1

	add.w	d2,d2
	add.w	d2,d2

	and.l	(a2,d2),d1
	lsr.l	d2,d1
	lsl.l	#3,d1
	move.l	a0,a5
	add.l	d1,a5	
	move.l	a1,a3
	move.w	#y\@,d2
	lsl.w	#4,d2
	move.w	(a4,d2),d2
	add.w	d2,a3
	move.w	#x\@,d2
	
	move.w	d6,d4
	move.w	#antal\@-1,d3
	sub.w	d4,d3
	add.w	d3,d2
	
	move.w	d2,d3
	and.w	#1,d3
	and.w	#$fffe,d2
	lsl.w	#2,d2
	add.w	d2,a3
	add.w	d3,a3	
	
	move.b	(a5)+,160*0+tmp\@*2(a3)
	move.b	(a5)+,160*1+tmp\@*2(a3)
	move.b	(a5)+,160*2+tmp\@*2(a3)
	move.b	(a5)+,160*3+tmp\@*2(a3)
	move.b	(a5)+,160*4+tmp\@*2(a3)
	move.b	(a5)+,160*5+tmp\@*2(a3)
	move.b	(a5)+,160*6+tmp\@*2(a3)
	move.b	(a5)+,160*7+tmp\@*2(a3)
	
	dbra	d6,loop\@
	
	movem.l	(sp)+,a0-a5/d0-d4/d6

	endm

pr_num_tab	macro
table	
	dc.l	$0000000f
	dc.l	$000000f0
	dc.l	$00000f00
	dc.l	$0000f000
	dc.l	$000f0000
	dc.l	$00f00000
	dc.l	$0f000000
	dc.l	$f0000000

	endm

pr_num_tab2	macro
num
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00011000
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%00011110
	dc.b	%00000110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%00000110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%00000000

	dc.b	%01111100
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111100
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01111100
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01100000
	dc.b	%01100000
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111100
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01111100
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01111000
	dc.b	%01100000
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00000000

	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01100000
	dc.b	%01111000
	dc.b	%01100000
	dc.b	%01100000
	dc.b	%01100000
	dc.b	%00000000

	endm

box	macro
	
	movem.l	d2-6/a0,-(sp)
	
	move.w	\1,d2
	move.w	\2,d3
	move.w	\3,d4
	move.w	\4,d5
	move.l	\5,a0
	
	move.w	d2,d6
loop\@
	plot	d6,d3,a0,\6
	plot	d6,d5,a0,\6
	
	inc.w	d6
	cmp.w	d6,d4
	bhi	loop\@
	
	move.w	d3,d6
loop2\@
	plot	d2,d6,a0,\6
	plot	d4,d6,a0,\6
	
	inc.w	d6
	cmp.w	d6,d5
	bhi	loop2\@
	
	movem.l	(sp)+,d2-6/a0
	
	endm
	
setscreen	macro	logpek,physpek,mode

	movem.l	d0-a6,-(sp)
	
	move.w	\3,-(sp)
	move.w	#3,-(sp)
	move.l	\2,-(sp)
	move.l	\1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#14,sp
	
	movem.l	(sp)+,d0-a6
	
	endm

getphys	macro

	movem.l	d1-a6,-(sp)
	
	move.w	#2,-(sp)
	trap	#14
	addq.l	#2,sp
	
	movem.l	(sp)+,d1-a6
	
	endm

getlog	macro

	movem.l	d1-a6,-(sp)
	
	move.w	#3,-(sp)
	trap	#14
	addq.l	#2,sp
	
	movem.l	(sp)+,d1-a6
	
	endm

getres	macro

	movem.l	d1-a6,-(sp)
	
	move.w	#-1,-(sp)
	move.w	#88,-(sp)
	trap	#14
	addq.l	#4,sp
	
	movem.l	(sp)+,d1-a6
	
	endm
	
abs	macro
	move.\0	d0,-(sp)
	move.\0	\1,d0

	tst.\0	d0
	bpl	ejb\@
	neg.\0	d0
ejb\@
	move.\0	d0,\1
	move.\0	(sp)+,d0
	endm

stdinit	macro

	movem.l	d0-a6,-(sp)
	
	getphys
	move.l	d0,save_phys
	getlog
	move.l	d0,save_log
	getres
	move.w	d0,save_res
	
	setscreen	\1,\2,\3
	
	movem.l	(sp)+,d0-a6
	
	endm

stdexit	macro

	setscreen	save_log,save_phys,save_res

	clr.w	-(sp)
	trap	#1
	
	endm
	
stdbss	macro

save_phys	ds.l	1
save_log	ds.l	1
save_res	ds.w	1

	endm

qpoint_f	macro

	movem.l	d1-a6,-(sp)
	
	lea	mulu,a1
	move.w	\1,d0
	move.w	\2,d1
	move.l	\3,a0
	
	add.w	(a1,d1.w*2),a0
	move.w	d0,d1
	and.w	#$fff0,d0
	lsr.w	d0
	add.w	d0,a0
	and.w	#$f,d1
	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	
	movem.w	(a0),d2-d5
	roxl	d1,d5
	roxl	d0
	roxl	d1,d4
	roxl	d0
	roxl	d1,d3
	roxl	d0
	roxl	d1,d2
	roxl	d0
	
	movem.l	(sp)+,d1-a6
	
	endm

pi12tru	macro

	movem.l	d0-a6,-(sp)
	
	move.l	\1,a0
	move.l	\2,a1
	move.l	\3,a2
	
	move.w	#199,d6
loop\@
	move.w	#319,d7
loop2\@
	qpoint_f	d7,d6,a0
	
	move.w	(a2,d0.w*2),d0
	
	move.w	d0,d1
	move.w	d0,d2

	and.w	#$700,d0
	lsl.w	#5,d0
	and.w	#$70,d1
	lsl.w	#4,d1
	and.w	#$7,d2
	lsl.w	#2,d2
	or.w	d1,d0
	or.w	d2,d0
	
	move.w	d0,(a1)+
	
	dbra	d7,loop2\@
	
	dbra	d6,loop\@

	movem.l	(sp)+,d0-a6
	
	endm



bload	macro

	move.w	#0,-(sp)
	pea	\1
	move.w	#$3d,-(sp)
	trap	#1
	addq.l	#8,sp
	move.l	d0,d6
	bmi	error\@

	move.w	#2,-(sp)
	move.w	d6,-(sp)
	move.l	#0,-(sp)
	move.w	#$42,-(sp)
	trap	#1
	lea	10(sp),sp
	move.l	d0,d5
	bmi	error\@

	move.w	#0,-(sp)
	move.w	d6,-(sp)
	move.l	#0,-(sp)
	move.w	#$42,-(sp)
	trap	#1
	lea	10(sp),sp

	pea	\2
	move.l	d5,-(sp)
	move.w	d6,-(sp)
	move.w	#$3f,-(sp)
	trap	#1
	lea	12(sp),sp
	cmp.l	d0,d5
	bne	error\@

	move.w	d6,-(sp)
	move.w	#$3e,-(sp)
	trap	#1
	addq.l	#4,sp
	tst.l	d0
	bmi	error\@

	moveq	#0,d0
	bra	end\@
error\@
	moveq	#-1,d0
end\@
	endm

bsave	macro

	move.w	#0,-(sp)
	pea	\1
	move.w	#$3c,-(sp)
	trap	#1
	addq.l	#8,sp
	move.l	d0,d6
	bmi	error\@

	move.l	#\3,d5

	pea	\2
	move.l	d5,-(sp)
	move.w	d6,-(sp)
	move.w	#$40,-(sp)
	trap	#1
	lea	12(sp),sp
	cmp.l	d0,d5
	bne	error\@

	move.w	d6,-(sp)
	move.w	#$3e,-(sp)
	trap	#1
	addq.l	#4,sp
	tst.l	d0
	bmi	error\@

	moveq	#0,d0
	bra	end\@
error\@
	moveq	#-1,d0
end\@
	endm
	
sload	macro

	move.w	#0,-(sp)
	pea	\1
	move.w	#$3d,-(sp)
	trap	#1
	addq.l	#8,sp
	move.l	d0,d6
	bmi	error\@

	move.w	#0,-(sp)
	move.w	d6,-(sp)
	move.l	#\3,-(sp)
	move.w	#$42,-(sp)
	trap	#1
	lea	10(sp),sp
	move.l	d0,d5
	bmi	error\@

	pea	\2
	move.l	#\4,-(sp)
	move.w	d6,-(sp)
	move.w	#$3f,-(sp)
	trap	#1
	lea	12(sp),sp
	cmp.l	d0,d5
	bne	error\@

	move.w	d6,-(sp)
	move.w	#$3e,-(sp)
	trap	#1
	addq.l	#4,sp
	tst.l	d0
	bmi	error\@

	moveq	#0,d0
	bra	end\@
error\@
	moveq	#-1,d0
end\@
	endm
	
ste2fpal	macro
	movem.l	d0-3/a0-1,-(sp)

	move.l	\1,a0
	move.l	\2,a1
	move.w	\3,d0
	dec.w	d0
loop\@
	move.w	(a0)+,d1
	move.w	d1,d2
	lsl.w	#1,d1	
	lsr.w	#3,d2
	and.w	#$eee,d1
	and.w	#$111,d2
	add.w	d2,d1
	move.w	d1,d2	
	move.w	d1,d3
	lsl.w	#4,d1	
	lsr.w	#4,d3
	and.w	#$f0,d2	
	and.w	#$f0,d3
	move.b	d3,(a1)+	
	move.b	d2,(a1)+	
	move.b	#0,(a1)+	
	move.b	d1,(a1)+
	dbra	d0,loop\@
	
	movem.l	(sp)+,d0-3/a0-1
	endm
		
bmove	macro
	movem.l	d0/a0-1,-(sp)
	move.l	\1,a0
	move.l	\2,a1
	move.l	\3,d0
loop\@
	move.\0	(a0)+,(a1)+
	ldbra	d0,loop\@

	movem.l	(sp)+,d0/a0-1
	endm
	
**************
* indata L: m_buffer  (14 bytes)
exit_mouse	macro
	movem.l	a0-1,-(sp)
	move.l	\1,a1
	move.l	6(a1),a0	terstlla musvektorn.
	move.l	10(a1),(a0)
	movem.l	(sp)+,a0-1
	endm
**************
* indata L: m_buffer  (14 bytes inehller w:x w:y w:k  l:musvektor l:musrutin)
init_mouse	macro
	movem.l	d0/a0-1,-(sp)
	move.w	#34,-(sp)	Kbdvec
	trap	#14
	lea	2(sp),sp
	add.l	#16,d0
	move.l	\1,a0
	move.l	d0,6(a0)	Spara musvektorn & installera egna
	move.l	d0,a1
	move.l	(a1),10(a0)	
	move.l	#mouse_r\@,(a1)
	move.l	#0,(a0)
	bra	exit\@

**************
* Ny vector
mouse_r\@	movem.l	d0-a6,-(sp)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.l	\1,a0
	ext.w	d1
	ext.w	d2
	add.w	d1,(a0)
	add.w	d2,2(a0)
	and.w	#3,d0
	move.w	d0,4(a0)
	movem.l	(sp)+,d0-a6
	rts
**************

exit\@	movem.l	(sp)+,d0/a0-1
	endm
	

**************
	
sendchar	macro
wait\@	btst.b	#1,$fffffc00.w
	bne	wait\@
	move.b	\1,$fffffc02.w
	endm
	
getchar	macro
	move.b	$fffffc02.w,\1
	endm
	
	