
{ Berlin, 10.08.93                                                          }
{ Example of a box-run-prg, written by dl8hbs                               }

{ The following program is an example for a tiny box-run-prg... When        }
{ writing such a program, assure that the values found in the cmd-args      }
{ are valid! The validity check is performed in the main routine of this    }
{ program, it is very! important to check the adress, because a user is     }
{ allowed to create his own command parameters. This is nesessary for       }
{ calling programs that were not especially dedicated for the use with DP.  }
{ Usually, when DP-BOX is executing a program, the commandline contains the }
{ following parameters: 'CALLSIGN ADRESS_OF_BOXPARMS' and all parameters the}
{ user typed. If the first user-given parameter is a '-', the commandline   }
{ only contains the parameters defined by the user, without the '-'.        }

{ Imagine what would happen if a hacker types: 'RUNTEST - DL1ZZ 8756751'    }
{ and there would not be a parameter-check... right, a watchdog-reset after }
{ 45 minutes...                                                             }

{ If selected in the parameter-dialog of DP, the watchdog is active, time-  }
{ out set to 45 minutes. This should be long enough for harddisk-check-     }
{ programs and others. Assure that your program falls back to DP within this}
{ time - if not, a RESET is created.                                        }

{ You have access to all listed boxparms, and you may alter them. After     }
{ execution DP uses the altered parms. All date/times are in DOS-Format.    }
{ All STRINGS are PASCAL-strings, the length in the first byte, no 0 at the }
{ end. When manipulating such a string, be aware of using C-format hi.      }

{ To install a box-run-prg, simply put an entry in COMMANDS.BOX             }
{ If it should run with full GEM-environment, set the command number to 99, }
{ if you won't access to the screen, set the command number to 98.          }
{ You may install as many run-prgs as you like.                             }

{ See also APPENDIX C of the documentation                                  }

program cmdline;

type
    boxparmpointer= ^boxparms;
    boxparms    =   record
                        call    :   string[6];
                        mybbs   :   string[40];
                        language:   string[3];
                        name    :   string[15];
                        board   :   string[8];
                        reply_board:string[8];
                        reply_call: string[6];
                        reply_box:  string[40];
                        reply_mbx:  string[40];
                        reply_title:string[80];
                        password:   string[80];
                        lastdate:   integer; 
                        lasttime:   integer; 
                        level   :   integer; 
                        logindate:  integer; 
                        logintime:  integer; 
                        lasttouch:  integer; 
                        s_e_ok  :   boolean; 
                        hidden  :   boolean; 
                        console :   boolean; 
                        sysop   :   boolean; 
                        fbbmode :   boolean; 
                        cputime :   long_integer;
                        txbytes :   long_integer;
                        rxbytes :   long_integer;
                        tncchan :   integer;
                    end;




{ Subroutine for MAIN, checks if the string contains a numerical value      }

function is_numerical(s:string):boolean;
var x   :   integer;
begin
    if length(s) = 0 then is_numerical := false
    else begin
        is_numerical := true;
        for x := 1 to length(s) do 
            if not (s[x] in ['0'..'9']) then 
                is_numerical := false;
    end;
end;



procedure main;
const
    max_mem =   3000000;
var outf    :   text;
    cs      :   string[255];
    h,call1 :   string;
    x       :   integer;
    data    :   boxparmpointer;
    adress  :   long_integer;

    { assigns an adress to a pointer, compiler-dependent    }
    
    function ptr(adress:long_integer):boxparmpointer;
    external;

begin
    { get the first argument (callsign) }
    cmd_getarg(1,call1);
    
    { get the second argument (adress)  }
    cmd_getarg(2,h);
    
    { check the validity of the adress  }
    if is_numerical(h) then begin
    
    { convert the string to a long_integer-variable, compiler-dependent }
        readv(h,adress);
        
    { check validity of the adress      }
    { odd adresses are odd...           }
        if not(odd(adress)) 
        
    { don't manipulate in the system's ram  }
           and (adress > 500000)
           
    { check if adress is too high... instead of a constant value,   }
    { check for memtop                                              }
           and (adress < max_mem)
           
    { all ok, no hack   }
        then begin
        
    { assign the adress to the pointer  }
            data    := ptr(adress);
            
    { check if callsign in commandline is   }
    { same with callsign in the structure   }
            if data^.call = call1 then with data^ do begin
            
    { ok, all valid...  }
    
    { in this example, all found userparms (except the password)    }
    { are written in the file OUT.TXT, which is sent by DP after    }
    { fallback                                                      }
    
            { reread the commandline to display it                  }
            { all commandline operations have to take place before  }
            { manipulating the file system, the DTA points directly }
            { into the basepage of our process (thank you Atari)    }
            
                cs  := '';
                for x := 1 to cmd_args do begin
                    cmd_getarg(x,h);
                    cs  := concat(cs,' ',h);
                end;

                rewrite(outf,'OUT.TXT');
                
                writeln(outf,'the commandline contains the following arguments:');
                writeln(outf,cs);
                
                writeln(outf,'actual parms of ',call,':');
                writeln(outf,'mybbs       : ',mybbs);
                writeln(outf,'language    : ',language);
                writeln(outf,'name        : ',name);
                writeln(outf,'board       : ',board);
                writeln(outf,'reply_board : ',reply_board);
                writeln(outf,'reply_call  : ',reply_call);
                writeln(outf,'reply_box   : ',reply_box);
                writeln(outf,'reply_mbx   : ',reply_mbx);
                writeln(outf,'reply_title : ',reply_title);
                writeln(outf,'lastdate    : ',lastdate);
                writeln(outf,'lasttime    : ',lasttime);
                writeln(outf,'level       : ',level);
                writeln(outf,'logindate   : ',logindate);
                writeln(outf,'logintime   : ',logintime);
                writeln(outf,'lasttouch   : ',lasttouch);
                writeln(outf,'send/erase  : ',s_e_ok);
                writeln(outf,'hidden      : ',hidden);
                writeln(outf,'console     : ',console);
                writeln(outf,'sysop       : ',sysop);
                writeln(outf,'fbbmode     : ',fbbmode);
                writeln(outf,'cputime     : ',cputime/200:1:2,' sec');
                writeln(outf,'txbytes     : ',txbytes);
                writeln(outf,'rxbytes     : ',rxbytes);
                writeln(outf,'tncchan     : ',tncchan);
                
                close(outf);

            end;
        end;
    end;
end;

begin
    main;
end.

