/*
** PackIt - a simple shell for tar, zip and lha
**
** This piece of useful, but badly written software is published
** without any license whatsoever. Do what you like with it.
**
** Sorry for the Norwegian variable-names, but I didn't intend to release
** it when I started it. It started out as a tiny hack with a very
** specific purpose and evolved into a slightly bigger hack which
** might be of use for others. It's inspired by Kellis' tarit, which
** was a bit limited to my taste.
**
** To use it simply drag one or more folders or files to PackIt, or put
** it in Thing's SendTo-group. A fileselector will now popup and tell you
** what to do. If you've only selected tar, tar.gz, tgz, zip, lha or lzh
** archives you can now select which folder to unpack these to. Otherwise
** you'll have to select which archive to store the files/folders in.
** PackIt will run the appropriate packer depending on the extension of
** this archive.
**
** PackIt will most likely only work under MiNT, and the following files
** should be present on your system:
** /bin/tar
** /bin/gzip
** /bin/lha
** /bin/zip
** /bin/unzip
** /bin/sh (atleast I think MiNT-libs implementation of system() requires
**          this).
**
** NB! As I said, this hack is badly written, I wouldn't have written it
** like this if I knew that it would turn out this useful. Don't follow
** my example, spend some time digging out documentation instead of
** hacking together poor replacements for stdlib-stuff...
**
** Suggestions for improvement:
** 1. Check whether an archive exists or not, and ask the user if [s]he
**    wants to overwrite or add to it.
** 2. Modify it to use Pexec() instead of system(), this should make it
**    a bit more efficient and TOS/MagiC-friendly.
** 3. Clean it up and integrate it in Thing :-)
**
**  Jo Even Skarstein, 2/5-2000
**   joska@nvg.org
**   http://home.nvg.org/~joska/
**   http://atari.nvg.org/
*/

#ifndef TRUE
#define FALSE 0
#define TRUE 1
#endif

#include <stdio.h>
#include <gem.h>
#include <mintbind.h>

char *dos2unix(char *inn);
int sjekkFilSuffix(char *filnamn, char *suffix, int casesensitive);
int cwd(char *dir);

char pack_arg[5000], pack_cmd[5000], archive[256], sti[256], fil[256], cd[256];

/*
** main
*/
int main(int argc, char **argv)
{
	int err = 0, ok = FALSE;
	char tmp[256];

	Pdomain(1);
	
	/*
	** Don't do anything if there's no arguments
	*/
	if (argc > 1)
	{
		int i, cut, archives_only = TRUE;

		/*
		** This is an AES-application
		*/
		if (appl_init() == -1)
		{
			printf("appl_init() failed!");
			exit();
		}

		/*
		** First we find the path to the fils(s)/folder(s).
		** NB! This is simply done by extracting the path to the *first*
		** file or folder, so dragging files/folders from different
		** directories won't work. Feel free to fix this. It's not trivial
		** though, and a bit out of scope for this small hack.
		*/
		strcpy(tmp, dos2unix(argv[1]));
		cut = strlen(tmp) - 1;
		if (tmp[cut] == '/') cut--;
		for (; tmp[cut] != '/'; cut--); cut++;
		strcpy(cd, tmp);
		cd[cut] = '\0';

		/*
		** Build a string with all files/folders without their path.
		*/
		pack_arg[0] = '\0';
		for (i = 1; i < argc; i++)
		{
			/*
			** Now that we're stepping through argv anyway we check if all
			** files are archives.
			*/
			if (!sjekkFilSuffix(argv[i], "tar", FALSE) &&
				 !sjekkFilSuffix(argv[i], "tar.gz", FALSE) &&
				 !sjekkFilSuffix(argv[i], "tgz", FALSE) &&
				 !sjekkFilSuffix(argv[i], "zip", FALSE) &&
				 !sjekkFilSuffix(argv[i], "lha", FALSE) &&
				 !sjekkFilSuffix(argv[i], "lzh", FALSE))
				{
					archives_only = FALSE;
				}

			sprintf(tmp, " '%s'", dos2unix(&(argv[i])[cut]));
			strcat(pack_arg, tmp);
		}

		/*
		** Fileselector. Needs TOS 1.04 or better.
		*/
		strcpy(sti, "u:\\tmp\\*.*");
		strcpy(fil, "");

		if (archives_only)
		{
			fsel_exinput(sti, fil, &ok, "Select folder to unpack to.");
		}
		else
		{
			fsel_exinput(sti, fil, &ok, "Select archive.");
		}

		if (ok)
		{
			int i;
			
			/*
			** Remove the mask from the path returned by the
			** fileselector.
			*/
			for (i = strlen(sti); sti[i] != '\\'; i--);
			sti[i] = '\0';

			if (archives_only)
			{
				/*
				** Unpack all archives to this path.
				*/
				char *arc;

				/*
				** Set current path
				*/
				cwd(dos2unix(sti));

				/*
				** Step through the list of archives.
				*/
				for (i = 1; i < argc; i++)
				{
					arc = argv[i];
					if (sjekkFilSuffix(arc, "tar", FALSE))
						sprintf(pack_cmd, "/bin/tar -x --force-local -f %s", arc);

					if (sjekkFilSuffix(arc, "tar.gz", FALSE) || sjekkFilSuffix(archive, "tgz", FALSE))
						sprintf(pack_cmd, "/bin/tar -x --force-local -z -f %s", arc);

					if (sjekkFilSuffix(arc, "zip", FALSE))
						sprintf(pack_cmd, "/bin/unzip -qq %s", arc);

					if (sjekkFilSuffix(arc, "lha", FALSE) || sjekkFilSuffix(arc, "lzh", FALSE))
						sprintf(pack_cmd, "/bin/lha xq %s", arc);

					system(pack_cmd);
				}				
			}
			else
			{
				/*
				** Pack files/folders to the selected archive.
				*/

				/*
				** Set current path, build a complete path/filename for the archive.
				*/
				cwd(cd);
				sprintf(archive, "%s/%s", dos2unix(sti), fil);

				/*
				** Build argument strings and call the appropriate packers
				*/
				if (sjekkFilSuffix(fil, "tar", FALSE))
				{
					sprintf(pack_cmd, "/bin/tar -c --force-local -f %s %s", archive, pack_arg);
					err = system(pack_cmd);
				}

				if (sjekkFilSuffix(fil, "tar.gz", FALSE) || sjekkFilSuffix(archive, "tgz", FALSE))
				{
					sprintf(pack_cmd, "/bin/tar -c -z --force-local -f %s %s", archive, pack_arg);
					err = system(pack_cmd);
				}

				if (sjekkFilSuffix(fil, "zip", FALSE))
				{
					sprintf(pack_cmd, "/bin/zip -q -r %s %s", archive, pack_arg);
					err = system(pack_cmd);
				}

				if (sjekkFilSuffix(fil, "lha", FALSE) || sjekkFilSuffix(archive, "lzh", FALSE))
				{
					sprintf(pack_cmd, "/bin/lha aq %s %s", archive, pack_arg);
					err = system(pack_cmd);
				}
			}
		}

		appl_exit();
	}

	return err;
}

/*
** Converts DOS-paths to unix-paths. Pathetic implementation, but
** it works.
*/
char *dos2unix(char *inn)
{
	int t;

	for (t = 0; inn[t] != '\0'; t++)
	{
		if (inn[t] == '\\')
		{
			inn[t] = '/';
		}
	}
	
	return inn;
}

/*
** Check if the file 'filnamn' has the extension 'suffix'.
*/
int sjekkFilSuffix(char *filnamn, char *suffix, int casesensitive)
{
	long lFil, lSuf;
	char fSuffix[255];
	
	lFil = strlen(filnamn);
	lSuf = strlen(suffix);
	if (lSuf >= lFil)
	{
		return FALSE;
	}

	strcpy(fSuffix, &filnamn[lFil - lSuf]);
	switch (casesensitive)
	{
		case TRUE:
			return !strcmp(fSuffix, suffix);
		case FALSE:
			return !strcmpi(fSuffix, suffix);
	}

	return FALSE;
}


/*
** Set current directory. If this directory doesn't exist, attempt
** to create it.
*/
int cwd(char *dir)
{
	long int d;
	char path[256], drive;

	strcpy(path, dir);
	for (d = 0; path[d] != '\0'; d++)
	{
		if (path[d] == '/') path[d] = '\\';
	}

	if (strlen(path) < 3)
	{
		return FALSE;
	}

	if (strlen(path) > 3 && path[strlen(path) - 1] == '\\')
	{
		path[strlen(path) - 1] = '\0';
	}
	drive = path[0];
	
	if (drive >= 'a' && drive <= 'z')
	{
		d = (int)(drive - 'a');
	}
	else
	{
		d = (int)(drive - 'A');
	}

	Dsetdrv(d);
	
	if (Dsetpath(&path[2]))
	{
		/*
		** Directory doesn't exist, attempt to create it.
		*/
		if (strlen(&path[2]) > 1)
		{
			if (Dcreate(path))
			{
				/*
				** Failed.
				*/
				return FALSE;
			}
			else
			{
				Dsetpath(&path[2]);
			}
		}
	}

	return TRUE;
}