;FalcAMP Plugin - 4/6/8 channel module player
;
;v1.0, August 29, 2001
;
;Anders Eriksson
;ae@dhs.nu
;
;final fixes by stghost 2005/04/05

		output	.plg

debug:		equ	0

def_songlength:	equ	300					;seconds
ttram_fix	equ	1	;move player down to stram

		section	text
		
		

; 4 bytes - Dummy header -----------------------------------------------------
		clr.w	-(sp)
		trap	#1

; 4 bytes - Plugin ID --------------------------------------------------------
		dc.b	'.mod'

; 2 bytes - Plugin version ---------------------------------------------------
		dc.w	$0101

; 16*4 bytes addresses to functions ------------------------------------------
		dc.l	file_info				;request file infos
		dc.l	open_file				;file infos. reserve mem and load file
		dc.l	close_file				;return mem and close file
		dc.l	install_player 				;do player installs
		dc.l	remove_player  				;the reverse of above
		dc.l	check_player  				;see if player is installed
		dc.l	start_replay   				;play music
		dc.l	stop_replay  				;stop play music
		dc.l	pause_replay				;unsupported
		dc.l	fast_forward				;usupported
		dc.l	seek_file				;unsuppoted
		dc.l	kernel					;playing status
		dc.l	time					;seconds we have played this song
		dc.l	position				;unsupported
		dc.l	setup					;loop, monomode, mfree/mxalloc addrs
		dc.l	infos					;plugin infos

; Header END -----------------------------------------------------------------

	opt	o+,ow-



; Function: file_info --------------------------------------------------------

file_info:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#file_info_text,d0
		bsr.w	print
		endc

		move.w	56+16(sp),.var	;0 = do short test only ? Otherwise fill out fileinfos too
		move.l	56+12(sp),tmpbuf	;pointer to 4096 temp buffer which can be used (not zeroed!)
		move.l	56+8(sp),fileinfo	;fileinfo buffer
		move.l	56+4(sp),filename	;filename address (nulled)

		move.l	56+12(sp),d0	;load first 1084 bytes data from file into tmpbuf
		move.l	#1084,filelength	;
		bsr.w	loader		;

		tst.l	d0		;check if loading was ok
		bne.s	.file_error	;

		;check file here

		move.l	56+12(sp),a0	;check format from tmpbuf content
		bsr.w	check_modformat
		tst.l	d0
		bne.s	.unknownformat


.fileok:		tst.w	56+16(sp)	;.var= 0, don't fill out fileinfos
		beq.s	.allok		;
		
		;fill out fileinfos here	

		move.l	56+12(sp),a0
		bsr.w	fill_fileinfo
		

.allok:		moveq.l	#0,d0		;file can be played
		bra.s	.rts		;
.unplayable:	moveq.l	#-1,d0		;we know fileformat but can't be played
		bra.s	.rts		;
.unknownformat:	moveq.l	#-2,d0		;unknown format, can't be played
		bra.s	.rts		;
.file_error:	moveq.l	#-3,d0		;we had a read error on the file

.rts:		movem.l	(sp)+,d1-a6
		rts

.var:		dc.w	1		;short test only?



; Function: open_file --------------------------------------------------------

open_file:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#file_open_text,d0
		bsr.w	print
		endc

		move.l	56+12(sp),tmpbuf			;pointer to 4096 temp buffer which can be used (not zeroed!)
		move.l	56+8(sp),fileinfo			;fileinfo buffer
		move.l	56+4(sp),filename			;filename address (nulled)

		bsr.w	get_fileinfos				;check filesize
		tst.l	d0					;if not zero
		bne	.error0					;error

		move.w	playing,.saved_playing
		beq.s	.notplay
		bsr.w	stop_replay
.notplay:

		move.l	filelength,d0				;reserve memory for file
		moveq	#3,d1
		bsr.w	mxalloc					;
		tst.l	d0					;if 0, not enough ram
		beq.s	.error					;
		move.l	d0,d7					;keep new address in d7

		move.l	filebuffer,d6				;keep old address in d6
		move.l	d7,filebuffer				;store new memory address

		move.l	d7,d0
		bsr.w	loader					;load file
		tst.l	d0					;check for error
		bne.s	.error2					;not 0 = error

		;check file here
.fileok:
		move.l	filebuffer,a0
		bsr.w	check_modformat
		tst.l	d0
		bne.s	.error2

		move.l	filebuffer,a0
		move.l	modhead,1080(a0)

		tst.l	fileinfo				;see if fileinfos should be written
		beq.s	.allok

		;fill out fileinfos here
		move.l	filebuffer,a0
		bsr.w	fill_fileinfo
		
.allok:
		tst.l	d6		;if there was a previous file, we can free it
		beq.s	.no_old_free
		move.l	d6,d0
		bsr	mfree
.no_old_free
		tst.w	.saved_playing
		beq.s	.ok
		bsr.w	start_replay

.ok:		moveq.l	#0,d0					;file can be played
		movem.l	(sp)+,d1-a6
		rts						;

.error2:					;if something failed in new file
		move.l	d6,filebuffer	;restore old file
		move.l	d7,d0
		beq.s	.error
		bsr	mfree		;free buffer of failed new file

.error:					;if something failed, resume with previous file
		tst.l	filebuffer
		beq.s	.no_old_play
		tst.w	.saved_playing
		beq.s	.no_old_play
		bsr.w	start_replay
.no_old_play
.error0					;new file doesn't exists, just exit
		moveq.l	#-3,d0
		movem.l	(sp)+,d1-a6
		rts
.saved_playing	ds.w	1	;keep play status across file change


; Function: close_file -------------------------------------------------------

close_file:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#file_close_text,d0
		bsr.w	print
		endc

		tst.w	playing
		beq.s	.fine
		bsr.w	stop_replay
.fine:		move.l	filebuffer,d0				;paranoia
		beq.s	.no
		bsr.w	mfree
		clr.l	filebuffer
.no:

.nono:		moveq.l	#0,d0
		movem.l	(sp)+,d1-a6
		rts


; Function: install_player ---------------------------------------------------
install_player:

		movem.l	d1-a6,-(sp)

		tst.w	installed	;avoid double lock
		bne.s	.ok

		ifne	debug
		move.l	#install_text,d0
		bsr.w	print
		endc

		move.w	#$68,-(sp)				;Dsp_Lock()
		trap	#14					;
		addq.l	#2,sp					;
		
		tst.l	d0					;is dsp locked?
		bne.s	.dsp					;no
		
		move.w	#$80,-(sp)				;Locksnd()
		trap	#14					;
		addq.l	#2,sp					;
		
		cmp.l	#1,d0					;is soundsystem locked?
		bne.s	.audio					;no

		clr.w	d1
		move.l	#dspmod_player_end-dspmod_player,d0
		bsr	mxalloc
		tst.l	d0
		beq	.relocfail
		move.l	d0,a1
		move.l	#dspmod_player,a0
		move.l	#dspmod_player_end,a2
.mover		move.w	(a0)+,(a1)+
		cmp.l	a2,a0
		blo.s	.mover
		move.l	d0,player_base
		
		move.w	#1,installed

.ok:		movem.l	(sp)+,d1-a6
		moveq.l	#0,d0
		rts


.dsp:
		ifne	debug
		move.l	#install_dsp,d0
		bsr.w	print
		endc

		moveq.l	#-2,d0	;dsp locked
		movem.l	(sp)+,d1-a6
		rts


.audio:
		move.w	#$69,-(sp)				;Dsp_Unlock()
		trap	#14					;
		addq.l	#2,sp					;

		ifne	debug
		move.l	#install_audio,d0
		bsr.w	print
		endc

		moveq.l	#-1,d0	;audio locked
		movem.l	(sp)+,d1-a6
		rts

.relocfail
		move.w	#$69,-(sp)				;Dsp_Unlock()
		trap	#14					;
		addq.l	#2,sp					;
		move.w	#$81,-(sp)				;Unlocksnd()
		trap	#14					;
		addq.l	#2,sp					;
		moveq	#-4,d0	;not enough stram
		movem.l	(sp)+,d1-a6
		rts

; Function: start_replay -----------------------------------------------------
start_replay:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#start_text,d0
		bsr.w	print
		endc

		tst.w	installed
		beq.s	.nok

		tst.w	playing
		bne.s	.ok

		tst.l	dma_pointer
		bne.s	.already_have_dma
		move.l	#8000,d0
		move.w	#0,d1
		bsr.w	mxalloc

		tst.l	d0					;check if there is stram enough
		beq.s	.nok					;nope
		move.l	d0,dma_pointer				;store address of stram buffer
.already_have_dma

		;start playing here

		move.l	#def_songlength,songlength

		move.l	#dspmod_begin,d0			;start module
		bsr.w	supexec					;

		move.w	#1,playing

.ok:		moveq.l	#0,d0
		movem.l	(sp)+,d1-a6
		rts
.mem
		ifne	debug
		move.l	#start_mem,d0
		bsr.w	print
		endc
.nok		moveq	#-1,d0
		bra.s	.ok


; Function: remove_player ----------------------------------------------------
remove_player:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#remove_text,d0
		bsr.w	print
		endc


		tst.w	installed
		beq.s	.no

		tst.w	playing
		bne.s	.no_stop
		bsr.s	stop_replay
.no_stop:

		move.l	player_base,d0
		beq.s	.noreloc
		bsr	mfree
		clr.l	player_base
.noreloc

		move.w	#$69,-(sp)				;Dsp_Unlock()
		trap	#14					;
		addq.l	#2,sp					;

		move.w	#$81,-(sp)				;Unlocksnd()
		trap	#14					;
		addq.l	#2,sp					;


		clr.w	installed

.no:		movem.l	(sp)+,d1-a6
		moveq.l	#0,d0
		rts


; Function: stop_replay ------------------------------------------------------
stop_replay:
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#stop_text,d0
		bsr.w	print
		endc

		;stop all here, unlock dsp/audio as well

		tst.w	playing
		beq.s	.done

		move.l	#dspmod_end,d0				;stop module
		bsr.w	supexec					;


		move.l	dma_pointer,d0
		beq.s	.done

		bsr.w	mfree
		clr.l	dma_pointer
		
.done:		clr.w	playing

		clr.l	duration
		movem.l	(sp)+,d1-a6
		moveq.l	#0,d0
		rts



; Function: check_player -----------------------------------------------------
check_player:	
		movem.l	d1-a6,-(sp)

		ifne	debug
		move.l	#check_text,d0
		bsr.w	print
		endc

		tst.w	installed
		beq.s	.notplaying

		moveq.l	#1,d0
		movem.l	(sp)+,d1-a6
		rts

.notplaying:	moveq.l	#0,d0
		movem.l	(sp)+,d1-a6
		rts



; Function: pause_replay -----------------------------------------------------
pause_replay:	moveq.l	#-1,d0
		rts

; Function: fast_forward -----------------------------------------------------
fast_forward:	moveq.l	#-1,d0
		rts

; Function: seek_file --------------------------------------------------------
seek_file:	moveq.l	#-1,d0
		rts

; Function: kernel -----------------------------------------------------------
kernel:
		movem.l	d1-a6,-(sp)


		ifne	debug
		move.l	#kernel_text,d0
		bsr.w	print
		endc

		;tst.w	playing
		;beq.s	.error

		tst.l	songlength
		bne.s	.ok
		
		tst.w	loopmode
		beq.s	.endofmod

		
		move.l	#def_songlength,songlength
		moveq.l	#0,d0
		movem.l	(sp)+,d1-a6
		rts

.endofmod:
		ifne	debug
		move.l	#kernel_end,d0
		bsr.w	print
		endc

		moveq.l	#1,d0
		movem.l	(sp)+,d1-a6
		rts

.ok:		moveq.l	#0,d0
		movem.l	(sp)+,d1-a6
		rts

.error:		moveq.l	#-1,d0
		movem.l	(sp)+,d1-a6
		rts

; Function: time -------------------------------------------------------------
time:		move.l	duration,d0
		rts

; Function: position ---------------------------------------------------------
position:	moveq.l	#0,d0
		rts


; Function: setup ------------------------------------------------------------
setup:
		movem.l	d1-a6,-(sp)
		ifne	debug
		move.l	#setup_text,d0
		bsr.w	print
		endc

		move.w	56+4(sp),d0
		cmp.w	#$5049,d0
		bne.s	.loop
		
		move.l	56+6(sp),a1
		move.l	(a1)+,mxalloc_addr
		move.l	(a1)+,mfree_addr
		bra.s	.ok


.loop:		move.w	56+4(sp),d0
		cmp.w	#1,d0
		bne.s	.mono
		
		move.l	56+6(sp),d0
		beq.s	.noloop
		move.w	#1,loopmode
		bra.s	.ok
.noloop:	clr.w	loopmode
		bra.s	.ok

.mono:		move.w	56+4(sp),d0
		cmp.w	#2,d0
		bne.s	.no
		
		move.l	56+8(sp),d0
		beq.s	.stereo
		bra.s	.surround
.stereo:	bsr.w	set_stereo
		bra.s	.ok
.surround:	bsr.w	set_surround

.ok:		movem.l	(sp)+,d1-a6
		moveq.l	#0,d0
		rts

.no:		movem.l	(sp)+,d1-a6
		moveq.l	#-1,d0
		rts



; Subroutine: get fileinfos --------------------------------------------------

; input:	filename.l = address to filename
; output:	d0 = 0 all ok, otherwise error
; output:	filelength.l = size of file

get_fileinfos:	move.l	#0,.var

		move.w	#$2f,-(sp)				;fgetdta()
		trap	#1					;
		addq.l	#2,sp					;
		move.l	d0,dta_adr				;

		move.w	#0,-(sp)				;fsfirst()
		move.l	filename,-(sp)				;
		move.w	#$4e,-(sp)				;
		trap	#1					;
		addq.l	#8,sp					;

		tst.l	d0					;file found ?
		bne.s	.load_error				;yep

		move.l	dta_adr,a0
		move.l	26(a0),filelength			;get file-length

		bra.s	.ok
		
.load_error:	move.l	#-1,.var				;file error

.ok:		move.l	.var,d0
		
		rts
.var:		ds.l	1





; Subroutine: loader ---------------------------------------------------------

loader:

;d0.l = address to load data at
;filename.l = address of null-terminated filename
;filelength.l = how much to load
;
;output: d0 = 0  all ok, otherwise error

		move.l	d0,.var

		clr.w	-(sp)					;fopen()
		move.l	filename,-(sp)				;
		move.w	#$3d,-(sp)				;
		trap	#1					;
		addq.l	#8,sp					;
	
		tst.l	d0					;see if file was found
		bmi.s	.load_error
		
.ok:		move.w	d0,filenumber				;filenumber
		move.l	.var,-(sp)				;buffer
		move.l	filelength,-(sp)			;length
		move.w	filenumber,-(sp)			;filenumber
		move.w	#$3f,-(sp)				;
		trap	#1					;
		lea	12(sp),sp				;

		move.w	filenumber,-(sp)			;fclose()
		move.w	#$3e,-(sp)				;
		trap	#1					;
		addq.l	#4,sp					;

		moveq.l	#0,d0
		rts

.load_error:	moveq.l	#-1,d0
		rts

.var:		ds.l	1	;filebuffer addr


; Subroutine: check modformat ------------------------------------------------

;in: 	a0 = address to module header (104 bytes of mod loaded as minimum)
;out:	d0.l = 0, all OK, play the file
;       d0.l = anything but 0, file not supported

check_modformat:
		move.l	1080(a0),d0

		cmp.l	#"M.K.",d0				;noisetracker 4ch
		beq	.pt4ch					;

		cmp.l	#"M!K!",d0				;noisetracker 4ch
		beq.s	.pt4ch					;

		cmp.l	#"M&K&",d0				;noisetracker 4ch
		beq.s	.pt4ch					;

		cmp.l	#"FLT4",d0				;startrekker 4ch
		beq.s	.pt4ch					;

		cmp.l	#"CD41",d0				;Octalyser STe 4ch
		beq.s	.pt4ch					;

		cmp.l	#"RASP",d0				;startrekker 4ch
		beq.s	.pt4ch					;

		cmp.l	#"FA04",d0				;Digital tracker 4ch (old vers)
		beq.s	.pt4ch					;


		cmp.l	#"6CHN",d0				;Fasttracker 6ch
		beq.s	.misc6ch				;

		cmp.l	#"CD61",d0				;Octalyser STe 6ch
		beq.s	.misc6ch				;

		cmp.l	#"06CH",d0				;Fasttracker xxch
		beq.s	.misc6ch				;

		cmp.l	#"FA06",d0				;Digital tracker 6ch (old vers)
		beq.s	.misc6ch				;


		cmp.l	#"8CHN",d0				;Fasttracker 8ch
		beq.s	.misc8ch				;

		cmp.l	#"CD81",d0				;Octalyser STe 8ch
		beq.s	.misc8ch				;

		cmp.l	#"FLT8",d0				;Startrekker 8ch
		beq.s	.misc8ch				;

		cmp.l	#"08CH",d0				;Fasttracker xxch
		beq.s	.misc8ch

		cmp.l	#"OCTA",d0				;Octalsyer STe (old vers)
		beq.s	.misc8ch				;

		cmp.l	#"FA08",d0				;Digital tracker 8ch (old vers)
		beq.s	.misc8ch				;

		bra.s	.unknown


.pt4ch:		move.l	#"M.K.",modhead				;put general 4ch header
		move.b	#"4",modchan
		bra.s	.done					;

.misc6ch:	move.l	#"CD61",modhead				;put general 6ch header
		move.b	#"6",modchan
		bra.s	.done					;

.misc8ch:	move.l	#"CD81",modhead				;put general 8ch header
		move.b	#"8",modchan

.done:		moveq.l	#0,d0
		rts

.unknown:	moveq.l	#-1,d0
		rts



; Subroutine: print ----------------------------------------------------------
		ifne	debug
print:		move.l	d0,-(sp)				;textprint
		move.w	#9,-(sp)				;
		trap	#1					;
		addq.l	#6,sp					;
		rts
		endc


; Subroutine: supexec --------------------------------------------------------

supexec:	move.l	d0,-(sp)				;supexec()
		move.w	#$26,-(sp)				;
		trap	#14					;
		addq.l	#6,sp					;
		rts						;


; Subroutine: mxalloc --------------------------------------------------------

;input:		d0.l = size of block to allocate
;		d1.w = memory type (0=stram 3=prefer ttram)
;output:	d0 = address of block
;		if d0 = 0, no memory available

mxalloc:
		move.w	d1,-(sp)				;Mxalloc()
		move.l	d0,-(sp)				;
		move.l	mxalloc_addr,a0
		jsr	(a0)
		addq.l	#6,sp					;

		rts

; Subroutine: mfree ----------------------------------------------------------
; in: d0 = address to block to free

mfree:		move.l	d0,-(sp)				;mfree()
		move.l	mfree_addr,a0
		jsr	(a0)
		addq.l	#4,sp					;
		rts						;

; Subroutine: fill out fileinfos ---------------------------------------------
; input: a0 = address to modfile

fill_fileinfo:	
	;fmt_txt_1
		move.l	fileinfo,a1
		lea.l	fileinfo_text,a2
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		move.w	(a2)+,(a1)+
		move.l	modchan,(a1)				;number of channels
		lea.l	38-10(a1),a1
	;fmt_txt_2
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		move.w	(a2)+,(a1)+
		move.l	a0,a3
		moveq	#20-1,d7
.songname:	move.b	(a3)+,d0
		bne.s	.nozero
		move.b	#" ",d0
.nozero:		move.b	d0,(a1)+
		dbf	d7,.songname
		clr.b	(a1)
		lea.l	38-30(a1),a1
	;fmt_txt_3
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		move.w	(a2)+,(a1)+
		lea.l	20(a0),a3
		moveq	#22-1,d7
.samplename:
		move.b	(a3)+,d0
		bne.s	.nozero2
		move.b	#" ",d0
.nozero2:	move.b	d0,(a1)+
		dbf	d7,.samplename
		clr.b	(a1)
		lea	38-32(a1),a1
		clr.l	(a1)+
		clr.l	(a1)+
		move.l	#49170,(a1)+
		move.w	#1,(a1)+
		clr.w	(a1)+
		rts

		include	'dspmod.s'


;default functions before init is called
def_mxalloc
	move.w	8(sp),-(sp)
	move.l	6(sp),-(sp)
	move.w	#$44,-(sp)
	trap	#1
	addq.l	#8,sp
	rts
def_mfree
	move.l	4(sp),-(sp)
	move.w	#$49,-(sp)
	trap	#1
	addq.l	#6,sp
	rts

		section	data

		ifne	debug
install_text:	dc.b	'Install_player(); ',13,10,0
		even
remove_text:	dc.b	'Remove_player(); ',13,10,0
		even
file_info_text:	dc.b	'File_info(); ',13,10,0
		even
file_open_text:	dc.b	'File_open(); ',13,10,0
		even
file_close_text:dc.b	'File_close(); ',13,10,0
		even
stop_text:	dc.b	'Stop_replay(); ',13,10,0
		even
start_text:	dc.b	'Start_replay(); ',13,10,0
		even
start_mem:	dc.b	'Start_replay(); has noticed ST-RAM shortage. ',13,10,0
		even
install_dsp:	dc.b	'Start_replay(); has noticed DSP busy ',13,10,0
		even
install_audio:	dc.b	'Start_replay(); has noticed audiosystem to be busy ',13,10,0
		even
setup_text:	dc.b	'Setup(); ',13,10,0
		even
check_text:	dc.b	'Check_player(); ',13,10,0
		even
kernel_text:	dc.b	'Kernel(); ',13,10,0
		even
kernel_end:	dc.b	'Kernel(); has detected songend ',13,10,0
		even
		endc


		section	data
mxalloc_addr:	dc.l	def_mxalloc
mfree_addr:	dc.l	def_mfree

fileinfo_text:
		dc.b	'Channels: '
		dc.b	'Songname: '
		dc.b	'Instr.#1: '
		even

infos:		dc.b	'4-8ch Module Player',0				;19+1b free text
		dc.b	'using dspmod engine',0				;19+1b free text
		dc.b	'  49170 Hz Stereo  ',0				;19+1b free text
		dc.b	'     ae@dhs.nu     ',0				;19+1b free text
		even

songlength:	dc.l	1000

		section	bss
modhead:	ds.l	1
modchan:	ds.l	1

loopmode:	ds.w	1
installed:	ds.w	1
duration:	ds.l	1
dma_pointer:	ds.l	1					;replay dmabuffer address
playing:		ds.w	1					;0=not playing  1=playing
filelength:	ds.l	1					;filesize
filename:	ds.l	1					;address to nulled filename
fileinfo:	ds.l	1					;address to fileinfo buffer
tmpbuf:		ds.l	1					;address to 4096 byte buffer
filebuffer:	ds.l	1					;address where to read file
filenumber:	ds.w	1					;current filenumber
dta_adr:		ds.l	1

