UNIT CidFuncs;

 {----------------------------------------------------------------------}
 {-- Generic CALLER ID unit using LPTCIDs Service Interrupt Functions --}
 {----------------------------------------------------------------------}
 {-                                                                    -}
 {- This unit source may freely be copied and used by anyone, and also -}
 {- distributed as long as nothing in this file is modified in any way.-}
 {-                                                                    -}
 {- Any suggestions or questions can be sent to:                       -}
 {-                                                                    -}
 {- Fidonet node:  Jorgen Olsson, 2:205/201                            -}
 {- Internet mail: jorgen@kuai.se                                      -}
 {- BBS/Fax:       026-161476                                          -}
 {-                                                                    -}
 {----------------------------------------------------------------------}
 {---                                                                ---}
 {-                Mountain Village Software (c) 1994                  -}
 {---                                                                ---}
 {----------------------------------------------------------------------}

INTERFACE

USES DOS;



TYPE {--- Public types ---}

      tCstring         = array[1..255] of char;     { C-type string         }
      pCstring         = ^tCstring;                 { Pointer to C-string   }




 {--- Public constants ---}
CONST
      { Areacode list filename  }
      AreaCodeListFile : string[12] = 'AREACODE.LST';

      { Name of environment variable that may contain a service int number  }
      EnvCIDINT        : string[6] = 'CIDINT';

      { Default service int (used if service int number is not specified)   }
      DefaultSrvIntNum : byte = $65;

      { these are Telia's special characters found in caller id sequence    }
      CidCode_rStart   : char = 'A'; { Caller id start (redirected number)  }
      CidCode_Info     : char = 'B'; { Caller id special info start         }
      CidCode_EOT      : char = 'C'; { Caller id EOT character              }
      CidCode_Start    : char = 'D'; { Caller id start                      }

      { Special information code: Caller has no caller id ability           }
      CidInfo_LoTek    : string[2] = '00';

      { Special information code: Caller has blocked caller id information  }
      CidInfo_Unpubl   : string[2] = '10';


      { Code returned in VAR PhoneNum from procedure MatchAreaCode if the   }
      { caller has no caller id ability (loTek caller)                      }
      Phonenum_Lotek   : char = 'L';

      { Code returned in VAR PhoneNum from procedure MatchAreaCode if the   }
      { caller has blocked caller id (Unpublished caller)                   }
      Phonenum_Unpubl  : char = 'U';




 {--- Public variables ---}
VAR   SrvIntNum        : byte;     { Service interrupt number used          }
      CID              : pCstring; { Pointer to caller id buffer            }




 {--- Public functions and procedures ---}

 { Return Service interrupt vector defined in environment variable }
 { CIDINT. If CIDINT is not defined, then this function returns 0. }
FUNCTION GetEnvironmentCIDINT : byte;


 { Check if service routines are installed on interrupt SrvIntNum }
FUNCTION CIDserviceInstalled : boolean;


 { Get pointer to CID buffer }
FUNCTION GetCIDbufpointer : pointer;


 { Mark latest caller id as read }
PROCEDURE CIDwasRead;


 { Check if there is a new caller id string in buffer }
FUNCTION NewCIDstr : boolean;


 { Check if caller id in S indicated that caller id is blocked }
FUNCTION CIDunpublished(s:string) : boolean;


 { Check if caller id in S indicated that user has no caller id ability }
FUNCTION CIDlotek(s:string) : boolean;


 { Get CID string }
FUNCTION GetCID : string;


 { Separate areacode from phone number                                  }
 { Returns: PHONENUM: Phone number, with areacode and phonenumber       }
 {          separated with '-'                                          }
 {          AREA: Name of area associated with the areacode             }
 {                                                                      }
 { If the areacode list (AREACODE.LST) is not found in your program's   }
 { path, or if the areacode itself was not found, CIDSTR (the raw       }
 { caller id string) is returned unmodified in PHONENUM.                }
 {                                                                      }
 { If the caller id string indicates that caller id is blocked by the   }
 { caller, then the character 'U' will be returned in PHONENUM.         }
 {                                                                      }
 { If the caller id string indicates that the caller has no caller id   }
 { capability, then the character 'L' will be returned in PHONENUM.     }
PROCEDURE MatchAreaCode(cidstr:string;VAR phonenum,area:string);







IMPLEMENTATION


VAR regs : registers; { CPU register var }





 { --- Internal function: Cut leading spaces --- }
FUNCTION TrimLead(s:string):string;
BEGIN
     while (s <> '') and (s[1] = #32) do Delete(s,1,1);
     TrimLead:=s;
END;






 { --- Internal function: Cut trailing spaces --- }
FUNCTION TrimTrail(s:string):string;
BEGIN
     while (s <> '') and (s[ord(s[0])] = #32) do Delete(s,ord(s[0]),1);
     TrimTrail:=s;
END;




 { --- Internal function: Return position of the last occurance of CH }
FUNCTION Bpos(Ch:char;s:string):byte;
VAR i : byte;
BEGIN
     Bpos:=0;
     for i:=1 to ord(s[0]) do if s[i] = ch then Bpos:=i;
END;




 { Return Service interrupt vector defined in environment variable }
 { CIDINT. If CIDINT is not defined, then this function returns 0. }
FUNCTION GetEnvironmentCIDINT : byte;
VAR i : integer;
    w : word;
BEGIN
     GetEnvironmentCIDINT:=0;
     if getenv(EnvCIDINT) = '' then exit;
     val('$'+getenv(EnvCIDINT),w,i);
     if (i=0) and (w < 256) then GetEnvironmentCIDINT:=byte(w);
END;





 { --- Check if service routines are installed on interrupt SrvIntNum --- }
FUNCTION CIDserviceInstalled : boolean;
BEGIN
     regs.AH:=$00;
     intr(SrvIntNum,regs);
     CIDserviceInstalled:= (regs.AX = 1213);
END;







 { --- Get pointer to CID buffer --- }
FUNCTION GetCIDbufpointer : pointer;
BEGIN
     regs.AH:=$00;
     intr(SrvIntNum,regs);
     GetCIDbufPointer:=Ptr(regs.BX,regs.CX);
END;







 { --- Mark latest caller id as read --- }
PROCEDURE CIDwasRead;
BEGIN
     regs.AH:=$FE;
     intr(SrvIntNum,regs);
END;







 { --- Check if there is a new caller id string in buffer --- }
FUNCTION NewCIDstr : boolean;
BEGIN
     regs.AH:=$FF;
     intr(SrvIntNum,regs);
     NewCIDstr:= (regs.BX = 0);
END;





 { --- Check if caller id in S indicated that caller id is blocked }
FUNCTION CIDunpublished(s:string) : boolean;
BEGIN
     CIDunpublished:=(copy(s,1,3) = CIDcode_Info+CIDinfo_unpubl);
END;







 { --- Check if caller id in S indicated that user has no caller id ability }
FUNCTION CIDlotek(s:string) : boolean;
BEGIN
     CIDlotek:=(copy(s,1,3) = Cidcode_Info+CIDinfo_Lotek);
END;






 { --- Get CID string --- }
FUNCTION GetCID : string;
VAR s : string;
BEGIN
     regs.AH:=$01;
     intr(SrvIntNum,regs);
     s[0]:=chr(lo(regs.BX));
     move(CID^,s[1],ord(s[0]));
     GetCID:=s;
END;







 { --- Separate areacode from phone number --- }
PROCEDURE MatchAreaCode(cidstr:string;VAR phonenum,area:string);
VAR ac       : string[4];
    s,ss,ps  : string;
    f        : text;
    mc,hm    : byte;
    x        : byte;
    Match    : boolean;
    iook     : boolean;
BEGIN
     PhoneNum:=cidstr; { Return Cidstr in Phonenum if something wrong }
     Area:='';         { Return nothing in Area if no match }


     if cidstr[1] = CIDcode_Info then { We got a special information code }
     BEGIN
          If CIDunpublished(CidStr) then PhoneNum:= PhoneNum_Lotek;
          If CIDlotek(CidStr) then Phonenum:= PhoneNum_UnPubl;
          exit;
     END;

     ac:=copy(cidstr,2,4); { Get the 4 first digits in CidStr }
     hm:=0;                { Reset hi-match counter }
     Match:=FALSE;         { Reset match flag }


     { Assign and try open the areacode list. If not found, exit. }
     { File must be found in the same directory as the .EXE file  }
     { of your application program.                               }
     s:=paramstr(0);
     s:=copy(s,1,bpos('\',s));
     assign(f,s+AreaCodeListFile);
     reset(f);
     if ioresult <> 0 then exit;

     REPEAT
           ReadLn(f,s); { Read a line }
           iook:=(ioresult=0);

           { Handle the raw string }
           s:=trimlead(trimtrail(s));
           while pos('  ',s) <> 0 do delete(s,pos('  ',s),1);
           s:=s+#32;

           { Get the area code on this line }
           ss:=copy(s,1,pos(#32,s)-1);


           { Match counting }
           for x:=1 to ord(ss[0]) do if copy(ss,1,x) = copy(ac,1,x) then mc:=x;


           { If this is the best match so far, update hi-match counter }
           if mc > hm then hm:=mc;


           { If we have less matches than hi-match counter, then the area- }
           { code on the previous line is the area we are looking for      }
           if mc < hm then
           BEGIN
                s:=ps;
                Match:=TRUE;
           END
           ELSE ps:=s;


     UNTIL Match or eof(f) or (not iook);


     { Close areacode list }
     close(f);
     x:=ioresult;

     { If there was a match, return the telephone number in PhoneNum as     }
     { a complete telephone number with separated areacode and phonenumber. }
     { Do also return the name of the area in variable Area }
     If Match then
     BEGIN
          { Phone number }
          PhoneNum:=copy(cidstr,pos('D',cidstr)+1,ord(cidstr[0])-(pos('D',cidstr)+1));
          insert('-',PhoneNum,pos(#32,s));


          { Name of area }
          Area:=trimtrail(copy(s,pos(#32,s)+1,ord(s[0])-pos(#32,s)));
     END;

END;




 { The initialization code initializes the buffer pointer CID  only if }
 { a interrupt number was found in environment variable CIDINT, and if }
 { LPTCID's service functions really are installed on that interrupt.  }
 { If you want to do this check in your own routines, then disable     }
 { everything between BEGIN and END in the initialization code, by     }
 { adding comment characters.                                          }

BEGIN
     CID:=NIL;
     {
     SrvIntNum:=GetEnvironmentCIDINT;

     if (SrvIntnum <> 0) and CIDserviceInstalled
        then CID:=GetCIDbufPointer;
     }
END.


