
;;; ********************
;;; ** SID-LOAD 1.0.5 **
;;; ********************

	;; equates

DOSVEC		.EQU   $0A
MATCH		.EQU   $FB
FIRST:		.EQU   $FC
LAST:		.EQU   $FE

COLOR2:		.EQU  $2C6
RUNAD:		.EQU  $2E0
INITAD:		.EQU  $2E2
CRSINH		.EQU  $2F0
	
CIOV:		.EQU $E456
COLDSV:		.EQU $E477

;;; **********************
;;; ** BOOT DISK HEADER **
;;; **********************

		.ORG $480
		
BOOT:	        .BYTE 0
		.BYTE (ENDBOOT-BOOT+127)/128
		.WORD $-2
		.WORD DOSVEC_SET

;;; *************************
;;; ** BOOT INITIALISATION **
;;; *************************
	
		CLC
RTS_INSTR:	RTS

;;; ************
;;; ** LOADER **
;;; ************

NEXT_BLOCK:	LDX #$10	;  in case INITADR routine destroys X

		LDA #FIRST	;  BGET #1,FIRST,2
		STA $344,X
		LDA #2
		STA $348,X
		LDA #0
		STA $345,X
		STA $349,X
		JSR CIOV
		BMI CLOSE_RUN	;  ERROR? CLOSE #1, JMP (RUNAD)

		LDA #$FF	; IF FIRST==$FFFF GOTO NEXT_BLOCK
		CMP FIRST
		BNE NO_FFFF
		CMP FIRST+1
		BEQ NEXT_BLOCK

NO_FFFF:	LDA #LAST	; BGET #1,LAST,2
		STA $344,X
		JSR CIOV
		BMI CLOSE_RUN	; ERROR? CLOSE #1, JMP (RUNAD)

	;; reset INITAD
	
		LDA #RTS_INSTR%256
		STA INITAD
		LDA #RTS_INSTR/256
		STA INITAD+1

	;; BGET #1,FIRST,LAST-FIRST+1

		LDA FIRST
		STA $344,X
		LDA FIRST+1
		STA $345,X
		LDA LAST
		SEC
		SBC FIRST
		STA $348,X
		LDA LAST+1
		SBC FIRST+1
		BCC CLOSE_RUN	;  if FIRST>LAST
		STA $349,X
		INC $348,X
		BNE NO_CARRY
		INC $349,X
NO_CARRY:	JSR CIOV
		BMI CLOSE_RUN	;  ERROR? CLOSE #1, JMP (RUNAD)

	;; PUSH NEXTBLK

		LDA #(NEXT_BLOCK-1)/256
		PHA
		LDA #(NEXT_BLOCK-1)%256
		PHA
		JMP (INITAD)

CLOSE_RUN:	LDA #12
		STA $342,X
		JSR CIOV
		JMP (RUNAD)
;;; ****************
;;; ** DOSVEC-SET **
;;; ****************

DOSVEC_SET:	LDA #USER_INTF%256
		STA DOSVEC
		LDA #USER_INTF/256
		STA DOSVEC+1
		RTS
	
;;; ********************
;;; ** USER INTERFACE **
;;; ********************
	
USER_INTF:	LDA COLOR2	;  save COLOR2
		PHA
		LDA #0
		STA COLOR2	; black screen

	;; print title

		LDX #0
		LDA #11
		STA $342,X
		LDA #TITLE%256
		STA $344,X
		LDA #TITLE/256
		STA $345,X
		LDA #TITLE_LEN%256
		STA $348,X
		LDA #TITLE_LEN/256
		STA $349,X
		JSR CIOV
		
	;; print "filename" prompt
	
REDO:		LDX #0
		LDA #11
		STA $342,X
		LDA #PROMPT%256
		STA $344,X
		LDA #PROMPT/256
		STA $345,X
		LDA #PROMPT_LEN%256
		STA $348,X
		LDA #PROMPT_LEN/256
		STA $349,X
		JSR CIOV

	;; read filename from keyboard

		LDX #0
		LDA #5
		STA $342,X
		LDA #FNAME%256
		STA $344,X
		LDA #FNAME/256
		STA $345,X
		LDA #$FF
		STA $348,X
		STA $349,X
		JSR CIOV

	;; open file for input (IOCB #1)

		LDX #$10
		LDA #3
		STA $342,X
		LDA #DEVICE%256
		STA $344,X
		LDA #DEVICE/256
		STA $345,X
		LDA #4
		STA $34A,X
		LDA #0
		STA $34B,X
		JSR CIOV
		BMI TRY_DIR

;;; *******************
;;; ** GO FOR LOADER **
;;; *******************

		LDA #7		; IOCB command := get bytes
		STA $342,X
		LDA #$60	; RTS instruction on page zero.
		STA RTS_INSTR
		PLA		; restore screen color
		STA COLOR2
		LDA #1		;  Turn cursor off
		STA CRSINH
		
	;; print "Loading..."
	
		LDX #0
		LDA #11
		STA $342,X
		LDA #LOADING%256
		STA $344,X
		LDA #LOADING/256
		STA $345,X
		LDA #LOADING_LEN%256
		STA $348,X
		LDA #LOADING_LEN/256
		STA $349,X
		JSR CIOV

		LDA #0		; Turn cursor back on
		STA CRSINH

		LDA #RTS_INSTR%256
		STA RUNAD
		LDA #RTS_INSTR/256
		STA RUNAD+1

		LDA #(COLDSV-1)/256	; COLDST --> STACK (if RUNAD returns!)
		PHA
		LDA #(COLDSV-1)%256
		PHA
	
		JMP NEXT_BLOCK	; Go for loader!

;;; ************************
;;; ** TRY DIRECTORY LIST **
;;; ************************

TRY_DIR:	LDX #$10	;  CLOSE #1
		LDA #12
		STA $342,X
		JSR CIOV

		LDX #$00	;  Print EOL
		LDA #11
		STA $342,X
		LDA #0
		STA $348,X
		STA $349,X
		LDA #$9B
		JSR CIOV

		LDX #$10	;  OPEN #1,6,0,DEVICE
		LDA #3
		STA $342,X
		LDA #DEVICE%256
		STA $344,X
		LDA #DEVICE/256
		STA $345,X
		LDA #6
		STA $34A,X
		LDA #0
		STA $34B,X
		JSR CIOV

		LDA #0		;  Initially, no matches detected
		STA MATCH

DIR_NEXT:	LDX #$10	; Get directory entry
		LDA #5
		STA $342,X
		LDA #DIR_ENTRY%256
		STA $344,X
		LDA #DIR_ENTRY/256
		STA $345,X
		LDA #$FF
		STA $348,X
		STA $349,X
		JSR CIOV
		BMI CHK_MATCH	; Bail out on error

		LDA #1		; We have a match
		STA MATCH
	
		LDX #$00	; Print space
		LDA #11
		STA $342,X
		LDA #0
		STA $348,X
		STA $349,X
		LDA #' '
		JSR CIOV
	
		LDX #$00	;  Print match
		LDA #9
		STA $342,X
		LDA #DIR_ENTRY%256
		STA $344,X
		LDA #DIR_ENTRY/256
		STA $345,X
		LDA #$FF
		STA $348,X
		STA $349,X
		JSR CIOV

		JMP DIR_NEXT	;  repeat for next dir entry

CHK_MATCH:	LDA MATCH	; skip print if match...
		BNE CLOSE_DIR

		LDX #0		; print "No match" message.
		LDA #11
		STA $342,X
		LDA #NOMATCH%256
		STA $344,X
		LDA #NOMATCH/256
		STA $345,X
		LDA #NOMATCH_LEN%256
		STA $348,X
		LDA #NOMATCH_LEN/256
		STA $349,X
		JSR CIOV		

CLOSE_DIR:	LDX #$10	;  CLOSE #1 for DIR
		LDA #12
		STA $342,X
		JSR CIOV

		LDX #$00	;  Print EOL
		LDA #11
		STA $342,X
		LDA #0
		STA $348,X
		STA $349,X
		LDA #$9B
		JSR CIOV

		JMP REDO	;  Start over with 'file name' prompt.

	;; FILE NAME & STUFF

TITLE:		.BYTE ' '+$80
		.BYTE 'S'+$80,'I'+$80,'D'+$80,'-'+$80,'L'+$80,'O'+$80,'A'+$80
		.BYTE 'D'+$80,' '+$80,'1'+$80,'.'+$80,'0'+$80,'.'+$80,'5'+$80
		.BYTE ' '+$80
		.BYTE $9B,$9B
TITLE_LEN:	.EQU $-TITLE

PROMPT:		.BYTE "Filename: "
PROMPT_LEN:	.EQU $-PROMPT

NOMATCH:	.BYTE " No match.",$9B
NOMATCH_LEN:	.EQU $-NOMATCH

LOADING:	.BYTE $7D,$9B,"Loading...",$9B
LOADING_LEN:	.EQU $-LOADING

DEVICE:		.BYTE "H1:"
FNAME:

ENDBOOT:
DIR_ENTRY:	.EQU $+16

		.END
