/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CCartridgeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CCartridgeDlg.h"
#include "registry.h"
#include "winatari.h"
#include "CWarnDlg.h"
#include "resource.h"
#include <stdio.h>
#include <io.h>
#include <sys/types.h>
#include <windows.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define NO_CART 0
#define NORMAL8_CART 1
#define NORMAL16_CART 2
#define AGS32_CART 3
#define OSS_SUPERCART 4
#define DB_SUPERCART 5
#define CARTRIDGE 6

extern "C" {
extern TCHAR	gcErrorString[];
extern int	default_system;
extern void Coldstart( void );
extern int Remove_ROM (void);
extern int Insert_8K_ROM (char *filename);
extern int Insert_16K_ROM (char *filename);
extern int Insert_32K_5200ROM (char *filename);
extern char atari_basic_filename[];
extern int	rom_inserted;
extern char	current_rom[];
extern int	hold_option;
extern void EnablePILL (void);
extern void WriteRegString( HKEY hkInput, char *item, char *data );
extern void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
extern DWORD ReadRegBinary( HKEY hkInput, char *item, char *buffer, unsigned long maxsize, BOOL bShowError );
extern ULONG	ulDontShowFlags;
extern int cart_type;
extern ULONG	ulAtariState;
extern int		main (int argc, char **argv);
extern HWND		hWnd;
}

extern unsigned long CheckFile( char *fn, int *result );

static char BASED_CODE szFilter[LOADSTRING_STRING_SIZE];
/////////////////////////////////////////////////////////////////////////////
// CCartridgeDlg dialog


CCartridgeDlg::CCartridgeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCartridgeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCartridgeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	nCartState = 2;
	LoadString( NULL, IDS_ROM_FILTER, szFilter, LOADSTRING_STRING_SIZE );
}


void CCartridgeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCartridgeDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCartridgeDlg, CDialog)
	//{{AFX_MSG_MAP(CCartridgeDlg)
	ON_BN_CLICKED(IDC_BASIC_ROM, OnBasicRom)
	ON_BN_CLICKED(IDC_OTHER_ROM, OnOtherRom)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCartridgeDlg message handlers

BOOL CCartridgeDlg::OnInitDialog() 
{
	CButton	*pTemp;
	CDialog::OnInitDialog();

	pTemp = (CButton *)GetDlgItem( IDC_CART_BASIC );
	if( default_system == 4 || default_system == 3)
	{
		pTemp->EnableWindow( FALSE );
		if( !strcmp( current_rom, atari_basic_filename ))
			strcpy( current_rom, "None" );
	}
	SetDlgItemText( IDC_BASIC_EDIT, atari_basic_filename );

	if( !strcmp( "None", current_rom ))
		rom_inserted = FALSE;

	if( rom_inserted )
	{
		if( !strcmp( current_rom, atari_basic_filename ) )
		{
			CheckRadioButton( IDC_CART_BASIC, IDC_CART_NONE, IDC_CART_BASIC );
			nCartState = 0;
		}
		else 
		{
			CheckRadioButton( IDC_CART_BASIC, IDC_CART_NONE, IDC_CART_OTHER );
			nCartState = 1;
		}
	}
	else
	{
		CheckRadioButton( IDC_CART_BASIC, IDC_CART_NONE, IDC_CART_NONE );
		nCartState = 2;
	}

	if( hold_option )
	{
		pTemp = (CButton *)GetDlgItem( IDC_HOLD_OPTION );
		pTemp->SetCheck( 1 );
	}

	ReadRegBinary( NULL, REG_OTHER_ROM, szOther_ROM_name, MAX_PATH, FALSE );
	SetDlgItemText( IDC_OTHER_EDIT, szOther_ROM_name );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCartridgeDlg::OnBasicRom() 
{
	CString	name;
	CFileDialog	dlgRomImage( TRUE, NULL, NULL, OFN_EXPLORER | OFN_FILEMUSTEXIST, szFilter, this );

	if( dlgRomImage.DoModal() == IDOK )
	{
		unsigned long crc;
		int result;

		name = dlgRomImage.GetPathName();
		SetDlgItemText( IDC_BASIC_EDIT, name.GetBuffer(0) );
		crc = CheckFile( name.GetBuffer( 0 ), &result);
		if( !result && (crc != 2190982779L ) && !(ulDontShowFlags & DONT_SHOW_BASIC_WARN))
		{
			CWarnDlg	Warning;
			char		message[LOADSTRING_STRING_SIZE];			
			LoadString( NULL, IDS_WARNING_ROM_CORRUPT, message, LOADSTRING_STRING_SIZE );
			Warning.csWarnText = message;
			Warning.iWarnBit = DONT_SHOW_BASIC_WARN;
			Warning.DoModal();
		}
		name.ReleaseBuffer();
	}
}

void CCartridgeDlg::OnOtherRom() 
{
	CString	name;
	char	szCurDir[ MAX_PATH ];
	char	szCurRom[ MAX_PATH ];
	CFileDialog	dlgRomImage( TRUE, NULL, NULL, OFN_EXPLORER | OFN_FILEMUSTEXIST, szFilter, this );

	GetDlgItemText( IDC_OTHER_EDIT, szCurRom, MAX_PATH );
	GetCurrentDirectory( MAX_PATH, szCurDir );
	if( strcmp( szCurRom, "None" ) && strcmp( szCurRom, "Off" ) )
	{
		char	szNewDir[ MAX_PATH ];
		int i;

		strcpy( szNewDir, szCurRom );
		for( i=strlen( szNewDir ); i > 0 && szNewDir[i]!='\\'; i--);
		if( i > 0 )
			szNewDir[i] = 0;
		SetCurrentDirectory( szNewDir );
	}

	if( dlgRomImage.DoModal() == IDOK )
	{
		name = dlgRomImage.GetPathName();
		SetDlgItemText( IDC_OTHER_EDIT, name.GetBuffer(0) );
		name.ReleaseBuffer();
	}
	SetCurrentDirectory( szCurDir );
}

void CCartridgeDlg::OnOK() 
{
	int	nNewCartOpt;
	BOOL	bReboot = FALSE;
	char	szNew_other_cart[ MAX_PATH ];
	CButton *pCheckButton;

	GetDlgItemText( IDC_OTHER_EDIT, szNew_other_cart, MAX_PATH );
	if( strcmp( szNew_other_cart, szOther_ROM_name ) )
	{
		strcpy( current_rom, szNew_other_cart );
		if( rom_inserted )
			bReboot = TRUE;
	}
	strcpy( szOther_ROM_name, szNew_other_cart );
	WriteRegString( NULL, REG_OTHER_ROM, szOther_ROM_name );

	GetDlgItemText( IDC_BASIC_EDIT, atari_basic_filename, MAX_PATH );
	WriteRegString( NULL, REG_BASIC_ROM, atari_basic_filename );

	nNewCartOpt = GetCheckedRadioButton( IDC_CART_BASIC, IDC_CART_NONE ) - IDC_CART_BASIC;
	if( nNewCartOpt != nCartState )
	{
		bReboot = TRUE;
		if( nNewCartOpt == 0 )
		{
			if( rom_inserted )
				Remove_ROM();
			strcpy( current_rom, atari_basic_filename );
			if( Insert_8K_ROM( atari_basic_filename ) )
				WriteRegString( NULL, REG_CURRENT_ROM, atari_basic_filename );
			else
			{
				LoadString( NULL, IDS_ERROR_LOADING_ROM, gcErrorString, LOADSTRING_STRING_SIZE );
				strcat( gcErrorString, atari_basic_filename );
				AfxGetMainWnd()->MessageBox( gcErrorString, "Atari800Win", MB_ICONSTOP );
				strcpy( current_rom, "None" );
			}
		}
		if( nNewCartOpt == 1 )
		{
			CFile	cfFile;
			int		length = 0, result = -1;

			if( rom_inserted )
				Remove_ROM();
			strcpy( current_rom, szOther_ROM_name );
			
			if( cfFile.Open( szOther_ROM_name, CFile::modeRead | CFile::typeBinary, NULL ) )
			{
				length = cfFile.GetLength();
				cfFile.Close();
			}
			cart_type = NO_CART;
			if( length < 8193 )
			{
				result = Insert_8K_ROM( szOther_ROM_name );
				if( result )
					cart_type = NORMAL8_CART;
			}
			else if( length < 16385 )
			{
				result = Insert_16K_ROM( szOther_ROM_name );
				if( result )
					cart_type = NORMAL16_CART;
			}
			else if( length < 32769 )
			{
				result = Insert_32K_5200ROM( szOther_ROM_name );
				if( result )
					cart_type = AGS32_CART;
			}
			if( result > 0 )
			{
				strcpy( current_rom, szOther_ROM_name );
				WriteRegString( NULL, REG_CURRENT_ROM, szOther_ROM_name );
			}
			else
			{
				if( result == -1 )
				{
					LoadString( NULL, IDS_UNKNOWN_ROM_FORMAT, gcErrorString, LOADSTRING_STRING_SIZE );
					AfxGetMainWnd()->MessageBox( gcErrorString, "Atari800Win", MB_ICONSTOP );
				}
				else
				{
					LoadString( NULL, IDS_ERROR_LOADING_ROM, gcErrorString, LOADSTRING_STRING_SIZE );
					AfxGetMainWnd()->MessageBox( gcErrorString, "Atari800Win", MB_ICONSTOP );
				}
				strcpy( current_rom, "None" );
			}
		}
		if( nNewCartOpt == 2 )
		{
			strcpy( current_rom, "None" );
			cart_type = NO_CART;
			WriteRegString( NULL, REG_CURRENT_ROM, "None" );
		}
		WriteRegDWORD( NULL, REG_CART_TYPE, cart_type );
	}

	pCheckButton = (CButton *)GetDlgItem( IDC_HOLD_OPTION );
	if( pCheckButton->GetCheck( ) )
	{
		hold_option = 1;
		WriteRegDWORD( NULL, REG_HOLD_OPTION, 1 );
	}
	else
	{
		hold_option = 0;
		WriteRegDWORD( NULL, REG_HOLD_OPTION, 0 );
	}

	if( ulAtariState & ATARI_LOAD_FAILED )
	{
		hWnd = NULL;
		ulAtariState = ATARI_UNINITIALIZED | ATARI_PAUSED;
		main( 1, NULL );
	}
	else
	{
		if( bReboot )
		{
			ulAtariState = ATARI_UNINITIALIZED | ATARI_PAUSED;
			main( 1, NULL );
			hWnd = NULL;
		}
	}

	CDialog::OnOK();
}
