/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CDriveDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CDriveDialog.h"
#include "registry.h"
#include "WinAtari.h"

extern "C" int SIO_Mount (int diskno, char *filename);
extern "C" void SIO_Dismount (int diskno);
extern "C" void SIO_DisableDrive (int diskno);
extern "C" void SIO (void);
extern "C" char sio_filename[8][MAX_PATH];
extern "C" void WriteRegString( HKEY hkInput, char *item, char *data );
extern "C" 	TCHAR	gcErrorString[];

static char new_sio_filename[8][MAX_PATH];
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static int nDlgEditID[8] =  {IDC_EDIT1, IDC_EDIT2, IDC_EDIT3, IDC_EDIT4, IDC_EDIT5, IDC_EDIT6, IDC_EDIT7, IDC_EDIT8 };

/////////////////////////////////////////////////////////////////////////////
// CDriveDialog dialog


CDriveDialog::CDriveDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CDriveDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDriveDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CDriveDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDriveDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDriveDialog, CDialog)
	//{{AFX_MSG_MAP(CDriveDialog)
	ON_BN_CLICKED(IDC_DRIVE1, OnDrive1)
	ON_BN_CLICKED(IDC_DRIVE2, OnDrive2)
	ON_BN_CLICKED(IDC_DRIVE3, OnDrive3)
	ON_BN_CLICKED(IDC_DRIVE4, OnDrive4)
	ON_BN_CLICKED(IDC_DRIVE5, OnDrive5)
	ON_BN_CLICKED(IDC_DRIVE6, OnDrive6)
	ON_BN_CLICKED(IDC_DRIVE7, OnDrive7)
	ON_BN_CLICKED(IDC_DRIVE8, OnDrive8)
	ON_BN_CLICKED(IDC_DRIVE1CHECK, OnDrive1check)
	ON_BN_CLICKED(IDC_DRIVE2CHECK, OnDrive2check)
	ON_BN_CLICKED(IDC_DRIVE3CHECK, OnDrive3check)
	ON_BN_CLICKED(IDC_DRIVE4CHECK, OnDrive4check)
	ON_BN_CLICKED(IDC_DRIVE5CHECK, OnDrive5check)
	ON_BN_CLICKED(IDC_DRIVE6CHECK, OnDrive6check)
	ON_BN_CLICKED(IDC_DRIVE7CHECK, OnDrive7check)
	ON_BN_CLICKED(IDC_DRIVE8CHECK, OnDrive8check)
	ON_BN_CLICKED(IDC_CLEAR_DRIVES, OnClearDrives)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDriveDialog message handlers

void CDriveDialog::SetButtons( void )
{
	int i;
	int nDlgCheckID[8] = { IDC_DRIVE1CHECK, IDC_DRIVE2CHECK, IDC_DRIVE3CHECK, IDC_DRIVE4CHECK,
		IDC_DRIVE5CHECK, IDC_DRIVE6CHECK, IDC_DRIVE7CHECK, IDC_DRIVE8CHECK };

	CButton	*cbCheckBox;
	for( i=0; i < 8; i++ )
	{
		SetDlgItemText( nDlgEditID[i], new_sio_filename[i] );
		if( strcmp( new_sio_filename[i], "Off" ) )
		{
			cbCheckBox = (CButton *)GetDlgItem( nDlgCheckID[i] );
			cbCheckBox->SetCheck( 1 );
			nDriveEnabled[i] = 1;
		}
	}
}

//We set the drive edit boxes to the the appropriate values, and check or uncheck
//the "Enabled" boxes as well
BOOL CDriveDialog::OnInitDialog() 
{
	int i;
	CDialog::OnInitDialog();
	ZeroMemory( nDriveEnabled, sizeof( int ) << 3 );

	for( i = 0; i < 8; i++ )
		strcpy( new_sio_filename[i], sio_filename[i] );
	SetButtons();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//GetDiskImage will call up a file dialog, and if the user oks the file will copy
//it's name into the appropriate edit box. The drives are not unmounted/mounted 
//until the OK button is pushed, in case the user decides to cancel the entire 
//operation. So the edit boxes are being used as temporary buffers, basically
BOOL CDriveDialog::GetDiskImage( int idnum, int disknum )
{
	CString	name;
	char	szCurDir[ MAX_PATH ];

	char BASED_CODE szFilter[] = "Atari disk images (*.atr,*.xfd)|*.atr;*.xfd|ATR Images only (*.atr)|*.atr|XFD Images only (*.xfd)|*.xfd|All Files (*.*)|*.*||";
	CFileDialog	dlgDiskImage( TRUE, NULL, NULL, OFN_EXPLORER | OFN_FILEMUSTEXIST, szFilter, this );

	GetCurrentDirectory( MAX_PATH, szCurDir );
	if( strcmp( new_sio_filename[ disknum ], "Empty" ) && strcmp( new_sio_filename[ disknum ], "None" ) &&
		strcmp( new_sio_filename[ disknum ], "Off" ) )
	{
		char	szNewDir[ MAX_PATH ];
		int i;

		strcpy( szNewDir, new_sio_filename[ disknum ] );
		for( i=strlen( szNewDir ); i > 0 && szNewDir[i]!='\\'; i--);
		if( i > 0 )
			szNewDir[i] = 0;
		SetCurrentDirectory( szNewDir );
	}

	if( dlgDiskImage.DoModal() == IDOK )
	{
		name = dlgDiskImage.GetPathName();
		SetDlgItemText( idnum, name.GetBuffer(0) );
		strcpy( new_sio_filename[disknum], name.GetBuffer(0) );
		name.ReleaseBuffer();

		return TRUE;
	}
	SetCurrentDirectory( szCurDir );

	return FALSE;
}

//The various OnDriveX()s just call GetDiskImage with the appropriate identifiers
void CDriveDialog::OnDrive1() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT1, 0 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[0] )
		SetButtons();
}

void CDriveDialog::OnDrive2() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT2, 1 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[1] )
		SetButtons();
}

void CDriveDialog::OnDrive3() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT3, 2 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[2] )
		SetButtons();
}

void CDriveDialog::OnDrive4() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT4, 3 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[3] )
		SetButtons();
}

void CDriveDialog::OnDrive5() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT5, 4 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[4] )
		SetButtons();
}

void CDriveDialog::OnDrive6() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT6, 5 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[5] )
		SetButtons();
}

void CDriveDialog::OnDrive7() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT7, 6 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[6] )
		SetButtons();
}

void CDriveDialog::OnDrive8() 
{
	int	nButton;

	if( GetDiskImage( IDC_EDIT8, 7 ) )
		nButton = 1;
	else
		nButton = 0;

	if( nButton != nDriveEnabled[7] )
		SetButtons();
}

//SetDriveCheck will set the text for the edit of given DRIVE appropriately. Once 
//again no actual operations are taken here; it's just stored in the edit box and
//the OnOK handler will decide what changes need to be made
void CDriveDialog::SetDriveCheck( int idnum, int drive )
{
	if( nDriveEnabled[ drive ] )
	{
		SetDlgItemText( idnum, "Off" );
		nDriveEnabled[ drive ] = 0;
	}
	else
	{
		SetDlgItemText( idnum, new_sio_filename[ drive ] );
		nDriveEnabled[ drive ] = 1;
	}
}

void CDriveDialog::OnDrive1check() 
{
	SetDriveCheck( IDC_EDIT1, 0 );
}

void CDriveDialog::OnDrive2check() 
{
	SetDriveCheck( IDC_EDIT2, 1 );
}

void CDriveDialog::OnDrive3check() 
{
	SetDriveCheck( IDC_EDIT3, 2 );
}

void CDriveDialog::OnDrive4check() 
{
	SetDriveCheck( IDC_EDIT4, 3 );
}

void CDriveDialog::OnDrive5check() 
{
	SetDriveCheck( IDC_EDIT5, 4 );
}

void CDriveDialog::OnDrive6check() 
{
	SetDriveCheck( IDC_EDIT6, 5 );
}

void CDriveDialog::OnDrive7check() 
{
	SetDriveCheck( IDC_EDIT7, 6 );
}

void CDriveDialog::OnDrive8check() 
{
	SetDriveCheck( IDC_EDIT8, 7 );
}

//The reason for doing this here instead of just doing it in GetDiskImage is
//to preserve the ability to cancel the entire drive operation with one
//click of the cancel button.
void CDriveDialog::OnOK() 
{
	int i;
	char	szFileName[ MAX_PATH ];
	BOOL	bDrivesChanged = FALSE;

	for( i = 0; i < 8; i++ )
	{
		if( !nDriveEnabled[i] )
		{
			if( strcmp( sio_filename[i], "Off" ) )
			{
				bDrivesChanged = TRUE;
				strcpy( sio_filename[i], "Off" );
				SIO_DisableDrive( i + 1 );
			}
		}
		else
		{
			GetDlgItemText( nDlgEditID[i], szFileName, MAX_PATH );
			if( strcmp( szFileName, sio_filename[i] ) )
			{
				bDrivesChanged = TRUE;
				strcpy( sio_filename[i], szFileName );
				if( !strcmp( szFileName, "Empty" ) )
					SIO_Dismount( i + 1 );
				else
				{
					SIO_Dismount( i + 1 );
					SIO_Mount( i + 1, szFileName );		
				}
			}
		}
	}

	if( bDrivesChanged )
	{
		HKEY	hkKey;

		if( RegOpenKeyEx(
			HKEY_CURRENT_USER,		// handle of open key 
			REGNAME,				// address of name of subkey to open 
			0,						// reserved 
			KEY_WRITE,				// security access mask 
			&hkKey 					// address of handle of open key 
			)!=ERROR_SUCCESS )
		{
			LoadString( NULL, IDS_REG_OPEN_ERROR, gcErrorString, LOADSTRING_STRING_SIZE );
			AfxGetMainWnd()->MessageBox( gcErrorString, "Atari800Win", MB_ICONSTOP );
			CDialog::OnOK();
		}

		WriteRegString( hkKey, REG_DRIVE1, sio_filename[0] );
		WriteRegString( hkKey, REG_DRIVE2, sio_filename[1] );
		WriteRegString( hkKey, REG_DRIVE3, sio_filename[2] );
		WriteRegString( hkKey, REG_DRIVE4, sio_filename[3] );
		WriteRegString( hkKey, REG_DRIVE5, sio_filename[4] );
		WriteRegString( hkKey, REG_DRIVE6, sio_filename[5] );
		WriteRegString( hkKey, REG_DRIVE7, sio_filename[6] );
		WriteRegString( hkKey, REG_DRIVE8, sio_filename[7] );
		RegCloseKey( hkKey );
	}
	
	CDialog::OnOK();
}


void CDriveDialog::OnClearDrives() 
{
	int i;

	for( i=0; i < 8; i++ )
	{
		if( nDriveEnabled[i] ) 
			SetDlgItemText( nDlgEditID[i], "Empty" );
		else
			SetDlgItemText( nDlgEditID[i], "Off" );
	}
}

