#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<pc.h>
#include 	<conio.h>
#include 	<unistd.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>

/* #define	DO_R */
#define DO_SOCK

#ifdef VMS
#include	<unixio.h>
#include	<file.h>
#else
#include	<fcntl.h>
#ifndef	AMIGA
#ifndef WIN32
#include	<unistd.h>
#endif
#endif
#endif



#define	DO_DIR

#ifdef AMIGA
#undef	DO_DIR
#endif

#ifdef VMS
#undef	DO_DIR
#endif

#ifdef WIN32
#include <io.h>
#include <sys/stat.h>
#include "windows.h"
#endif

#ifdef DO_DIR
#ifndef WIN32
#include	<dirent.h>
#endif
#endif

#define FALSE   0
#define TRUE    1

#include "atari.h"
#include "cpu.h"
#include "memory.h"
#include "devices.h"
#include "rt-config.h"
#include "log.h"


/* Need to put this in the ui menu. */
/* Used for real dial-up. */
#define COM_PORT        COM2
/* Used for NETFOSSIL, port #6. */
/* #define COM_PORT        COM6 */
#define BAUD_RATE       115200
#define COM_SETTINGS    (BITS_8 | STOP_1 | NO_PARITY)



#define	ICHIDZ	0x0020
#define	ICDNOZ	0x0021
#define	ICCOMZ	0x0022
#define	ICSTAZ	0x0023
#define	ICBALZ	0x0024
#define	ICBAHZ	0x0025
#define	ICPTLZ	0x0026
#define	ICPTHZ	0x0027
#define	ICBLLZ	0x0028
#define	ICBLHZ	0x0029
#define	ICAX1Z	0x002a
#define	ICAX2Z	0x002b

#define Peek(a)    (dGetByte((a)))
#define DPeek(a)   (dGetByte((a))+( dGetByte((a)+1)<<8 ) )
#define Poke(x,y)  (dPutByte((x),(y)))
/* #define DPoke(x,y) (dPutByte((x),(y))) */

static int connected;
static int do_once;

static char *H[5] =
{
	".",
	atari_h1_dir,
	atari_h2_dir,
	atari_h3_dir,
	atari_h4_dir
};

static int devbug = FALSE;

static FILE *fp[8] =
{NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};
static int flag[8];

static int fid;
static char filename[64];



static char IACdoBinary[3] =
{255,253,0};
static char IACwillBinary[3] =
{255,251,0};
static char IACdontLinemode[3] =
{255,254,34};
static char IACwontLinemode[3] =
{255,252,34};


char *strtoupper(char *str)
{
	char *ptr;
	for (ptr = str; *ptr; ptr++)
		*ptr = toupper(*ptr);

	return str;
}

void Device_Initialise(int *argc, char *argv[])
{
	int i;
	int j;

	for (i = j = 1; i < *argc; i++) {
		if (strncmp(argv[i], "-H1", 2) == 0)
			H[1] = argv[i] + 2;
		else if (strncmp(argv[i], "-H2", 2) == 0)
			H[2] = argv[i] + 2;
		else if (strncmp(argv[i], "-H3", 2) == 0)
			H[3] = argv[i] + 2;
		else if (strncmp(argv[i], "-H4", 2) == 0)
			H[4] = argv[i] + 2;
		else if (strcmp(argv[i], "-devbug") == 0)
			devbug = TRUE;
		else
			argv[j++] = argv[i];
	}

	if (devbug)
		Aprint("H%d: %s", i, H[i]);

	*argc = j;
}

int Device_isvalid(char ch)
{
	int valid;

#ifdef WIN32
  if( isalnum(ch) && ch!=-101 )
#else
	if (isalnum(ch))
#endif
		valid = TRUE;
	else
		switch (ch) {
		case ':':
		case '.':
		case '_':
		case '*':
		case '?':
		case '>':
		case '<':
			valid = TRUE;
			break;
		default:
			valid = FALSE;
			break;
		}

	return valid;
}

void Device_GetFilename()
{
	int bufadr;
	int offset = 0;
	int devnam = TRUE;

	bufadr = (dGetByte(ICBAHZ) << 8) | dGetByte(ICBALZ);

	while (Device_isvalid(dGetByte(bufadr))) 
		{
		int byte = dGetByte(bufadr);

			if (!devnam) {
				if(byte == '>')
				{
					byte = '\\';
				}
				else
				{
					if (isupper(byte))
						byte = tolower(byte);
				}

			filename[offset++] = byte;
		}
		else if (byte == ':')
			devnam = FALSE;

		bufadr++;
	}

	filename[offset++] = '\0';
}

int match(char *pattern, char *filename)
{
	int status = TRUE;

	while (status && *filename && *pattern) {
		switch (*pattern) {
		case '?':
			pattern++;
			filename++;
			break;
		case '*':
			if (*filename == pattern[1]) {
				pattern++;
			}
			else {
				filename++;
			}
			break;
		default:
			status = (*pattern++ == *filename++);
			break;
		}
	}
	if ((*filename)
		|| ((*pattern)
			&& (((*pattern != '*') && (*pattern != '?'))
				|| pattern[1]))) {
		status = 0;
	}
	return status;
}

void Device_HHOPEN(void)
{
	char fname[128];
	int devnum;
	int temp;
	char mask[256];

FILE *fd;
FILE *fd2;

char str1[256];
char str2[256];
char sparta[256];

unsigned char i, j;
char *ptr1;
unsigned int free;




	if (devbug)
		Aprint("HHOPEN");

	fid = dGetByte(0x2e) >> 4;

	if (fp[fid]) {
		fclose(fp[fid]);
		fp[fid] = NULL;
	}
/*
   flag[fid] = (memory[ICDNOZ] == 2) ? TRUE : FALSE;
 */
	Device_GetFilename();
/*
   if (memory[ICDNOZ] == 0)
   sprintf (fname, "./%s", filename);
   else
   sprintf (fname, "%s/%s", h_prefix, filename);
 */
	devnum = dGetByte(ICDNOZ);
	if (devnum > 9) {
		Aprint("Attempt to access H%d: device", devnum);
		return;
	}
	if (devnum >= 5) {
		flag[fid] = TRUE;
		devnum -= 5;
	}
	else {
		flag[fid] = FALSE;
	}

#ifdef VMS
/* Assumes H[devnum] is a directory _logical_, not an explicit directory
   specification! */
	sprintf(fname, "%s:%s", H[devnum], filename);
#else
/*
#ifdef BACK_SLASH
	sprintf (fname, "%s\\%s", H[devnum], filename);
#else
	sprintf(fname, "%s/%s", H[devnum], filename);
#endif
*/
	strcpy(fname,H[devnum]);

	/* Aprint("%s\n",filename); */


	if(filename[0] != 92)
	{
		strcat(fname,"\\");
	}


	strcat(fname,filename);


#endif

	temp = dGetByte(ICAX1Z);

	switch (temp) {
	case 4:
		if (devbug)
			Aprint(fname);

		fp[fid] = fopen(fname, "rb");
		if (fp[fid]) {
			regY = 1;
			ClrN;
		}
		else {
			regY = 170;
			SetN;
		}
		break;
	case 6:
	case 7:
#ifdef DO_DIR
#ifndef WIN32

/* open directory */

		fp[fid] = tmpfile();
		if (fp[fid]) 
		{


	strcpy(mask,"dir ");
	strcat(mask,H[devnum]);

	/* Aprint("%s\n",filename); */


	if(filename[0] != 92)
	{
		strcat(mask,"\\");
	}


	strcat(mask,filename);
	strcat(mask," > c:\\t.txt\n");

/*
	for(i=0;i<=strlen(mask);i++)
	{
		if(mask[i] == ">")
			mask[i] = "\\";
	}
*/

	Aprint(mask); 

	system(mask);
	fd2 = fopen("c:\\t.txt", "r");
	fd = fopen("c:\\t2.txt", "w");

	if(!fd)
	{
		Aprint("ERROR! Cannot open directory!\n");
		return;
	}

/* Do sparta directory */

	fgets(str1, 256, fd2); /* blank line */
	fgets(str1, 256, fd2); /* Volume in drive D has no label */
	fprintf(fd, "\n");

	fprintf(fd,"Volume:    ");
	str2[0] = 0;
	strncat(str2, str1, 8);
	strcat(str2,"\n");
	fprintf(fd,"%s",str2);

	fprintf(fd,"Directory: ");


	fgets(str1, 256, fd2); /* Volume Serial Number is 3D1B-10FD */
	fgets(str1, 256, fd2); /* Directory of D:\Djgpp\proxy */

	ptr1 = strchr(str1, '\\');

	while(ptr1 != 0)
	{
		ptr1 = strchr(str1, '\\');
		if(ptr1 != 0)
		{
			*ptr1++;
			strcpy(str2,ptr1);
			strcpy(str1,str2);
		}
	}
	fprintf(fd,str1);
	fprintf(fd,"\n");

	fgets(str1, 256, fd2); /* blank line */

	while (fgets(str1, 256, fd2)) 
	{
		if(str1[0] == ".")
			goto short_loop;

		if(str1[6] == '~')
			str1[6] = '_';

		sparta[0] = 0;
		strncat(sparta,str1,13);


		if(str1[15] == '<')
		{
			strncat(sparta,str1+15,6);
			strcat(sparta, " ");

/* get date, time */

			if(str1[28] == '0')
				str1[28] = ' ';
			strncat(sparta,str1+28,15);

			strcat(sparta,"\n"); 
			fprintf(fd,"%s",sparta);

		}

		else if(strncmp(str1+11,"file(s)",7) == 0)
		{
		}
		else if(strncmp(str1+11,"dir(s)",6) == 0)
		{



			str2[0] = 0;
			strncat(str2,str1+20,13);

/* strip comma in bytes free, if any */
			j = 0;
			for(i=0;i<21;i++)
			{
				if(str2[i] !=',')
				{
					str2[j] = str2[i];
					j++;
				}
			}

			strcpy(sparta," ");
			free = atoi(str2);
			free = free/256;
			itoa(free,str2,10);
			strcat(sparta, str2);
			while(strlen(sparta)<7)
			{
				strcat(sparta, " ");
			}

			strcat(sparta, "FREE SECTORS");
			strcat(sparta,"\n"); 
			fprintf(fd,"%s",sparta);


		}

		else
		{
/*			printf("regular file\n"); */
/* process filesize */
			str2[0] = 0;
			strncat(str2,str1+19,7);

/* strip comma in filesize, if any */
			j = 0;
			for(i=0;i<8;i++)
			{
				if(str2[i] !=',')
				{
					str2[j] = str2[i];
					j++;
				}
			}


			strncat(sparta,str2,6);
			strcat(sparta, " ");

/* get date, time */

			if(str1[28] == '0')
				str1[28] = ' ';
			strncat(sparta,str1+28,15);

			strcat(sparta,"\n"); 
			fprintf(fd,"%s",sparta);

		}

short_loop:

	}

	fclose(fd);
	fclose(fd2);




				fd2 = fopen("c:\\t2.txt", "r");
				fp[fid] = fd2;


				regY = 1;
				ClrN;

				rewind(fp[fid]);

				flag[fid] = TRUE;

		}
          else
#else	/* WIN32 DIR code */
		  fp[fid] = tmpfile ();
	  if( fp[fid] )
	  {
		  WIN32_FIND_DATA FindFileData;
		  HANDLE	hSearch;
		  char filesearch[ MAX_PATH ];
		  
		  strcpy( filesearch, H[devnum] );
		  strcat( filesearch, "\\*.*" );
		  
		  hSearch = FindFirstFile( filesearch, &FindFileData );
		  
		  if( hSearch )
		  {
			  FindNextFile( hSearch, &FindFileData );
			  
			  while( FindNextFile( hSearch, &FindFileData ) )
			  {
				  if( (match( filename, FindFileData.cFileName )) )
					  fprintf (fp[fid],"%s\n", FindFileData.cFileName );
			  }
			  
			  FindClose( hSearch );
			  regY = 1;
			  ClrN;
			  
			  rewind (fp[fid]);
			  
			  flag[fid] = TRUE;
		  }
		  else
		  {
			  regY = 163;
			  SetN;
			  fclose (fp[fid]);
			  fp[fid] = NULL;
		  }
	  }
	  else
#endif /* Win32 */
#endif /* DO_DIR */
		{
			regY = 163;
			SetN;
		}
		break;
	case 8:
		fp[fid] = fopen(fname, "wb");
		if (fp[fid]) {
			regY = 1;
			ClrN;
		}
		else {
			regY = 170;
			SetN;
		}
		break;
	default:
		regY = 163;
		SetN;
		break;
	}
}

void Device_HHCLOS(void)
{
	if (devbug)
		Aprint("HHCLOS");

	fid = dGetByte(0x2e) >> 4;

	if (fp[fid]) {
		fclose(fp[fid]);
		fp[fid] = NULL;
	}
	regY = 1;
	ClrN;
}

void Device_HHREAD(void)
{
	if (devbug)
		Aprint("HHREAD");

	fid = dGetByte(0x2e) >> 4;

	if (fp[fid]) {
		int ch;

		ch = fgetc(fp[fid]);
		if (ch != EOF) {
			if (flag[fid]) {
				switch (ch) {
				case '\n':
					ch = 0x9b;
					break;
				default:
					break;
				}
			}
			regA = ch;
			regY = 1;
			ClrN;
		}
		else {
			regY = 136;
			SetN;
		}
	}
	else {
		regY = 163;
		SetN;
	}
}

void Device_HHWRIT(void)
{
	if (devbug)
		Aprint("HHWRIT");

	fid = dGetByte(0x2e) >> 4;

	if (fp[fid]) {
		int ch;

		ch = regA;
		if (flag[fid]) {
			switch (ch) {
			case 0x9b:
				ch = 0x0a;
				break;
			default:
				break;
			}
		}
		fputc(ch, fp[fid]);
		regY = 1;
		ClrN;
	}
	else {
		regY = 163;
		SetN;
	}
}

void Device_HHSTAT(void)
{
	if (devbug)
		Aprint("HHSTAT");

	fid = dGetByte(0x2e) >> 4;

	regY = 146;
	SetN;
}

void Device_HHSPEC(void)
{
	if (devbug)
		Aprint("HHSPEC");

	fid = dGetByte(0x2e) >> 4;

	switch (dGetByte(ICCOMZ)) {
	case 0x20:
		Aprint("RENAME Command");
		break;
	case 0x21:
		Aprint("DELETE Command");
		break;
	case 0x23:
		Aprint("LOCK Command");
		break;
	case 0x24:
		Aprint("UNLOCK Command");
		break;
	case 0x25:
		Aprint("NOTE Command");
		break;
	case 0x26:
		Aprint("POINT Command");
		break;
/* 0x27, decimal 39 goes here, file length */

	case 0xFE:
		Aprint("FORMAT Command");
		break;
	default:
		Aprint("UNKNOWN Command");
		break;
	}

	regY = 146;
	SetN;
}

void Device_HHINIT(void)
{
	if (devbug)
		Aprint("HHINIT");
}

/**********************************************/
/*             R: stuff                       */
/**********************************************/
UBYTE r_dtr, r_rts, r_sd;
UBYTE r_dsr, r_cts, r_cd;
UBYTE r_parity, r_stop;
UBYTE r_error, r_in;
unsigned int r_stat;
unsigned int svainit;




 struct sockaddr_in in;
 struct sockaddr_in peer_in;
 int sock;
 char PORT[256];
 char MESSAGE[256];
 int newsock;
 int len;
 char buf[256];
 fd_set fd;
 struct timeval tv;
 char str[256];
 int retval;
 char buffer[200];
 char reading=0;
 unsigned char one;
 unsigned char bufout[256];
 unsigned char bufend = 0;
 char temp1;
 char temp2;
 int bytesread;
 int concurrent;



void xio_34(void)
{
int temp;
int fid;

/* Controls handshake lines DTR, RTS, SD */

fid = dGetByte(0x2e) >> 4;
temp = dGetByte(ICAX1Z);

	if(temp & 128)
	{
		if(temp & 64)
		{
/* turn DTR on */
		}
		else
		{
			if(connected != 0)
			{
	        		close ( newsock );
				connected = 0;
				do_once = 0;
				bufend = 0;
			}
		}
	}
	regA = 1;
	regY = 1;
	ClrN;

	Poke(747,0);
}

void xio_36(void)
{
/* Sets baud, stop bits, and ready monitoring. */

  	r_cd = dGetByte(ICAX2Z);


	regA = 1;
	regY = 1;
	ClrN;
	Poke(747,0);

}



void xio_38(void)
{
/* Translation and parity */
	regA = 1;
	regY = 1;
	ClrN;
	Poke(747,0);

}

void xio_40(void)
{

/* Sets concurrent mode.  Also checks for dropped carrier. */

/*
		if(connected == 0)
			Poke(747,0);
*/

	Poke(747,0);
		regA = 1;
		regY = 1;
		ClrN;
		concurrent = 1;


}


void Device_ROPEN(void)
{


	Poke(747,0);
	regA = 1;
	regY = 1;
	ClrN;


}

void Device_RCLOSE(void)
{
	Poke(747,0);
	bufend = 0;
	regA = 1;
	regY = 1;
	ClrN;
	concurrent = 0;
}

void Device_RREAD(void)


{
char j;



		if(bufend > 0) 
		{
			regA = bufout[1];
			regY = 1;
			ClrN;

			bufend--;
			Poke(747,bufend);



			j = 1;

			for(j = 1; j <= bufend; j++)
			{
				bufout[j] = bufout[j+1];
			}

			return;
                }
}



void Device_RWRITE(void)
{
	if(connected != 0)
	{
		if(regA == 255)
			retval = write(newsock, &regA, 1); /* IAC escape sequence */

		retval = write(newsock, &regA, 1); /* returns -1 if disconnected */
		if(retval == -1)
		{
			Aprint("Error on R: write.");

                }
		else
		{
			Poke(749,0);
			regA = 1;
			regY = 1;
			ClrN;
		}
		Poke(749,0); /* bytes waiting to be sent */
		return;
	}


}

void Device_RSTAT(void)
{
static char IACctr = 0;

/* are we connected? */
	regA = 1;
	regY = 1;
	ClrN;


	if(connected == 0)
	{

		if(do_once == 0)
		{
			strcpy(PORT,"23\n");
/* Set up the listening port. */
			do_once = 1;
			memset ( &in, 0, sizeof ( struct sockaddr_in ) );
 			sock = socket ( AF_INET, SOCK_STREAM, 0 );
 			in.sin_family = AF_INET;
 			in.sin_addr.s_addr = INADDR_ANY;
 			in.sin_port = htons ( atoi ( PORT ) );
 			bind ( sock, (struct sockaddr *)&in, sizeof ( struct sockaddr_in ) );
 			listen ( sock, 5 );
/* 			sethostent(1); */
 			retval = fcntl( sock, F_SETFL, O_NONBLOCK);
 			len = sizeof ( struct sockaddr_in );
			connected = 0;
			bufend = 0;
			Aprint("Socket is listening.");
		}

		newsock = accept ( sock, (struct sockaddr *)&peer_in, &len );
		if(newsock != -1)
		{
			Aprint("Connected.");
			retval = fcntl( newsock, F_SETFL, O_NONBLOCK);
			connected = 1;
/*
			retval = write(newsock, &IACdoBinary, 3); 
			retval = write(newsock, &IACwillBinary, 3); 
			retval = write(newsock, &IACdontLinemode, 3); 
			retval = write(newsock, &IACwontLinemode, 3); 
*/


                        strcat(bufout,"\r\nCONNECT 19200\r\n");
			bufend = 17;
			Poke(747,17);
/*
			bufout[1] = 13;
			bufend = 1;
			Poke(747,1);
*/
			close(sock);
			return;
		}
	}




	if(concurrent == 1)
	{
			bytesread = read(newsock, &one,1 );
			if(bytesread > 0)
			{





				if(one == 255)
				{
					while((bytesread=read(newsock, &one,1 ))==0) {}
					if(one == 255)
					{
						bufend++;
						bufout[bufend] = one;
						Poke(747,bufend);
						regA = 1;
						regY = 1;
						ClrN;
						return;
					}
					else
					{
						while((bytesread=read(newsock, &one,1 ))==0) {}

						regA = 1;
						regY = 1;
						ClrN;
						return;
					}
				}
				else






				{
					bufend++;
					bufout[bufend] = one;
					Poke(747,bufend);
					regA = 1;
					regY = 1;
					ClrN;
					return;
				}

			}

	}
	else
	{
		Poke(747,8);
		regA = 1;
		regY = 1;
		ClrN;
		return;
	}









}

void Device_RSPEC(void)
{
	r_in = Peek(ICCOMZ);
/*
	Aprint( "R: device special" );

	Aprint("ICCOMZ =");
	Aprint("%d",r_in);
	Aprint("^^ in ICCOMZ");
*/

	switch (r_in) {
		case 34:
			xio_34();
			break;
		case 36:
			xio_36();
			break;
		case 38:
			xio_38();
			break;
		case 40:
			xio_40();
			break;
		default:
			Aprint("Unsupported XIO #.");
			break;
	}
/*
	regA = 1;
	regY = 1;
	ClrN;
*/

}

void Device_RINIT(void)
{
/*
	Aprint( "R: device init" );
	Aprint("ICCOMZ =");
	r_in = Peek(ICCOMZ);
	Aprint("%d",r_in);
*/
	regA = 1;
	regY = 1;
	ClrN;
}



static int phfd = -1;
void Device_PHCLOS(void);
static char *spool_file = NULL;

void Device_PHOPEN(void)
{
	if (devbug)
		Aprint("PHOPEN");

	if (phfd != -1)
		Device_PHCLOS();

	spool_file = tmpnam(NULL);
	phfd = open(spool_file, O_CREAT | O_TRUNC | O_WRONLY, 0777);
	if (phfd != -1) {
		regY = 1;
		ClrN;
	}
	else {
		regY = 130;
		SetN;
	}
}

void Device_PHCLOS(void)
{
	if (devbug)
		Aprint("PHCLOS");

	if (phfd != -1) {
		char command[256];
		int status;

		close(phfd);

		sprintf(command, print_command, spool_file);
		system(command);

#ifndef VMS
#ifndef WIN32
		status = unlink(spool_file);
		if (status == -1) {
			perror(spool_file);
			exit(1);
		}
#endif
#endif

		phfd = -1;
	}
	regY = 1;
	ClrN;
}

void Device_PHREAD(void)
{
	if (devbug)
		Aprint("PHREAD");

	regY = 146;
	SetN;
}

void Device_PHWRIT(void)
{
	unsigned char byte;
	int status;

	if (devbug)
		Aprint("PHWRIT");

	byte = regA;
	if (byte == 0x9b)
		byte = '\n';

	status = write(phfd, &byte, 1);
	if (status == 1) {
		regY = 1;
		ClrN;
	}
	else {
		regY = 144;
		SetN;
	}
}

void Device_PHSTAT(void)
{
	if (devbug)
		Aprint("PHSTAT");
}

void Device_PHSPEC(void)
{
	if (devbug)
		Aprint("PHSPEC");

	regY = 1;
	ClrN;
}

void Device_PHINIT(void)
{
	if (devbug)
		Aprint("PHINIT");

	phfd = -1;
	regY = 1;
	ClrN;
}
