
/************/
/** trim.c **/
/************/

/* (c) 1997 by Sidney Cadot */

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

int
main (int argc, char *argv[])

{
  unsigned long BYTES;
  int file;

  if (argc != 3)
    {
      puts ("\nUsage: TRIM <count> <file>");
      return EXIT_FAILURE;
    }

  if (sscanf (argv[1], "%lu", &BYTES) != 1)
    {
      puts ("\nERROR: <count> not ok.");
      return EXIT_FAILURE;
    }

  file = open (argv[2], O_WRONLY);

  if (file < 0)
    {
      puts ("\nERROR: unable to open file.");
      return EXIT_FAILURE;
    }

  if (ftruncate (file, BYTES) != 0)
    {
      puts ("\nERROR: unable to truncate file.");
      close (file);
      return EXIT_FAILURE;
    }

  close (file);

  return EXIT_SUCCESS;
}
