	.Xlist
	Page	58,132
	Subttl	EQUATES.INC	Apple Emulator (65C02 Processor)
;******************************************************************************
;
;   Name:	EQUATES 	Apple Emulator (65C02 Processor)
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the equates needed by the
;	Apple emulator. This module can be included with any needed
;	source files to define the Apple emulator equates.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
OP_SIZE 	Equ	80h			; Op-code size (128 Bytes)
OP_BASE 	Equ	01h			; Op-code base (Op_Size Log 2)
STACK_SIZE	Equ	4000h			; 16k emulator stack size
PRIVATE_SIZE	Equ	0100h			; Private stack size value
RAM_SIZE	Equ	1000h			; Apple RAM space size (64k)
CGA_SEGMENT	Equ	0B800h			; CGA Video RAM segment value
EGA_SEGMENT	Equ	0A000h			; EGA Video RAM segment value
STACK_TOP	Equ	01FFh			; Default 65C02 stack top
FILLER		Equ	00h			; Filler byte value
SLOT_MAX	Equ	08h			; Number of expansion slots
INPUT_SIZE	Equ	50h			; Input buffer size (Bytes)
PARM_SIZE	Equ	80h			; Parameter buffer size (Bytes)
DATA_SIZE	Equ	40h			; Data buffer size (Bytes)
BREAKPOINTS	Equ	0Ah			; Number of breakpoint entries
HARDWARE_PAGE	Equ	0C0h			; Hardware page number
PAGE_SIZE	Equ	0100h			; 65C02 memory page size (Bytes)
BIOS		Equ	0040h			; ROM BIOS data segment
OFF_CURSOR	Equ	2000h			; Cursor off start/end values
ON_CURSOR	Equ	0607h			; Cursor on start/end values
;******************************************************************************
;
;	DEFINE THE COUNT TABLE
;
;******************************************************************************
;COUNT TICKS
C00             EQU     7               ; 00h
C01             EQU     6               ; 01h
C02             EQU     0               ; 02h
C03             EQU     0               ; 03h
C04             EQU     5               ; 04h
C05             EQU     3               ; 05h
C06             EQU     5               ; 06h
C07             EQU     5               ; 07h
C08             EQU     3               ; 08h
C09             EQU     2               ; 09h
C0A             EQU     2               ; 0Ah
C0B             EQU     0               ; 0Bh
C0C             EQU     6               ; 0Ch
C0D             EQU     4               ; 0Dh
C0E             EQU     6               ; 0Eh
C0F             EQU     5               ; 0Fh
C10             EQU     3               ; 10h
C11             EQU     5               ; 11h
C12             EQU     5               ; 12h
C13             EQU     0               ; 13h
C14             EQU     5               ; 14h
C15             EQU     4               ; 15h
C16             EQU     6               ; 16h
C17             EQU     5               ; 17h
C18             EQU     2               ; 18h
C19             EQU     4               ; 19h
C1A             EQU     2               ; 1Ah
C1B             EQU     0               ; 1Bh
C1C             EQU     6               ; 1Ch
C1D             EQU     4               ; 1Dh
C1E             EQU     7               ; 1Eh
C1F             EQU     5               ; 1Fh
C20             EQU     6               ; 20h
C21             EQU     6               ; 21h
C22             EQU     0               ; 22h
C23             EQU     0               ; 23h
C24             EQU     3               ; 24h
C25             EQU     3               ; 25h
C26             EQU     5               ; 26h
C27             EQU     5               ; 27h
C28             EQU     4               ; 28h
C29             EQU     2               ; 29h
C2A             EQU     2               ; 2Ah
C2B             EQU     0               ; 2Bh
C2C             EQU     4               ; 2Ch
C2D             EQU     4               ; 2Dh
C2E             EQU     6               ; 2Eh
C2F             EQU     5               ; 2Fh
C30             EQU     3               ; 30h
C31             EQU     5               ; 31h
C32             EQU     5               ; 32h
C33             EQU     0               ; 33h
C34             EQU     4               ; 34h
C35             EQU     4               ; 35h
C36             EQU     6               ; 36h
C37             EQU     5               ; 37h
C38             EQU     2               ; 38h
C39             EQU     4               ; 39h
C3A             EQU     2               ; 3Ah
C3B             EQU     0               ; 3Bh
C3C             EQU     4               ; 3Ch
C3D             EQU     4               ; 3Dh
C3E             EQU     7               ; 3Eh
C3F             EQU     5               ; 3Fh
C40             EQU     6               ; 40h
C41             EQU     6               ; 41h
C42             EQU     0               ; 42h
C43             EQU     0               ; 43h
C44             EQU     0               ; 44h
C45             EQU     3               ; 45h
C46             EQU     5               ; 46h
C47             EQU     5               ; 47h
C48             EQU     3               ; 48h
C49             EQU     2               ; 49h
C4A             EQU     2               ; 4Ah
C4B             EQU     0               ; 4Bh
C4C             EQU     3               ; 4Ch
C4D             EQU     4               ; 4Dh
C4E             EQU     6               ; 4Eh
C4F             EQU     5               ; 4Fh
C50             EQU     3               ; 50h
C51             EQU     5               ; 51h
C52             EQU     5               ; 52h
C53             EQU     0               ; 53h
C54             EQU     0               ; 54h
C55             EQU     4               ; 55h
C56             EQU     6               ; 56h
C57             EQU     5               ; 57h
C58             EQU     2               ; 58h
C59             EQU     4               ; 59h
C5A             EQU     3               ; 5Ah
C5B             EQU     0               ; 5Bh
C5C             EQU     0               ; 5Ch
C5D             EQU     4               ; 5Dh
C5E             EQU     7               ; 5Eh
C5F             EQU     5               ; 5Fh
C60             EQU     6               ; 60h
C61             EQU     6               ; 61h
C62             EQU     0               ; 62h
C63             EQU     0               ; 63h
C64             EQU     3               ; 64h
C65             EQU     3               ; 65h
C66             EQU     5               ; 66h
C67             EQU     5               ; 67h
C68             EQU     4               ; 68h
C69             EQU     2               ; 69h
C6A             EQU     2               ; 6Ah
C6B             EQU     0               ; 6Bh
C6C             EQU     6               ; 6Ch
C6D             EQU     4               ; 6Dh
C6E             EQU     6               ; 6Eh
C6F             EQU     5               ; 6Fh
C70             EQU     3               ; 70h
C71             EQU     5               ; 71h
C72             EQU     5               ; 72h
C73             EQU     0               ; 73h
C74             EQU     4               ; 74h
C75             EQU     4               ; 75h
C76             EQU     6               ; 76h
C77             EQU     5               ; 77h
C78             EQU     2               ; 78h
C79             EQU     4               ; 79h
C7A             EQU     4               ; 7Ah
C7B             EQU     0               ; 7Bh
C7C             EQU     6               ; 7Ch
C7D             EQU     4               ; 7Dh
C7E             EQU     7               ; 7Eh
C7F             EQU     5               ; 7Fh
C80             EQU     3               ; 80h
C81             EQU     6               ; 81h
C82             EQU     0               ; 82h
C83             EQU     0               ; 83h
C84             EQU     3               ; 84h
C85             EQU     3               ; 85h
C86             EQU     3               ; 86h
C87             EQU     5               ; 87h
C88             EQU     2               ; 88h
C89             EQU     2               ; 89h
C8A             EQU     2               ; 8Ah
C8B             EQU     0               ; 8Bh
C8C             EQU     4               ; 8Ch
C8D             EQU     4               ; 8Dh
C8E             EQU     4               ; 8Eh
C8F             EQU     5               ; 8Fh
C90             EQU     3               ; 90h
C91             EQU     6               ; 91h
C92             EQU     5               ; 92h
C93             EQU     0               ; 93h
C94             EQU     4               ; 94h
C95             EQU     4               ; 95h
C96             EQU     4               ; 96h
C97             EQU     5               ; 97h
C98             EQU     2               ; 98h
C99             EQU     5               ; 99h
C9A             EQU     2               ; 9Ah
C9B             EQU     0               ; 9Bh
C9C             EQU     4               ; 9Ch
C9D             EQU     5               ; 9Dh
C9E             EQU     5               ; 9Eh
C9F             EQU     5               ; 9Fh
CA0             EQU     2               ; A0h
CA1             EQU     6               ; A1h
CA2             EQU     2               ; A2h
CA3             EQU     0               ; A3h
CA4             EQU     3               ; A4h
CA5             EQU     3               ; A5h
CA6             EQU     3               ; A6h
CA7             EQU     5               ; A7h
CA8             EQU     2               ; A8h
CA9             EQU     2               ; A9h
CAA             EQU     2               ; AAh
CAB             EQU     0               ; ABh
CAC             EQU     4               ; ACh
CAD             EQU     4               ; ADh
CAE             EQU     4               ; AEh
CAF             EQU     5               ; AFh
CB0             EQU     3               ; B0h
CB1             EQU     5               ; B1h
CB2             EQU     5               ; B2h
CB3             EQU     0               ; B3h
CB4             EQU     4               ; B4h
CB5             EQU     4               ; B5h
CB6             EQU     4               ; B6h
CB7             EQU     5               ; B7h
CB8             EQU     2               ; B8h
CB9             EQU     4               ; B9h
CBA             EQU     2               ; BAh
CBB             EQU     0               ; BBh
CBC             EQU     4               ; BCh
CBD             EQU     4               ; BDh
CBE             EQU     4               ; BEh
CBF             EQU     5               ; BFh
CC0             EQU     2               ; C0h
CC1             EQU     6               ; C1h
CC2             EQU     0               ; C2h
CC3             EQU     0               ; C3h
CC4             EQU     3               ; C4h
CC5             EQU     3               ; C5h
CC6             EQU     5               ; C6h
CC7             EQU     5               ; C7h
CC8             EQU     2               ; C8h
CC9             EQU     2               ; C9h
CCA             EQU     2               ; CAh
CCB             EQU     0               ; CBh
CCC             EQU     4               ; CCh
CCD             EQU     4               ; CDh
CCE             EQU     6               ; CEh
CCF             EQU     5               ; CFh
CD0             EQU     3               ; D0h
CD1             EQU     5               ; D1h
CD2             EQU     5               ; D2h
CD3             EQU     0               ; D3h
CD4             EQU     0               ; D4h
CD5             EQU     4               ; D5h
CD6             EQU     6               ; D6h
CD7             EQU     5               ; D7h
CD8             EQU     2               ; D8h
CD9             EQU     4               ; D9h
CDA             EQU     3               ; DAh
CDB             EQU     0               ; DBh
CDC             EQU     0               ; DCh
CDD             EQU     4               ; DDh
CDE             EQU     7               ; DEh
CDF             EQU     5               ; DFh
CE0             EQU     2               ; E0h
CE1             EQU     6               ; E1h
CE2             EQU     0               ; E2h
CE3             EQU     0               ; E3h
CE4             EQU     3               ; E4h
CE5             EQU     3               ; E5h
CE6             EQU     5               ; E6h
CE7             EQU     5               ; E7h
CE8             EQU     2               ; E8h
CE9             EQU     2               ; E9h
CEA             EQU     2               ; EAh
CEB             EQU     0               ; EBh
CEC             EQU     4               ; ECh
CED             EQU     4               ; EDh
CEE             EQU     6               ; EEh
CEF             EQU     5               ; EFh
CF0             EQU     3               ; F0h
CF1             EQU     5               ; F1h
CF2             EQU     5               ; F2h
CF3             EQU     0               ; F3h
CF4             EQU     0               ; F4h
CF5             EQU     4               ; F5h
CF6             EQU     6               ; F6h
CF7             EQU     5               ; F7h
CF8             EQU     2               ; F8h
CF9             EQU     4               ; F9h
CFA             EQU     4               ; FAh
CFB             EQU     0               ; FBh
CFC             EQU     0               ; FCh
CFD             EQU     4               ; FDh
CFE             EQU     7               ; FEh
CFF             EQU     5               ; FFh
;******************************************************************************
;
;	Define the 65C02 Interrupt Vector Addresses
;
;******************************************************************************
IRQ_VECTOR	Equ	0FFFEh			; IRQ interrupt vector address
BRK_VECTOR	Equ	0FFFEh			; BRK interrupt vector address
RST_VECTOR	Equ	0FFFCh			; RESET interrupt vector address
NMI_VECTOR	Equ	0FFFAh			; NMI interrupt vector address
ABT_VECTOR	Equ	0FFF8h			; ABORT interrupt vector address
;******************************************************************************
;
;	Define the BIOS equates needed
;
;******************************************************************************
VIDEO		Equ	10h			; BIOS video interrupt number
SET_MODE	Equ	00h			; Video set mode function code
CURSOR_TYPE	Equ	01h			; Video set cursor type code
WRITE_CURSOR	Equ	02h			; Video set cursor position code
READ_CURSOR	Equ	03h			; Video get cursor function code
SET_PALETTE	Equ	10h			; Video set pal. function code
SET_ALL 	Equ	02h			; Program all sub-function
PROGRAM_BLINK	Equ	03h			; Program blink sub-function
INTENSITY	Equ	00h			; Blink off value (Intensity)
BLINK		Equ	01h			; Blink on value (Blink)
ALT_SELECT	Equ	12h			; Alt. select function code
EGA_INFO	Equ	10h			; Return EGA info. sub-function
KEYBOARD	Equ	16h			; BIOS keyboard int. number
CHECK_KEY	Equ	01h			; Check key status function code
SHIFT_STATUS	Equ	02h			; Get shift status function code
;******************************************************************************
;
;	Define the MS-DOS equates needed
;
;******************************************************************************
DOS		Equ	21h			; MS-DOS interrupt number
SET_DTA 	Equ	1Ah			; Set DTA function code
SET_VECTOR	Equ	25h			; Set interrupt vector code
GET_VECTOR	Equ	35h			; Get interrupt vector code
OPEN_FILE	Equ	3Dh			; Open file function code
READ_ONLY	Equ	00h			; Read only access code
WRITE_ONLY	Equ	01h			; Write only access code
READ_WRITE	Equ	02h			; Read/write access code
CLOSE_FILE	Equ	3Eh			; Close file function code
READ_FILE	Equ	3Fh			; Read file function code
WRITE_FILE	Equ	40h			; Write file function code
SEEK_FILE	Equ	42h			; Seek file function code
ABSOLUTE	Equ	00h			; Absolute file seek code
RELATIVE	Equ	01h			; Relative file seek code
ALLOCATE_MEMORY Equ	48h			; Allocate memory function code
FREE_MEMORY	Equ	49h			; Free memory function code
TERMINATE	Equ	4Ch			; Terminate function code
FIND_FIRST	Equ	4Eh			; Find first function code
FIND_NEXT	Equ	4Fh			; Find next function code
;******************************************************************************
;
;	Define the Standard MS-DOS File Handles
;
;******************************************************************************
STD_INPUT	Equ	00h			; Standard input handle
STD_OUTPUT	Equ	01h			; Standard output handle
STD_ERROR	Equ	02h			; Standard error handle
STD_AUX 	Equ	03h			; Standard auxiliary handle
STD_PRINT	Equ	04h			; Standard print handle
;******************************************************************************
;
;	Define the 65C02 CPU flag byte (80x86 encoded format)
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Carry flag (0 = No carry, 1 = Carry)
;	 | | | | | | ---------> Mode flag (0 = Binary, 1 = Decimal [BCD])
;	 | | | | | -----------> Interrupt flag (0 = Not masked, 1 = Masked)
;	 | | | | -------------> Overflow flag (0 = No overflow, 1 = Overflow)
;	 | | | ---------------> Break flag (0 = Hardware, 1 = Software)
;	 | | -----------------> Reserved flag (Used for emulator break)
;	 | -------------------> Zero flag (0 = Non-zero, 1 = Zero)
;	 ---------------------> Negative flag (0 = Positive, 1 = Negative)
;
;******************************************************************************
CPU_C		Equ	01h			; CPU carry flag
CPU_M		Equ	02h			; CPU mode flag
CPU_I		Equ	04h			; CPU interrupt disable flag
CPU_V		Equ	08h			; CPU overflow flag
CPU_B		Equ	10h			; CPU break flag
CPU_R		Equ	20h			; CPU reserved flag (Break)
CPU_Z		Equ	40h			; CPU zero flag
CPU_N		Equ	80h			; CPU negative flag
;******************************************************************************
;
;	Define the Apple system flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Video type (0 = CGA, 1 = EGA)
;	 | | | | | | ---------> Display type (0 = CGA, 1 = EGA)
;	 | | | | | -----------> Interrupt status (0 = Normal, 1 = Patched)
;	 | | | | -------------> Video status (0 = Normal, 1 = Initialized)
;	 | | | ---------------> Keyboard status (0 = Normal, 1 = Input)
;	 | | -----------------> Mixed CPU status (0 = Normal, 1 = Mixed)
;	 | -------------------> Enhanced CPU status (0 = Normal, 1 = Enhanced)
;	 ---------------------> Config. data/Expression (0 = None, 1 = Present)
;
;******************************************************************************
EGA_TYPE	Equ	01h			; EGA type system video
EGA_DISPLAY	Equ	02h			; EGA type display attached
PATCHED 	Equ	04h			; Interrupts have been patched
INITIALIZED	Equ	08h			; Video has been initialized
INPUT		Equ	10h			; Keyboard is in input mode
MIXED_CPU	Equ	20h			; CPU type is mixed
ENHANCED_CPU	Equ	40h			; Enhanced CPU type (R65C02)
CONFIG_DATA	Equ	80h			; Configuration data present
EXPRESSION	Equ	80h			; Expression present
;******************************************************************************
;
;	Define the Video system flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Video Mode	(0 = Text,   1 = Graphics)
;	 | | | | | | ---------> Page Number	(0 = Page 1, 1 = Page 2)
;	 | | | | | -----------> Resolution	(0 = Low,    1 = High)
;	 | | | | -------------> Mixed Mode	(0 = Normal, 1 = Mixed)
;	 | | | ---------------> Video Mode	(1 = Text,   0 = Graphics)
;	 | | -----------------> Page Number	(1 = Page 1, 0 = Page 2)
;	 | -------------------> Resolution	(1 = Low,    0 = High)
;	 ---------------------> Mixed Mode	(1 = Normal, 0 = Mixed)
;
;******************************************************************************
VIDEO_MODE	Equ	01h		; Video mode test bit flag
PAGE_NUMBER	Equ	02h		; Page number test bit flag
RESOLUTION	Equ	04h		; Resolution test bit flag
MIXED_MODE	Equ	08h		; Mixed mode test bit flag
VIDEO_INV	Equ	10h		; Video mode inverted bit flag
PAGE_INV	Equ	20h		; Page number inverted bit flag
RES_INV 	Equ	40h		; Resolution inverted bit flag
MIXED_INV	Equ	80h		; Mixed mode inverted bit flag
;******************************************************************************
;
;	Define the Emulator system flag byte (In priority order, right to left)
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> System Break Interrupt has Occurred
;	 | | | | | | ---------> System Trace Interrupt has Occurred
;	 | | | | | -----------> System Debug Interrupt has Occurred
;	 | | | | -------------> ***** Reserved ***** (Dummy interrupt)
;	 | | | ---------------> ***** Reserved ***** (Dummy interrupt)
;	 | | -----------------> ***** Reserved ***** (Dummy interrupt)
;	 | -------------------> System Reset Interrupt has Occurred
;	 ---------------------> System Request Interrupt has Occurred
;
;******************************************************************************
SYS_BREAK	Equ	01h		; System break interrupt
SYS_TRACE	Equ	02h		; System trace interrupt
SYS_DEBUG	Equ	04h		; System debug interrupt
SYS_RESET	Equ	40h		; System reset interrupt
SYS_REQUEST	Equ	80h		; System request interrupt
INT_REQUEST	Equ	0FFh		; Any interrupt occurred test value
;******************************************************************************
;
;	Define the Language card flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Write enable
;	 | | | | | | ---------> ***** Reserved *****
;	 | | | | | -----------> ***** Reserved *****
;	 | | | | -------------> ***** Reserved *****
;	 | | | ---------------> ***** Reserved *****
;	 | | -----------------> ***** Reserved *****
;	 | -------------------> ***** Reserved *****
;	 ---------------------> Read enable (Language RAM)
;
;******************************************************************************
WRITE_ENABLE	Equ	01h		; Language card write enable flag
READ_ENABLE	Equ	80h		; Language card read enable flag
;******************************************************************************
;
;	Define the Disk Drive flag byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Disk type (0 = 16, 1 = 13)
;	 | | | | | | ---------> Write protect (0 = Writable, 1 = Write protect)
;	 | | | | | -----------> Disk present (0 = No disk, 1 = Disk present)
;	 | | | | -------------> Motor status (0 = Off, 1 = On)
;	 | | | ---------------> Controller mode (0 = Input, 1 = Output)
;	 | | -----------------> Track modified (0 = Un-modified, 1 = Modified)
;	 | -------------------> Buffer valid (0 = Invalid, 1 = Valid)
;	 ---------------------> ***** Reserved *****
;
;******************************************************************************
OLD_STYLE	Equ	01h		; Old style disk type (13 Sectors/track)
WRITE_PROTECT	Equ	02h		; Disk write protect flag
DISK_PRESENT	Equ	04h		; Disk present flag
MOTOR_ON	Equ	08h		; Disk drive motor on flag
OUTPUT_MODE	Equ	10h		; Disk controller mode flag
TRACK_MODIFIED	Equ	20h		; Disk track modified flag
BUFFER_VALID	Equ	40h		; Disk track buffer valid flag
;******************************************************************************
;
;	Define the keyboard status byte
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Shift key status (0 = Up, 1 = Down)
;	 | | | | | | ---------> Ctrl key status  (0 = Up, 1 = Down)
;	 | | | | | -----------> Alt key status (0 = Up, 1 = Down)
;	 | | | | -------------> ***** Reserved *****
;	 | | | ---------------> ***** Reserved *****
;	 | | -----------------> Scroll lock key status (1 = Locked)
;	 | -------------------> Num lock key status (1 = Locked)
;	 ---------------------> Caps lock key status (1 = Locked)
;
;******************************************************************************
SCROLL_LOCKED	Equ	20h		; Scroll locked (Special update mode)
TYPE_SPECIAL	Equ	SCROLL_LOCKED	; Special update mode in effect
NUM_LOCKED	Equ	40h		; Num locked (Joystick mode)
JOY_MODE	Equ	NUM_LOCKED	; Joystick mode in effect
CAPS_LOCKED	Equ	80h		; Caps locked (All caps)
SHIFTED 	Equ	01h		; Shift key is being held down
CTRLED		Equ	02h		; Ctrl key is being held down
ALTED		Equ	04h		; Alt key is being held down
AFFECTED	Equ	CAPS_LOCKED	; Affected by CAPS lock status
NOT_AFFECTED	Equ	00h		; Not affected by CAPS lock status
;******************************************************************************
;
;	Define the CGA color set equates
;
;	Color Number		Color Name
;	------------		----------
;
;	     0			Black
;	     1			Blue
;	     2			Green
;	     3			Cyan
;	     4			Red
;	     5			Magenta
;	     6			Brown
;	     7			White
;	     8			Gray
;	     9			Light Blue
;	     A			Light Green
;	     B			Light Cyan
;	     C			Light Red
;	     D			Light Magenta
;	     E			Yellow
;	     F			Intense White
;
;******************************************************************************
BLACK		Equ	00h		; Color 00h - Black
BLUE		Equ	01h		; Color 01h - Blue
GREEN		Equ	02h		; Color 02h - Green
CYAN		Equ	03h		; Color 03h - Cyan
RED		Equ	04h		; Color 04h - Red
MAGENTA 	Equ	05h		; Color 05h - Magneta
BROWN		Equ	06h		; Color 06h - Brown
WHITE		Equ	07h		; Color 07h - White
GRAY		Equ	08h		; Color 08h - Gray
LIGHT_BLUE	Equ	09h		; Color 09h - Light Blue
LIGHT_GREEN	Equ	0Ah		; Color 0Ah - Light Green
LIGHT_CYAN	Equ	0Bh		; Color 0Bh - Light Cyan
LIGHT_RED	Equ	0Ch		; Color 0Ch - Light Red
LIGHT_MAGENTA	Equ	0Dh		; Color 0Dh - Light Magenta
YELLOW		Equ	0Eh		; Color 0Eh - Yellow
INTENSE_WHITE	Equ	0Fh		; Color 0Fh - Intense White
INTENSE 	Equ	08h		; Intensity toggle value
;******************************************************************************
;
;	Define the ASCII Character Equate Values
;
;******************************************************************************
NULL		Equ	00h			; ASCII code for null
BELL		Equ	07h			; ASCII code for bell
BS		Equ	08h			; ASCII code for backspace
HT		Equ	09h			; ASCII code for horizontal tab
LF		Equ	0Ah			; ASCII code for line feed
VT		Equ	0Bh			; ASCII code for vertical tab
FF		Equ	0Ch			; ASCII code for form feed
CR		Equ	0Dh			; ASCII code for carriage return
EOF		Equ	1Ah			; ASCII code for end-of-file
ESCAPE		Equ	1Bh			; ASCII escape character
ZERO		Equ	"0"                     ; Zero character
SPACE		Equ	" "                     ; Space character
COMMA		Equ	","                     ; Comma character
COLON		Equ	":"                     ; Colon character
SEMI_COLON	Equ	";"                     ; Semi-colon character
PLUS		Equ	"+"                     ; Plus sign character
MINUS		Equ	"-"                     ; Minus sign character
EQUAL		Equ	"="                     ; Equal sign character
ASTERISK	Equ	"*"                     ; Asterisk character
POINT		Equ	"."                     ; Decimal point character
PERIOD		Equ	"."                     ; Period character
SLASH		Equ	"/"                     ; Slash character
BACK_SLASH	Equ	"\"                     ; Back-slash character
OPEN_BRACKET	Equ	"["                     ; Open bracket character
CLOSE_BRACKET	Equ	"]"                     ; Close bracket character
OPEN_BRACE	Equ	"{"                     ; Open brace character
CLOSE_BRACE	Equ	"}"                     ; Close brace character
OPEN_PAREN	Equ	"("                     ; Open parenthesis character
CLOSE_PAREN	Equ	")"                     ; Close parenthesis character
SINGLE_QUOTE	Equ	"'"                     ; Single quotation character
DOUBLE_QUOTE	Equ	'"'                     ; Double quotation character
AMPERSAND	Equ	"&"                     ; Ampersand character
TILDE		Equ	"~"                     ; Tilde character
EXCLAMATION	Equ	"!"                     ; Exclamation point character
VERTICAL_BAR	Equ	"|"                     ; Vertical bar character
LESS_THAN	Equ	"<"                     ; Less than character
GREATER_THAN	Equ	">"                     ; Greater than character
CAROT		Equ	"^"                     ; Carot character
PERCENT 	Equ	"%"                     ; Percent sign character
;******************************************************************************
;
;	Define the input delimiter type values
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | | | | | | -------> Separator delimiter type flag
;	 | | | | | | ---------> Comment delimiter type flag
;	 | | | | | -----------> Section delimiter type flag
;	 | | | | -------------> End of line delimiter type flag
;	 | | | ---------------> End of data delimiter type flag
;	 | | -----------------> Filename delimiter type flag
;	 | -------------------> Assignment delimiter type flag
;	 ---------------------> Numeric delimiter type flag
;
;******************************************************************************
SEPARATOR_TYPE	Equ	01h			; Separator delimiter type
COMMENT_TYPE	Equ	02h			; Comment delimiter type
SECTION_TYPE	Equ	04h			; Section delimiter type
END_OF_LINE	Equ	08h			; End of line delimiter type
END_OF_DATA	Equ	10h			; End of data delimiter type
FILENAME_TYPE	Equ	20h			; File name delimiter type
ASSIGN_TYPE	Equ	40h			; Assignment delimiter type
NUMERIC_TYPE	Equ	80h			; Numeric delimiter type
;******************************************************************************
;
;	Define the expression delimiter type values
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | ----- -------
;	 |   |	    |
;	 |   |	    ----------> Operation delimiter type value
;	 |   -----------------> Special delimiter type value
;	 ---------------------> End of expression delimiter type flag
;
;******************************************************************************
OP_MASK 	Equ	0Fh			; Operation delimiter mask
OP_AND		Equ	01h			; Logical AND operation value
OP_OR		Equ	02h			; Logical OR operation value
OP_XOR		Equ	03h			; Logical XOR operation value
OP_RIGHT	Equ	04h			; Shift right operation value
OP_LEFT 	Equ	05h			; Shift left operation value
OP_MOD		Equ	06h			; Modulus operation value
OP_ADD		Equ	07h			; Addition operation value
OP_SUB		Equ	08h			; Subtraction operation value
OP_MUL		Equ	09h			; Multiplication operation value
OP_DIV		Equ	0Ah			; Division operation value
OP_NOT		Equ	0Bh			; Logical NOT operation value
OP_NEG		Equ	0Ch			; Negation operation value
OP_PUSH 	Equ	0Dh			; Push operation value
OP_POP		Equ	0Eh			; Pop operation value
SPC_MASK	Equ	30h			; Special delimiter mask
SPC_STRING	Equ	10h			; Special string delimiter value
SPC_ASSIGN	Equ	20h			; Special assign delimiter value
SPC_LENGTH	Equ	30h			; Special length delimiter value
BASE_TYPE	Equ	40h			; Base delimiter type flag
BASE_MASK	Equ	30h			; Base delimiter mask
BASE_BINARY	Equ	40h			; Binary base delimiter
BASE_OCTAL	Equ	50h			; Octal base delimiter
BASE_DECIMAL	Equ	60h			; Decimal base delimiter
BASE_HEX	Equ	70h			; Hexadecimal delimiter
END_OF_EXPRESS	Equ	80h			; End of expression delimiter
;******************************************************************************
;
;	Define the opcode instruction type values
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | -----------
;	 | |	  |
;	 | |	  ------------> Addressing mode type value
;	 | -------------------> Instruction performs a write type
;	 ---------------------> Instruction performs a read type
;
;******************************************************************************
ADDRESS_MASK	Equ	3Fh			; Addressing mode type mask
READ		Equ	80h			; Instruction performs a read
WRITE		Equ	40h			; Instruction performs a write
ACCESS		Equ	READ + WRITE		; Instruction performs rd./wr.
NONE		Equ	00h			; Instruction self contained
;******************************************************************************
;
;	Define the debug breakpoint type values
;
;	-----------------
;	|7|6|5|4|3|2|1|0|
;	-----------------
;	 | | | | | | | |
;	 | | ------- ---
;	 | |	|     |
;	 | |	|     --------> Breakpoint type value (Soft, Hard, Execute)
;	 | |	--------------> ***** Reserved *****
;	 | -------------------> Breakpoint enabled flag (1 = Enabled)
;	 ---------------------> Breakpoint used flag (1 = Used)
;
;******************************************************************************
BREAK_MASK	Equ	03h			; Breakpoint type mask
TYPE_SOFT	Equ	00h			; Software type breakpoint
TYPE_HARD	Equ	01h			; Hardware type breakpoint
TYPE_EXECUTE	Equ	02h			; Execution type breakpoint
TYPE_ENABLED	Equ	40h			; Breakpoint enabled flag
TYPE_USED	Equ	80h			; Breakpoint used flag
	.List
