	Page	58,132
	Title	VIDEO.ASM	Atari video
;******************************************************************************
;
;   Name:	VIDEO.ASM	Atari Video Routines
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple
;	video routines.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Video_Init		; Video initialization routine
	Public	Video_Reset		; Video reset routine
	Public	Video_TEXT_OPEN		; open text screen
;
;  External Declarations
;
	Extrn	Write_Table:Word	; Write memory page table	 (DATA)
	Extrn	IO_Read_Table:Word	; I/O read table		 (DATA)
	Extrn	IO_Write_Table:Word	; I/O write table		 (DATA)
	Extrn	Video_Segment:Word	; Video segment value		 (DATA)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	Video_Flag:Byte 	; Video system flag byte	 (DATA)

;
;	LOCAL Equates
;
MCGA_320x200x256	Equ	13h
MCGA_SEGMENT		Equ	0a000h
RESET_MODE		Equ	3h

; Structures
PALETTE	STRUC
R	DB	?
G	DB	?
B	DB	?
PALETTE ENDS

;
;  Inlcude files
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing


;Table used to load IBM palette registers
COLOR_TABLE	Equ	This Byte
;		r	g	b	atari color
	PALETTE  <	03h	03h	03h	>  ;color 0
	PALETTE  <	07h	07h	07h	>  ;color 1
	PALETTE  <	0bh	0bh	0bh	>  ;color 2
	PALETTE  <	0fh	0fh	0fh	>  ;color 3
	PALETTE  <	013h	013h	013h	>  ;color 4
	PALETTE  <	017h	017h	017h	>  ;color 5
	PALETTE  <	01bh	01bh	01bh	>  ;color 6
	PALETTE  <	01fh	01fh	01fh	>  ;color 7
	PALETTE  <	023h	023h	023h	>  ;color 8
	PALETTE  <	027h	027h	027h	>  ;color 9
	PALETTE  <	02bh	02bh	02bh	>  ;color 10
	PALETTE  <	02fh	02fh	02fh	>  ;color 11
	PALETTE  <	033h	033h	033h	>  ;color 12
	PALETTE  <	037h	037h	037h	>  ;color 13
	PALETTE  <	03bh	03bh	03bh	>  ;color 14
	PALETTE  <	03fh	03fh	03fh	>  ;color 15
	PALETTE  <	03h	03h	00h	>  ;color 16
	PALETTE  <	06h	07h	00h	>  ;color 17
	PALETTE  <	0ah	0bh	00h	>  ;color 18
	PALETTE  <	0dh	0fh	00h	>  ;color 19
	PALETTE  <	011h	013h	00h	>  ;color 20
	PALETTE  <	014h	017h	00h	>  ;color 21
	PALETTE  <	018h	01bh	00h	>  ;color 22
	PALETTE  <	01bh	01fh	00h	>  ;color 23
	PALETTE  <	01fh	023h	00h	>  ;color 24
	PALETTE  <	022h	027h	00h	>  ;color 25
	PALETTE  <	025h	02bh	00h	>  ;color 26
	PALETTE  <	029h	02fh	00h	>  ;color 27
	PALETTE  <	02ch	033h	00h	>  ;color 28
	PALETTE  <	030h	037h	00h	>  ;color 29
	PALETTE  <	033h	03bh	00h	>  ;color 30
	PALETTE  <	037h	03fh	00h	>  ;color 31
	PALETTE  <	03h	02h	00h	>  ;color 32
	PALETTE  <	07h	05h	00h	>  ;color 33
	PALETTE  <	0bh	08h	00h	>  ;color 34
	PALETTE  <	0fh	0bh	00h	>  ;color 35
	PALETTE  <	013h	0eh	00h	>  ;color 36
	PALETTE  <	017h	011h	00h	>  ;color 37
	PALETTE  <	01bh	014h	00h	>  ;color 38
	PALETTE  <	01fh	017h	00h	>  ;color 39
	PALETTE  <	023h	01ah	00h	>  ;color 40
	PALETTE  <	027h	01dh	00h	>  ;color 41
	PALETTE  <	02bh	020h	00h	>  ;color 42
	PALETTE  <	02fh	023h	00h	>  ;color 43
	PALETTE  <	033h	026h	00h	>  ;color 44
	PALETTE  <	037h	029h	00h	>  ;color 45
	PALETTE  <	03bh	02ch	00h	>  ;color 46
	PALETTE  <	03fh	02fh	00h	>  ;color 47
	PALETTE  <	03h	01h	00h	>  ;color 48
	PALETTE  <	07h	02h	00h	>  ;color 49
	PALETTE  <	0bh	04h	00h	>  ;color 50
	PALETTE  <	0fh	05h	00h	>  ;color 51
	PALETTE  <	013h	07h	00h	>  ;color 52
	PALETTE  <	017h	08h	00h	>  ;color 53
	PALETTE  <	01bh	0ah	00h	>  ;color 54
	PALETTE  <	01fh	0bh	00h	>  ;color 55
	PALETTE  <	023h	0dh	00h	>  ;color 56
	PALETTE  <	027h	0eh	00h	>  ;color 57
	PALETTE  <	02bh	010h	00h	>  ;color 58
	PALETTE  <	02fh	011h	00h	>  ;color 59
	PALETTE  <	033h	013h	00h	>  ;color 60
	PALETTE  <	037h	014h	00h	>  ;color 61
	PALETTE  <	03bh	016h	00h	>  ;color 62
	PALETTE  <	03fh	017h	00h	>  ;color 63
	PALETTE  <	03h	00h	00h	>  ;color 64
	PALETTE  <	07h	00h	00h	>  ;color 65
	PALETTE  <	0bh	00h	00h	>  ;color 66
	PALETTE  <	0fh	00h	00h	>  ;color 67
	PALETTE  <	013h	00h	00h	>  ;color 68
	PALETTE  <	017h	00h	00h	>  ;color 69
	PALETTE  <	01bh	00h	00h	>  ;color 70
	PALETTE  <	01fh	00h	00h	>  ;color 71
	PALETTE  <	023h	00h	00h	>  ;color 72
	PALETTE  <	027h	00h	00h	>  ;color 73
	PALETTE  <	02bh	00h	00h	>  ;color 74
	PALETTE  <	02fh	00h	00h	>  ;color 75
	PALETTE  <	033h	00h	00h	>  ;color 76
	PALETTE  <	037h	00h	00h	>  ;color 77
	PALETTE  <	03bh	00h	00h	>  ;color 78
	PALETTE  <	03fh	00h	00h	>  ;color 79
	PALETTE  <	03h	00h	01h	>  ;color 80
	PALETTE  <	07h	00h	02h	>  ;color 81
	PALETTE  <	0bh	00h	04h	>  ;color 82
	PALETTE  <	0fh	00h	05h	>  ;color 83
	PALETTE  <	013h	00h	07h	>  ;color 84
	PALETTE  <	017h	00h	08h	>  ;color 85
	PALETTE  <	01bh	00h	0ah	>  ;color 86
	PALETTE  <	01fh	00h	0bh	>  ;color 87
	PALETTE  <	023h	00h	0dh	>  ;color 88
	PALETTE  <	027h	00h	0eh	>  ;color 89
	PALETTE  <	02bh	00h	010h	>  ;color 90
	PALETTE  <	02fh	00h	011h	>  ;color 91
	PALETTE  <	033h	00h	013h	>  ;color 92
	PALETTE  <	037h	00h	014h	>  ;color 93
	PALETTE  <	03bh	00h	016h	>  ;color 94
	PALETTE  <	03fh	00h	017h	>  ;color 95
	PALETTE  <	03h	00h	02h	>  ;color 96
	PALETTE  <	07h	00h	05h	>  ;color 97
	PALETTE  <	0bh	00h	08h	>  ;color 98
	PALETTE  <	0fh	00h	0bh	>  ;color 99
	PALETTE  <	013h	00h	0eh	>  ;color 100
	PALETTE  <	017h	00h	011h	>  ;color 101
	PALETTE  <	01bh	00h	014h	>  ;color 102
	PALETTE  <	01fh	00h	017h	>  ;color 103
	PALETTE  <	023h	00h	01ah	>  ;color 104
	PALETTE  <	027h	00h	01dh	>  ;color 105
	PALETTE  <	02bh	00h	020h	>  ;color 106
	PALETTE  <	02fh	00h	023h	>  ;color 107
	PALETTE  <	033h	00h	026h	>  ;color 108
	PALETTE  <	037h	00h	029h	>  ;color 109
	PALETTE  <	03bh	00h	02ch	>  ;color 110
	PALETTE  <	03fh	00h	02fh	>  ;color 111
	PALETTE  <	03h	00h	03h	>  ;color 112
	PALETTE  <	06h	00h	07h	>  ;color 113
	PALETTE  <	0ah	00h	0bh	>  ;color 114
	PALETTE  <	0dh	00h	0fh	>  ;color 115
	PALETTE  <	011h	00h	013h	>  ;color 116
	PALETTE  <	014h	00h	017h	>  ;color 117
	PALETTE  <	018h	00h	01bh	>  ;color 118
	PALETTE  <	01bh	00h	01fh	>  ;color 119
	PALETTE  <	01fh	00h	023h	>  ;color 120
	PALETTE  <	022h	00h	027h	>  ;color 121
	PALETTE  <	025h	00h	02bh	>  ;color 122
	PALETTE  <	029h	00h	02fh	>  ;color 123
	PALETTE  <	02ch	00h	033h	>  ;color 124
	PALETTE  <	030h	00h	037h	>  ;color 125
	PALETTE  <	033h	00h	03bh	>  ;color 126
	PALETTE  <	037h	00h	03fh	>  ;color 127
	PALETTE  <	01h	00h	03h	>  ;color 128
	PALETTE  <	03h	00h	07h	>  ;color 129
	PALETTE  <	05h	00h	0bh	>  ;color 130
	PALETTE  <	07h	00h	0fh	>  ;color 131
	PALETTE  <	09h	00h	013h	>  ;color 132
	PALETTE  <	0bh	00h	017h	>  ;color 133
	PALETTE  <	0dh	00h	01bh	>  ;color 134
	PALETTE  <	0fh	00h	01fh	>  ;color 135
	PALETTE  <	011h	00h	023h	>  ;color 136
	PALETTE  <	013h	00h	027h	>  ;color 137
	PALETTE  <	015h	00h	02bh	>  ;color 138
	PALETTE  <	017h	00h	02fh	>  ;color 139
	PALETTE  <	019h	00h	033h	>  ;color 140
	PALETTE  <	01bh	00h	037h	>  ;color 141
	PALETTE  <	01dh	00h	03bh	>  ;color 142
	PALETTE  <	01fh	00h	03fh	>  ;color 143
	PALETTE  <	00h	00h	03h	>  ;color 144
	PALETTE  <	00h	00h	07h	>  ;color 145
	PALETTE  <	01h	00h	0bh	>  ;color 146
	PALETTE  <	01h	00h	0fh	>  ;color 147
	PALETTE  <	02h	00h	013h	>  ;color 148
	PALETTE  <	02h	00h	017h	>  ;color 149
	PALETTE  <	03h	00h	01bh	>  ;color 150
	PALETTE  <	03h	00h	01fh	>  ;color 151
	PALETTE  <	04h	00h	023h	>  ;color 152
	PALETTE  <	04h	00h	027h	>  ;color 153
	PALETTE  <	05h	00h	02bh	>  ;color 154
	PALETTE  <	05h	00h	02fh	>  ;color 155
	PALETTE  <	06h	00h	033h	>  ;color 156
	PALETTE  <	06h	00h	037h	>  ;color 157
	PALETTE  <	07h	00h	03bh	>  ;color 158
	PALETTE  <	07h	00h	03fh	>  ;color 159
	PALETTE  <	00h	00h	03h	>  ;color 160
	PALETTE  <	00h	01h	07h	>  ;color 161
	PALETTE  <	00h	02h	0bh	>  ;color 162
	PALETTE  <	00h	03h	0fh	>  ;color 163
	PALETTE  <	00h	04h	013h	>  ;color 164
	PALETTE  <	00h	05h	017h	>  ;color 165
	PALETTE  <	00h	06h	01bh	>  ;color 166
	PALETTE  <	00h	07h	01fh	>  ;color 167
	PALETTE  <	00h	08h	023h	>  ;color 168
	PALETTE  <	00h	09h	027h	>  ;color 169
	PALETTE  <	00h	0ah	02bh	>  ;color 170
	PALETTE  <	00h	0bh	02fh	>  ;color 171
	PALETTE  <	00h	0ch	033h	>  ;color 172
	PALETTE  <	00h	0dh	037h	>  ;color 173
	PALETTE  <	00h	0eh	03bh	>  ;color 174
	PALETTE  <	00h	0fh	03fh	>  ;color 175
	PALETTE  <	00h	02h	03h	>  ;color 176
	PALETTE  <	00h	04h	07h	>  ;color 177
	PALETTE  <	00h	07h	0bh	>  ;color 178
	PALETTE  <	00h	09h	0fh	>  ;color 179
	PALETTE  <	00h	0ch	013h	>  ;color 180
	PALETTE  <	00h	0eh	017h	>  ;color 181
	PALETTE  <	00h	011h	01bh	>  ;color 182
	PALETTE  <	00h	013h	01fh	>  ;color 183
	PALETTE  <	00h	016h	023h	>  ;color 184
	PALETTE  <	00h	018h	027h	>  ;color 185
	PALETTE  <	00h	01bh	02bh	>  ;color 186
	PALETTE  <	00h	01dh	02fh	>  ;color 187
	PALETTE  <	00h	01fh	033h	>  ;color 188
	PALETTE  <	00h	022h	037h	>  ;color 189
	PALETTE  <	00h	024h	03bh	>  ;color 190
	PALETTE  <	00h	027h	03fh	>  ;color 191
	PALETTE  <	00h	03h	03h	>  ;color 192
	PALETTE  <	00h	07h	07h	>  ;color 193
	PALETTE  <	00h	0bh	0bh	>  ;color 194
	PALETTE  <	00h	0fh	0fh	>  ;color 195
	PALETTE  <	00h	013h	013h	>  ;color 196
	PALETTE  <	00h	017h	017h	>  ;color 197
	PALETTE  <	00h	01bh	01bh	>  ;color 198
	PALETTE  <	00h	01fh	01fh	>  ;color 199
	PALETTE  <	00h	023h	023h	>  ;color 200
	PALETTE  <	00h	027h	027h	>  ;color 201
	PALETTE  <	00h	02bh	02bh	>  ;color 202
	PALETTE  <	00h	02fh	02fh	>  ;color 203
	PALETTE  <	00h	033h	033h	>  ;color 204
	PALETTE  <	00h	037h	037h	>  ;color 205
	PALETTE  <	00h	03bh	03bh	>  ;color 206
	PALETTE  <	00h	03fh	03fh	>  ;color 207
	PALETTE  <	00h	03h	02h	>  ;color 208
	PALETTE  <	00h	07h	04h	>  ;color 209
	PALETTE  <	00h	0bh	07h	>  ;color 210
	PALETTE  <	00h	0fh	09h	>  ;color 211
	PALETTE  <	00h	013h	0ch	>  ;color 212
	PALETTE  <	00h	017h	0eh	>  ;color 213
	PALETTE  <	00h	01bh	011h	>  ;color 214
	PALETTE  <	00h	01fh	013h	>  ;color 215
	PALETTE  <	00h	023h	016h	>  ;color 216
	PALETTE  <	00h	027h	018h	>  ;color 217
	PALETTE  <	00h	02bh	01bh	>  ;color 218
	PALETTE  <	00h	02fh	01dh	>  ;color 219
	PALETTE  <	00h	033h	01fh	>  ;color 220
	PALETTE  <	00h	037h	022h	>  ;color 221
	PALETTE  <	00h	03bh	024h	>  ;color 222
	PALETTE  <	00h	03fh	027h	>  ;color 223
	PALETTE  <	00h	03h	00h	>  ;color 224
	PALETTE  <	00h	07h	01h	>  ;color 225
	PALETTE  <	00h	0bh	02h	>  ;color 226
	PALETTE  <	00h	0fh	03h	>  ;color 227
	PALETTE  <	00h	013h	04h	>  ;color 228
	PALETTE  <	00h	017h	05h	>  ;color 229
	PALETTE  <	00h	01bh	06h	>  ;color 230
	PALETTE  <	00h	01fh	07h	>  ;color 231
	PALETTE  <	00h	023h	08h	>  ;color 232
	PALETTE  <	00h	027h	09h	>  ;color 233
	PALETTE  <	00h	02bh	0ah	>  ;color 234
	PALETTE  <	00h	02fh	0bh	>  ;color 235
	PALETTE  <	00h	033h	0ch	>  ;color 236
	PALETTE  <	00h	037h	0dh	>  ;color 237
	PALETTE  <	00h	03bh	0eh	>  ;color 238
	PALETTE  <	00h	03fh	0fh	>  ;color 239
	PALETTE  <	00h	03h	00h	>  ;color 240
	PALETTE  <	00h	07h	00h	>  ;color 241
	PALETTE  <	01h	0bh	00h	>  ;color 242
	PALETTE  <	01h	0fh	00h	>  ;color 243
	PALETTE  <	02h	013h	00h	>  ;color 244
	PALETTE  <	02h	017h	00h	>  ;color 245
	PALETTE  <	03h	01bh	00h	>  ;color 246
	PALETTE  <	03h	01fh	00h	>  ;color 247
	PALETTE  <	04h	023h	00h	>  ;color 248
	PALETTE  <	04h	027h	00h	>  ;color 249
	PALETTE  <	05h	02bh	00h	>  ;color 250
	PALETTE  <	05h	02fh	00h	>  ;color 251
	PALETTE  <	06h	033h	00h	>  ;color 252
	PALETTE  <	06h	037h	00h	>  ;color 253
	PALETTE  <	07h	03bh	00h	>  ;color 254
	PALETTE  <	07h	03fh	00h	>  ;color 255

	Subttl	Video_Init	Video Initialization Routine
	Page	+
;******************************************************************************
;
;	Video_Init(RAM_Space)
;
;		Save the required registers
;		Determine the video type
;		If this is a VGA or MCGA type video
;			Setup the MCGA video RAM segment value
;			Setup the MCGA I/O routine addresses
;			Call routine to restore MCGA screen
;		Endif for video type
;		Set video initialized flag
;		Save the video segment value
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS    - 65C02 RAM space
;
;	Registers on Exit:
;
;		AX    - Destroyed
;		ES    - Video segment
;
;******************************************************************************
		Even			; Force procedure to even address
Video_Init	Proc	Near		; Video initialization procedure
	Save	si			; Save the required registers
	call	Video_MCGA_OPEN		; Call routine to open 320x200x256
Setup_CGA:
	mov	ax,MCGA_SEGMENT		; Get the CGA video RAM segment value
	mov	es,ax			; Setup video RAM segment address
	or	cs:[System_Flag],INITIALIZED
	mov	cs:[Video_Segment],es	; Save the video segment value
	Restore si			; Restore the required registers
	ret				; Return to the caller
Video_Init	Endp			; End of the Video_Init procedure
	Subttl	Video_Reset	Video Reset Routine
	Page	+
;******************************************************************************
;
;	Video_Reset()
;
;		If video has been initialized
;			Reset the video mode
;			Call routine to turn cursor on
;		Endif video has not been initialized
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		AX    - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Video_Reset	Proc	Near		; Video reset procedure
	test	cs:[System_Flag],INITIALIZED
	jz	Reset_Done		; Jump if video not initialized
	mov	ah,SET_MODE		; Get set mode video sub-function code
	mov	al,RESET_MODE		; Get the 80x25 text mode value
	int	VIDEO			; Set video mode to 80x25 text mode
Reset_Done:
	ret				; Return to the caller
Video_Reset	Endp			; End of the Video_Reset procedure
	Subttl	Video_MCGA_OPEN	Open video mode 13h
	Page	+
;******************************************************************************
;
;	Video_MCGA_OPEN()
;
;		Save the required registers
;	        try to open MCGA video 320x200x256 mode (13h)
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Video_MCGA_OPEN	Proc	Near		; Set video type procedure
	Save	ax,bx,cx		; Save the required registers
	mov 	al,MCGA_320x200x256	; mode 13h
	mov 	ah,SET_MODE		; AH = 0 is set video mode
	int 	VIDEO			; call video bios
	mov	ax,SEG COLOR_TABLE
	mov	es,ax
	mov	dx,OFFSET COLOR_TABLE		; get offset
	mov 	ax,01012h		; copy palette
	mov	bx,0
	mov	cx,0100h		; copy 256 colors
	int	VIDEO			; call video bias to do the work
	Restore ax,bx,cx		; Restore the required registers
	ret				; Return to the caller
Video_MCGA_OPEN	Endp			; End of the Video_Type procedure

	Subttl	Video_TEXT_OPEN	Open video mode 7h
	Page	+
;******************************************************************************
;
;	Video_TEXT_OPEN()
;
;		Save the required registers
;	        Open TEXT video 80x25 mode (7h)
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Video_TEXT_OPEN	Proc	Near		; Set video type procedure
	mov 	al,7			; mode 7h
	mov 	ah,SET_MODE		; AH = 0 is set video mode
	int 	VIDEO			; call video bios
	ret				; Return to the caller
Video_TEXT_OPEN	Endp			; End of the Video_Type procedure
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Video module
