/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CHardDiskDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CHardDiskDlg.h"
#include "CFileSmallDlg.h"
#include "winatari.h"
#include "registry.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" char atari_h1_dir[];
extern "C" char atari_h2_dir[];
extern "C" char atari_h3_dir[];
extern "C" char atari_h4_dir[];
extern "C" void WriteRegString( HKEY hkInput, char *item, char *data );
/////////////////////////////////////////////////////////////////////////////
// CHardDiskDlg dialog


CHardDiskDlg::CHardDiskDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHardDiskDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardDiskDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CHardDiskDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardDiskDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardDiskDlg, CDialog)
	//{{AFX_MSG_MAP(CHardDiskDlg)
	ON_BN_CLICKED(IDC_HD1, OnHd1)
	ON_BN_CLICKED(IDC_HD2, OnHd2)
	ON_BN_CLICKED(IDC_HD3, OnHd3)
	ON_BN_CLICKED(IDC_HD4, OnHd4)
	ON_EN_KILLFOCUS(IDC_HD2_EDIT, OnKillfocusHd2Edit)
	ON_EN_KILLFOCUS(IDC_HD1_EDIT, OnKillfocusHd1Edit)
	ON_EN_KILLFOCUS(IDC_HD3_EDIT, OnKillfocusHd3Edit)
	ON_EN_KILLFOCUS(IDC_HD4_EDIT, OnKillfocusHd4Edit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardDisk message handlers

BOOL CHardDiskDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDlgItemText( IDC_HD1_EDIT, atari_h1_dir );
	SetDlgItemText( IDC_HD2_EDIT, atari_h2_dir );
	SetDlgItemText( IDC_HD3_EDIT, atari_h3_dir );
	SetDlgItemText( IDC_HD4_EDIT, atari_h4_dir );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHardDiskDlg::SetToDrive( char *drivestring , int item )
{
	CString	name = "";
	int	result;

	CFileSmallDlg fileDlg;
	if( (result = fileDlg.DoModal()) == IDOK )
		name = fileDlg.GetPathName();	
	if( result )
	{
		strcpy( drivestring, name.GetBuffer( 0 ));
		if( drivestring[ strlen(drivestring)-1 ] == '\\' )
			drivestring[ strlen(drivestring)-1 ]= 0;
		name.ReleaseBuffer();
		SetDlgItemText( item, drivestring );
	}
}

void CHardDiskDlg::OnHd1() 
{
	SetToDrive( atari_h1_dir, IDC_HD1_EDIT );
}

void CHardDiskDlg::OnHd2() 
{
	SetToDrive( atari_h2_dir, IDC_HD2_EDIT );
}

void CHardDiskDlg::OnHd3() 
{
	SetToDrive( atari_h3_dir, IDC_HD3_EDIT );
}

void CHardDiskDlg::OnHd4() 
{
	SetToDrive( atari_h4_dir, IDC_HD4_EDIT );
}

void CHardDiskDlg::OnKillfocusHd1Edit() 
{
	GetDlgItemText( IDC_HD1_EDIT, atari_h1_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd2Edit() 
{
	GetDlgItemText( IDC_HD2_EDIT, atari_h2_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd3Edit() 
{
	GetDlgItemText( IDC_HD3_EDIT, atari_h3_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd4Edit() 
{
	GetDlgItemText( IDC_HD4_EDIT, atari_h4_dir, MAX_PATH );
}

void CHardDiskDlg::OnOK() 
{
	if( atari_h1_dir[0] == 0 )
		strcpy( atari_h1_dir, "." );
	if( atari_h2_dir[0] == 0 )
		strcpy( atari_h2_dir, "." );
	if( atari_h3_dir[0] == 0 )
		strcpy( atari_h3_dir, "." );
	if( atari_h4_dir[0] == 0 )
		strcpy( atari_h4_dir, "." );

	WriteRegString( NULL, REG_HD1, atari_h1_dir );
	WriteRegString( NULL, REG_HD2, atari_h2_dir );
	WriteRegString( NULL, REG_HD3, atari_h3_dir );
	WriteRegString( NULL, REG_HD4, atari_h4_dir );
	
	CDialog::OnOK();
}

