#include <stdio.h>
#include <ctype.h>
#include <mem.h>
#include <io.h>
#include <dir.h>
#include <string.h>

#define VERSION "1.00"

void main(int,char **);
void decode_C1(void);
void decode_C3(void);
void decode_C4(void);
void decode_C6(void);
void decode_C7(void);
void decode_FA_atr(void);

FILE 			  *fin,*fout;
unsigned	int	secsize;
unsigned	short cursec=0,maxsec=0;
unsigned	char	createdisk=0,working=0,last=0,density,buf[256];

void main(int argc,char **argv)
{
unsigned char	blocktype,*self,*p,imgin[MAXPATH],imgout[MAXPATH],done=0;

	if ((self = strrchr(argv[0],'\\')) == NULL) {
		self = argv[0];
	} else
		self++;

	if (argc < 2) {
		printf("%s "VERSION" by cmwagner@gate.net\n",self);
		printf("%s <input[.dcm]> [output[.atr]]\n",self);
		exit();
	}

	strcpy(imgin,argv[1]);
	if (strrchr(imgin,'.') == NULL)
		strcat(imgin,".dcm");

	if (argc >= 3)
		strcpy(imgout,argv[2]);
	else {
		strcpy(imgout,imgin);
		if ((p = strrchr(imgout,'.')) != NULL)
			*p = 0;
	}
	if (strrchr(imgout,'.') == NULL)
		strcat(imgout,".atr");

	if ((fin = fopen(imgin,"rb")) == NULL) {
		printf("I couldn't open \"%s\" for reading.\n",imgin);
		exit();
	}

	blocktype = fgetc(fin);
	if (blocktype == 0xF9) {
		printf("0xF9 format has not been implemented.\n");
		exit();
	} else if (blocktype != 0xFA) {
		printf("0x%02X is not a known header block.\n",blocktype);
		exit();
	}

	if ((fout = fopen(imgout,"rb")) != NULL) {
		printf("I can't use \"%s\" for output, it already exists.\n",imgout);
		exit();
	} else {
		fclose(fout);
		fout = fopen(imgout,"wb");
	}

	rewind(fin);

	do {
		printf("\rCurrent sector: %4u",cursec);

		if (kbhit()) {
			if (getch() == 27) {
				printf("  Processing terminated by user.\n");
				exit();
			}
		}
		if (feof(fin)) {
			printf("  EOF before end block.\n");
			exit();
		}

		if (working) {
			if (((((long)cursec - 1) * secsize) + 16) != ftell(fout)) {
				printf("  Output has desynched.\nfin=%lu fout=%lu != %lu "
				"cursec=%u secsize=%u\n",ftell(fin),ftell(fout),
				(((long)cursec - 1) * secsize) + 16,cursec,secsize);
				exit();
			}
		}

		blocktype = fgetc(fin);
		if (((blocktype | 0x80) == 0xFA) || ((blocktype | 0x80) == 0xF9)) {
			decode_FA_atr();
			continue;
		}

		if (blocktype == 0x45) {
			working=0;
			if (last) {
				printf("\rFile has been successfully decompressed.\n");
				fclose(fin);
				done=1;
			}
			continue;
		}

		if ((blocktype | 0x80) == 0xC1) {
			decode_C1();
		}

		if ((blocktype | 0x80) == 0xC3) {
			decode_C3();
		}

		if ((blocktype | 0x80) == 0xC4) {
			decode_C4();
		}

		if ((blocktype | 0x80) == 0xC6) {
			decode_C6();
		}

		if ((blocktype | 0x80) == 0xC7) {
			decode_C7();
		}

		if (!(blocktype & 0x80)) {
			fread(&cursec,sizeof(short),1,fin);
			fseek(fout,(((long)cursec - 1) * secsize) + 16,SEEK_SET);
		} else {
			cursec++;
		}
	} while(done == 0);
}

void decode_C1(void)
{
unsigned char  secoff,tmpoff,c;

	fread(&tmpoff,sizeof(char),1,fin);
	fread(&c,sizeof(char),1,fin);
	for (secoff=0; secoff<secsize; secoff++) {
		buf[secoff]=c;
	}
	c=tmpoff;
	for (secoff=0; secoff<tmpoff; secoff++) {
		c--;
		fread(&buf[c],sizeof(char),1,fin);
	}
	fwrite(&buf,secsize,1,fout);
}

void decode_C3(void)
{
unsigned char  secoff,tmpoff,c;

	secoff=0;
	do {
		fread(&tmpoff,sizeof(char),1,fin);
		for (; secoff<tmpoff; secoff++) {
			fread(&buf[secoff],sizeof(char),1,fin);
		}
		if (secoff == secsize)
			break;
		fread(&tmpoff,sizeof(char),1,fin);
		fread(&c,sizeof(char),1,fin);
		for (; secoff<tmpoff; secoff++) {
			buf[secoff] = c;
		}
	} while(secoff < secsize);
	fwrite(&buf,secsize,1,fout);
}

void decode_C4(void)
{
unsigned char  secoff,c;

	fread(&c,sizeof(char),1,fin);
	for (secoff=c; secoff<secsize; secoff++) {
		fread(&buf[secoff],sizeof(char),1,fin);
	}
	fwrite(&buf,secsize,1,fout);
}

void decode_C6(void)
{
	fwrite(&buf,secsize,1,fout);
}

void decode_C7(void)
{
	fread(&buf,secsize,1,fin);
	fwrite(&buf,secsize,1,fout);
}

void decode_FA_atr(void)
{
unsigned char c;

struct {
	unsigned short special,
						limgsiz,
						secsize,
						himgsiz;
	unsigned	char	unused[8];
} atrhdr;

	if (working) {
		printf("\nTrying to start section but last section never had "
		"an end section block.\n");
		exit();
	}
	fread(&c,sizeof(char),1,fin);
	density=((c & 0x70) >> 4);
	last=((c & 0x80) >> 7);
	if (density == 0) {
		maxsec=720;
		secsize=128;
	} else if (density == 2) {
		maxsec=720;
		secsize=256;
	} else if (density == 4) {
		maxsec=1040;
		secsize=128;
	} else {
		printf("  Density type is unknown, density type=%u\n",density);
		exit();
	}

	if (createdisk == 0) {
		createdisk = 1;
		memset(&atrhdr,0,16);
		atrhdr.special = 0x296;
		atrhdr.limgsiz = (short)(((long)maxsec * secsize) >> 4);
		atrhdr.secsize = secsize;
		atrhdr.himgsiz = (short)(((long)maxsec * secsize) >> 20);
		fwrite(&atrhdr,16,1,fout);
		memset(buf,0,256);
		for (cursec=0; cursec<maxsec; cursec++) {
			fwrite(&buf,secsize,1,fout);
		}
	}
	fread(&cursec,sizeof(short),1,fin);
	fseek(fout,(((long)cursec - 1) * secsize) + 16,SEEK_SET);
	working=1;
}