/** EMULib Emulation Library *********************************/
/**                                                         **/
/**                            DSP.h                        **/
/**                                                         **/
/** This file contains definitions and declarations for     **/
/** routines in DSP.c.                                      **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996                      **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef DSP_H
#define DSP_H
#ifdef UNIX

#define SND_MELODIC   0x01   /* Melodic sound (default)      */
#define SND_NOISE     0x02   /* White noise                  */
#define SND_PERIODIC  0x04   /* Periodic noise (not sup-ted) */

#define SND_CHANNELS  8      /* Number of channels           */
#define SND_BUFSIZE   256    /* Buffer size, <= 2^SND_BITS   */
#define SND_BITS      8      /* Number of bits               */
#define SND_BUFFERS   8      /* Number of buffers, >= 2      */
  /* Bigger value results in better behaviour on loaded      */
  /* but output gets more delayed.                           */

int InitSound(int Rate,int Verbose);     /* Initialize DSP   */
    /* Returns Rate on success, 0 otherwise. Rate is 0 to    */
    /* skip initialization (will be silent).                 */
void TrashSound(void);                   /* Shut down DSP    */

void StopSound(void);                    /* Suspend sound    */
void ResumeSound(void);                  /* Resume sound     */

void SetSound(int Channel,int Type);     /* Set sound type   */
void SetFreq(int Channel,int Freq);      /* Set frequency    */
void SetVolume(int Channel,int Volume);  /* Set volume       */

void SetChannels(int Volume,int Toggle);
    /* Set master volume (0..255) and turn channels on/off.  */
    /* Each bit in Toggle corresponds to a channel (1=on).   */

void Sound(int Channel,int Freq,int Volume);
    /* Generate sound of given frequency (Hz) and volume     */
    /* (0..255) via given channel.                           */

#endif /* UNIX */
#endif /* DSP_H */
