/** GameBoy Cartridge Info and Manufacturer Codes ************/
/**                                                         **/
/**                        GBCarts.h                        **/
/**                                                         **/
/** This file contains definitions and declarations for     **/
/** routines in GBCarts.c.                                  **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1995,1996                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef GBCARTS_H
#define GBCARTS_H

#define GB_CRC(Header)      (Header[0x14E]*256+Header[0x14F])
#define GB_MakerID(Header)  (Header[0x14B]*256+Header[0x14A])
#define GB_ROMBanks(Header) ((((2<<Header[0x148])-1)&0x1F)+1)
#define GB_ROMSize(Header)  (GB_ROMBanks(Header)*0x4000)
#define GB_CMP(Header)      Header[0x14D]
#define GB_Version(Header)  Header[0x14C]
#define GB_Type(Header)     Header[0x147]

/** GB_RAMSize() *********************************************/
/** Size of on-cartridge RAM in bytes.                      **/
/*************************************************************/
int GB_RAMSize(unsigned char *Header);

/** GB_Name() ************************************************/
/** Extract and truncate cartridge name. Returns a pointer  **/
/** to internal buffer!                                     **/
/*************************************************************/
char *GB_Name(unsigned char *Header);

/** GB_Maker() ***********************************************/
/** Try to figure out producer's name. Returns name or NULL **/
/** if no producer is known for cartridge's GB_MakerID().   **/
/*************************************************************/
char *GB_Maker(unsigned char *Header);

/** GB_RealCMP() *********************************************/
/** Calculate complement byte of a cartridge.               **/
/*************************************************************/
unsigned char GB_RealCMP(unsigned char *Header);

/** GB_RealCRC() *********************************************/
/** Calculate CRC of a cartridge.                           **/
/*************************************************************/
unsigned short GB_RealCRC(unsigned char *Data);

#endif /* GBCARTS_H */
