/** EMULib Emulation Library *********************************/
/**                                                         **/
/**                           MIDI.h                        **/
/**                                                         **/
/** This file contains definitions and declarations for     **/
/** routines in MIDI.c.                                     **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996                      **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef MIDI_H
#define MIDI_H

#include <stdio.h>

#define MIN_FREQ     10
#define MAX_FREQ     12285

#define SND_MELODIC  0x01
#define SND_NOISE    0x02
#define SND_PERIODIC 0x04

int InitMIDI(FILE *File,int Channels,int Ticks);
    /* Initialize MIDI. Returns 1 on success, 0 otherwise.   */
void TrashMIDI(void);                    /* Shut down MIDI   */
void MIDITicks(int N);                   /* Count N ticks    */
void SetSound(int Channel,int Type);     /* Set sound type   */
void SetFreq(int Channel,int Freq);      /* Set frequency    */
void SetVolume(int Channel,int Volume);  /* Set volume       */
void Sound(int Channel,int Freq,int Volume);
    /* Generate sound of given frequency (Hz) and volume     */
    /* (0..255) via given channel.                           */

#endif /* MIDI_H */
