%TITLE          "DIR2ATR - Convert pc directory into Atari XL/XE ATR disk image(s) - CHiPS bv 1998"
;**********************************************************************
;**                                                                  **
;**  Program   : XDIR v02.00.00                                      **
;**  Purpose   : Convert pc directory into                           **
;**              Atari XL/XE ATR disk image(s)                       **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : May 19th, 1998                                      **
;**                                                                  **
;**  Calls     : DC_DIRS  - Determine Current Directories            **
;**              DC_DRV   - Determine Current Drives                 **
;**              DC_FILES - Determine Current Files                  **
;**              FIL2DISK - Add current dir files to XL/XE ATR image **
;**            : HEX2DIGI - Convert Hex Data To Digits (Text)        **
;**              WSIO     - Screen Handler                           **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\keyboard.equ"
include ".\equ\sysdep.equ"
include ".\equ\video.equ"
include ".\equ\wsio.equ"

EXTRA_TABLE_FIELDS          EQU     16
DIR_MAP_LENGTH              EQU (MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS) * DIR_ENTRY_LENGTH



;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db       128 dup (0)            ; Stack

ENDS    SSeg

;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\dta.str"
include ".\str\position.str"
include ".\str\wsio.str"

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Return_Code             DB    0

Requested_Format_Drives DB   "1"                ; 1 = "ABCDEFGHIJKL    " etc.
                                                ; 2 = "A: [Floppy     ]"
                                                ;     "C: [HARD_DRIVE ]" etc.
Requested_Format_LibFil DB   "1"                ; 1 = DIRENTRY format    etc.
                                                ; 2 = "..           <DIR>      "
                                                ;     "ATARI        <DIR>      "
Hex2digi_Requested_Format       DB  "2"         ; "1" = With thousand seperator
                                                ; "2" = Mo thousand seperator
Media_Id_Buffer         DB   25 dup (NULL)
Available_Drives        DB  MAX_DRIVES     dup (SPACE)
Directories_File_Mask   DB   "*.*         "
Search_Files_Path       DB  PATH_LENGTH    dup (SPACE)
                        DB  NULL                ; To satisfy DOS find file
Search_Dirs_Path        DB  PATH_LENGTH    dup (SPACE)
Search_Filemask         DB  FILE_NAME_LENGTH    dup (SPACE)

Save_cx                 DW    ?
Dir_Memo_Occur_Curr     DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Occur_W_Curr   DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Pointer        DB    0
Dir_Up                  DB    0                 ; 0=Stay current
                                                ; 1=Go dir up
                                                ; 2=Go dir down
Mouse_Pressed           DB  LOGIC_NO

Old_Dta_Seg             DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs             DW    ?                 ; Old Dta Segment Offset
Own_Dta                 Dta <>



;----------------------------------------------------------------------
;--                                                                  --
;--  C O N F I G U R A T I O N   F I L E                             --
;--                                                                  --
;----------------------------------------------------------------------
Config_Field_Filemask           DB    "*.*         "
Config_Field_Startup_Path       DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)
                                DB   1            dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  S C R E E N S   S E C T I O N                                   --
;--                                                                  --
;----------------------------------------------------------------------
Filler                  DB   64 dup (" ")

;**********************************************************************
; B a c k G r o u n d                                                 *
;**********************************************************************
Ws_BG                   DB    WSIO_OPEN
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_BG_Name              DB    "BG      "
Ws_BG_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_BG_Text              DB    "ͻ"
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "ͼ"
                        DB    NULL
Ws_BG_Fields            DB    NULL

;**********************************************************************
; F r e e W a r e                                                     *
;**********************************************************************
Ws_FW                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FW_Name              DB    "FREEWARE"
Ws_FW_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FW_Text              DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   DIR2ATR - Convert pc dir into .ATRs - v02.00.00  "
                        DB                               "                                                    "
                        DB                               "   by B.F. Schreurs, May 9th, 1998, CHiPS bv        "
                        DB                               "   Computer High Performance Software - Freeware    "
                        DB                               "   Email: stack@xs4all.nl                           "
                        DB                               "   Homepage: http:\\www.xs4all.nl\~stack            "
                        DB                               "                                                    "
                        DB                               "   Please select the appropiate Directory           "
                        DB                               "   (and Drive) to be converted into .ATR disks.     "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB    NULL
Ws_FW_Fields            DB    NULL

;**********************************************************************
; P A t h                                                             *
;**********************************************************************
Ws_PA                   DB    WSIO_DISPLAY_ONLY
                        DB    2                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB    2                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_PA_Name              DB    "PATH    "
Ws_PA_Keys              DB    KEY_ESC, KEY_ENTER, KEY_ARROW_LEFT, KEY_ARROW_RIGHT
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_PA_Text              DB    "Path:                                                                          "
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Path Specification
;
Ws_PA_F_Path            DB    1                 ; Relative ROW, NULL=End
                        DB    7                 ; Relative COLUMN 
                        DB   72                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_PA_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Search Files Path

;**********************************************************************
; D R i v e   S e l e c t i o n                                       *
;**********************************************************************
Ws_DR                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DR_Name              DB    "DRIVES  "
Ws_DR_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DR_Text              DB     "[Select Drive]ͻ"
                        DB     "    A: [FLOPPYDRIVE]    "
                        DB     "    C: [MY_VOLUME  ]    "
                        DB     "    D: [MY_CDROM   ]    "
                        DB     "    E: [NET_DRIVE  ]    "
                        DB     "    Z: [RAM_DISK   ]    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help                 "
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Drive Table
;
Ws_DR_F_Drive           DB    2                 ; Relative ROW, NULL=End
                        DB    6                 ; Relative COLUMN 
                        DB   16                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Drive Table
;
Ws_DR_D_Drive           DB    MAX_DRIVES + EXTRA_TABLE_FIELDS dup ("                ")

;--------------------
; W O R K F I E L D S
;--------------------
Ws_DR_Occur_Curr        DW    ?
Ws_DR_Occur_Max         DW    ?                 ; Maximum nr of drives present
Ws_DR_Occur_W_Curr      DW    ?
WS_DR_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; D r i v e   H e l p   S c r e e n                                   *
;**********************************************************************
Ws_DH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_DH_Name              DB    "DRIVEHLP"
Ws_DH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DH_Text              DB     "[Drive Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select drive    "
                        DB     "", ARROW_UP, "     = Previous drive  "
                        DB     "", ARROW_DOWN, "     = Next drive      "
                        DB     "Home  = First drive     "
                        DB     "End   = Last drive      "
                        DB     "Pg Up = Previous drives "
                        DB     "Pg Dn = Next drives     "
                        DB     "F1    = This screen     "
                        DB     "Esc   = Cancel          "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Esc=Exit Help           "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; L i b r a r y   F i l e   S e l e c t i o n                         *
;**********************************************************************
Ws_LF                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_LF_Name              DB    "LIBFILES"
Ws_LF_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2,        KEY_F3
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LF_Text              DB     "[Select Dir/Image]", ARROW_UP, ARROW_DOWN, ""
                        DB     "..           <DIR>      "
                        DB     "ASM          <DIR>      "
                        DB     "EQUAL        <DIR>      "
                        DB     "MYDIR        <DIR>      "
                        DB     "PROJECT .TOO <DIR>      "
                        DB     "ATARI   .ATR 123,456,789"
                        DB     "MY      .ATR  12,345,678"
                        DB     "YOUR    .ATR   1,234,567"
                        DB     "ZZZZZZZZ.ATR     123,456"
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help F2=CurDir F3=Drv"
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Directories/Images Table
;
Ws_LF_F_Dir_Fil         DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   24                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Up         DB    1                 ; Relative ROW, NULL=End
                        DB   24                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_UP       ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Down       DB    1                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_DOWN     ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Dir / Fil Table
;
Dir_Map_ptr_es          DW    1 dup (NULL)      ; Segment 1
Dir_Map_ptr_di          DW    1 dup (NULL)

;--------------------
; W O R K F I E L D S
;--------------------
Ws_LF_Occur_Curr        DW    ?
Ws_LF_Occur_Max         DW    ?                 ; Maximum nr of entries present
Ws_LF_Occur_W_Curr      DW    ?
WS_LF_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; L i b r a r y   F i l e   H e l p   S c r e e n                     *
;**********************************************************************
Ws_LH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_LH_Name              DB    "LIBHELP "
Ws_LH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LH_Text              DB     "[Dir/Image Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select Dir/Image"
                        DB     "", ARROW_UP, "     = Prev Dir/Image  "
                        DB     "", ARROW_DOWN, "     = Next Dir/Image  "
                        DB     "Home  = First Dir/Image "
                        DB     "End   = Last Dir/Image  "
                        DB     "Pg Up = Prev Dirs/Images"
                        DB     "Pg Dn = Next Dirs/Images"
                        DB     "F1    = This screen     "
                        DB     "F2    = Select Curr Dir "
                        DB     "F3    = Go to drive scrn"
                        DB     "Esc   = Exit Program    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Esc=Exit Help           "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - D R I V E   N O T   R E A D Y                           *
;**********************************************************************
Ws_E1                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E1_Name              DB    "ERROR1  "
Ws_E1_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E1_Text              DB                                             "[Drive Not Ready]ͻ"
                        DB                                             "                      "
                        DB                                             " There is NO media in "
                        DB                                             " the requested drive! "
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

ENDS    DSeg



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg1 Word Public 'LIBFILES'
Dir_Map                 DB   DIR_MAP_LENGTH dup ("E")

ENDS    DSeg1

;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   DC_DIRS:proc            ; Determine Current Directories
        EXTRN   DC_DRV:proc             ; Determine Current Drives
        EXTRN   DC_FILES:proc           ; Determine Current Files
        EXTRN   FIL2DISK:proc           ; Add current directory files to XL/XE ATR image
        EXTRN   HEX2DIGI:proc           ; Convert Hex Data To Digits (Text)
        EXTRN   WSIO:proc               ; Screen Handler



;**********************************************************************
Main:   
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize DS to address
        mov     ds, ax                          ; of data segment

        call    Init_Program
        call    Init_Screens
        call    Parameter_Processing
        call    Read_VTOC_Drives
        call    Open_Ws_BG
        call    Display_Ws_BG                   ; Display background
        call    Display_Ws_FW                   ; Display freeware message

@@20:
        call    Display_and_Read_Ws_LF          ; Let user select library

@@30:
        call    Close_Ws_BG
        call    Exit_Program



;**********************************************************************
PROC    Init_Program
;**********************************************************************
        xor     ax, ax
        mov	ah, DOS_SET_MEMORY_BLOCK_SIZE   ; resize the psp memory
        xor     bx, bx
        int	DOS_SERVICE

;
; Segment Addressing
;
        ASSUME  ds:DSeg1
        mov     ax, DSeg1                       ; Initialize ds to address
        mov     ds, ax                          ; of data segment
 
        mov     si, offset Dir_Map
        push    ds si
        pop     di es

        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize ds to address
        mov     ds, ax                          ; of data segment

        mov     [Dir_Map_ptr_es], es
        mov     [Dir_Map_ptr_di], di
 
@@99:
        ret

ENDP    Init_Program



;**********************************************************************
PROC    Init_Screens
;**********************************************************************
;
; Init screen BG=Background
;
        mov     si, offset Ws_BG
        push    ds si
        pop     di es

        mov     si, offset Ws_BG_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_BG_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_BG_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FW=FreeWare
;
        mov     si, offset Ws_FW
        push    ds si
        pop     di es

        mov     si, offset Ws_FW_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FW_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FW_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen PA=Path
;
        mov     si, offset Ws_PA
        push    ds si
        pop     di es

        mov     si, offset Ws_PA_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_PA_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_PA_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_PA_F_Path
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Files_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DR=Drives
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     si, offset Ws_DR_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DR_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DR_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DR_F_Drive
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DH=Drive Help Screen
;
        mov     si, offset Ws_DH
        push    ds si
        pop     di es

        mov     si, offset Ws_DH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen LF=Directories/Images
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     si, offset Ws_LF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, [Dir_Map_ptr_es]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     ax, [Dir_Map_ptr_di]
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], ax

;
; Init screen LH=Directory/Image Help Screen
;
        mov     si, offset Ws_LH
        push    ds si
        pop     di es

        mov     si, offset Ws_LH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E1=Error Screen - Drive Not Ready
;
        mov     si, offset Ws_E1
        push    ds si
        pop     di es

        mov     si, offset Ws_E1_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E1_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E1_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        ret

ENDP    Init_Screens



;**********************************************************************
PROC    Parameter_Processing
;**********************************************************************
;----------------------
; Use current directory
;----------------------
@@10:
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE
        rep     stosb                           ; Clear parameter

; Get default drive
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_DEFAULT_DRIVE       ; Get Default Drive
        int     DOS_SERVICE 
        add     al, 041h                        ; Because of 0-based stuff

; Process Drive
        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], al                ; Process Drive letter
        mov     [byte ds:si + 1], COLON
        mov     [byte ds:si + 2], BACKSLASH
        add     si, 3                           ; Locating at directory stuff

; Get current directory
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_CURRENT_DIRECTORY
        xor     dx, dx                          ; Reset dx
        mov     dl, DOS_DEFAULT_DRIVE
        int     DOS_SERVICE

; Terminate it with a backslash "\"
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        mov     ax, SPACE                       ; Search for non space
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting

        mov     cl, BACKSLASH                   ; Assume adding a backslash
        cmp     [byte es:di], BACKSLASH         ; Are we in the root?
        jne     @@15                            ; No
                                                ; Yes, so
        mov     cl, SPACE                       ; Replace 000h by SPACE

@@15:
        inc     di                              ; Pointer adjustment after search
        mov     [byte es:di], cl

;---------------------------------
; Copy Startup path to search path
;---------------------------------
@@20:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Field_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@99:
        ret

ENDP    Parameter_Processing



;**********************************************************************
PROC    Read_VTOC_Drives
;**********************************************************************
;
; Get drives in format: ACDE etc.
;
        mov     [Requested_Format_Drives], "1"          ; Format ABCDE
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Available_Drives     ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;
; Get drives in format: [A: Myvolume   ]
;                       [C: Yourvolume ] etc.
;
        mov     [Requested_Format_Drives], "2"          ; Format [A: Myvolume   ]
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Ws_DR_D_Drive  ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;-----------------------
; Specify start of table
;-----------------------
        mov     [Ws_DR_Occur_Curr], 0

@@00:
;-----------------------------------
; Determine which drive to highlight
;-----------------------------------
        mov     [Ws_DR_Occur_W_Curr], 0

        mov     si, offset Search_Dirs_Path
        mov     bl, [byte ds:si]                ; Config path drive

;-------------------------------------------
; Determine maximum number of drives present
;-------------------------------------------
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     cx, MAX_DRIVES

        mov     [Ws_DR_Occur_Max], 0
        mov     si, offset Ws_DR_D_Drive

@@10:
        cmp     [byte ds:si], SPACE
        je      @@30

        inc     [Ws_DR_Occur_Max]
        cmp     [byte ds:si], bl                ; Selected drive found?
        jne     @@20                            ; No
                                                ; Yes, so
        mov     dx, [Ws_DR_Occur_Max]
        mov     [Ws_DR_Occur_Curr], dx

@@15:
        mov     [Ws_DR_Occur_W_Curr], dx
        cmp     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; dx > Max occur of window?
        jle     @@20                            ; No
                                                ; Yes, so
        sub     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Move 1 window up
        jmp     @@15

@@20:
        add     si, ax
        loop    @@10

@@30:
        cmp     [Ws_DR_Occur_W_Curr], 0         ; Invalid drive specified?
        jne     @@40                            ; No
                                                ; Yes, so

        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], SPACE             ; Clear Config Field
        call    Parameter_Processing
        jmp     @@00                            ; Redo this section

@@40:
;------------------------------------
; Pass offset address of drives table
;------------------------------------
        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

@@99:
        ret

ENDP    Read_VTOC_Drives



;**********************************************************************
PROC    Open_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        cmp     ax, NULL                        ; Error?
        jz      @@99                            ; No
                                                ; Yes, so
;
; Error
;

@@99:        
        ret

ENDP    Open_Ws_BG



;**********************************************************************
PROC    Display_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_BG



;**********************************************************************
PROC    Display_Ws_FW
;**********************************************************************
        mov     si, offset Ws_FW

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_FW



;**********************************************************************
PROC    Display_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_PA



;**********************************************************************
PROC    Display_Ws_DR
;**********************************************************************
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DR



;**********************************************************************
PROC    Display_and_Read_Ws_DR
;**********************************************************************
;----------
; Init Path
;----------
;
; Reset Search Dirs Path
;
        mov     si, offset Search_Dirs_Path     ; Clear path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        call    Display_Ws_DR
        jmp     @@10

;---------------------------------
; Show fields only of Drives Table
;---------------------------------
@@05:
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;
; Make current occurrence Green/White
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_DR_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_DR_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_DR_Occur_Curr]          ; Current occurr = max?
        je      @@10                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_DR_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]
        dec     dx
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_DR_Occur_Max]           ; Is there a next window?
        jnle    @@10                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_DR_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_DR_Occur_Max]           ; Determine difference
        sub     [Ws_DR_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_DR_Occur_Max]

@@36:
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 1         ; At top of window?
        je      @@10                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_DR_Occur_W_Curr], 1
        mov     [Ws_DR_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_DR_Occur_Max]           ; Can we go "down" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Max]           ; Go to last occurrence
        mov     [Ws_DR_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_W_Curr], cx        ; Go  to  last entry in window
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_DR_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;----------------------------------------
; Set up drive window data and attributes
;----------------------------------------
@@50:
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     si, offset Ws_DR_D_Drive

        jmp     @@52

@@51:
        add     si, ax

@@52:
        loop    @@51

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@10                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_DR_Occur_Max]           ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_DR_Occur_W_Curr], cx

@@61:
;
; Copy selected drive to path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     si, offset Available_Drives
        add     si, [Ws_DR_Occur_Curr]
        dec     si
        movsb
        mov     [byte es:di], COLON
        mov     [byte es:di + 1], BACKSLASH

;
; Show new path to user
;
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     [Dir_Memo_Pointer], 0           ; Reset directory memo pointer
        jmp     @@99

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_DH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_DR



;**********************************************************************
PROC    Display_Ws_DH
;**********************************************************************
        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DH



;**********************************************************************
PROC    Read_VTOC_Directories_Files
;**********************************************************************
        cmp     [Dir_Up], 2                     ; Do we have to remember from which directory we came from?
        jne     @@05                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]
        mov     dx, [Ws_LF_Occur_W_Curr]
        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], cx
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], dx
        inc     [Dir_Memo_Pointer]

@@05:
        mov     [Ws_LF_Occur_Max], 0

;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        mov     si, offset Search_Dirs_Path
        cmp     [byte ds:si], "A"               ; Access drive A?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], "B"               ; Access drive B?
        jne     @@20                            ; No
                                                ; Yes, so
@@10:
        xor     bx, bx                          ; Reset dx
        mov     bl, [byte ds:si]                ; Copy selected drive to path
        sub     bl, 64                          ; Turn drive into DOS drive
        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     al, 00Dh                        ; subfunction code
        mov     cx, DOS_GET_MEDIA_ID_CX
        mov     dx, offset Media_ID_Buffer
        int     DOS_SERVICE                     ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_READY         ; Drive ready?
        jne     @@20                            ; Yes
                                                ; No, so
;------------------------
; ERROR - DRIVE NOT READY
;------------------------
        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@99

@@20:        
;-------------------------------
; Set up Search path - Libraries
;-------------------------------
;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add "*.*" to the Search path
;
        mov     si, offset Directories_File_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3
        push    es di
 
;-----------------------------------------
; Now retrieve Directory Map - Directories
;-----------------------------------------
        call    DC_DIRS

        pop     ax ax ax ax ax ax

;---------------------------
; Set up Search path - Files
;---------------------------

;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add FileMask to the Search path
;
        mov     si, offset Search_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

;
; Search null terminator
;
        xor     ax, ax
        mov     al, NULL                        ; Search the first null
        mov     cx, DIR_MAP_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

        push    es di
 
;-----------------------------------
; Now retrieve Directory Map - Files
;-----------------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;------------------------------------------------------
; After reading the VTOC we are at the first occurrence
;------------------------------------------------------
        mov     cx, 1                           ; To satisfy loop condition
        mov     [Ws_LF_Occur_Curr], 1
        mov     [Ws_LF_Occur_W_Curr], 1

        cmp     [Dir_Up], 1                     ; Did we go up a dir?
        jne     @@50                            ; No
                                                ; Yes, so
        cmp     [Dir_Memo_Pointer], 0           ; Did we have save info of previous dirs?
        je      @@50                            ; No
                                                ; Yes, so
        dec     [Dir_Memo_Pointer]

        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to occupied spot
        mov     cx, [ds:si]
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to occupied spot
        mov     dx, [ds:si]

        mov     [Ws_LF_Occur_Curr], cx
        mov     [Ws_LF_Occur_W_Curr], dx

        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now

@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

;------------------------------------
; Determine MAXimum nr of occurrences
;------------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, DIR_MAP_LENGTH              ; Search length
        xor     ax, ax                          ; Search for null character
        repne   scasb                           ; Search uses es:di

        mov     ax, DIR_MAP_LENGTH
        sub     ax, cx                          ; Nr of entries in size determined
        xor     dx, dx
        xor     cx, cx
        mov     bx, DIR_ENTRY_LENGTH            ; Determine nr of occurs
        div     bx

        mov     [Ws_LF_Occur_Max], ax

@@99:
        call    Display_Ws_PA                   ; Display path

        ret

ENDP    Read_VTOC_Directories_Files



;**********************************************************************
PROC    Display_and_Read_Ws_LF
;**********************************************************************
        jmp     @@64                            ; Because of startup path

;------------------------------------------
; Show fields only of Libraries/Files Table
;------------------------------------------
@@05:
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;------------------------------------------
; Show Freeware Text or Disk Image contents
;------------------------------------------
        call    Display_Ws_FW                   ; Show Freeware Text

;------------------------------------
; Make current occurrence Green/White
;------------------------------------
@@15:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;----------
; Get input
;----------
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_F2                      ; Select current directory
        je      @@68
        cmp     al, KEY_F3                      ; Back to drives
        je      @@62
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_LF_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_LF_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_LF_Occur_Curr]          ; Current occurr = max?
        je      @@15                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_LF_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]
        dec     dx
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_LF_Occur_Curr]          ; Can we go "down" anyhow?
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_LF_Occur_Max]           ; Is there a next window?
        jnle    @@15                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_LF_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_LF_Occur_Max]           ; Determine difference
        sub     [Ws_LF_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_LF_Occur_Max]

@@36:
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_LF_Occur_W_Curr], 1         ; At top of window?
        je      @@15                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_LF_Occur_W_Curr], 1
        mov     [Ws_LF_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_LF_Occur_Max]           ; Can we go "down" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Max]           ; Go to last occurrence
        mov     [Ws_LF_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_W_Curr], cx        ; Go  to  last entry in window
        mov     cx, 1                           ; Start from first occurrence
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_LF_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;--------------------------------------------
; Set up dir/image window data and attributes
;--------------------------------------------
@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@15                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_LF_Occur_Max]           ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_LF_Occur_W_Curr], cx

@@61:
        push    ds si

;
; Go to end of path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                              ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Go to drive selection or dirs?
;        
        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax
        cmp     [byte es:di], DOT               ; Go to drive selection/dirs?
        jne     @@66                            ; No
                                                ; Yes, so
        pop     di es                           ; Check path
        pop     si ds
        cmp     [byte es:di - 2], COLON         ; Go to drive selection?
        jne     @@65                            ; No
                                                ; Yes, so
@@62:
;
; Select another drive
;

@@63:
;
; Reset Search Files Path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb                           ; Clear path

        call    Display_Ws_PA                   ; Display path
        call    Display_and_Read_Ws_DR          ; Let user select drive

        cmp     al, KEY_ESC                     ; Cancel pressed?
        je      @@99                            ; Yes
                                                ; No, so
@@64:
        mov     [Dir_Up], 0                     ; We stay in the current dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0            ; Drive not ready?
        je      @@62                            ; Yes
                                                ; No, so
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@10

@@65:
;
; Go to previous dir
;
        dec     di                              ; Position on the "\"
        dec     di                              ; Position before the "\"
        std                                     ; Search direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

        mov     cx, DIR_NAME_LENGTH + 1         ; Because of "\"
        add     cx, FILE_NAME_LENGTH            ; Because of *.ATR
        mov     ax, SPACE
        rep     stosb

        mov     [Dir_Up], 1                     ; We go to previous dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files
        jmp     @@05

@@66:
;
; Go to subdir OR do nothing
;
        push    es di
        add     di, FILE_NAME_LENGTH + 1        ; Go to file size
        cmp     [byte es:di], "<"               ; Directory indicator
        pop     si ds                           ; From -> Dir/File table

        pop     di es                           ; To   -> Path
        jne     @@67                            ; It's a file!
                                                ; It's a directory, so
        mov     cx, DIR_NAME_LENGTH
        rep     movsb

        pop     si ds

        dec     di
        std                                     ; Search direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, SPACE                       ; Search for not equal " "
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To position after the " "

        mov     [byte es:di], BACKSLASH

        mov     [Dir_Up], 2                     ; We go to a subdir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        jmp     @@05

@@67:
        pop     si ds

        jmp     @@15

@@68:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Files_Path
        mov     cx, PATH_LENGTH
        rep     movsb

        call    Add_DirFiles_To_ATR_Image

        jmp     @@05

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_LH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_LF



;**********************************************************************
PROC    Display_Ws_LH
;**********************************************************************
        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_LH



;**********************************************************************
PROC    Add_DirFiles_To_ATR_Image
;**********************************************************************
        mov     si, offset Search_Files_Path            ; Parameter 1
        push    ds si

        call    FIL2DISK

        pop     ax ax

        ret

ENDP    Add_DirFiles_To_ATR_Image



;**********************************************************************
PROC    Close_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Close_Ws_BG



;**********************************************************************
PROC    Exit_Program
;**********************************************************************
        mov     ah, DOS_TERMINATE_EXE
        mov     al, [Return_Code]           ; Return code value
        int     DOS_SERVICE

ENDP    Exit_Program



ENDS    CSeg                                ; End of Code segment

END     Main
