%TITLE          "Pc Directory to XL/XE .ATR Disk Image File Creator - CHiPS bv 1998"
;**********************************************************************
;**                                                                  **
;**  Program   : FIL2DISK                                            **
;**  Purpose   : Pc Directory to XL/XE .ATR Disk Image Creator       **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : May 15, 1998                                        **
;**                                                                  **
;**  Calls     : DC_DIRS  - Determine Current Directories            **
;**              DC_DRV   - Determine Current Drives                 **
;**              DC_FILES - Determine Current Files                  **
;**            : HEX2DIGI - Convert Hex Data To Digits (Text)        **
;**              WSIO     - Screen Handler                           **
;**                                                                  **
;**  Parameter : 1. Pass the address of the directory path where the **
;**                 files reside to be placed on an ATR disk image.  **
;**                 Path size is PATH_LENGTH.                        **
;**                                                                **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Functions which can be called                                   --
;----------------------------------------------------------------------
        PUBLIC  FIL2DISK

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\keyboard.equ"
include ".\equ\sysdep.equ"
include ".\equ\video.equ"
include ".\equ\wsio.equ"

EXTRA_TABLE_FIELDS          EQU     16
DIR_MAP_LENGTH              EQU (MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS) * DIR_ENTRY_LENGTH

ATR_HEADER_SIZE                 EQU     16
EIGHTBIT_VTOC_OFFSET            EQU  0B400h
EIGHTBIT_VTOC_SECTOR_BITMAP     EQU    360
EIGHTBIT_VTOC_SECTOR_FILES      EQU    361
EIGHTBIT_VTOC_SECTOR_BITEXT     EQU   1023
EIGHTBIT_VTOC_SECTOR_END_MEDIUM EQU   1040
EIGHTBIT_VTOC_SECTOR_END_ENHANC EQU   1120
EIGHTBIT_VTOC_SECTOR_END_DOUBLE EQU   1440
EIGHTBIT_VTOC_SECTOR_BEGIN      EQU    360
EIGHTBIT_VTOC_SECTOR_END        EQU    368
EIGHTBIT_VTOC_FILES             EQU     64
EIGHTBIT_FILE_ENTRY_SIZE        EQU     16
EIGHTBIT_FILE_NAME_LENGTH       EQU     11
EIGHTBIT_SECTOR_PHANTOM         EQU    720
EIGHTBIT_SECTOR_SIZE            EQU    128
EIGHTBIT_SECTOR_DATA_SIZE       EQU    125
EIGHTBIT_VTOC_SIZE              EQU   1024
DISK_BOOTCODE_SIZE              EQU    384
DISK_BOOTCODE_SECTOR_SIZE       EQU      3
DISK_BLOCK_SIZE                 EQU   1024
DISK_SECTORS_SINGLE             EQU    720
DISK_SECTORS_SINGLE_USABLE      EQU    689
DISK_SECTORS_MEDIUM             EQU   1040
DISK_SECTORS_MEDIUM_USABLE      EQU   1009
DISK_SECTORS_ENHANCED           EQU   1120
DISK_SECTORS_ENHANCED_USABLE    EQU   1089
DISK_SECTORS_DOUBLE             EQU   1440
DISK_SECTORS_DOUBLE_USABLE      EQU   1409
FILE_DOS25_DOS_SECTOR_SIZE      EQU     37
FILE_DOS25_DUP_SECTOR_SIZE      EQU     42
FILE_MYDOS_DOS_SECTOR_SIZE      EQU     35
FILE_MYDOS_DUP_SECTOR_SIZE      EQU     54
NODOS_FORMAT                    EQU     " "
DOS25_FORMAT                    EQU     "D"
MYDOS_FORMAT                    EQU     "M"



;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db       256 dup (0)            ; Stack

ENDS    SSeg

;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\direntry.str"
include ".\str\dta.str"
include ".\str\position.str"
include ".\str\wsio.str"

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Fil2disk_Initialize     DB    LOGIC_NO

Requested_Format_Drives DB   "1"                ; 1 = "ABCDEFGHIJKL    " etc.
                                                ; 2 = "A: [Floppy     ]"
                                                ;     "C: [HARD_DRIVE ]" etc.
Requested_Format_LibFil DB   "1"                ; 1 = DIRENTRY format    etc.
                                                ; 2 = "..           <DIR>      "
                                                ;     "ATARI        <DIR>      "
Hex2digi_Requested_Format       DB  "2"         ; "1" = With thousand seperator
                                                ; "2" = Mo thousand seperator

File_Map_Length      = ( MAX_FILES * FILE_ENTRY_LENGTH )

Media_Id_Buffer         DB   25 dup (NULL)
Available_Drives        DB  MAX_DRIVES     dup (SPACE)
Directories_File_Mask   DB   "*.*         "
Search_Files_Path       DB  PATH_LENGTH    dup (SPACE)
                        DB  NULL                ; To satisfy DOS find file
Search_Dirs_Path        DB  PATH_LENGTH    dup (SPACE)
Search_Filemask         DB  FILE_NAME_LENGTH    dup (SPACE)

Save_cx                 DW    ?
Dir_Memo_Occur_Curr     DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Occur_W_Curr   DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Pointer        DB    0
Dir_Up                  DB    0                 ; 0=Stay current
                                                ; 1=Go dir up
                                                ; 2=Go dir down
Mouse_Pressed           DB  LOGIC_NO
Dir2atr_Error           DB  LOGIC_NO            ; 0=No Error
                                                ; 1=Error Encountered
Path_Spec               DB   PATH_LENGTH dup (SPACE)
File_Map_Entry          Dir_Entry <>

Progress_Bar_Cnt_Prev   DB    0
Progress_Bar_Cnt_Max    DB   32
Progress_Bar_Cnt_Files  DW    0
Progress_Bar_Files      DW    0

ATR_Header              DB   96h,02h,80h,20h,80h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
ATR_Header_Single       DB   96h,02h,80h,16h,80h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
ATR_Header_Medium       DB   96h,02h,80h,20h,80h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
ATR_Header_Enhanced     DB   96h,02h,00h,23h,80h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
ATR_Header_Double       DB   96h,02h,0E8h,2Ch,00h,01h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
VTOC_Header_DOS25       DB   042h,025h,000h,004h,000h
                        DB  "DOS     SYS"
                        DB   042h,02Ah,000h,029h,000h
                        DB  "DUP     SYS"
VTOC_Header_DOS25_NODUP DB   042h,025h,000h,004h,000h
                        DB  "DOS     SYS"
                        DB   000h,000h,000h,000h,000h
                        DB  "           "
VTOC_Header_MYDOS       DB   042h,023h,000h,004h,000h
                        DB  "DOS     SYS"
                        DB   042h,036h,000h,027h,000h
                        DB  "DUP     SYS"
VTOC_Header_MYDOS_NODUP DB   042h,023h,000h,004h,000h
                        DB  "DOS     SYS"
                        DB   000h,000h,000h,000h,000h
                        DB  "           "
Disk_Name               DB  "000"
                        DB  ".ATR     "
Disk_Seq_Nr             DW    0
Disk_Seq_Nr_Present     DW    0

Passed_Parameters       DB  PATH_LENGTH dup (0)

Disk_Path               DB  PATH_LENGTH dup (0)     ; C:\TO
File_Path               DB  PATH_LENGTH dup (0)     ; C:\FROM
File_DOS25_DOS_SYS      DB  "C:\DIR2ATR\DOS25\DOS.SYS"
                        DB  PATH_LENGTH dup (0)
File_DOS25_DUP_SYS      DB  "C:\DIR2ATR\DOS25\DUP.SYS"
                        DB  PATH_LENGTH dup (0)
File_MYDOS_DOS_SYS      DB  "C:\DIR2ATR\MYDOS\DOS.SYS"
                        DB  PATH_LENGTH dup (0)
File_MYDOS_DUP_SYS      DB  "C:\DIR2ATR\MYDOS\DUP.SYS"
                        DB  PATH_LENGTH dup (0)
Temp_File_Name          DB  "            "
File_Name_DOS_SYS       DB  "DOS.SYS     "
File_Name_DUP_SYS       DB  "DUP.SYS     "

Disk_Mask               DB   "*.ATR       "
File_Mask               DB   "*.*         "
ATR_Disk_Image_Open     DB    1 dup (FALSE)
Atari_Files_Processed   DB    64
File_Size_In_Sectors    DW     0
Disk_Sector_Start       DW     4
Disk_Sector_Current     DW     4
Disk_Sector_Next        DW     5
Disk_Sectors_Left       DW  1009
Disk_Sectors_Available  DW     0
Bytes_In_Sector         DB     0

Old_Dta_Seg             DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs             DW    ?                 ; Old Dta Segment Offset
Own_Dta                 Dta <>

Disk_Handler            DW      0
File_Handler            DW      0
VTOC_I_O_Buffer         DB  EIGHTBIT_VTOC_SIZE dup (0)
VTOC_I_O_Bitmap         DB  EIGHTBIT_SECTOR_SIZE dup (0)
VTOC_I_O_Bitmap_Extend  DB  EIGHTBIT_SECTOR_SIZE dup (0)
Disk_I_O_Buffer         DB  EIGHTBIT_SECTOR_SIZE dup (0)
Disk_File_ID            DB      0
Remainder_Bytes         DB      0

Disk_Sectors            DW      0
Disk_Sectors_Usable     DW      0

; Supported DOS formats: "D"=DOS 2.5, "M"=MYDOS 4.53, " "=None
DOS_Format              DB  "D"

; Continue adding disks after highest disk number found? N=NO A=YES
Disk_Adding             DB  "N"

;
;   Atari Disk sector layout
;    Byte 1      Byte 125           Byte 126                 Byte 127                 Byte 128
; +----------//------------+------------------------+------------------------+------------------------+
;                          6 bits File ID    10 bits for Next Sector Addr  Byte Count per Sector  
; +----------//------------+------------------------+------------------------+------------------------+
;
Bootcode_MYDOS          DB   04Dh,003h,000h,007h,0E0h,007h,04Ch,014h,007h,003h,009h,001h,0E8h,01Bh,001h,004h
                        DB   000h,07Dh,00Ah,00Bh,0ACh,012h,007h,0ADh,013h,007h,020h,058h,007h,0ADh,010h,007h
                        DB   0ACh,00Fh,007h,018h,0AEh,00Eh,007h,0F0h,01Dh,020h,063h,007h,030h,018h,0ACh,011h
                        DB   007h,0B1h,043h,029h,0FFh,048h,0C8h,011h,043h,0F0h,00Eh,0B1h,043h,048h,020h,04Dh
                        DB   007h,068h,0A8h,068h,090h,0DDh,0A9h,0C0h,0A0h,068h,00Ah,0A8h,060h,0ADh,011h,007h
                        DB   018h,065h,043h,0A8h,0A5h,044h,069h,000h,084h,043h,085h,044h,08Ch,004h,003h,08Dh
                        DB   005h,003h,060h,08Dh,00Bh,003h,08Ch,00Ah,003h,0A0h,003h,0A9h,052h,090h,002h,0A9h
                        DB   050h,084h,048h,08Dh,002h,003h,018h,08Ch,006h,003h,0A9h,080h,0CAh,0F0h,00Dh,0AEh
                        DB   00Bh,003h,0D0h,007h,0AEh,00Ah,003h,0E0h,004h,090h,001h,00Ah,08Dh,008h,003h,02Ah
                        DB   08Dh,009h,003h,0A0h,031h,08Ch,000h,003h,0C6h,048h,030h,016h,0AEh,002h,003h,0E8h
                        DB   08Ah,0A2h,040h,029h,006h,0D0h,002h,0A2h,080h,08Eh,003h,003h,020h,059h,0E4h,088h
                        DB   030h,0E6h,0A6h,02Eh,0C8h,098h,060h,010h,069h,001h,000h,080h,0F6h,000h,000h,000h
                        DB   023h,028h,050h,04Dh,001h,001h,000h,000h,000h,000h,000h,000h,052h,052h,0D2h,0D2h
                        DB   0D2h,0D2h,0D2h,0D2h,05Ch,00Ch,05Ch,00Eh,062h,00Dh,0C6h,00Dh,050h,00Eh,067h,010h
                        DB   0A9h,069h,08Dh,0B8h,007h,0A9h,001h,08Dh,0B9h,007h,0A2h,008h,08Eh,001h,003h,020h
                        DB   0B6h,00Bh,0BDh,0CBh,007h,030h,012h,020h,09Ah,00Bh,0F0h,00Dh,0BDh,0CBh,007h,0C9h
                        DB   040h,0B0h,006h,0BCh,0C3h,007h,020h,024h,00Bh,0CAh,0D0h,0E0h,0A0h,0AEh,08Ah,099h
                        DB   055h,008h,088h,0D0h,0FAh,0EEh,059h,008h,0ADh,00Ch,007h,08Dh,0E7h,002h,0ACh,00Dh
                        DB   007h,0A2h,00Fh,0ECh,009h,007h,090h,005h,0DEh,0DDh,008h,030h,005h,098h,09Dh,0EDh
                        DB   008h,0C8h,0CAh,010h,0EEh,08Ch,0E8h,002h,0E8h,0E8h,0E8h,0BDh,018h,003h,0F0h,004h
                        DB   0C9h,044h,0D0h,0F4h,0A9h,044h,09Dh,018h,003h,0A9h,0D4h,09Dh,019h,003h,0A9h,007h
                        DB   09Dh,01Ah,003h,04Ch,079h,01Ah,000h,000h,0FFh,001h,000h,000h,000h,000h,000h,000h
                        DB   000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0C8h,080h
                        DB   07Dh,000h,003h,004h,000h,000h,000h,000h,000h,069h,001h,000h,000h,000h,000h,000h

Bootcode_DOS25          DB   000h,003h,000h,007h,040h,015h,04Ch,014h
                        DB   007h,003h,003h,000h,0CCh,019h,001h,004h
                        DB   000h,07Dh,0CBh,007h,0ACh,00Eh,007h,0F0h
                        DB   035h,020h,05Fh,007h,0ADh,010h,007h,0ACh
                        DB   00Fh,007h,0A6h,024h,08Eh,004h,003h,0A6h
                        DB   025h,08Eh,005h,003h,018h,020h,06Ch,007h
                        DB   030h,01Ch,0ACh,011h,007h,0B1h,024h,029h
                        DB   003h,0AAh,0C8h,011h,024h,0F0h,011h,0B1h
                        DB   024h,048h,0C8h,0B1h,024h,020h,055h,007h
                        DB   068h,0A8h,08Ah,04Ch,022h,007h,0A9h,0C0h
                        DB   00Ah,0A8h,060h,0A9h,080h,018h,065h,024h
                        DB   085h,024h,090h,002h,0E6h,025h,060h,0ADh
                        DB   012h,007h,085h,024h,0ADh,013h,007h,085h
                        DB   025h,060h,000h,000h,08Dh,00Bh,003h,08Ch
                        DB   00Ah,003h,0A9h,052h,0A0h,040h,090h,004h
                        DB   0A9h,050h,0A0h,080h,008h,0A6h,021h,0E0h
                        DB   008h,0D0h,007h,028h,020h,081h,014h,04Ch
                        DB   0B9h,007h,028h,08Dh,002h,003h,0A9h,00Fh
                        DB   08Dh,006h,003h,08Ch,017h,013h,0A9h,031h
                        DB   08Dh,000h,003h,0A9h,003h,08Dh,009h,013h
                        DB   0A9h,080h,08Dh,008h,003h,00Ah,08Dh,009h
                        DB   003h,0ADh,017h,013h,08Dh,003h,003h,020h
                        DB   059h,0E4h,010h,005h,0CEh,009h,013h,010h
                        DB   0F0h,0A6h,049h,098h,060h,020h,0ADh,011h
                        DB   020h,064h,00Fh,020h,004h,00Dh,04Ch,0C7h
                        DB   012h,000h,000h,064h,008h,08Fh,00Ah,04Dh
                        DB   00Ah,08Fh,009h,0BCh,007h,02Ah,00Bh,080h
                        DB   040h,020h,010h,008h,004h,002h,001h,0FFh
                        DB   0ADh,00Ch,007h,085h,024h,0ADh,00Dh,007h
                        DB   085h,025h,0ADh,00Ah,007h,085h,043h,0A2h
                        DB   007h,0A9h,000h,006h,043h,090h,015h,0A0h
                        DB   005h,091h,024h,0A5h,024h,09Dh,029h,013h
                        DB   0A5h,025h,09Dh,031h,013h,0A9h,090h,020h
                        DB   055h,007h,0A9h,064h,09Dh,019h,013h,0CAh
                        DB   010h,0DFh,0A5h,024h,08Dh,039h,013h,0A5h
                        DB   025h,08Dh,03Ah,013h,0ACh,009h,007h,0A2h
                        DB   000h,088h,098h,09Dh,021h,013h,030h,003h
                        DB   020h,053h,007h,0E8h,0E0h,008h,0D0h,0F1h
                        DB   0A5h,024h,08Dh,0E7h,002h,0A5h,025h,08Dh
                        DB   0E8h,002h,0A9h,000h,0A8h,099h,081h,013h
                        DB   0C8h,010h,0FAh,0A8h,0B9h,01Ah,003h,0F0h
                        DB   00Ch,0C9h,044h,0F0h,008h,0C8h,0C8h,0C8h
                        DB   0C0h,01Eh,0D0h,0F0h,000h,0A9h,044h,099h
                        DB   01Ah,003h,0A9h,0CBh,099h,01Bh,003h,0A9h
                        DB   007h,099h,01Ch,003h,060h,020h,0ADh,011h
                        DB   020h,07Dh,00Eh,0BDh,04Ah,003h,09Dh,082h
                        DB   013h,029h,002h,0F0h,003h,04Ch,072h,00Dh
                        DB   020h,0ECh,00Eh,008h,0BDh,082h,013h,0C9h

File_Map_ptr_es         DW    1 dup (NULL)      ; Segment 1
File_Map_ptr_di         DW    1 dup (NULL)


;----------------------------------------------------------------------
;--                                                                  --
;--  C O N F I G U R A T I O N   F I L E                             --
;--                                                                  --
;----------------------------------------------------------------------
Config_Field_Filemask           DB    "*.*         "
Config_Field_Startup_Path       DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)
                                DB   1            dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  S C R E E N S   S E C T I O N                                   --
;--                                                                  --
;----------------------------------------------------------------------
Filler                  DB   16 dup (" ")

;**********************************************************************
; B a c k G r o u n d                                                 *
;**********************************************************************
Ws_BG                   DB    WSIO_OPEN
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_BG_Name              DB    "BG2     "
Ws_BG_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_BG_Text              DB    "ͻ"
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "ͼ"
                        DB    NULL
Ws_BG_Fields            DB    NULL

;**********************************************************************
; F r e e W a r e                                                     *
;**********************************************************************
Ws_FW                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FW_Name              DB    "FREEWARE"
Ws_FW_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FW_Text              DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   DIR2ATR - Convert pc dir into .ATRs - v02.00.00  "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   Please select the appropiate Directory           "
                        DB                               "   (and Drive) to store the .ATR disk images.       "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB    NULL
Ws_FW_Fields            DB    NULL

;**********************************************************************
; P A t h                                                             *
;**********************************************************************
Ws_PA                   DB    WSIO_DISPLAY_ONLY
                        DB    2                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB    2                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_PA_Name              DB    "PATH    "
Ws_PA_Keys              DB    KEY_ESC, KEY_ENTER, KEY_ARROW_LEFT, KEY_ARROW_RIGHT
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_PA_Text              DB    "Path:                                                                          "
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Path Specification
;
Ws_PA_F_Path            DB    1                 ; Relative ROW, NULL=End
                        DB    7                 ; Relative COLUMN 
                        DB   72                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_PA_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Search Files Path

;**********************************************************************
; D R i v e   S e l e c t i o n                                       *
;**********************************************************************
Ws_DR                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DR_Name              DB    "DRIVES  "
Ws_DR_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DR_Text              DB     "[Select Drive]ͻ"
                        DB     "    A: [FLOPPYDRIVE]    "
                        DB     "    C: [MY_VOLUME  ]    "
                        DB     "    D: [MY_CDROM   ]    "
                        DB     "    E: [NET_DRIVE  ]    "
                        DB     "    Z: [RAM_DISK   ]    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help                 "
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Drive Table
;
Ws_DR_F_Drive           DB    2                 ; Relative ROW, NULL=End
                        DB    6                 ; Relative COLUMN 
                        DB   16                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Drive Table
;
Ws_DR_D_Drive           DB    MAX_DRIVES + EXTRA_TABLE_FIELDS dup ("                ")

;--------------------
; W O R K F I E L D S
;--------------------
Ws_DR_Occur_Curr        DW    ?
Ws_DR_Occur_Max         DW    ?                 ; Maximum nr of drives present
Ws_DR_Occur_W_Curr      DW    ?
WS_DR_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; D r i v e   H e l p   S c r e e n                                   *
;**********************************************************************
Ws_DH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_DH_Name              DB    "DRIVEHLP"
Ws_DH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DH_Text              DB     "[Drive Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select drive    "
                        DB     "", ARROW_UP, "     = Previous drive  "
                        DB     "", ARROW_DOWN, "     = Next drive      "
                        DB     "Home  = First drive     "
                        DB     "End   = Last drive      "
                        DB     "Pg Up = Previous drives "
                        DB     "Pg Dn = Next drives     "
                        DB     "F1    = This screen     "
                        DB     "Esc   = Cancel          "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Esc=Exit Help           "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; L i b r a r y   F i l e   S e l e c t i o n                         *
;**********************************************************************
Ws_LF                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_LF_Name              DB    "LIBFILES"
Ws_LF_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2,        KEY_F3
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LF_Text              DB     "[Select Dir/Image]", ARROW_UP, ARROW_DOWN, ""
                        DB     "..           <DIR>      "
                        DB     "ASM          <DIR>      "
                        DB     "EQUAL        <DIR>      "
                        DB     "MYDIR        <DIR>      "
                        DB     "PROJECT .TOO <DIR>      "
                        DB     "ATARI   .ATR 123,456,789"
                        DB     "MY      .ATR  12,345,678"
                        DB     "YOUR    .ATR   1,234,567"
                        DB     "ZZZZZZZZ.ATR     123,456"
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "ENTER=Select Esc=Cancel "
                        DB     "F1=Help F2=CurDir F3=Drv"
                        DB     "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Directories/Images Table
;
Ws_LF_F_Dir_Fil         DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   24                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Up         DB    1                 ; Relative ROW, NULL=End
                        DB   24                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_UP       ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Down       DB    1                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_DOWN     ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Dir / Fil Table
;
Dir_Map_ptr_es          DW    1 dup (NULL)      ; Segment 1
Dir_Map_ptr_di          DW    1 dup (NULL)

;--------------------
; W O R K F I E L D S
;--------------------
Ws_LF_Occur_Curr        DW    ?
Ws_LF_Occur_Max         DW    ?                 ; Maximum nr of entries present
Ws_LF_Occur_W_Curr      DW    ?
WS_LF_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; L i b r a r y   F i l e   H e l p   S c r e e n                     *
;**********************************************************************
Ws_LH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_LH_Name              DB    "LIBHELP "
Ws_LH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LH_Text              DB     "[Dir/Image Help]ͻ"
                        DB     "                        "
                        DB     "ENTER = Select Dir/Image"
                        DB     "", ARROW_UP, "     = Prev Dir/Image  "
                        DB     "", ARROW_DOWN, "     = Next Dir/Image  "
                        DB     "Home  = First Dir/Image "
                        DB     "End   = Last Dir/Image  "
                        DB     "Pg Up = Prev Dirs/Images"
                        DB     "Pg Dn = Next Dirs/Images"
                        DB     "F1    = This screen     "
                        DB     "F2    = Select Curr Dir "
                        DB     "F3    = Go to drive scrn"
                        DB     "Esc   = Exit Program    "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "                        "
                        DB     "Esc=Exit Help           "
                        DB     "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - D R I V E   N O T   R E A D Y                           *
;**********************************************************************
Ws_E1                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E1_Name              DB    "ERROR1  "
Ws_E1_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E1_Text              DB                                             "[Drive Not Ready]ͻ"
                        DB                                             "                      "
                        DB                                             " There is NO media in "
                        DB                                             " the requested drive! "
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; E R R O R - G E N E R A L   I / O   E R R O R                       *
;**********************************************************************
Ws_E2                   DB    WSIO_DISPLAY_ONLY
                        DB    9                 ; Start of screen ROW
                        DB   32                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   75                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E2_Name              DB    "ERROR2  "
Ws_E2_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E2_Text              DB                                   "[I / O   E r r o r]ͻ"
                        DB                                   "                                          "
                        DB                                   "                                          "
                        DB                                   " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                   "                                          "
                        DB                                   "                                          "
                        DB                                   " Enter=Acknowledge Error                  "
                        DB                                   "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Error message
;
Ws_E2_F_Error_Message   DB    4                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   40                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_E2_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_E2_D_General_I_O_Error       DB   "I/O ERROR - Reason Unknown!             "
Ws_E2_D_DOS25_DOS_SYS_Not_Found DB   "C:\DIR2ATR\DOS25\DOS.SYS file not found!"
Ws_E2_D_DOS25_DUP_SYS_Not_Found DB   "C:\DIR2ATR\DOS25\DUP.SYS file not found!"
Ws_E2_D_MYDOS_DOS_SYS_Not_Found DB   "C:\DIR2ATR\MYDOS\DOS.SYS file not found!"
Ws_E2_D_MYDOS_DUP_SYS_Not_Found DB   "C:\DIR2ATR\MYDOS\DUP.SYS file not found!"
Ws_E2_D_Disk_Full               DB   "The destination drive is full!          "
Ws_E2_D_Opening_File            DB   "Opening disk file to be placed on image!"
Ws_E2_D_Reading_File            DB   "Reading disk file to be placed on image!"
Ws_E2_D_Opening_Image           DB   "ATR disk image could not be opened!     "
Ws_E2_D_Positioning_Image       DB   "ATR disk image sector positioning error!"
Ws_E2_D_Sector_Allocation       DB   "ATR disk image sector allocation error! "
Ws_E2_D_Writing_Image           DB   "ATR disk image sector writing error!    "

;**********************************************************************
; Please select an option                                             *
;**********************************************************************
Ws_E3                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E3_Name              DB    "ERROR3  "
Ws_E3_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E3_Text              DB                                             "[Option Selection]ͻ"
                        DB                                             "                      "
                        DB                                             " No option selected!  "
                        DB                                             " Please select one.   "
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; Too many options selected                                           *
;**********************************************************************
Ws_E4                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   42                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   65                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E4_Name              DB    "ERROR4  "
Ws_E4_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E4_Text              DB                                             "[Option Selection]ͻ"
                        DB                                             "                      "
                        DB                                             " Too many selections! "
                        DB                                             " Select 1 option only."
                        DB                                             "                      "
                        DB                                             "Esc or Any key=Confirm"
                        DB                                             "ͼ"
                        DB    NULL

;**********************************************************************
; D i s k   M e d i a   s p e c i f i c a t i o n                     *
;**********************************************************************
Ws_DM                   DB    WSIO_OPEN
                        DB    9                 ; Start of screen ROW
                        DB   40                 ; Start of screen COLUMN
                        DB   17                 ; End of screen ROW
                        DB   67                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DM_Name              DB    "MEDIUM  "
Ws_DM_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DM_Text              DB                                           "[Medium specification]ͻ"
                        DB                                           "                          "
                        DB                                           "  [ ] SINGLE   density    "
                        DB                                           "  [ ] MEDIUM   density    "
                        DB                                           "  [ ] ENHANCED density    "
                        DB                                           "  [ ] DOUBLE   density    "
                        DB                                           "                          "
                        DB                                           "ENTER=Specify   Esc=Cancel"
                        DB                                           "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Disk Medium to use
;
Ws_DM_F_Single          DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Medium          DB    4                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_F_Enhanced        DB    5                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DM_No_More_Fields    DB    NULL

Ws_DM_F_Double          DB    6                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;--------
; D A T A
;--------
Ws_DM_D_Single          DB    SPACE
Ws_DM_D_Medium          DB    SPACE
Ws_DM_D_Enhanced        DB    SPACE
Ws_DM_D_Double          DB    SPACE



;**********************************************************************
; D O S   M e d i a   s p e c i f i c a t i o n                       *
;**********************************************************************
Ws_DS                   DB    WSIO_OPEN
                        DB    8                 ; Start of screen ROW
                        DB   40                 ; Start of screen COLUMN
                        DB   18                 ; End of screen ROW
                        DB   68                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DS_Name              DB    "DOSMASK "
Ws_DS_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DS_Text              DB                                           "[Include which DOS]ͻ"
                        DB                                           "                           "
                        DB                                           "  [ ] Do not include a DOS "
                        DB                                           "  [ ] Include DOS 2.5      "
                        DB                                           "  [ ] Include MYDOS 4.53   "
                        DB                                           "                           "
                        DB                                           "      If DOS is included:  "
                        DB                                           "  [ ] Include DUP.SYS file "
                        DB                                           "                           "
                        DB                                           "ENTER=Specify    Esc=Cancel"
                        DB                                           "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; DOS to include
;
Ws_DS_F_NODOS           DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_DOS25           DB    4                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_MYDOS           DB    5                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_F_DUPSYS          DB    8                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DS_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_DS_D_DOS25           DB    SPACE
Ws_DS_D_MYDOS           DB    SPACE
Ws_DS_D_NODOS           DB    SPACE
Ws_DS_D_DUPSYS          DB    SPACE


;**********************************************************************
; A d d   D i s k n u m b e r s   a f t e r   l a s t   d i s k n r   *
;**********************************************************************
Ws_AD                   DB    WSIO_OPEN
                        DB   10                 ; Start of screen ROW
                        DB   40                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   68                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_AD_Name              DB    "ADDDISKS"
Ws_AD_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_AD_Text              DB                                           "[Add from where]ͻ"
                        DB                                           "                           "
                        DB                                           "  [ ] Add at end           "
                        DB                                           "  [ ] Add from begin       "
                        DB                                           "                           "
                        DB                                           "ENTER=Specify    Esc=Cancel"
                        DB                                           "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; DOS to include
;
Ws_AD_F_Add_At_End      DB    3                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_AD_F_Add_From_Begin  DB    4                 ; Relative ROW, NULL=End
                        DB    5                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    1                 ; Not mouse sensitive
                        DB    3                 ; Edit Filemask
                        DB    0                 ; Blanks Anywhere
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

WS_AD_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_AD_D_Add_At_End      DB    SPACE
Ws_AD_D_Add_From_Begin  DB    SPACE



;**********************************************************************
; C r e a t i n g   x l   d i s k   F i l e s                         *
;**********************************************************************
Ws_CF                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   36                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   71                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_GREEN_WHITE ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; No cursor
                        DB    CURSOR_OFF_SCREEN ; to display
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_CF_Name              DB    "CFILES  "
Ws_CF_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_CF_Text              DB                                       "[Adding files to disk images]ͻ"
                        DB                                       "                                  "
                        DB                                       " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                       "                                  "
                        DB                                       " Processing disk: xxxxxxxxxxxx    "
                        DB                                       " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                       "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Progress bar
;
Ws_CF_F_Progress_Bar    DB    3                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   32                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Process disk
;
Ws_CF_F_Add_Disk        DB    5                 ; Relative ROW, NULL=End
                        DB   20                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Process file
;
Ws_CF_F_Add_File        DB    6                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   32                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
Ws_CF_D_Progress_Bar            DB   32 dup (0B0h)
Ws_CF_D_Progress_Bar_Attr       DB   ATTRIB_CYAN_WHITE
Ws_CF_D_Add_Disk                DB   12 dup (SPACE)
Ws_CF_D_Add_File                DB   "Processing file: "
Ws_CF_D_Add_File_File           DB   12 dup (SPACE)
                                DB   "   "
Ws_CF_D_No_Message              DB   32 dup (SPACE)
Ws_CF_D_Formatting_Disk         DB   "F O R M A T T I N G    D I S K  "

ENDS    DSeg



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg2 Word Public 'LIBFILES'
Dir_Map                 DB   DIR_MAP_LENGTH dup ("E")

ENDS    DSeg2



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg3 Word Public 'FILEMAP'
File_Map                DB   File_Map_Length dup (SPACE)
ENDS    DSeg3



;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   DC_DIRS:proc            ; Determine Current Directories
        EXTRN   DC_DRV:proc             ; Determine Current Drives
        EXTRN   DC_FILES:proc           ; Determine Current Files
        EXTRN   HEX2DIGI:proc           ; Convert Hex Data To Digits (Text)
        EXTRN   WSIO:proc               ; Screen Handler



;**********************************************************************
PROC    FIL2DISK
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize DS to address
        mov     ds, ax                          ; of data segment

        mov     bx, sp

;
; Parameter Files
;
        mov     di, [ss:bx+2]
        mov     es, [ss:bx+4]

        push    ds si
        push    es di

        mov     si, offset File_Path
        push    ds si
        pop     di es

        pop     si ds
        mov     cx, PATH_LENGTH
        rep     movsb

        pop     si ds

        call    Init_Program
        call    Init_Screens
        call    Parameter_Processing
        call    Read_VTOC_Drives
        call    Open_Ws_BG
        call    Display_Ws_BG                   ; Display background
        call    Display_Ws_FW                   ; Display freeware message

@@20:
        call    Display_and_Read_Ws_LF          ; Let user select library

@@30:
        call    Close_Ws_BG

        ret

ENDP    FIL2DISK



;**********************************************************************
PROC    Init_Program
;**********************************************************************
        xor     ax, ax
        mov	ah, DOS_SET_MEMORY_BLOCK_SIZE   ; resize the psp memory
        xor     bx, bx
        int	DOS_SERVICE

;
; Segment Addressing
;
        ASSUME  ds:DSeg2
        mov     ax, DSeg2                       ; Initialize ds to address
        mov     ds, ax                          ; of data segment
 
        mov     si, offset Dir_Map
        push    ds si
        pop     di es

        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize ds to address
        mov     ds, ax                          ; of data segment

        mov     [Dir_Map_ptr_es], es
        mov     [Dir_Map_ptr_di], di

@@99:
        ret

ENDP    Init_Program



;**********************************************************************
PROC    Init_Screens
;**********************************************************************
;
; Init screen BG=Background
;
        mov     si, offset Ws_BG
        push    ds si
        pop     di es

        mov     si, offset Ws_BG_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_BG_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_BG_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FW=FreeWare
;
        mov     si, offset Ws_FW
        push    ds si
        pop     di es

        mov     si, offset Ws_FW_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FW_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FW_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen PA=Path
;
        mov     si, offset Ws_PA
        push    ds si
        pop     di es

        mov     si, offset Ws_PA_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_PA_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_PA_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_PA_F_Path
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Files_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DR=Drives
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     si, offset Ws_DR_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DR_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DR_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DR_F_Drive
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DH=Drive Help Screen
;
        mov     si, offset Ws_DH
        push    ds si
        pop     di es

        mov     si, offset Ws_DH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen LF=Directories/Images
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     si, offset Ws_LF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, [Dir_Map_ptr_es]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     ax, [Dir_Map_ptr_di]
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], ax

;
; Init screen LH=Directory/Image Help Screen
;
        mov     si, offset Ws_LH
        push    ds si
        pop     di es

        mov     si, offset Ws_LH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E1=Error Screen - Drive Not Ready
;
        mov     si, offset Ws_E1
        push    ds si
        pop     di es

        mov     si, offset Ws_E1_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E1_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E1_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E2=Error Screen - I/O ERROR
;
        mov     si, offset Ws_E2
        push    ds si
        pop     di es

        mov     si, offset Ws_E2_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E2_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E2_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_E2_D_General_I_O_Error
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen E3=Error Screen - No option selected
;
        mov     si, offset Ws_E3
        push    ds si
        pop     di es

        mov     si, offset Ws_E3_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E3_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E3_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen E4=Error Screen - Too many options selected
;
        mov     si, offset Ws_E4
        push    ds si
        pop     di es

        mov     si, offset Ws_E4_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E4_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E4_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen DM=DiskMedium
;
        mov     si, offset Ws_DM
        push    ds si
        pop     di es

        mov     si, offset Ws_DM_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DM_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DM_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DM_F_Single
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Single
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Medium

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Medium
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Enhanced

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Enhanced
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DM_F_Double

        push    ds si
        pop     di es

        mov     si, offset Ws_DM_D_Double
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DS=DosSpecification
;
        mov     si, offset Ws_DS
        push    ds si
        pop     di es

        mov     si, offset Ws_DS_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DS_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DS_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DS_F_NODOS
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_NODOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_DOS25

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_DOS25
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_MYDOS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_MYDOS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_DS_F_DUPSYS

        push    ds si
        pop     di es

        mov     si, offset Ws_DS_D_DUPSYS
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen AD=AddDisks
;
        mov     si, offset WS_AD
        push    ds si
        pop     di es

        mov     si, offset WS_AD_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset WS_AD_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset WS_AD_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_AD_F_Add_At_End
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_AD_D_Add_At_End
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_AD_F_Add_From_Begin

        push    ds si
        pop     di es

        mov     si, offset Ws_AD_D_Add_From_Begin
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen CF=Create ATR Disk Image containing pc Files
;
        mov     si, offset Ws_CF
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_CF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

; Field 1
        mov     si, offset Ws_CF_F_Progress_Bar
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Progress_Bar
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset Ws_CF_D_Progress_Bar_Attr
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 2
        mov     si, offset Ws_CF_F_Add_Disk
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_Disk
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

; Field 3
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_File
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        ret

ENDP    Init_Screens



;**********************************************************************
PROC    Parameter_Processing
;**********************************************************************
;----------------------
; Use current directory
;----------------------
@@10:
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE
        rep     stosb                           ; Clear parameter

; Get default drive
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_DEFAULT_DRIVE       ; Get Default Drive
        int     DOS_SERVICE 
        add     al, 041h                        ; Because of 0-based stuff

; Process Drive
        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], al                ; Process Drive letter
        mov     [byte ds:si + 1], COLON
        mov     [byte ds:si + 2], BACKSLASH
        add     si, 3                           ; Locating at directory stuff

; Get current directory
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_CURRENT_DIRECTORY
        xor     dx, dx                          ; Reset dx
        mov     dl, DOS_DEFAULT_DRIVE
        int     DOS_SERVICE

; Terminate it with a backslash "\"
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        mov     ax, SPACE                       ; Search for non space
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting

        mov     cl, BACKSLASH                   ; Assume adding a backslash
        cmp     [byte es:di], BACKSLASH         ; Are we in the root?
        jne     @@15                            ; No
                                                ; Yes, so
        mov     cl, SPACE                       ; Replace 000h by SPACE

@@15:
        inc     di                              ; Pointer adjustment after search
        mov     [byte es:di], cl

;---------------------------------
; Copy Startup path to search path
;---------------------------------
@@20:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Field_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@99:
        ret

ENDP    Parameter_Processing



;**********************************************************************
PROC    Read_VTOC_Drives
;**********************************************************************
;
; Get drives in format: ACDE etc.
;
        mov     [Requested_Format_Drives], "1"          ; Format ABCDE
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Available_Drives     ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;
; Get drives in format: [A: Myvolume   ]
;                       [C: Yourvolume ] etc.
;
        mov     [Requested_Format_Drives], "2"          ; Format [A: Myvolume   ]
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Ws_DR_D_Drive  ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;-----------------------
; Specify start of table
;-----------------------
        mov     [Ws_DR_Occur_Curr], 0

@@00:
;-----------------------------------
; Determine which drive to highlight
;-----------------------------------
        mov     [Ws_DR_Occur_W_Curr], 0

        mov     si, offset Search_Dirs_Path
        mov     bl, [byte ds:si]                ; Config path drive

;-------------------------------------------
; Determine maximum number of drives present
;-------------------------------------------
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     cx, MAX_DRIVES

        mov     [Ws_DR_Occur_Max], 0
        mov     si, offset Ws_DR_D_Drive

@@10:
        cmp     [byte ds:si], SPACE
        je      @@30

        inc     [Ws_DR_Occur_Max]
        cmp     [byte ds:si], bl                ; Selected drive found?
        jne     @@20                            ; No
                                                ; Yes, so
        mov     dx, [Ws_DR_Occur_Max]
        mov     [Ws_DR_Occur_Curr], dx

@@15:
        mov     [Ws_DR_Occur_W_Curr], dx
        cmp     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; dx > Max occur of window?
        jle     @@20                            ; No
                                                ; Yes, so
        sub     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Move 1 window up
        jmp     @@15

@@20:
        add     si, ax
        loop    @@10

@@30:
        cmp     [Ws_DR_Occur_W_Curr], 0         ; Invalid drive specified?
        jne     @@40                            ; No
                                                ; Yes, so

        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], SPACE             ; Clear Config Field
        call    Parameter_Processing
        jmp     @@00                            ; Redo this section

@@40:
;------------------------------------
; Pass offset address of drives table
;------------------------------------
        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

@@99:
        ret

ENDP    Read_VTOC_Drives



;**********************************************************************
PROC    Open_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        cmp     ax, NULL                        ; Error?
        jz      @@99                            ; No
                                                ; Yes, so
;
; Error
;

@@99:        
        ret

ENDP    Open_Ws_BG



;**********************************************************************
PROC    Display_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_BG



;**********************************************************************
PROC    Display_Ws_FW
;**********************************************************************
        mov     si, offset Ws_FW

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_FW



;**********************************************************************
PROC    Display_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_PA



;**********************************************************************
PROC    Display_Ws_DR
;**********************************************************************
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DR



;**********************************************************************
PROC    Display_and_Read_Ws_DR
;**********************************************************************
;----------
; Init Path
;----------
;
; Reset Search Dirs Path
;
        mov     si, offset Search_Dirs_Path     ; Clear path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        call    Display_Ws_DR
        jmp     @@10

;---------------------------------
; Show fields only of Drives Table
;---------------------------------
@@05:
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;
; Make current occurrence Green/White
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_DR_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_DR_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_DR_Occur_Curr]          ; Current occurr = max?
        je      @@10                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_DR_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]
        dec     dx
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_DR_Occur_Max]           ; Is there a next window?
        jnle    @@10                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_DR_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_DR_Occur_Max]           ; Determine difference
        sub     [Ws_DR_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_DR_Occur_Max]

@@36:
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 1         ; At top of window?
        je      @@10                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_DR_Occur_W_Curr], 1
        mov     [Ws_DR_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_DR_Occur_Max]           ; Can we go "down" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Max]           ; Go to last occurrence
        mov     [Ws_DR_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_W_Curr], cx        ; Go  to  last entry in window
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_DR_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;----------------------------------------
; Set up drive window data and attributes
;----------------------------------------
@@50:
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     si, offset Ws_DR_D_Drive

        jmp     @@52

@@51:
        add     si, ax

@@52:
        loop    @@51

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@10                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_DR_Occur_Max]           ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_DR_Occur_W_Curr], cx

@@61:
;
; Copy selected drive to path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     si, offset Available_Drives
        add     si, [Ws_DR_Occur_Curr]
        dec     si
        movsb
        mov     [byte es:di], COLON
        mov     [byte es:di + 1], BACKSLASH

;
; Show new path to user
;
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     [Dir_Memo_Pointer], 0           ; Reset directory memo pointer
        jmp     @@99

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_DH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_DR



;**********************************************************************
PROC    Display_Ws_DH
;**********************************************************************
        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DH



;**********************************************************************
PROC    Read_VTOC_Directories_Files
;**********************************************************************
        cmp     [Dir_Up], 2                     ; Do we have to remember from which directory we came from?
        jne     @@05                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]
        mov     dx, [Ws_LF_Occur_W_Curr]
        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], cx
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], dx
        inc     [Dir_Memo_Pointer]

@@05:
        mov     [Ws_LF_Occur_Max], 0

;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        mov     si, offset Search_Dirs_Path
        cmp     [byte ds:si], "A"               ; Access drive A?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], "B"               ; Access drive B?
        jne     @@20                            ; No
                                                ; Yes, so
@@10:
        xor     bx, bx                          ; Reset dx
        mov     bl, [byte ds:si]                ; Copy selected drive to path
        sub     bl, 64                          ; Turn drive into DOS drive
        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     al, 00Dh                        ; subfunction code
        mov     cx, DOS_GET_MEDIA_ID_CX
        mov     dx, offset Media_ID_Buffer
        int     DOS_SERVICE                     ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_READY         ; Drive ready?
        jne     @@20                            ; Yes
                                                ; No, so
;------------------------
; ERROR - DRIVE NOT READY
;------------------------
        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@99

@@20:        
;-------------------------------
; Set up Search path - Libraries
;-------------------------------
;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add "*.*" to the Search path
;
        mov     si, offset Directories_File_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3
        push    es di
 
;-----------------------------------------
; Now retrieve Directory Map - Directories
;-----------------------------------------
        call    DC_DIRS

        pop     ax ax ax ax ax ax

;---------------------------
; Set up Search path - Files
;---------------------------

;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add FileMask to the Search path
;
        mov     si, offset Disk_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

;
; Search null terminator
;
        xor     ax, ax
        mov     al, NULL                        ; Search the first null
        mov     cx, DIR_MAP_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

        push    es di
 
;-----------------------------------
; Now retrieve Directory Map - Files
;-----------------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;------------------------------------------------------
; After reading the VTOC we are at the first occurrence
;------------------------------------------------------
        mov     cx, 1                           ; To satisfy loop condition
        mov     [Ws_LF_Occur_Curr], 1
        mov     [Ws_LF_Occur_W_Curr], 1

        cmp     [Dir_Up], 1                     ; Did we go up a dir?
        jne     @@50                            ; No
                                                ; Yes, so
        cmp     [Dir_Memo_Pointer], 0           ; Did we have save info of previous dirs?
        je      @@50                            ; No
                                                ; Yes, so
        dec     [Dir_Memo_Pointer]

        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to occupied spot
        mov     cx, [ds:si]
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to occupied spot
        mov     dx, [ds:si]

        mov     [Ws_LF_Occur_Curr], cx
        mov     [Ws_LF_Occur_W_Curr], dx

        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now

@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

;------------------------------------
; Determine MAXimum nr of occurrences
;------------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, DIR_MAP_LENGTH              ; Search length
        xor     ax, ax                          ; Search for null character
        repne   scasb                           ; Search uses es:di

        mov     ax, DIR_MAP_LENGTH
        sub     ax, cx                          ; Nr of entries in size determined
        xor     dx, dx
        xor     cx, cx
        mov     bx, DIR_ENTRY_LENGTH            ; Determine nr of occurs
        div     bx

        mov     [Ws_LF_Occur_Max], ax

@@99:
        call    Display_Ws_PA                   ; Display path

        ret

ENDP    Read_VTOC_Directories_Files



;**********************************************************************
PROC    Display_and_Read_Ws_LF
;**********************************************************************
        jmp     @@64                            ; Because of startup path

;------------------------------------------
; Show fields only of Libraries/Files Table
;------------------------------------------
@@05:
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;------------------------------------------
; Show Freeware Text or Disk Image contents
;------------------------------------------
        call    Display_Ws_FW                   ; Show Freeware Text

;------------------------------------
; Make current occurrence Green/White
;------------------------------------
@@15:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;----------
; Get input
;----------
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_F2                      ; Do it! Convert all files to .ATR imagaes
        je      @@70
        cmp     al, KEY_F3                      ; Back to drives
        je      @@62
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_LF_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_LF_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_LF_Occur_Curr]          ; Current occurr = max?
        je      @@15                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_LF_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]
        dec     dx
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_LF_Occur_Curr]          ; Can we go "down" anyhow?
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_LF_Occur_Max]           ; Is there a next window?
        jnle    @@15                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_LF_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_LF_Occur_Max]           ; Determine difference
        sub     [Ws_LF_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_LF_Occur_Max]

@@36:
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_LF_Occur_W_Curr], 1         ; At top of window?
        je      @@15                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_LF_Occur_W_Curr], 1
        mov     [Ws_LF_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_LF_Occur_Max]           ; Can we go "down" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Max]           ; Go to last occurrence
        mov     [Ws_LF_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_W_Curr], cx        ; Go  to  last entry in window
        mov     cx, 1                           ; Start from first occurrence
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_LF_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;--------------------------------------------
; Set up dir/image window data and attributes
;--------------------------------------------
@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@15                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_LF_Occur_Max]           ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_LF_Occur_W_Curr], cx

@@61:
        push    ds si

;
; Go to end of path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                              ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Go to drive selection or dirs?
;        
        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax
        cmp     [byte es:di], DOT               ; Go to drive selection/dirs?
        jne     @@66                            ; No
                                                ; Yes, so
        pop     di es                           ; Check path
        pop     si ds
        cmp     [byte es:di - 2], COLON         ; Go to drive selection?
        jne     @@65                            ; No
                                                ; Yes, so
@@62:
;
; Select another drive
;

@@63:
;
; Reset Search Files Path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb                           ; Clear path

        call    Display_Ws_PA                   ; Display path
        call    Display_and_Read_Ws_DR          ; Let user select drive

        cmp     al, KEY_ESC                     ; Cancel pressed?
        je      @@99                            ; Yes
                                                ; No, so
@@64:
        mov     [Dir_Up], 0                     ; We stay in the current dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0            ; Drive not ready?
        je      @@62                            ; Yes
                                                ; No, so
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@10

@@65:
;
; Go to previous dir
;
        dec     di                              ; Position on the "\"
        dec     di                              ; Position before the "\"
        std                                     ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

        mov     cx, DIR_NAME_LENGTH + 1         ; Because of "\"
        add     cx, FILE_NAME_LENGTH            ; Because of *.ATR
        mov     ax, SPACE
        rep     stosb

        mov     [Dir_Up], 1                     ; We go to previous dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files
        jmp     @@05

@@66:
;
; Go to subdir OR do nothing
;
        push    es di
        add     di, FILE_NAME_LENGTH + 1        ; Go to file size
        cmp     [byte es:di], "<"               ; Directory indicator
        pop     si ds                           ; From -> Dir/File table

        pop     di es                           ; To   -> Path
        jne     @@67                            ; It's a file!
                                                ; It's a directory, so
        mov     cx, DIR_NAME_LENGTH
        rep     movsb

        pop     si ds

        std                                     ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, SPACE                       ; Search for not equal " "
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To position after the " "

        mov     [byte es:di], BACKSLASH

        mov     [Dir_Up], 2                     ; We go to a subdir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        jmp     @@05

@@67:
        pop     si ds

        jmp     @@15

;-----------------------------------
; DO IT! CONVERT FILES TO ATR IMAGES
;-----------------------------------
@@70:
        call    Add_DirFiles_To_ATR_Image

        cmp     al, KEY_ESC                     ; Return to dir where ATR's should be stored?
        je      @@15                            ; Yes
                                                ; No, so
        jmp     @@99                            ; Return to Files to ATR

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_LH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_LF



;**********************************************************************
PROC    Display_Ws_LH
;**********************************************************************
        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_LH



;**********************************************************************
PROC    Add_DirFiles_To_ATR_Image
;**********************************************************************
        mov     [Dir2atr_Error], LOGIC_NO

        mov     [Disk_Seq_Nr], 0
        mov     [Disk_Seq_Nr_Present], 0

        cmp     [Fil2disk_Initialize], LOGIC_YES        ; Initialize executed?
        je      @@50                                    ; Yes
                                                        ; No, so
        mov     [Fil2disk_Initialize], LOGIC_YES

        mov     [Ws_DM_D_Single], SPACE
        mov     [Ws_DM_D_Medium], "X"
        mov     [Ws_DM_D_Enhanced], SPACE
        mov     [Ws_DM_D_Double], SPACE

        mov     [Ws_DS_D_NODOS], SPACE
        mov     [Ws_DS_D_DOS25], "X"
        mov     [Ws_DS_D_MYDOS], SPACE
        mov     [Ws_DS_D_DUPSYS], "X"

@@10:
;
; DOS25 present?
;
        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_DOS25_DOS_SYS
        mov     cx, PATH_LENGTH                 ; Copy length
        rep     movsb                           ; Copy path

        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@20                            ; Error
                                                ; No, so
        mov     bx, ax
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE
        jmp     @@40

@@20:
        mov     [Ws_DS_D_DOS25], SPACE
        mov     [Ws_DS_D_MYDOS], "X"

;
; MYDOS present?
;
        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_MYDOS_DOS_SYS
        mov     cx, PATH_LENGTH                 ; Copy length
        rep     movsb                           ; Copy path

        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@30                            ; Error
                                                ; No, so
        mov     bx, ax
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE
        jmp     @@40

@@30:
        mov     [Ws_DS_D_MYDOS], SPACE
        mov     [Ws_DS_D_NODOS], "X"

@@40:
        mov     [Ws_AD_D_Add_From_Begin], SPACE
        mov     [Ws_AD_D_Add_At_End], "X"

@@50:
;----------------------------
; Retrieve DISK MEDIUM Format
;----------------------------
        call    Process_Medium_Format
        cmp     al, KEY_ESC
        je      @@99

@@60:
;--------------------
; Retrieve DOS Format
;--------------------
        call    Process_DOS_Format
        cmp     al, KEY_ESC
        je      @@50

;-----------------------
; Retrieve ADDING option
;-----------------------
        call    Process_Disk_Adding
        cmp     al, KEY_ESC
        je      @@60

@@80:
        mov     si, offset Disk_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Files_Path
        mov     cx, PATH_LENGTH
        rep     movsb

        cmp     [Disk_Adding], "N"
        je      @@90

        mov     ax, [Disk_Seq_Nr_Present]
        mov     [Disk_Seq_Nr], ax

@@90:
;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;-------------------------------------------
; Retrieve files to put on the disk image(s)
;-------------------------------------------
        mov     [Requested_Format_LibFil], "1"          ; See DIRENTRY.STR specification
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset File_Path                    ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

        push    es di
 
;------------------------
; Determine Current Files
;------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;----------------------
; Process "Atari" Files
;----------------------
        call    Process_Atari_Files

@@99:
        ret

ENDP    Add_DirFiles_To_ATR_Image



;**********************************************************************
PROC    Process_Medium_Format
;**********************************************************************
        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@10

@@05:
;
; Too many options selected
;
        call    Display_Too_Many_Options_Selected

@@10:
        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ESC
        je      @@98

;------------------
; ENTER was pressed
;------------------
        cmp     [Ws_DM_D_Single], SPACE
        jne     @@20

        cmp     [Ws_DM_D_Medium], SPACE
        jne     @@30

        cmp     [Ws_DM_D_Enhanced], SPACE
        jne     @@40

        cmp     [Ws_DM_D_Double], SPACE
        jne     @@50

;
; No option selected
;
        call    Display_No_Option_Selected
        jmp     @@10

@@20:
;------------------------------------------------------
; Check if Disk Medium Single is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Medium], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Enhanced], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Double], SPACE
        jne     @@05

        mov     [Disk_Sectors], DISK_SECTORS_SINGLE
        mov     [Disk_Sectors_Usable], DISK_SECTORS_SINGLE_USABLE
        mov     si, offset ATR_Header_Single
        jmp     @@97

@@30:
;------------------------------------------------------
; Check if Disk Medium Medium is the only one specified
;------------------------------------------------------
        cmp     [Ws_DM_D_Enhanced], SPACE
        jne     @@05

        cmp     [Ws_DM_D_Double], SPACE
        jne     @@05

        mov     [Disk_Sectors], DISK_SECTORS_MEDIUM
        mov     [Disk_Sectors_Usable], DISK_SECTORS_MEDIUM_USABLE
        mov     si, offset ATR_Header_Medium
        jmp     @@97

@@40:
;--------------------------------------------------------
; Check if Disk Medium Enhanced is the only one specified
;--------------------------------------------------------
        cmp     [Ws_DM_D_Double], SPACE
        jne     @@05

        mov     [Disk_Sectors], DISK_SECTORS_ENHANCED
        mov     [Disk_Sectors_Usable], DISK_SECTORS_ENHANCED_USABLE
        mov     si, offset ATR_Header_Enhanced
        jmp     @@97

@@50:
;------------------------------------------------------
; Check if Disk Medium Double is the only one specified
;------------------------------------------------------
        mov     [Disk_Sectors], DISK_SECTORS_DOUBLE
        mov     [Disk_Sectors_Usable], DISK_SECTORS_DOUBLE_USABLE
        mov     si, offset ATR_Header_Double

@@97:
        push    ds si

        mov     si, offset ATR_Header
        push    ds si
        pop     di es

        pop     si ds

        mov     cx, ATR_HEADER_SIZE
        rep     movsb

@@98:
        push    ax

        mov     si, offset Ws_DM
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     ax

@@99:
        ret

ENDP    Process_Medium_Format



;**********************************************************************
PROC    Process_DOS_Format
;**********************************************************************
        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@10

@@05:
;
; Too many options selected
;
        call    Display_Too_Many_Options_Selected

@@10:
        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ESC
        je      @@98

;------------------
; ENTER was pressed
;------------------
        cmp     [Ws_DS_D_NODOS], SPACE
        jne     @@20

        cmp     [Ws_DS_D_DOS25], SPACE
        jne     @@30

        cmp     [Ws_DS_D_MYDOS], SPACE
        jne     @@40

;
; No option selected
;
        call    Display_No_Option_Selected
        jmp     @@10

@@20:
;-----------------------------------------------------------
; Check if DOS Specification NODOS is the only one specified
;-----------------------------------------------------------
        cmp     [Ws_DS_D_DOS25], SPACE
        jne     @@05

        cmp     [Ws_DS_D_MYDOS], SPACE
        jne     @@05

        mov     [DOS_Format], " "
        jmp     @@98

@@30:
;-----------------------------------------------------------
; Check if DOS Specification DOS25 is the only one specified
;-----------------------------------------------------------
        cmp     [Ws_DS_D_MYDOS], SPACE
        jne     @@05

        mov     [DOS_Format], "D"
        jmp     @@98

@@40:
;-----------------------------------------------------------
; Check if DOS Specification MYDOS is the only one specified
;-----------------------------------------------------------
        mov     [DOS_Format], "M"

@@98:
        push    ax

        mov     si, offset Ws_DS
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     ax

@@99:
        ret

ENDP    Process_DOS_Format



;**********************************************************************
PROC    Process_Disk_Adding
;**********************************************************************
;-------------------------------------------------
; Are there already disk images in this directory?
;-------------------------------------------------
        mov     [Disk_Adding], "N"              ; Add disks from start

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]            ; Dir Map
        mov     cx, 999                         ; Maximum nr of disks

@@10:
        cmp     [byte es:di], NULL              ; End of table reached?
        je      @@99                            ; Yes
                                                ; No, so
        cmp     [byte es:di + 13], "<"          ; Subdirectory?
        jne     @@20                            ; No
                                                ; Yes, so
        add     di, DIR_ENTRY_LENGTH
        jmp     @@10

@@20:
        cmp     [byte es:di], NULL          ; More files?
        je      @@40                        ; No
                                            ; Yes, so
;
; Check for valid disk name
;
        cmp     [byte es:di], "0"
        jl      @@30
        cmp     [byte es:di], "9"
        jnle    @@30
        cmp     [byte es:di + 1], "0"
        jl      @@30
        cmp     [byte es:di + 1], "9"
        jnle    @@30
        cmp     [byte es:di + 2], "0"
        jl      @@30
        cmp     [byte es:di + 2], "9"
        jnle    @@30
        cmp     [byte es:di + 3], DOT
        jne     @@30

        xor     ax, ax
        xor     bx, bx
        xor     dx, dx
        mov     bl, [byte es:di + 2]
        sub     bl, ZERO
        mov     al, [byte es:di + 1]
        sub     al, ZERO
        mov     cx, 10
        mul     cx
        add     bx, ax
        xor     ax, ax
        mov     al, [byte es:di]
        sub     al, ZERO
        mov     cx, 100
        mul     cx
        add     bx, ax
        cmp     bx, [Disk_Seq_Nr_Present]
        jle     @@30
        
        mov     [Disk_Seq_Nr_Present], bx

@@30:
        add     di, DIR_ENTRY_LENGTH
        loop    @@20

@@40:
        cmp     [Disk_Seq_Nr_Present], 0        ; Already disk nrs present?
        je      @@99                            ; No
                                                ; Yes, so
;-----------------------
; Add disknumber to end?
;-----------------------
        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@50

@@45:
;
; Too many options selected
;
        call    Display_Too_Many_Options_Selected

@@50:
        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

;--------------------
; Was Cancel pressed?
;--------------------
        cmp     al, KEY_ESC
        je      @@98

;------------------
; ENTER was pressed
;------------------
        cmp     [Ws_AD_D_Add_At_End], SPACE
        jne     @@60

        cmp     [Ws_AD_D_Add_From_Begin], SPACE
        jne     @@70

;
; No option selected
;
        call    Display_No_Option_Selected
        jmp     @@50

@@60:
;----------------------------------------------
; Check if Add To End is the only one specified
;----------------------------------------------
        cmp     [Ws_AD_D_Add_From_Begin], SPACE
        jne     @@45

        mov     [Disk_Adding], "Y"              ; Add disks at end
        jmp     @@98

@@70:
;------------------------------------------------------
; Check if Add From Beginning is the only one specified
;------------------------------------------------------
        mov     [Disk_Adding], "N"              ; Add disks from begin

@@98:
        push    ax

        mov     si, offset Ws_AD
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

        pop     ax

@@99:
        ret

ENDP    Process_Disk_Adding



;**********************************************************************
PROC    Display_No_Option_Selected
;**********************************************************************
        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E3
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_No_Option_Selected



;**********************************************************************
PROC    Display_Too_Many_Options_Selected
;**********************************************************************
        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E4
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Too_Many_Options_Selected



;**********************************************************************
PROC    Process_Atari_Files
;**********************************************************************
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

;
; Initialize progress bar
;
        mov     si, offset Ws_CF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0B0h
        xor     cx, cx
        mov     cl, [Progress_Bar_Cnt_Max]
        rep     stosb

        mov     [Progress_Bar_Cnt_Prev], 0
        mov     [Progress_Bar_Cnt_Files], 0
;
; Determine number of files in this directory to process
;
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     [Progress_Bar_Files], 0

@@00:
        cmp     [byte es:di], NULL          ; More files?
        je      @@05                        ; No
                                            ; Yes, so
        inc     [Progress_Bar_Files]

        add     di, FILE_ENTRY_LENGTH

        jmp     @@00

@@05:
;
; Initialize disk image name
;
        mov     si, offset Ws_CF_D_Add_Disk
        push    ds si
        pop     di es
        mov     cx, FILE_NAME_LENGTH
        xor     ax, ax
        mov     al, SPACE
        rep     stosb

;
; Message "None"
;
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_No_Message
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Display progress screen
;
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Process found directory files
;
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        cmp     [byte es:di], NULL              ; Anything to process at all?
        je      @@98                            ; No
                                                ; Yes, so
        push    es di

        call    Process_Open_ATR_Image_Disk

        pop     di es

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
@@10:
;
; Check if we have to process a found file
;
        cmp     [byte es:di], NULL              ; Something left to process?
        je      @@90                            ; No
                                                ; Yes, so
        inc     [Progress_Bar_Cnt_Files]

        push    es di                           ; Save Dir_Map pointer
        push    ds si
        push    es di                           ; Save Dir_Map pointer

;
; Copy Entry
;
        mov     si, offset File_Map_Entry
        push    ds si
        pop     di es

        pop     si ds

        mov     cx, FILE_ENTRY_LENGTH
        rep     movsb

        pop     si ds

;
; Determine File Size in Sectors
;
        mov     [Remainder_Bytes], EIGHTBIT_SECTOR_SIZE
        xor     bx, bx
        mov     bx, EIGHTBIT_SECTOR_DATA_SIZE
        mov     si, offset File_Map_Entry.File_Size
        mov     dh, [byte ds:si + 3]
        mov     dl, [byte ds:si + 2]
        mov     ah, [byte ds:si + 1]
        mov     al, [byte ds:si]
        div     bx
        cmp     dx, NULL                    ; No remainder?
        jz      @@15                        ; No
                                            ; Yes, so
        inc     ax                          ; We need another sector
        mov     [Remainder_Bytes], dl       ; Save remainder

@@15:
        mov     [File_Size_In_Sectors], ax
        cmp     ax, [Disk_Sectors_Available]
        jnle    @@80

;
; File Size in sectors > remaining nr of sectors left?
;
        cmp     ax, [Disk_Sectors_Left]
        jnle    @@20

;
; Nr of files processed > nr of files in 8bit vtoc?
;
        cmp     [byte Atari_Files_Processed], EIGHTBIT_VTOC_FILES
        jl      @@30

@@20:
        call    Process_Write_8bit_VTOC

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Close_ATR_Image_Disk
        call    Process_Open_ATR_Image_Disk

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
@@30:
;
; Process 8 bit File
;
        call    Process_Open_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        call    Process_Move_File_To_Image

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        jne     @@40                            ; No
                                                ; Yes, so
        call    Process_Close_8bit_File
        pop     di es
        jmp     @@98

@@40:
        call    Process_Close_8bit_File
        call    Process_Update_8bit_VTOC
        inc     [Atari_Files_Processed]

@@80:
;------------------------------------------------------
; Calculate progress bar size, and show it if necessary
;------------------------------------------------------
        mov     ax, [Progress_Bar_Cnt_Files]
        xor     bx, bx
        xor     cx, cx
        mov     cl, [Progress_Bar_Cnt_Max]
        xor     dx, dx
        mul     cx

        xor     cx, cx
        mov     bx, [Progress_Bar_Files]
        div     bx

        cmp     al, [Progress_Bar_Cnt_Prev]
        je      @@85

;---------------------------------
; Update progress bar, and show it
;---------------------------------
        mov     [Progress_Bar_Cnt_Prev], al
        mov     cx, ax

        mov     si, offset Ws_CF_D_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0DBh
        rep     stosb

        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY
        push    ds si
        call    WSIO
        pop     si ds

@@85:
;
; Go to next entry
;
        pop     di es
        add     di, FILE_ENTRY_LENGTH

        jmp     @@10

@@90:
        pop     ax ax
        call    Process_Write_8bit_VTOC

@@95:
        call    Process_Close_ATR_Image_Disk

@@98:
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

@@99:
        ret

ENDP    Process_Atari_Files



;**********************************************************************
PROC    Process_Open_ATR_Image_Disk
;**********************************************************************
        mov     ax, [Disk_Sectors_Usable]
        mov     [Disk_Sectors_Available], ax
        mov     [Disk_Sectors_Left], ax

        mov     [Atari_Files_Processed], 0
        mov     [Disk_Sector_Current], 4
        mov     [ATR_Disk_Image_Open], FALSE
        inc     [Disk_Seq_Nr]

;
; Determine Diskname
;
        mov     si, offset Disk_Name
        push    ds si
        pop     di es
        add     di, 2
        mov     ax, [Disk_Seq_Nr]
        mov     bx, 10                      ; Extract digits

; Convert hexadecimal size to textual digits
        call    Extract_Digit               ; Convert value below 10000
        call    Extract_Digit
        call    Extract_Digit

;
; Show which disk we are working on
;
        mov     si, offset Ws_CF_D_Add_Disk
        push    ds si
        pop     di es
        mov     si, offset Disk_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Determine path of disk image file
;
        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset Disk_Path
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path to search path

        call    Setup_Path_Spec_Disk

;
; Create ATR Disk Image
;
        mov     dx, offset Path_Spec
        xor     cx, cx                  ; Normal attributes
        mov     ah, DOS_CREATE_FILE
        int     DOS_SERVICE
        jc      @@90                    ; Error
        mov     [Disk_Handler], ax      ; Store handle

;
; Reset I/O buffer
;
        mov     si, offset Disk_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     stosb

;
; Message "Formatting Disk"
;
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Formatting_Disk
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Display progress screen
;
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; "Format" ATR Disk Image
;
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, ATR_HEADER_SIZE
        mov     dx, offset ATR_Header
        int     DOS_SERVICE             ; Write ATR header
        jc      @@91                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@91                    ; Error

;
; Number of sectors to format
;
        mov     cx, [Disk_Sectors]

;
; Include DOS?
;
        cmp     [DOS_Format], NODOS_FORMAT
        je      @@10                    ; No
                                        ; Yes, so
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, DISK_BOOTCODE_SIZE

        sub     [Disk_Sectors_Available], 79
        mov     dx, offset Bootcode_DOS25

        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@07

        sub     [Disk_Sectors_Available], 10
        mov     dx, offset Bootcode_MYDOS

@@07:
        int     DOS_SERVICE             ; Write bootcode
        jc      @@92                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@92                    ; Error

        mov     cx, [Disk_Sectors]
        sub     cx, DISK_BOOTCODE_SECTOR_SIZE

@@10:
        push    cx

        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE             ; Write sector
        jc      @@93                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@93                    ; Error

        pop     cx
        loop    @@10

;
; Close ATR Disk Image
;
        mov     bx, [Disk_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

;
; Refer to files being added now
;
        mov     si, offset Ws_CF_F_Add_File
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_D_Add_File
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Open ATR Disk Image for update
;
        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_WRITE_ONLY
        int     DOS_SERVICE
        jc      @@94                    ; Open ERROR!

        mov     [Disk_Handler], ax      ; Load handle

;
; Include DOS (files)?
;
        cmp     [DOS_Format], NODOS_FORMAT
        je      @@89                    ; No
                                        ; Yes, so

        call    Process_Include_DOS_Files
        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@99                            ; Yes
                                                ; No, so
@@89:
;
; Update status
;
        mov     [ATR_Disk_Image_Open], TRUE

        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@91:
;       mov     si, offset Msg_Err_ATR_Header
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@92:
;       mov     si, offset Msg_Err_Bootcode
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@93:
        pop     cx
        mov     si, offset Ws_E2_D_Disk_Full
        push    ds si
        jmp     @@97

@@94:
        mov     si, offset Ws_E2_D_Opening_Image
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Open_ATR_Image_Disk



;**********************************************************************
PROC    Process_Include_DOS_Files
;**********************************************************************
;
; Save current values
;
        mov     cx, [File_Size_In_Sectors]
        push    cx
        xor     cx, cx
        mov     cl, [Remainder_Bytes]
        push    cx

        mov     si, offset Temp_File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Write DOS.SYS file
;
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Name_DOS_SYS
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Assume DOS 2.5 format
;
        mov     [File_Size_In_Sectors], FILE_DOS25_DOS_SECTOR_SIZE
        mov     [Remainder_Bytes], 125

        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_DOS25_DOS_SYS
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path

        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@10

;
; MYDOS format
;
        mov     [File_Size_In_Sectors], FILE_MYDOS_DOS_SECTOR_SIZE
        mov     [Remainder_Bytes], 125

        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_MYDOS_DOS_SYS
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path

@@10:
;
; Open 8bit file
;
        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@90                    ; Open ERROR!

        mov     [File_Handler], ax      ; Load handle

;
; Move file to image
;
        call    Process_Move_File_To_Image
        call    Process_Close_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        inc     [Atari_Files_Processed]

;
; Write DUP.SYS file?
;
        cmp     [Ws_DS_D_DUPSYS], SPACE         ; Include DUP.SYS file?
        je      @@30                            ; No
                                                ; Yes, so
;
; Write DUP.SYS file
;
        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset File_Name_DUP_SYS
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Assume DOS 2.5 format
;
        mov     [File_Size_In_Sectors], FILE_DOS25_DUP_SECTOR_SIZE
        mov     [Remainder_Bytes], 1

        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_DOS25_DUP_SYS
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path

        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@20

;
; MYDOS format
;
        mov     [File_Size_In_Sectors], FILE_MYDOS_DUP_SECTOR_SIZE
        mov     [Remainder_Bytes], 83

        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_MYDOS_DUP_SYS
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path

@@20:
;
; Open 8bit file
;
        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@92                    ; Open ERROR!

        mov     [File_Handler], ax      ; Load handle

;
; Move file to image
;
        call    Process_Move_File_To_Image
        call    Process_Close_8bit_File

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@98                            ; Yes
                                                ; No, so
        inc     [Atari_Files_Processed]

@@30:
;
; Update vtoc
;
        mov     si, offset VTOC_I_O_Buffer
        push    ds si
        pop     di es
        mov     si, offset VTOC_Header_DOS25

        cmp     [Ws_DS_D_DUPSYS], SPACE         ; Include DUP.SYS file?
        jne     @@35                            ; Yes
                                                ; No, so
        mov     si, offset VTOC_Header_DOS25_NODUP

@@35:
        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@40
        mov     si, offset VTOC_Header_MYDOS

        cmp     [Ws_DS_D_DUPSYS], SPACE         ; Include DUP.SYS file?
        jne     @@40                            ; Yes
                                                ; No, so
        mov     si, offset VTOC_Header_MYDOS_NODUP

@@40:
        mov     cx, EIGHTBIT_FILE_ENTRY_SIZE
        shl     cx, 1
        rep     movsb

        mov     si, offset File_Map_Entry.File_Name
        push    ds si
        pop     di es
        mov     si, offset Temp_File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

        pop     cx
        mov     [Remainder_Bytes], cl
        pop     cx
        mov     [File_Size_In_Sectors], cx

        jmp     @@99

@@90:
        mov     si, offset Ws_E2_D_DOS25_DOS_SYS_Not_Found
        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@91                    ; No
                                        ; Yes, so
        mov     si, offset Ws_E2_D_MYDOS_DOS_SYS_Not_Found

@@91:
        push    ds si
        jmp     @@97

@@92:
        mov     si, offset Ws_E2_D_DOS25_DUP_SYS_Not_Found
        cmp     [DOS_Format], MYDOS_FORMAT
        jne     @@93                    ; No
                                        ; Yes, so
        mov     si, offset Ws_E2_D_MYDOS_DUP_SYS_Not_Found

@@93:
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@98:
        pop     cx
        pop     cx

@@99:
        ret

ENDP    Process_Include_DOS_Files



;**********************************************************************
PROC    Process_Move_File_To_Image
;**********************************************************************
        mov     si, offset Ws_CF_D_Add_File_File
        push    ds si
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

        mov     si, offset Ws_CF_D_Add_File_File
        mov     cx, FILE_NAME_LENGTH

@@05:
        cmp     [byte ds:si], NULL
        jne     @@06
        mov     [byte ds:si], SPACE

@@06:
        inc     si
        loop    @@05

;
; Display progress screen
;
        mov     si, offset Ws_CF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     cx, [Disk_Sector_Current]
        mov     [Disk_Sector_Start], cx

        mov     cx, [File_Size_In_Sectors]

@@10:
;
; Read Data Sector from 8 bit file
;
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [File_Handler]
        mov     dx, EIGHTBIT_SECTOR_DATA_SIZE

        push    cx

;
; Are we processing the "last" sector?
;
        cmp     cx, 1
        jne     @@20

;
; Process the "remainder" bytes
;
        mov     si, offset Disk_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, EIGHTBIT_SECTOR_SIZE
        rep     stosb

        mov     ah, DOS_READ_FROM_HANDLE
        xor     dx, dx
        mov     dl, [Remainder_Bytes]
        
@@20:
;
; Process Data bytes
;
        push    dx

        mov     cx, dx                  ; Data Size
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE             ; Read data bytes
        jc      @@90                    ; Stop on error
        or      ax, ax                  ; End of file?
        jz      @@90                    ; Yes
                                        ; No, so
        pop     dx

;
; Setup number of data bytes in current sector
;
        mov     si, offset DISK_I_O_Buffer
        mov     [byte ds:si + 127], dl

;
; Determine Next Disk Sector
;
        mov     [Disk_Sector_Next], 0

        pop     cx
        push    cx

        cmp     cx, 1                   ; Is there a next sector?
        je      @@30                    ; No
                                        ; Yes, so
        call    Process_Find_Free_Sector

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        jne     @@30                            ; No
                                                ; Yes, so
        pop     cx
        jmp     @@99

@@30:
;
; Setup Sector File ID
;
        xor     ax, ax
        mov     al, [Atari_Files_Processed]
        mov     cx, 10

@@35:
        shl     ax, 1
        loop    @@35

;
; Setup Next Sector Number
;
        mov     bx, [Disk_Sector_Next]

;
; Combine File ID and Next Sector Number
;
        or      ax, bx

;
; Store information at end of current sector
;
        mov     [byte ds:si + 125], ah
        mov     [byte ds:si + 126], al

@@40:
;
; Determine offset to write to
;
        xor     ax, ax                  ; Reset ax
        xor     bx, bx                  ; Reset bx
        mov     ax, [Disk_Sector_Current]
        dec     ax                      ; Because of positioning before sector
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mul     cx
        mov     cx, dx
        mov     dx, ax
        add     dx, ATR_HEADER_SIZE
        mov     ah, DOS_MOVE_FILE_POINTER
        mov     al, DOS_MOVE_FILE_POINTER_BEGIN
        mov     bx, [Disk_Handler]
        int     DOS_SERVICE             ; Position in dx:ax
        jc      @@91                    ; Stop on error
        or      ax, ax                  ; End of file?
        jz      @@91                    ; Yes
                                        ; No, so
;
; Write Current Disk Sector to Image
;
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE             ; Write sector
        jc      @@92                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@92                    ; Error

        dec     [Disk_Sectors_Left]

        mov     cx, [Disk_Sector_Next]
        cmp     cx, 0
        je      @@50
        mov     [Disk_Sector_Current], cx

@@50:
        pop     cx
        loop    @@10

@@89:
        call    Process_Find_Free_Sector

        cmp     [Dir2atr_Error], LOGIC_YES      ; Error encountered?
        je      @@99                            ; Yes
                                                ; No, so
        mov     cx, [Disk_Sector_Next]
        mov     [Disk_Sector_Current], cx

        jmp     @@99

@@90:
;
; E R R O R S
;
        pop     dx
        pop     cx

        mov     si, offset Ws_E2_D_Reading_File
        push    ds si
        jmp     @@97

@@91:
        pop     cx
        mov     si, offset Ws_E2_D_Positioning_Image
        push    ds si
        jmp     @@97

@@92:
        pop     cx
        mov     si, offset Ws_E2_D_Writing_Image
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error
@@99:
        ret

ENDP    Process_Move_File_To_Image



;**********************************************************************
PROC    Process_Find_Free_Sector
;**********************************************************************
;
; The following sectors cannot be used
; Sector 1 thru 3 (boot sectors)
; Sector 360 (bitmap sector)
; Sector 361 thru 368 (vtoc sectors)
; Sector 720 (to be compatible with DOS 2.0S)
; Sector 1023 (extended bitmap sector)
; Sector 1024 thru 1040 (or 1024 and up being Free Space)
;
        mov     cx, [Disk_Sector_Current]
        inc     cx

        cmp     cx, EIGHTBIT_VTOC_SECTOR_BEGIN
        jl      @@20
        cmp     cx, EIGHTBIT_VTOC_SECTOR_END
        jnle    @@20
        mov     cx, EIGHTBIT_VTOC_SECTOR_END

@@10:
        inc     cx

@@20:
;
; Sector = 720?
;
        cmp     cx, EIGHTBIT_SECTOR_PHANTOM
        je      @@10

;
; Sector < 1023?
;
        cmp     cx, EIGHTBIT_VTOC_SECTOR_BITEXT
        jl      @@89

;
; Sector < 1040?
;
        cmp     cx, EIGHTBIT_VTOC_SECTOR_END_MEDIUM
        jle     @@10

        cmp     [Disk_Sectors], DISK_SECTORS_MEDIUM
        je      @@90
        cmp     [Disk_Sectors], DISK_SECTORS_ENHANCED
        je      @@30
        cmp     [Disk_Sectors], DISK_SECTORS_DOUBLE
        je      @@40

        jmp     @@90

@@30:
;
; Sector < 1120?
;
        cmp     cx, EIGHTBIT_VTOC_SECTOR_END_ENHANC
        jle     @@89

        jmp     @@90

@@40:
;
; Sector < 1440?
;
        cmp     cx, EIGHTBIT_VTOC_SECTOR_END_DOUBLE
        jle     @@89

        jmp     @@90

@@89:
        mov     [Disk_Sector_Next], cx
        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Sector_Allocation
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Find_Free_Sector



;**********************************************************************
PROC    Process_Update_8bit_VTOC
;**********************************************************************
        mov     si, offset VTOC_I_O_Buffer
        xor     cx, cx
        mov     cl, [Atari_Files_Processed]
        cmp     cx, 0
        je      @@20

@@10:
        add     si, EIGHTBIT_FILE_ENTRY_SIZE
        loop    @@10

@@20:
;
; File is unlocked and active
;
        mov     [byte ds:si], 042h
        inc     si

;
; File Size in Sectors
;
        mov     cx, [File_Size_In_Sectors]
        mov     [byte ds:si], cl
        inc     si
        mov     [byte ds:si], ch
        inc     si

;
; Starting Sector
;
        mov     cx, [Disk_Sector_Start]
        mov     [byte ds:si], cl
        inc     si
        mov     [byte ds:si], ch
        inc     si

        push    ds si

;
; "Initialize" filename area
;
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE
        mov     cx, EIGHTBIT_FILE_NAME_LENGTH
        rep     stosb

;
; Move filename
;
        pop     di es
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, 8

@@30:
        mov     al, [byte ds:si]
        cmp     al, NULL                            ; End of file?
        je      @@99                                ; Yes
                                                    ; No, so
        cmp     al, DOT                             ; "." found?
        je      @@40                                ; Yes
                                                    ; No, so
        mov     [byte es:di], al
        inc     si
        inc     di
        loop    @@30

@@40:
        inc     di
        loop    @@40
        inc     si
        mov     cx, 3

@@50:
        mov     al, [byte ds:si]
        cmp     al, NULL                            ; End of file?
        je      @@99                                ; Yes
                                                    ; No, so
        mov     [byte es:di], al
        inc     si
        inc     di
        loop    @@50

@@99:
        ret

ENDP    Process_Update_8bit_VTOC



;**********************************************************************
PROC    Process_Write_8bit_VTOC
;**********************************************************************
        cmp     [ATR_Disk_Image_Open], TRUE
        jne     @@99

;
; VTOC bitmap - Determine offset to write to
;
        xor     ax, ax                  ; Reset ax
        xor     bx, bx                  ; Reset bx
        mov     ax, EIGHTBIT_VTOC_SECTOR_BITMAP
        dec     ax                      ; Because of positioning before sector
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mul     cx
        mov     cx, dx
        mov     dx, ax
        add     dx, ATR_HEADER_SIZE
        mov     ah, DOS_MOVE_FILE_POINTER
        mov     al, DOS_MOVE_FILE_POINTER_BEGIN
        mov     bx, [Disk_Handler]
        int     DOS_SERVICE             ; Position in dx:ax
        jc      @@90                    ; Stop on error
        or      ax, ax                  ; End of file?
        jz      @@90                    ; Yes
                                        ; No, so
;
; VTOC bitmap - Write
;
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mov     dx, offset VTOC_I_O_Bitmap
        int     DOS_SERVICE             ; Write bitmap
        jc      @@91                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@91                    ; Error
        
;
; Write Current Disk Sector to Image
;
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_VTOC_SIZE
        mov     dx, offset VTOC_I_O_Buffer
        int     DOS_SERVICE             ; Write vtoc
        jc      @@92                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@92                    ; Error

;
; Single density disk?
;
        cmp     [Disk_Sectors], DISK_SECTORS_SINGLE
        je      @@10                    ; Yes
                                        ; No, so
;
; VTOC bitmap extended - Determine offset to write to
;
        xor     ax, ax                  ; Reset ax
        xor     bx, bx                  ; Reset bx
        mov     ax, EIGHTBIT_VTOC_SECTOR_BITEXT
        dec     ax                      ; Because of positioning before sector
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mul     cx
        mov     cx, dx
        mov     dx, ax
        add     dx, ATR_HEADER_SIZE
        mov     ah, DOS_MOVE_FILE_POINTER
        mov     al, DOS_MOVE_FILE_POINTER_BEGIN
        mov     bx, [Disk_Handler]
        int     DOS_SERVICE             ; Position in dx:ax
        jc      @@90                    ; Stop on error
        or      ax, ax                  ; End of file?
        jz      @@90                    ; Yes
                                        ; No, so
;
; VTOC bitmap extended - Write
;
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_SECTOR_SIZE
        mov     dx, offset VTOC_I_O_Bitmap_Extend
        int     DOS_SERVICE             ; Write bitmap extend
        jc      @@91                    ; Error
        or      ax, ax                  ; Disk full?
        jz      @@91                    ; Error

@@10:
;
; Initialize VTOC map
;        
        mov     si, offset VTOC_I_O_Buffer
        push    ds si
        pop     di es
        xor     ax, ax
        mov     cx, EIGHTBIT_VTOC_SIZE
        rep     stosb

        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Positioning_Image
        push    ds si
        jmp     @@97

@@91:
;       mov     si, offset Msg_Err_VTOC
        mov     si, offset Ws_E2_D_Writing_Image
        push    ds si
        jmp     @@97

@@92:
;       mov     si, offset Msg_Err_VTOC_Bitmap
        mov     si, offset Ws_E2_D_Writing_Image
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Write_8bit_VTOC



;**********************************************************************
PROC    Process_Close_ATR_Image_Disk
;**********************************************************************
        cmp     [ATR_Disk_Image_Open], TRUE
        jne     @@99

;
; Close ATR Disk Image
;
        mov     bx, [Disk_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

;
; Update status
;
        mov     [ATR_Disk_Image_Open], FALSE

@@99:
        ret

ENDP    Process_Close_ATR_Image_Disk



;**********************************************************************
PROC    Process_Open_8bit_File
;**********************************************************************
;
; Determine Filename path
;
        mov     si, offset Path_Spec
        push    ds si
        pop     di es
        mov     si, offset File_Path
        mov     cx, PATH_LENGTH             ; Copy length
        rep     movsb                       ; Copy path to search path

        call    Setup_Path_Spec_File

;
; Open 8bit file
;
        mov     dx, offset Path_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@90                    ; Open ERROR!

        mov     [File_Handler], ax      ; Load handle
        jmp     @@99

@@90:
;
; E R R O R S
;
        mov     si, offset Ws_E2_D_Opening_File
        push    ds si
        jmp     @@97

@@97:
        mov     si, offset Ws_E2_F_Error_Message
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        pop     si ds
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        call    General_I_O_Error

@@99:
        ret

ENDP    Process_Open_8bit_File



;**********************************************************************
PROC    Process_Close_8bit_File
;**********************************************************************
        mov     bx, [File_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

@@99:
        ret

ENDP    Process_Close_8bit_File



;**********************************************************************
PROC    Setup_Path_Spec_Disk
;**********************************************************************
        mov     di, offset Path_Spec
        mov     cx, PATH_LENGTH                 ; Search length
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        xor     ax, ax
        mov     al, BACKSLASH                   ; Search for the last "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer correction after search
        inc     di                              ; Location after the "\"

;
; Add Disk Specification
;
        mov     si, offset Disk_Name
        mov     cx, FILE_NAME_LENGTH        ; Copy length
        rep     movsb                       ; Copy path to search path

        ret

ENDP    Setup_Path_Spec_Disk



;**********************************************************************
PROC    Setup_Path_Spec_File
;**********************************************************************
        mov     di, offset Path_Spec
        mov     cx, PATH_LENGTH                 ; Search length
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        xor     ax, ax
        mov     al, BACKSLASH                   ; Search for the last "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer correction after search
        inc     di                              ; Location after the "\"

;
; Add File Specification
;
        mov     si, offset File_Map_Entry.File_Name
        mov     cx, FILE_NAME_LENGTH        ; Copy length
        rep     movsb                       ; Copy path to search path

        ret

ENDP    Setup_Path_Spec_File



;**********************************************************************
PROC    Extract_Digit
;**********************************************************************
        xor     dx, dx                      ; Reset result
        div     bx                          ; Extract digit
        add     dx, 030h                    ; Turn digit into character
        cmp     [byte es:di], DECIMAL_SEPERATOR ; Character is decimal?
        jne     @@10                        ; No
                                            ; Yes, so
        dec     di                          ; Move to previous character

@@10:
        mov     [byte es:di], dl            ; Move character to text
        dec     di                          ; Move to previous character
        ret

ENDP    Extract_Digit



;**********************************************************************
PROC    Close_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Close_Ws_BG



;**********************************************************************
PROC    General_I_O_Error
;**********************************************************************
        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_OPEN

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E2
        mov     [byte ds:si], WSIO_CLOSE

        push    ds si
        call    WSIO
        pop     si ds

;
; Error encountered
;
        mov     [Dir2atr_Error], LOGIC_YES

        ret

ENDP    General_I_O_Error



ENDS    CSeg                                ; End of Code segment

END
