%TITLE          "XDIR - Atari XL/XE DIsk manageR - CHiPS bv 1997"
;**********************************************************************
;**                                                                  **
;**  Program   : XDIR v07.02.00                                      **
;**  Purpose   : Atari XL/XE Disk Manager                            **
;**                                                                  **
;**  Author    : B.F. Schreurs                                       **
;**              Computer High Performance Software (CHiPS) bv       **
;**  Date      : November 19th, 1997                                 **
;**                                                                  **
;**  Calls     : DC_DIRS  - Determine Current Directories            **
;**              DC_DRV   - Determine Current Drives                 **
;**              DC_FILES - Determine Current Files                  **
;**            : HEX2DIGI - Convert Hex Data To Digits (Text)        **
;**              WSIO     - Screen Handler                           **
;**                                                                  **
;**  Language  : Turbo Assembler                                     **
;**                                                                  **
;**********************************************************************
        IDEAL
        JUMPS

;----------------------------------------------------------------------
;--  Equates                                                         --
;----------------------------------------------------------------------
include ".\equ\attrib.equ"
include ".\equ\dos.equ"
include ".\equ\keyboard.equ"
include ".\equ\sysdep.equ"
include ".\equ\video.equ"
include ".\equ\wsio.equ"

EXTRA_TABLE_FIELDS          EQU     16
DIR_MAP_LENGTH              EQU (MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS) * DIR_ENTRY_LENGTH
COMMENT_ROW                 EQU    "#"
DISK_SIZE                   EQU     11
ATR_HEADER_SIZE             EQU     16
ATR_HEADER_SIZE_COMPARE     EQU      8
EIGHTBIT_VTOC_OFFSET        EQU  0B400h
EIGHTBIT_VTOC_OFFSET_DOUBLE_CX EQU 00001h
EIGHTBIT_VTOC_OFFSET_DOUBLE_DX EQU 06680h
EIGHTBIT_VTOC_FILES_MAX     EQU     64
EIGHTBIT_VTOC_SIZE          EQU   1024
EIGHTBIT_FILE_ENTRY_SIZE    EQU     16
EIGHTBIT_SECTOR_SIZE        EQU    128
EIGHTBIT_BOOT_SECTOR_SIZE   EQU    384
EIGHTBIT_SECTOR_SIZE_DOUBLE EQU    256
DISK_BLOCK_SIZE             EQU   1024

XDISK_SECTORS_SINGLE        EQU    720
XDISK_SECTORS_MEDIUM        EQU   1040
XDISK_SECTORS_ENHANCED      EQU   1120
XDISK_SECTORS_DOUBLE        EQU   1440

XFILE_SIZE_LENGTH           EQU      4



;**********************************************************************
SEGMENT SSeg Para Stack 'STACK'
;**********************************************************************

        db        64 dup (0)            ; Stack

ENDS    SSeg

;**********************************************************************
SEGMENT DSeg Word Public 'DATA'
;**********************************************************************

;----------------------------------------------------------------------
;--  Structures                                                      --
;----------------------------------------------------------------------
include ".\str\dta.str"
include ".\str\position.str"
include ".\str\wsio.str"

;----------------------------------------------------------------------
;--  Working Storage                                                 --
;----------------------------------------------------------------------
GLOBAL Return_Code:Byte:1

Return_Code             DB    0

Requested_Format_Drives DB   "1"                ; 1 = "ABCDEFGHIJKL    " etc.
                                                ; 2 = "A: [Floppy     ]"
                                                ;     "C: [HARD_DRIVE ]" etc.
Requested_Format_LibFil DB   "1"                ; 1 = DIRENTRY format    etc.
                                                ; 2 = "..           <DIR>      "
                                                ;     "ATARI        <DIR>      "
Hex2digi_Requested_Format       DB  "2"         ; "1" = With thousand seperator
                                                ; "2" = Mo thousand seperator
Media_Id_Buffer         DB   25 dup (NULL)
Available_Drives        DB  MAX_DRIVES     dup (SPACE)
Directories_File_Mask   DB   "*.*         "
Search_Files_Path       DB  PATH_LENGTH    dup (SPACE)
                        DB  NULL                ; To satisfy DOS find file
Search_Dirs_Path        DB  PATH_LENGTH    dup (SPACE)
Search_Filemask         DB  FILE_NAME_LENGTH    dup (SPACE)
Disk_Image_File_Path    DB  PATH_LENGTH    dup (SPACE)
                        DB  NULL                ; To satisfy DOS open file
Extraction_File_Path    DB  PATH_LENGTH    dup (SPACE)
                        DB  NULL                ; To satisfy DOS open file

Save_cx                 DW    ?
XL_VTOC_File_Nr         DB    0
Dir_Memo_Occur_Curr     DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Occur_W_Curr   DW  MAX_DIRS dup (NULL) ; Remember from which dir we came
Dir_Memo_Pointer        DB    0
Dir_Up                  DB    0                 ; 0=Stay current
                                                ; 1=Go dir up
                                                ; 2=Go dir down
Mouse_Pressed           DB  LOGIC_NO

Old_Dta_Seg             DW    ?                 ; Old Dta Segment Address
Old_Dta_Ofs             DW    ?                 ; Old Dta Segment Offset
Own_Dta                 Dta <>

Disk_Handler            DW      0
File_Handler            DW      0
Disk_VTOC_Buffer        DB  DISK_BLOCK_SIZE dup (0)
Disk_I_O_Buffer         DB  DISK_BLOCK_SIZE dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  C O N F I G U R A T I O N   F I L E   F O R   X D I R           --
;--                                                                  --
;----------------------------------------------------------------------
Config_Parameter        DB  256 dup (SPACE)
                        DB    1 dup (0)
Config_File_Spec        DB  "C:\XDIR.CFG    "   ; configuration file
                        DB    1 dup (0)
;--------------
; Config Fields
;--------------
Config_Field_Filemask           DB    "*.*         "
Config_Field_Startup_Path       DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)
Config_Field_Extract_To_Path    DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)
Config_Field_Deleted_Extract    DB   1            dup (LOGIC_YES)
Config_Field_Deleted_Path       DB   PATH_LENGTH  dup (SPACE)
                                DB   1            dup (0)



;----------------------------------------------------------------------
;--                                                                  --
;--  A T A R I   8   B I T   D I S K   I N F O                       --
;--                                                                  --
;----------------------------------------------------------------------
Disk_Image              DB   0                  ; 0=None, 1=Single, 2=Medium, 3=Enhanced, 4=Double
Disk_Image_Shown        DB   LOGIC_NO
Disk_Image_ATR          DB   LOGIC_NO

Disk_XFD_Single         DB   "     92,160"
Disk_XFD_Medium         DB   "    133,120"
Disk_XFD_Enhanced       DB   "    143,360"
Disk_XFD_Double         DB   "    183,936"

Disk_ATR_Single         DB   "     92,176"
Disk_ATR_Medium         DB   "    133,136"
Disk_ATR_Enhanced       DB   "    143,376"
Disk_ATR_Double         DB   "    183,952"

Disk_ATR_Single_Header          DB   96h,02h,80h,16h,80h,00h,00h,00h
Disk_ATR_Medium_Header          DB   96h,02h,80h,20h,80h,00h,00h,00h
Disk_ATR_Enhanced_Header        DB   96h,02h,00h,23h,80h,00h,00h,00h
Disk_ATR_Double_Header          DB   96h,02h,0E8h,2Ch,00h,01h,00h,00h

XFile_Size_Text         DB  "000,000,000"
XFile_Deleted           DB    1 dup (LOGIC_NO)
XFile_Locked            DB    1 dup (LOGIC_NO)
XFile_Extended          DB    1 dup (LOGIC_NO)
XFile_Inverse           DB    1 dup (LOGIC_NO)
XDisk_Sectors_Free      DW  XDISK_SECTORS_SINGLE

XDisk_File_Info_1       DB   22 dup ("xxxxxxxx.xxx9999")
XDisk_File_Info_2       DB   22 dup ("xxxxxxxx.xxx9999")
XDisk_File_Info_3       DB   20 dup ("xxxxxxxx.xxx9999")
;                            --
;                            64 files
;
XDisk_Free_Sectors      DB  "0000"

XDisk_Attrib_Info_1     DB   22 dup (ATTRIB_CYAN_WHITE)
XDisk_Attrib_Info_2     DB   22 dup (ATTRIB_CYAN_WHITE)
XDisk_Attrib_Info_3     DB   20 dup (ATTRIB_CYAN_WHITE)

XDisk_Attrib_Size_1     DB   22 dup (ATTRIB_CYAN_WHITE)
XDisk_Attrib_Size_2     DB   22 dup (ATTRIB_CYAN_WHITE)
XDisk_Attrib_Size_3     DB   20 dup (ATTRIB_CYAN_WHITE)

XDisk_Progress_Cnt_Prev DB    0
XDisk_Progress_Cnt_Max  DB   32

XDisk_Progress_Bar      DB   32 dup (0B0h)
XDisk_Progress_Bar_Attr DB   ATTRIB_CYAN_WHITE
XDisk_Extract_File      DB   12 dup (SPACE)

XDisk_Next_Sector       DW      0

Sectors_To_Extract      DW      ?
Sectors_Extracted       DW      ?
Sectors_For_This_File   DW      ?

XDisk_Image_Is_Bootdisk DB   "Bootdisk    "

;----------------------------------------------------------------------
;--                                                                  --
;--  S C R E E N S   S E C T I O N                                   --
;--                                                                  --
;----------------------------------------------------------------------
Filler                  DB   64 dup (" ")

;**********************************************************************
; B a c k G r o u n d                                                 *
;**********************************************************************
Ws_BG                   DB    WSIO_OPEN
                        DB    1                 ; Start of screen ROW
                        DB    1                 ; Start of screen COLUMN
                        DB   25                 ; End of screen ROW
                        DB   80                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_BG_Name              DB    "BG      "
Ws_BG_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_BG_Text              DB    "ͻ"
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "                                                                              "
                        DB    "ͼ"
                        DB    NULL
Ws_BG_Fields            DB    NULL

;**********************************************************************
; F r e e W a r e                                                     *
;**********************************************************************
Ws_FW                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FW_Name              DB    "FREEWARE"
Ws_FW_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FW_Text              DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "   XDIR - Atari XL/XE Directory Lister - v07.02.00  "
                        DB                               "                                                    "
                        DB                               "   by B.F. Schreurs, May 8th, 1998, CHiPS bv        "
                        DB                               "   Computer High Performance Software - Freeware    "
                        DB                               "   Email: stack@xs4all.nl                           "
                        DB                               "   Homepage: http:\\www.xs4all.nl\~stack            "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB                               "                                                    "
                        DB    NULL
Ws_FW_Fields            DB    NULL

;**********************************************************************
; X L   d i s k   i m a g e   v t o c                                 *
;**********************************************************************
Ws_XL                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_CYAN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_XL_Name              DB    "XLDISK  "
Ws_XL_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_XL_Text              DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                                "
                        DB                               "                                Free Sectors    "
                        DB    NULL
;
; VTOC Files Specification
;
Ws_XL_F_XL_File_1       DB    1                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB   22                 ; Nr of occurrences
                        DW    4                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_XL_Size_1       DB    1                 ; Relative ROW, NULL=End
                        DB   14                 ; Relative COLUMN 
                        DB    4                 ; Field Size
                        DB   22                 ; Nr of occurrences
                        DW   12                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_XL_File_2       DB    1                 ; Relative ROW, NULL=End
                        DB   19                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB   22                 ; Nr of occurrences
                        DW    4                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_XL_Size_2       DB    1                 ; Relative ROW, NULL=End
                        DB   31                 ; Relative COLUMN 
                        DB    4                 ; Field Size
                        DB   22                 ; Nr of occurrences
                        DW   12                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_XL_File_3       DB    1                 ; Relative ROW, NULL=End
                        DB   36                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB   20                 ; Nr of occurrences
                        DW    4                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_XL_Size_3       DB    1                 ; Relative ROW, NULL=End
                        DB   48                 ; Relative COLUMN 
                        DB    4                 ; Field Size
                        DB   20                 ; Nr of occurrences
                        DW   12                 ; Offset to next field
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    ?                 ; <Attrib Hi>
                        DW    ?                 ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_F_Free_Sectors    DB   22                 ; Relative ROW, NULL=End
                        DB   48                 ; Relative COLUMN 
                        DB    4                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    1                 ; Protected
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Hi>
                        DB    0                 ; <.... Lo>
                        DB    0                 ; <Backspace option>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XL_No_More_Fields    DB    NULL

;**********************************************************************
; e X t r a c t i n g   x l   d i s k   F i l e s                     *
;**********************************************************************
Ws_XF                   DB    WSIO_DISPLAY_ONLY
                        DB   11                 ; Start of screen ROW
                        DB   36                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   71                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_GREEN_WHITE ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; No cursor
                        DB    CURSOR_OFF_SCREEN ; to display
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_XF_Name              DB    "XFILES  "
Ws_XF_Keys              DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_XF_Text              DB                                       "[8 bit Disk Image Extraction]ͻ"
                        DB                                       "                                  "
                        DB                                       " xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx "
                        DB                                       "                                  "
                        DB                                       " Extracting file: xxxxxxxxxxxx    "
                        DB                                       "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Progress bar
;
Ws_XF_F_Progress_Bar    DB    3                 ; Relative ROW, NULL=End
                        DB    3                 ; Relative COLUMN 
                        DB   32                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

;
; Progress bar
;
Ws_XF_F_Extract_File    DB    5                 ; Relative ROW, NULL=End
                        DB   20                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    0                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_XF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Beginning of program

;**********************************************************************
; P A t h                                                             *
;**********************************************************************
Ws_PA                   DB    WSIO_DISPLAY_ONLY
                        DB    2                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB    2                 ; End of screen ROW
                        DB   79                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Input attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_PA_Name              DB    "PATH    "
Ws_PA_Keys              DB    KEY_ESC, KEY_ENTER, KEY_ARROW_LEFT, KEY_ARROW_RIGHT
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_PA_Text              DB    "Path:                                                                          "
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Path Specification
;
Ws_PA_F_Path            DB    1                 ; Relative ROW, NULL=End
                        DB    7                 ; Relative COLUMN 
                        DB   72                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Protected
                        DB    0                 ; <Mouse Sensitive>
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_PA_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Search Files Path

;**********************************************************************
; D R i v e   S e l e c t i o n                                       *
;**********************************************************************
Ws_DR                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_DR_Name              DB    "DRIVES  "
Ws_DR_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2 
;                       DB    KEY_HELP,     KEY_F2,         KEY_F3
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DR_Text              DB    "[Select Drive]ͻ"
                        DB    "    A: [FLOPPYDRIVE]    "
                        DB    "    C: [MY_VOLUME  ]    "
                        DB    "    D: [MY_CDROM   ]    "
                        DB    "    E: [NET_DRIVE  ]    "
                        DB    "    Z: [RAM_DISK   ]    "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "ENTER=Select Esc=Cancel "
                        DB    "F1=Help F2=FilMsk       "
                        DB    "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Drive Table
;
Ws_DR_F_Drive           DB    2                 ; Relative ROW, NULL=End
                        DB    6                 ; Relative COLUMN 
                        DB   16                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_DR_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Drive Table
;
Ws_DR_D_Drive           DB    MAX_DRIVES + EXTRA_TABLE_FIELDS dup ("                ")

;--------------------
; W O R K F I E L D S
;--------------------
Ws_DR_Occur_Curr        DW    ?
Ws_DR_Occur_Max         DW    ?                 ; Maximum nr of drives present
Ws_DR_Occur_W_Curr      DW    ?
WS_DR_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; D r i v e   H e l p   S c r e e n                                   *
;**********************************************************************
Ws_DH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_DH_Name              DB    "DRIVEHLP"
Ws_DH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_DH_Text              DB    "[Drive Help]ͻ"
                        DB    "                        "
                        DB    "ENTER = Select drive    "
                        DB    "", ARROW_UP, "     = Previous drive  "
                        DB    "", ARROW_DOWN, "     = Next drive      "
                        DB    "Home  = First drive     "
                        DB    "End   = Last drive      "
                        DB    "Pg Up = Previous drives "
                        DB    "Pg Dn = Next drives     "
                        DB    "F1    = This screen     "
                        DB    "F2    = Specify FileMask"
                        DB    "F3    = Config setup    "
                        DB    "Esc   = Cancel          "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "Esc=Exit Help           "
                        DB    "ͼ"
                        DB    NULL

;**********************************************************************
; L i b r a r y   F i l e   S e l e c t i o n                         *
;**********************************************************************
Ws_LF                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_BLUE_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_GREEN_WHITE  ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    1                 ; Locate cursor at field
                        DB    1                 ; Locate cursor at occurrence
                        DB    1                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_LF_Name              DB    "LIBFILES"
Ws_LF_Keys              DB    KEY_ESC,      KEY_ENTER
                        DB    KEY_HELP,     KEY_F2,         KEY_F3
                        DB    KEY_ARROW_UP, KEY_ARROW_DOWN
                        DB    KEY_PAGE_UP,  KEY_PAGE_DOWN
                        DB    KEY_HOME,     KEY_END
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LF_Text              DB    "[Select Dir/Image]", ARROW_UP, ARROW_DOWN, ""
                        DB    "..           <DIR>      "
                        DB    "ASM          <DIR>      "
                        DB    "EQUAL        <DIR>      "
                        DB    "MYDIR        <DIR>      "
                        DB    "PROJECT .TOO <DIR>      "
                        DB    "ATARI   .ATR 123,456,789"
                        DB    "MY      .ATR  12,345,678"
                        DB    "YOUR    .ATR   1,234,567"
                        DB    "ZZZZZZZZ.ATR     123,456"
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "ENTER=Select Esc=Cancel "
                        DB    "F1=Help F2=FilMsk F3=Drv"
                        DB    "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; Directories/Images Table
;
Ws_LF_F_Dir_Fil         DB    2                 ; Relative ROW, NULL=End
                        DB    2                 ; Relative COLUMN 
                        DB   24                 ; Field Size
                        DB   17                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_ENTER         ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Up         DB    1                 ; Relative ROW, NULL=End
                        DB   24                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_UP       ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_F_Page_Down       DB    1                 ; Relative ROW, NULL=End
                        DB   25                 ; Relative COLUMN 
                        DB    1                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is a table, not part of a table
                        DB    0                 ; Protected
                        DB    KEY_PAGE_DOWN     ; Mouse sensitive
                        DB    0                 ; <Edit option>
                        DB    0                 ; <Blanks option>
                        DB    0                 ; <Uppercase/Lowercase option>
                        DB    0                 ; <Backspace option>
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    NULL              ; Source Hi
                        DW    NULL              ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_LF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
;
; Dir / Fil Table
;
Dir_Map_ptr_es          DW    1 dup (NULL)      ; Segment 1
Dir_Map_ptr_di          DW    1 dup (NULL)

;--------------------
; W O R K F I E L D S
;--------------------
Ws_LF_Occur_Curr        DW    ?
Ws_LF_Occur_Max         DW    ?                 ; Maximum nr of entries present
Ws_LF_Occur_W_Curr      DW    ?
WS_LF_OCCUR_W_CURR_MAX  DW   17                 ; Maximum occurrences per window

;**********************************************************************
; L i b r a r y   F i l e   H e l p   S c r e e n                     *
;**********************************************************************
Ws_LH                   DB    WSIO_DISPLAY_ONLY
                        DB    3                 ; Start of screen ROW
                        DB    2                 ; Start of screen COLUMN
                        DB   24                 ; End of screen ROW
                        DB   27                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    0                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_LH_Name              DB    "LIBHELP "
Ws_LH_Keys              DB    KEY_ESC
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_LH_Text              DB    "[Dir/Image Help]ͻ"
                        DB    "                        "
                        DB    "ENTER = Select Dir/Image"
                        DB    "", ARROW_UP, "     = Prev Dir/Image  "
                        DB    "", ARROW_DOWN, "     = Next Dir/Image  "
                        DB    "Home  = First Dir/Image "
                        DB    "End   = Last Dir/Image  "
                        DB    "Pg Up = Prev Dirs/Images"
                        DB    "Pg Dn = Next Dirs/Images"
                        DB    "F1    = This screen     "
                        DB    "F2    = Specify FileMask"
                        DB    "F3    = Go to drive scrn"
                        DB    "Esc   = Exit Program    "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "                        "
                        DB    "Esc=Exit Help           "
                        DB    "ͼ"
                        DB    NULL

;**********************************************************************
; F i l e m a s k   s p e c i f i c a t i o n                         *
;**********************************************************************
Ws_FM                   DB    WSIO_DISPLAY_AND_READ
                        DB   10                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   15                 ; End of screen ROW
                        DB   53                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_FM_Name              DB    "CONFIG  "
Ws_FM_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_FM_Text              DB    "[Specify Filemask]ͻ"
                        DB    "                        "
                        DB    "      xxxxxxxxxxxx      "
                        DB    "                        "
                        DB    "ENTER=Specify Esc=Cancel"
                        DB    "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; File Mask
;
Ws_FM_F_Filemask        DB    3                 ; Relative ROW, NULL=End
                        DB    8                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    6                 ; Edit Filemask
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_FM_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Configuration File Fields

;**********************************************************************
; C o n f i g u r a t i o n   F I l e   S p e c i f i c a t i o n     *
;**********************************************************************
Ws_CF                   DB    WSIO_DISPLAY_AND_READ
                        DB   10                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   15                 ; End of screen ROW
                        DB   53                 ; End of screen COLUMN
                        DB    ATTRIB_GREEN_WHITE ; Screen attribute
                        DB    ATTRIB_BLUE_WHITE ; Field attribute
                        DB    ATTRIB_BLUE_WHITE ; Input attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    0                 ; Go to first          
                        DB    0                 ; modifiable field
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    ?                 ; Field Area  Address HIGH
                        DW    ?                 ; Field Area  Address LOW
Ws_CF_Name              DB    "CONFIG  "
Ws_CF_Keys              DB    KEY_ESC, KEY_ENTER
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_CF_Text              DB    "[Configuration Setup]ͻ"
                        DB    "                        "
                        DB    "      xxxxxxxxxxxx      "
                        DB    "                        "
                        DB    "ENTER=Specify Esc=Cancel"
                        DB    "ͼ"
                        DB    NULL
;------------
; F I E L D S
;------------
;
; File Mask
;
Ws_CF_F_Filemask        DB    3                 ; Relative ROW, NULL=End
                        DB    8                 ; Relative COLUMN 
                        DB   12                 ; Field Size
                        DB    1                 ; Nr of occurrences
                        DW    0                 ; This is not a table
                        DB    1                 ; Modifiable
                        DB    0                 ; Not mouse sensitive
                        DB    6                 ; Edit Filemask
                        DB    1                 ; Blanks Trailing
                        DB    0                 ; Uppercase
                        DB    0                 ; Backspace destructive
                        DB    0                 ; <Digits before dot>
                        DB    0                 ; <Digits after dot>
                        DB    0                 ; <Negative number option>
                        DB    0                 ; <Decimal point character>
                        DB    0                 ; <Date Time Format>
                        DB    LOGIC_NO          ; Field changed indicator
                        DW    ?                 ; Source Hi
                        DW    ?                 ; ...... Lo
                        DW    NULL              ; <Object Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Attrib Hi>
                        DW    NULL              ; <...... Lo>
                        DW    NULL              ; <Keys Hi>
                        DW    NULL              ; <.... Lo>

Ws_CF_No_More_Fields    DB    NULL

;--------
; D A T A
;--------
; See Configuration File Fields

;**********************************************************************
; E R R O R - D R I V E   N O T   R E A D Y                           *
;**********************************************************************
Ws_E1                   DB    WSIO_DISPLAY_ONLY
                        DB   10                 ; Start of screen ROW
                        DB   28                 ; Start of screen COLUMN
                        DB   16                 ; End of screen ROW
                        DB   51                 ; End of screen COLUMN
                        DB    ATTRIB_RED_WHITE  ; Screen attribute
                        DB    0                 ; Field attribute
                        DB    0                 ; Select attribute
                        DB    0                 ; Error attribute
                        DB    1                 ; Mouse support
                        DB    0                 ; Locate cursor at field
                        DB    0                 ; Locate cursor at occurrence
                        DB    0                 ; Locate cursor at position
                        DB    LOGIC_NO          ; Screen not changed
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Row
                        DB    CURSOR_OFF_SCREEN ; Cursor Position Col
                        DW    ?                 ; Screen Name Address HIGH
                        DW    ?                 ; Screen Name Address LOW
                        DW    ?                 ; Text        Address HIGH
                        DW    ?                 ; Text        Address LOW
                        DW    NULL              ; Attribute   Address HIGH
                        DW    NULL              ; Attribute   Address LOW
                        DW    ?                 ; Valid Keys  Address HIGH
                        DW    ?                 ; Valid Keys  Address LOW
                        DW    NULL              ; Field Area  Address HIGH
                        DW    NULL              ; Field Area  Address LOW
Ws_E1_Name              DB    "ERROR1  "
Ws_E1_Keys              DB    KEY_ANY
                        DB    NULL
;                                       1         2         3         4         5         6         7         8
;                              ....5....0....5....0....5....0....5....0....5....0....5....0....5....0....5....0
Ws_E1_Text              DB    "[Drive Not Ready]ͻ"
                        DB    "                      "
                        DB    " There is NO media in "
                        DB    " the requested drive! "
                        DB    "                      "
                        DB    "Esc or Any key=Confirm"
                        DB    "ͼ"
                        DB    NULL

ENDS    DSeg



;**********************************************************************
;               Extended Segments
;**********************************************************************
SEGMENT DSeg1 Word Public 'LIBFILES'
Dir_Map                 DB   DIR_MAP_LENGTH dup ("E")

ENDS    DSeg1

;**********************************************************************
SEGMENT CSeg Word Public 'CODE'
;**********************************************************************
;----------------------------------------------------------------------
;--  External Variables                                              --
;----------------------------------------------------------------------
        EXTRN   DC_DIRS:proc            ; Determine Current Directories
        EXTRN   DC_DRV:proc             ; Determine Current Drives
        EXTRN   DC_FILES:proc           ; Determine Current Files
        EXTRN   HEX2DIGI:proc           ; Convert Hex Data To Digits (Text)
        EXTRN   WSIO:proc               ; Screen Handler



;**********************************************************************
Main:   
;**********************************************************************
        ASSUME  cs:CSeg
        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize DS to address
        mov     ds, ax                          ; of data segment

        call    Init_Program
        call    Init_Screens
        call    Read_XDir_Config_File
        call    Parameter_Processing
        call    Read_VTOC_Drives
        call    Open_Ws_BG
        call    Display_Ws_BG                   ; Display background
        call    Display_Ws_FW                   ; Display freeware message

@@20:
        call    Display_and_Read_Ws_LF          ; Let user select library
;       call    Display_and_Read_Ws_PA          ; Let user enter path

@@30:
        call    Close_Ws_BG
        call    Exit_Program



;**********************************************************************
PROC    Init_Program
;**********************************************************************
        xor     ax, ax
        mov	ah, DOS_SET_MEMORY_BLOCK_SIZE   ; resize the psp memory
        xor     bx, bx
        int	DOS_SERVICE

;
; Segment Addressing
;
        ASSUME  ds:DSeg1
        mov     ax, DSeg1                       ; Initialize ds to address
        mov     ds, ax                          ; of data segment
 
        mov     si, offset Dir_Map
        push    ds si
        pop     di es

        ASSUME  ds:DSeg
        mov     ax, DSeg                        ; Initialize ds to address
        mov     ds, ax                          ; of data segment

        mov     [Dir_Map_ptr_es], es
        mov     [Dir_Map_ptr_di], di
 
@@99:
        ret

ENDP    Init_Program



;**********************************************************************
PROC    Init_Screens
;**********************************************************************
;
; Init screen BG=Background
;
        mov     si, offset Ws_BG
        push    ds si
        pop     di es

        mov     si, offset Ws_BG_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_BG_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_BG_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FW=FreeWare
;
        mov     si, offset Ws_FW
        push    ds si
        pop     di es

        mov     si, offset Ws_FW_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FW_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FW_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen XL=Atari Disk Image VTOC
;
        mov     si, offset Ws_XL
        push    ds si
        pop     di es

        mov     si, offset Ws_XL_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_XL_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_XL_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

; Field 1 Filename
        mov     si, offset Ws_XL_F_XL_File_1
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_1
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Info_1
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 1 Size
        mov     si, offset Ws_XL_F_XL_Size_1
        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_1
        add     si, FILE_NAME_LENGTH
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Size_1
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 2 Filename
        mov     si, offset Ws_XL_F_XL_File_2
        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_2
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Info_2
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 2 Size
        mov     si, offset Ws_XL_F_XL_Size_2
        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_2
        add     si, FILE_NAME_LENGTH
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Size_2
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 3 Filename
        mov     si, offset Ws_XL_F_XL_File_3
        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_3
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Info_3
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 3 Size
        mov     si, offset Ws_XL_F_XL_Size_3
        push    ds si
        pop     di es

        mov     si, offset XDisk_File_Info_3
        add     si, FILE_NAME_LENGTH
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Attrib_Size_3
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 4
        mov     si, offset Ws_XL_F_Free_Sectors
        push    ds si
        pop     di es

        mov     si, offset XDisk_Free_Sectors
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen XF=Extracting Files From Atari Disk Image
;
        mov     si, offset Ws_XF
        push    ds si
        pop     di es

        mov     si, offset Ws_XF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_XF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_XF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

; Field 1
        mov     si, offset Ws_XF_F_Progress_Bar
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset XDisk_Progress_Bar
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        mov     si, offset XDisk_Progress_Bar_Attr
        mov     [(Wsio_Field ptr di).Attrib_Address_Hi], ds
        mov     [(WSio_Field ptr di).Attrib_Address_Lo], si

; Field 2
        mov     si, offset Ws_XF_F_Extract_File
        push    ds si
        pop     di es

        mov     si, offset XDisk_Extract_File
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen PA=Path
;
        mov     si, offset Ws_PA
        push    ds si
        pop     di es

        mov     si, offset Ws_PA_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_PA_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_PA_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_PA_F_Path
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Files_Path
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DR=Drives
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     si, offset Ws_DR_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DR_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DR_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_DR_F_Drive
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen DH=Drive Help Screen
;
        mov     si, offset Ws_DH
        push    ds si
        pop     di es

        mov     si, offset Ws_DH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_DH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_DH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen LF=Directories/Images
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     si, offset Ws_LF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, [Dir_Map_ptr_es]
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     ax, [Dir_Map_ptr_di]
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], ax

;
; Init screen LH=Directory/Image Help Screen
;
        mov     si, offset Ws_LH
        push    ds si
        pop     di es

        mov     si, offset Ws_LH_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_LH_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_LH_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

;
; Init screen FM=FileMask
;
        mov     si, offset Ws_FM
        push    ds si
        pop     di es

        mov     si, offset Ws_FM_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_FM_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_FM_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_FM_F_Filemask
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Search_Filemask
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen CF=Configuration File
;
        mov     si, offset Ws_CF
        push    ds si
        pop     di es

        mov     si, offset Ws_CF_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_CF_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_CF_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        mov     si, offset Ws_CF_F_Filemask
        mov     [(Wsio_Area ptr di).Field_Address_Hi], ds
        mov     [(WSio_Area ptr di).Field_Address_Lo], si

        push    ds si
        pop     di es

        mov     si, offset Config_Field_Filemask
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

;
; Init screen E1=Error Screen - Drive Not Ready
;
        mov     si, offset Ws_E1
        push    ds si
        pop     di es

        mov     si, offset Ws_E1_Name
        mov     [(Wsio_Area ptr di).Name_Address_Hi], ds
        mov     [(WSio_Area ptr di).Name_Address_Lo], si

        mov     si, offset Ws_E1_Keys
        mov     [(Wsio_Area ptr di).Keys_Address_Hi], ds
        mov     [(WSio_Area ptr di).Keys_Address_Lo], si

        mov     si, offset Ws_E1_Text
        mov     [(Wsio_Area ptr di).Text_Address_Hi], ds
        mov     [(WSio_Area ptr di).Text_Address_Lo], si

        ret

ENDP    Init_Screens



;**********************************************************************
PROC    Read_XDir_Config_File
;**********************************************************************
; Open file
        mov     dx, offset Config_File_Spec
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@99                            ; Open ERROR!

        mov     [Disk_Handler], ax              ; Load handle

; Retrieve File Mask
        call    Get_Parameter_From_Config_File
        mov     si, offset Config_Field_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Parameter
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

; Retrieve Startup Path
        call    Get_Parameter_From_Config_File
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     si, offset Config_Parameter
        mov     cx, PATH_LENGTH
        rep     movsb

; Retrieve Destination Path
        call    Get_Parameter_From_Config_File
        mov     si, offset Config_Field_Extract_To_Path
        push    ds si
        pop     di es
        mov     si, offset Config_Parameter
        mov     cx, PATH_LENGTH
        rep     movsb

; Retrieve Specification If Deleted Files Should Be Extracted
        mov     [Config_Field_Deleted_Extract], LOGIC_NO
        call    Get_Parameter_From_Config_File
        mov     si, offset Config_Parameter
        cmp     [byte ds:si], "N"               ; Check if No is specified
        je      @@90                            ; No is specified
                                                ; Extract Deleted Files too!
        mov     [Config_Field_Deleted_Extract], LOGIC_YES

; Retrieve Destination Path Deleted Files (XFILESD)
        call    Get_Parameter_From_Config_File
        mov     si, offset Config_Field_Deleted_Path
        push    ds si
        pop     di es
        mov     si, offset Config_Parameter
        mov     cx, PATH_LENGTH
        rep     movsb                           ; Copy Passed Mask to File Mask

@@90:
; Close config file
        mov     bx, [Disk_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

@@99:
        ret

ENDP    Read_XDir_Config_File



;**********************************************************************
PROC    Get_Parameter_From_Config_File
;**********************************************************************
; Clear parameter
        mov     si, offset Config_Parameter
        push    ds si
        pop     di es
        push    es di
        mov     cx, PATH_LENGTH
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE
        rep     stosb                           ; Clear parameter
        pop     di es
        mov     si, offset Disk_I_O_Buffer

@@10:
; Scan character of the retrieved byte from the config file
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, 1                           ; Process 1 byte at a time
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Read byte from config file
        jc      @@99                            ; Stop on error
        or      ax, ax                          ; End of file?
        jz      @@99                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], LF                ; End of line of previous scan?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], CR                ; Empty "line" in config file?
        je      @@20                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], SPACE             ; Empty "line" in config file?
        je      @@20                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], COMMENT_ROW       ; Comment "line" in config file?
        jne     @@30                            ; No
                                                ; Yes, so
@@20:
; Scan for end of line character
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, 1                           ; Process 1 byte at a time
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Read byte from config file
        jc      @@99                            ; Stop on error
        or      ax, ax                          ; End of file?
        jz      @@99                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], LF                ; End of line reached?
        jne     @@20                            ; No,
                                                ; Yes, so
        jmp     @@10                            ; Scan next line of config file

@@30:
; Process the config parameter
        movsb                                   ; Copy byte from I/O Buffer

        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, 1                           ; Process 1 byte at a time
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Read byte from config file
        jc      @@99                            ; Stop on error
        or      ax, ax                          ; End of file?
        jz      @@99                            ; Yes
                                                ; No, so
        mov     si, dx
        cmp     [byte ds:si], CR                ; End of line reached?
        jne     @@30                            ; No,
                                                ; Yes, so
@@99:
        ret

ENDP    Get_Parameter_From_Config_File



;**********************************************************************
PROC    Parameter_Processing
;**********************************************************************
;------------------------------------
; Check Startup Path from config file
;------------------------------------
;
; If not specified, we use the current directory
;
        mov     si, offset Config_Field_Startup_Path
        cmp     [byte ds:si], SPACE             ; Config Field specified?
        je      @@10                            ; No
                                                ; Yes, so
;
; Startup path specified, use current directory?
;
        cmp     [byte ds:si], BACKSLASH         ; Use current directory
        je      @@10                            ; Yes
                                                ; No, so
;---------------------------
; Use specified startup path
;---------------------------
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH                 ; Search length
        dec     cx                              ; Because of null terminator
        add     di, cx                          ; Go to end of path
        std                                     ; Search direction is down
        xor     ax, ax                          ; Reset ax
        mov     al, BACKSLASH                   ; Search for the "\" character
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search

        jmp     @@20

;----------------------
; Use current directory
;----------------------
@@10:
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE
        rep     stosb                           ; Clear parameter

; Get default drive
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_DEFAULT_DRIVE       ; Get Default Drive
        int     DOS_SERVICE 
        add     al, 041h                        ; Because of 0-based stuff

; Process Drive
        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], al                ; Process Drive letter
        mov     [byte ds:si + 1], COLON
        mov     [byte ds:si + 2], BACKSLASH
        add     si, 3                           ; Locating at directory stuff

; Get current directory
        xor     ax, ax                          ; Reset ax
        mov     ah, DOS_GET_CURRENT_DIRECTORY
        xor     dx, dx                          ; Reset dx
        mov     dl, DOS_DEFAULT_DRIVE
        int     DOS_SERVICE

; Terminate it with a backslash "\"
        mov     si, offset Config_Field_Startup_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        mov     ax, SPACE                       ; Search for non space
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting

        mov     cl, BACKSLASH                   ; Assume adding a backslash
        cmp     [byte es:di], BACKSLASH         ; Are we in the root?
        jne     @@15                            ; No
                                                ; Yes, so
        mov     cl, SPACE                       ; Replace 000h by SPACE

@@15:
        inc     di                              ; Pointer adjustment after search
        mov     [byte es:di], cl

;---------------------------------
; Copy Startup path to search path
;---------------------------------
@@20:
        mov     si, offset Search_Dirs_Path
        push    ds si
        pop     di es

        mov     si, offset Config_Field_Startup_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;----------------------------------------
; Copy Config Filemask to Search Filemask
;----------------------------------------
        mov     si, offset Search_Filemask
        push    ds si
        pop     di es
        mov     si, offset Config_Field_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

@@99:
        ret

ENDP    Parameter_Processing



;**********************************************************************
PROC    Read_VTOC_Drives
;**********************************************************************
;
; Get drives in format: ACDE etc.
;
        mov     [Requested_Format_Drives], "1"          ; Format ABCDE
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Available_Drives     ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;
; Get drives in format: [A: Myvolume   ]
;                       [C: Yourvolume ] etc.
;
        mov     [Requested_Format_Drives], "2"          ; Format [A: Myvolume   ]
        mov     si, offset Requested_Format_Drives      ; Parameter 1
        push    ds si

        mov     si, offset Ws_DR_D_Drive  ; Parameter 2
        push    ds si
 
        call    DC_DRV

        pop     ax ax ax ax

;-----------------------
; Specify start of table
;-----------------------
        mov     [Ws_DR_Occur_Curr], 0

@@00:
;-----------------------------------
; Determine which drive to highlight
;-----------------------------------
        mov     [Ws_DR_Occur_W_Curr], 0

        mov     si, offset Search_Dirs_Path
        mov     bl, [byte ds:si]                ; Config path drive

;-------------------------------------------
; Determine maximum number of drives present
;-------------------------------------------
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     cx, MAX_DRIVES

        mov     [Ws_DR_Occur_Max], 0
        mov     si, offset Ws_DR_D_Drive

@@10:
        cmp     [byte ds:si], SPACE
        je      @@30

        inc     [Ws_DR_Occur_Max]
        cmp     [byte ds:si], bl                ; Selected drive found?
        jne     @@20                            ; No
                                                ; Yes, so
        mov     dx, [Ws_DR_Occur_Max]
        mov     [Ws_DR_Occur_Curr], dx

@@15:
        mov     [Ws_DR_Occur_W_Curr], dx
        cmp     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; dx > Max occur of window?
        jle     @@20                            ; No
                                                ; Yes, so
        sub     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Move 1 window up
        jmp     @@15

@@20:
        add     si, ax
        loop    @@10

@@30:
        cmp     [Ws_DR_Occur_W_Curr], 0         ; Invalid drive specified?
        jne     @@40                            ; No
                                                ; Yes, so

        mov     si, offset Config_Field_Startup_Path
        mov     [byte ds:si], SPACE             ; Clear Config Field
        call    Parameter_Processing
        jmp     @@00                            ; Redo this section

@@40:
;------------------------------------
; Pass offset address of drives table
;------------------------------------
        mov     si, offset Ws_DR_D_Drive
        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

@@99:
        ret

ENDP    Read_VTOC_Drives



;**********************************************************************
PROC    Open_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        cmp     ax, NULL                        ; Error?
        jz      @@99                            ; No
                                                ; Yes, so
;
; Error
;

@@99:        
        ret

ENDP    Open_Ws_BG



;**********************************************************************
PROC    Display_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_BG



;**********************************************************************
PROC    Display_Ws_FW
;**********************************************************************
        mov     si, offset Ws_FW

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_FW



;**********************************************************************
PROC    Display_Ws_XL
;**********************************************************************
        mov     si, offset Ws_XL

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_XL



;**********************************************************************
PROC    Display_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_PA



;**********************************************************************
PROC    Display_and_Read_Ws_PA
;**********************************************************************
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        JMP     @@15

@@10:
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_READ_ONLY

@@15:
        push    ds si
        call    WSIO
        pop     si ds

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_LEFT
        je      @@20
        cmp     al, KEY_ARROW_RIGHT
        je      @@30
        cmp     al, KEY_ENTER
        je      @@60
;
; Assume the Esc(ape) key
;
        jmp     @@99

;---------------
; KEY ARROW LEFT
;---------------
@@20:
        jmp     @@10

;----------------
; KEY ARROW RIGHT
;----------------
@@30:
        jmp     @@10

;----------
; KEY ENTER
;----------
@@60:
        jmp     @@99

@@99:
        ret

ENDP    Display_and_Read_Ws_PA



;**********************************************************************
PROC    Display_Ws_DR
;**********************************************************************
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DR



;**********************************************************************
PROC    Display_and_Read_Ws_DR
;**********************************************************************
;----------
; Init Path
;----------
;
; Reset Search Dirs Path
;
        mov     si, offset Search_Dirs_Path     ; Clear path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb

        call    Display_Ws_DR
        jmp     @@10

;---------------------------------
; Show fields only of Drives Table
;---------------------------------
@@05:
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;
; Make current occurrence Green/White
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_DR_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_DR
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_F2                      ; Specify filemask
        je      @@70
        cmp     al, KEY_F3                      ; Configuration setup
        je      @@70
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_DR_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_DR_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_DR_Occur_Curr]          ; Current occurr = max?
        je      @@10                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_DR_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_DR_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_DR_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]
        dec     dx
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_DR_Occur_Max]           ; Is there a next window?
        jnle    @@10                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_DR_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_DR_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_DR_Occur_Max]           ; Determine difference
        sub     [Ws_DR_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_DR_Occur_Max]

@@36:
        mov     [Ws_DR_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_DR_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_DR_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_DR_Occur_W_Curr], 1         ; At top of window?
        je      @@10                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_DR_Occur_W_Curr], 1
        mov     [Ws_DR_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_DR_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_DR_Occur_Max]           ; Can we go "down" anyhow?
        je      @@10                            ; No
                                                ; Yes, so
        mov     cx, [Ws_DR_Occur_Max]           ; Go to last occurrence
        mov     [Ws_DR_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_W_Curr], cx        ; Go  to  last entry in window
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_DR_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_DR_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_DR_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;----------------------------------------
; Set up drive window data and attributes
;----------------------------------------
@@50:
        mov     si, offset Ws_DR_F_Drive
        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        mov     si, offset Ws_DR_D_Drive

        jmp     @@52

@@51:
        add     si, ax

@@52:
        loop    @@51

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ds
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], si

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_DR
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@10                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_DR_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_DR_Occur_Max]           ; Valid occurrence?
        jnle    @@10                            ; No
                                                ; Yes, so
        mov     [Ws_DR_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_DR_Occur_W_Curr], cx

@@61:
;
; Copy selected drive to path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     si, offset Available_Drives
        add     si, [Ws_DR_Occur_Curr]
        dec     si
        movsb
        mov     [byte es:di], COLON
        mov     [byte es:di + 1], BACKSLASH

;
; Show new path to user
;
        mov     si, offset Ws_PA
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        mov     [Dir_Memo_Pointer], 0           ; Reset directory memo pointer
        jmp     @@99

;------------------
; KEY F2 - FileMask
;------------------
@@70:
        call    Display_and_Read_Ws_FM
        jmp     @@10

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_DH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_DR



;**********************************************************************
PROC    Display_Ws_DH
;**********************************************************************
        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_DH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_DH



;**********************************************************************
PROC    Read_VTOC_Directories_Files
;**********************************************************************
        cmp     [Dir_Up], 2                     ; Do we have to remember from which directory we came from?
        jne     @@05                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]
        mov     dx, [Ws_LF_Occur_W_Curr]
        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], cx
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to empty spot
        mov     [ds:si], dx
        inc     [Dir_Memo_Pointer]

@@05:
        mov     [Ws_LF_Occur_Max], 0

;---------------------------------------------
; Get field size of Libraries/Files Table item
;---------------------------------------------
        mov     si, offset Ws_LF_F_Dir_Fil
        push    ds si
        pop     di es

        mov     ax, MAX_DIRS_AND_FILES + EXTRA_TABLE_FIELDS
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]
        xor     dx, dx
        mul     cx

;----------------------------
; Clear Libraries/Files Table
;----------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, NULL                        ; Fill character
        rep     stosb

;----------------------------------------------
; Check if drive we have to access drive A or B
;----------------------------------------------
        mov     si, offset Search_Dirs_Path
        cmp     [byte ds:si], "A"               ; Access drive A?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [byte ds:si], "B"               ; Access drive B?
        jne     @@20                            ; No
                                                ; Yes, so
@@10:
        xor     bx, bx                          ; Reset dx
        mov     bl, [byte ds:si]                ; Copy selected drive to path
        sub     bl, 64                          ; Turn drive into DOS drive
        mov     ax, DOS_SENSE_MEDIA_TYPE
        mov     al, 00Dh                        ; subfunction code
        mov     cx, DOS_GET_MEDIA_ID_CX
        mov     dx, offset Media_ID_Buffer
        int     DOS_SERVICE                     ; Check Drive Presence
        cmp     ax, DOS_DRIVE_NOT_READY         ; Drive ready?
        jne     @@20                            ; Yes
                                                ; No, so
;------------------------
; ERROR - DRIVE NOT READY
;------------------------
        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_E1
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@99

@@20:        
;-------------------------------
; Set up Search path - Libraries
;-------------------------------
;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add "*.*" to the Search path
;
        mov     si, offset Directories_File_Mask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3
        push    es di
 
;-----------------------------------------
; Now retrieve Directory Map - Directories
;-----------------------------------------
        call    DC_DIRS

        pop     ax ax ax ax ax ax

;---------------------------
; Set up Search path - Files
;---------------------------

;
; Copy shown path to search path first
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Find first non blank character in the Search path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, SPACE                       ; Search the first space
        mov     cx, PATH_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

;
; Add FileMask to the Search path
;
        mov     si, offset Search_Filemask
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

;
; Terminate it with a null
;
        mov     [byte es:di], NULL

;
; Set up parameters for Directory search
;
        mov     [Requested_Format_LibFil], "2"          ; Format "..           <DIR>      "
                                                        ;        "ATARI        <DIR>      "
        mov     si, offset Requested_Format_LibFil      ; Parameter 1
        push    ds si

        mov     si, offset Search_Files_Path            ; Parameter 2
        push    ds si

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]                    ; Parameter 3

;
; Search null terminator
;
        xor     ax, ax
        mov     al, NULL                        ; Search the first null
        mov     cx, DIR_MAP_LENGTH
        repne   scasb                           ; Search
        dec     di                              ; Pointer correction after search

        push    es di
 
;-----------------------------------
; Now retrieve Directory Map - Files
;-----------------------------------
        call    DC_FILES

        pop     ax ax ax ax ax ax

;------------------------------------------------------
; After reading the VTOC we are at the first occurrence
;------------------------------------------------------
        mov     cx, 1                           ; To satisfy loop condition
        mov     [Ws_LF_Occur_Curr], 1
        mov     [Ws_LF_Occur_W_Curr], 1

        cmp     [Dir_Up], 1                     ; Did we go up a dir?
        jne     @@50                            ; No
                                                ; Yes, so
        cmp     [Dir_Memo_Pointer], 0           ; Did we have save info of previous dirs?
        je      @@50                            ; No
                                                ; Yes, so
        dec     [Dir_Memo_Pointer]

        xor     ax, ax
        mov     al, [Dir_Memo_Pointer]          ; Get current occurrence
        rol     ax, 1                           ; Multiply by 2

        mov     si, offset Dir_Memo_Occur_Curr
        add     si, ax                          ; Move to occupied spot
        mov     cx, [ds:si]
        mov     si, offset Dir_Memo_Occur_W_Curr
        add     si, ax                          ; Move to occupied spot
        mov     dx, [ds:si]

        mov     [Ws_LF_Occur_Curr], cx
        mov     [Ws_LF_Occur_W_Curr], dx

        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now

@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

;------------------------------------
; Determine MAXimum nr of occurrences
;------------------------------------
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        mov     cx, DIR_MAP_LENGTH              ; Search length
        xor     ax, ax                          ; Search for null character
        repne   scasb                           ; Search uses es:di

        mov     ax, DIR_MAP_LENGTH
        sub     ax, cx                          ; Nr of entries in size determined
        xor     dx, dx
        xor     cx, cx
        mov     bx, DIR_ENTRY_LENGTH            ; Determine nr of occurs
        div     bx

        mov     [Ws_LF_Occur_Max], ax

@@99:
        call    Display_Ws_PA                   ; Display path

        ret

ENDP    Read_VTOC_Directories_Files



;**********************************************************************
PROC    Display_and_Read_Ws_LF
;**********************************************************************
        jmp     @@64                            ; Because of startup path

;------------------------------------------
; Show fields only of Libraries/Files Table
;------------------------------------------
@@05:
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY

        push    ds si
        call    WSIO
        pop     si ds

@@10:
;----------------------------------------------------
; Are we dealing with an Atari 8 bit disk image here?
;----------------------------------------------------
;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                              ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Check contents of selected dir/file
;        
        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax

        add     di, FILE_NAME_LENGTH + 1        ; Go to file size

        mov     [Disk_Image_ATR], LOGIC_YES     ; Assume ATR disk image

; Check ATR single
        mov     [Disk_Image], 1

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_SINGLE
        push    es di
        mov     si, offset Disk_ATR_Single
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = ATR single?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check ATR medium
        mov     [Disk_Image], 2

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_MEDIUM
        push    es di
        mov     si, offset Disk_ATR_Medium
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = ATR medium?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check ATR enhanced
        mov     [Disk_Image], 3

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_ENHANCED
        push    es di
        mov     si, offset Disk_ATR_Enhanced
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = ATR enhanced?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check ATR double
        mov     [Disk_Image], 4

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_DOUBLE
        push    es di
        mov     si, offset Disk_ATR_Double
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = ATR double?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; No ATR disk image
        mov     [Disk_Image_ATR], LOGIC_NO      ; Assume no ATR disk image

; Check XFD single
        mov     [Disk_Image], 1

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_SINGLE
        push    es di
        mov     si, offset Disk_XFD_Single
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = XFD single?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check XFD medium
        mov     [Disk_Image], 2

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_MEDIUM
        push    es di
        mov     si, offset Disk_XFD_Medium
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = XFD medium?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check XFD enhanced
        mov     [Disk_Image], 3

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_ENHANCED
        push    es di
        mov     si, offset Disk_XFD_Enhanced
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = XFD enhanced?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

; Check XFD double
        mov     [Disk_Image], 4

        mov     [word XDisk_Sectors_Free], XDISK_SECTORS_DOUBLE
        push    es di
        mov     si, offset Disk_XFD_Double
        mov     cx, DISK_SIZE                   ; Compare Size (file size)
        rep     cmpsb                           ; File size = XFD double?
        je      @@12                            ; Yes,
                                                ; No, so
        pop     di es

        mov     [Disk_Image], 0

        jmp     @@13

;-------------------------------------
; Show Atari 8 bit disk image contents
;-------------------------------------
@@12:
        pop     di es

        call    Retrieve_Disk_Image_VTOC

;------------------------------------------
; Show Freeware Text or Disk Image contents
;------------------------------------------
@@13:
        cmp     [Disk_Image], 0                 ; Is it an Atari 8 bit image?
        jne     @@14                            ; Yes
                                                ; No, so
        cmp     [Disk_Image_Shown], LOGIC_YES   ; Is there still an image showing?
        jne     @@15                            ; No
                                                ; Yes, so
        mov     [Disk_Image_Shown], LOGIC_NO
        call    Display_Ws_FW                   ; Show Freeware Text
        jmp     @@15                            ; Continue

@@14:
        call    Display_Ws_XL
        mov     [Disk_Image_Shown], LOGIC_YES

;------------------------------------
; Make current occurrence Green/White
;------------------------------------
@@15:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, ATTRIB_GREEN_WHITE
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     [(Wsio_Area ptr di).Cursor_Position_Row], CURSOR_OFF_SCREEN
        mov     [(Wsio_Area ptr di).Cursor_Position_Col], CURSOR_OFF_SCREEN

;
; Display current occurrence
;
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;----------
; Get input
;----------
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_READ_ONLY

        push    ds si
        call    WSIO
        pop     si ds

;
; Save pressed key
;
        push    ax

;
; Reset current occurrence
;
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        mov     cl, [(Wsio_Area ptr di).Field_Attrib]
        mov     [(Wsio_Area ptr di).Input_Select_Attrib], cl

        mov     [(Wsio_Area ptr di).Select_Field_Nr], 1
        mov     cx, [Ws_LF_Occur_W_Curr]
        mov     [(Wsio_Area ptr di).Select_Field_Occur_Nr], cl

        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_SELECT_DESELECT

        push    ds si
        call    WSIO
        pop     si ds

;
; Restore pressed key
;
        pop     ax

;--------------------------------
; Determine which key was pressed
;--------------------------------
        cmp     al, KEY_ARROW_UP
        je      @@20
        cmp     al, KEY_ARROW_DOWN
        je      @@25
        cmp     al, KEY_PAGE_UP
        je      @@30
        cmp     al, KEY_PAGE_DOWN
        je      @@35
        cmp     al, KEY_HOME
        je      @@40
        cmp     al, KEY_END
        je      @@45
        cmp     al, KEY_ENTER
        je      @@60
        cmp     al, KEY_F2                      ; Specify filemask
        je      @@70
        cmp     al, KEY_F3                      ; Back to drives
        je      @@62
        cmp     al, KEY_HELP
        je      @@90
;
; Assume the Esc(ape) key
;
        jmp     @@99

;-------------
; KEY ARROW UP
;-------------
@@20:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move "up" to previous occurrence
;
        dec     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        cmp     [Ws_LF_Occur_W_Curr], 1
        je      @@21

        dec     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@21:
;
; Move occurrence down
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        jmp     @@50

;---------------
; KEY ARROW DOWN
;---------------
@@25:
        mov     dx, [Ws_LF_Occur_Max]           ; Max nr of available occurrences
        cmp     dx, [Ws_LF_Occur_Curr]          ; Current occurr = max?
        je      @@15                            ; Yes
                                                ; No, so
;
; Move "down" to next occurrence
;
        inc     [Ws_LF_Occur_Curr]

;
; Are we still in the current "window"?
;
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Max occurrence of window
        cmp     [Ws_LF_Occur_W_Curr], dx        ; Current occurr = max window?
        je      @@26                            ; Yes
                                                ; No, so
        inc     [Ws_LF_Occur_W_Curr]
        jmp     @@10

@@26:
;
; Move occurrences up
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Get current occurrence
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Calculate window size
        inc     cx
        jmp     @@50

;------------
; KEY PAGE UP
;------------
@@30:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
;
; Move up to previous window
;
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Can we subtract 1 page?
        jl      @@31                            ; No
                                                ; Yes, so
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract size of 1 page
        jmp     @@32

@@31:
        mov     cx, 1                           ; Go to beginning of occur

@@32:
;
; Determine Window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]
        dec     dx
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;--------------
; KEY PAGE DOWN
;--------------
@@35:
        mov     cx, [Ws_LF_Occur_Curr]          ; Can we go "down" anyhow?
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        add     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Add size of 1 page
        cmp     cx, [Ws_LF_Occur_Max]           ; Is there a next window?
        jnle    @@15                            ; No
                                                ; Yes, so
;
; Determine window occurrence
;
        mov     dx, cx
        add     dx, [Ws_LF_Occur_W_Curr]        ; Go to same window occurrence
        dec     dx                              ; Which is done now
        cmp     dx, [Ws_LF_Occur_Max]           ; Does it exist?
        jle     @@36                            ; Yes
                                                ; No, so
        mov     bx, dx                          ; bx = dx
        sub     bx, [Ws_LF_Occur_Max]           ; Determine difference
        sub     [Ws_LF_Occur_W_Curr], bx        ; Go to last occurrence
        mov     dx, [Ws_LF_Occur_Max]

@@36:
        mov     [Ws_LF_Occur_Curr], dx
        jmp     @@50

;---------
; KEY HOME
;---------
@@40:
        cmp     [Ws_LF_Occur_Curr], 1           ; Can we go "up" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     cx, [Ws_LF_Occur_W_Curr]        ; Determine begin of window
        inc     cx                              ; Which is done now
        cmp     cx, 1                           ; Showing from 1st already?
        jne     @@41                            ; No
                                                ; Yes, so
        cmp     [Ws_LF_Occur_W_Curr], 1         ; At top of window?
        je      @@15                            ; Yes
                                                ; No, so
@@41:
        mov     cx, 1                           ; Go to beginning of screen
        mov     [Ws_LF_Occur_W_Curr], 1
        mov     [Ws_LF_Occur_Curr], 1
        jmp     @@50

;--------
; KEY END
;--------
@@45:
        mov     cx, [Ws_LF_Occur_Curr]          ; Current occurrence
        cmp     cx, [Ws_LF_Occur_Max]           ; Can we go "down" anyhow?
        je      @@15                            ; No
                                                ; Yes, so
        mov     cx, [Ws_LF_Occur_Max]           ; Go to last occurrence
        mov     [Ws_LF_Occur_Curr], cx          ; Go to last occurrence in table
        cmp     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Does it all fit in 1 window?
        jnle    @@46                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_W_Curr], cx        ; Go  to  last entry in window
        mov     cx, 1                           ; Start from first occurrence
        jmp     @@50

@@46:
;
; Determine window occurrence
;
        sub     cx, [WS_LF_OCCUR_W_CURR_MAX]    ; Subtract 1 page
        inc     cx                              ; We are at the last page now
        mov     dx, [WS_LF_OCCUR_W_CURR_MAX]    ; Get last window occurrence
        mov     [Ws_LF_Occur_W_Curr], dx        ; Move to last window occurrence
        jmp     @@50

;--------------------------------------------
; Set up dir/image window data and attributes
;--------------------------------------------
@@50:
        mov     si, offset Ws_LF_F_Dir_Fil

        push    ds si
        pop     di es

        xor     ax, ax
        mov     al, [(Wsio_Field ptr di).Size]

        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]

        jmp     @@52

@@51:
        add     di, ax

@@52:
        loop    @@51

        mov     ax, es
        mov     bx, di

        pop     di es

        mov     [(Wsio_Field ptr di).Data_Address_Src_Hi], ax
        mov     [(WSio_Field ptr di).Data_Address_Src_Lo], bx

        jmp     @@05

;----------
; KEY ENTER
;----------
@@60:
        mov     si, offset Ws_LF
        push    ds si
        pop     di es

        xor     bx, bx
        mov     bl, [(Wsio_Area ptr di).Select_Field_Occur_Nr]

        mov     [Mouse_Pressed], LOGIC_NO

        xor     cx, cx
        mov     cl, [(Wsio_Area ptr di).Cursor_Position_Row]
        cmp     cl, CURSOR_OFF_SCREEN           ; Enter by mouse press?
        je      @@61                            ; No
                                                ; Yes, so
        mov     [Mouse_Pressed], LOGIC_YES

;
; Mouse pressed Enter, is it valid?
;
        cmp     cl, 4                           ; Valid occurrence?
        jl      @@15                            ; No
                                                ; Maybe
        cmp     cl, 20                          ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Maybe
        sub     cl, 3                           ; Determine occurrence
        mov     dx, [Ws_LF_Occur_Curr]          ; Current occurrence
        sub     dx, bx
        add     dx, cx
        cmp     dx, [Ws_LF_Occur_Max]           ; Valid occurrence?
        jnle    @@15                            ; No
                                                ; Yes, so
        mov     [Ws_LF_Occur_Curr], dx          ; Set occurrence
        mov     [Ws_LF_Occur_W_Curr], cx

@@61:
        push    ds si

;
; Go to end of path
;
        mov     si, offset Search_Dirs_Path     ; 73 chars for Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        dec     cx                              ; To go to the last character
        add     di, cx                          ; Go to end of path
        std                                     ; Searh direction is down
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

;
; Determine selected directory/file
;
        mov     ax, [Ws_LF_Occur_Curr]
        dec     ax                              ; Because of offset reasons
        xor     bx, bx
        mov     cx, DIR_ENTRY_LENGTH
        xor     dx, dx
        mul     cx

;
; Go to drive selection or dirs?
;        
        push    es di

        mov     es, [Dir_Map_ptr_es]
        mov     di, [Dir_Map_ptr_di]
        add     di, ax
        cmp     [byte es:di], DOT               ; Go to drive selection/dirs?
        jne     @@66                            ; No
                                                ; Yes, so
        pop     di es                           ; Check path
        pop     si ds
        cmp     [byte es:di - 2], COLON         ; Go to drive selection?
        jne     @@65                            ; No
                                                ; Yes, so
@@62:
;
; Select another drive
;
        cmp     [Disk_Image_Shown], LOGIC_YES   ; Is there still an image showing?
        jne     @@63                            ; No
                                                ; Yes, so
        mov     [Disk_Image_Shown], LOGIC_NO
        call    Display_Ws_FW                   ; Show Freeware Text

@@63:
;
; Reset Search Files Path
;
        mov     si, offset Search_Files_Path
        push    ds si
        pop     di es
        mov     cx, PATH_LENGTH
        mov     ax, SPACE
        rep     stosb                           ; Clear path

        call    Display_Ws_PA                   ; Display path
        call    Display_and_Read_Ws_DR          ; Let user select drive

        cmp     al, KEY_ESC                     ; Cancel pressed?
        je      @@99                            ; Yes
                                                ; No, so
@@64:
        mov     [Dir_Up], 0                     ; We stay in the current dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        cmp     [Ws_LF_Occur_Max], 0            ; Drive not ready?
        je      @@62                            ; Yes
                                                ; No, so
        mov     si, offset Ws_LF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY

        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@10

@@65:
;
; Go to previous dir
;
        dec     di                              ; Position on the "\"
        dec     di                              ; Position before the "\"
        std                                     ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, BACKSLASH                   ; Search for "\"
        repne   scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To postion after the "\"

        mov     cx, DIR_NAME_LENGTH + 1         ; Because of "\"
        add     cx, FILE_NAME_LENGTH            ; Because of *.ATR
        mov     ax, SPACE
        rep     stosb

        mov     [Dir_Up], 1                     ; We go to previous dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files
        jmp     @@05

@@66:
;
; Go to subdir OR extract files from image OR do nothing
;
        push    es di
        add     di, FILE_NAME_LENGTH + 1        ; Go to file size
        cmp     [byte es:di], "<"               ; Directory indicator
        pop     si ds                           ; From -> Dir/File table

        pop     di es                           ; To   -> Path
        jne     @@67                            ; It's a file!
                                                ; It's a directory, so
        mov     cx, DIR_NAME_LENGTH
        rep     movsb

        pop     si ds

        std                                     ; Searh direction is down
        mov     cx, DIR_NAME_LENGTH + 1
        mov     ax, SPACE                       ; Search for not equal " "
        repe    scasb                           ; Search uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; To position after the " "

        mov     [byte es:di], BACKSLASH

        mov     [Dir_Up], 2                     ; We go to a subdir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files

        jmp     @@05

@@67:
        pop     si ds

        cmp     [Disk_Image], 0                 ; Is this a XL disk image?
        jne     @@68                            ; Yes
                                                ; No, so
        cmp     [Mouse_Pressed], LOGIC_YES      ; Mouse pressed Enter?
        je      @@10                            ; Yes
        jmp     @@15                            ; No, so

@@68:
        cmp     [Mouse_Pressed], LOGIC_YES      ; Mouse pressed Enter?
        je      @@10                            ; Yes
                                                ; No, so
        cmp     [Sectors_To_Extract], 0         ; Something to extract?
        je      @@15                            ; No
                                                ; Yes, so
        call    Extract_Disk_Image_Files

        jmp     @@15

;------------------
; KEY F2 - FileMask
;------------------
@@70:
        call    Display_and_Read_Ws_FM

        mov     si, offset Ws_FM
        push    ds si
        pop     di es

        cmp     [(Wsio_Area ptr di).Screen_Changed], LOGIC_NO   ; Screen changed?
        je      @@15                            ; No
                                                ; Yes, so
        mov     [Dir_Up], 0                     ; We stay in the current dir
        call    Read_VTOC_Directories_Files     ; Retrieve directories/files
        jmp     @@05

;---------
; KEY HELP
;---------
@@90:
        call    Display_Ws_LH
        jmp     @@10

;-------
; Return
;-------
@@99:
        ret

ENDP    Display_and_Read_Ws_LF



;**********************************************************************
PROC    Display_Ws_LH
;**********************************************************************
        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_LH
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_Ws_LH



;**********************************************************************
PROC    Display_and_Read_Ws_FM
;**********************************************************************
        mov     si, offset Ws_FM
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_FM
        mov     [byte ds:si], WSIO_DISPLAY_AND_READ
        push    ds si
        call    WSIO
        pop     si ds

        mov     si, offset Ws_FM
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Display_and_Read_Ws_FM



;**********************************************************************
PROC    Retrieve_Disk_Image_VTOC
;**********************************************************************
; Determine filename to open
        sub     di, FILE_NAME_LENGTH + 1        ; Go to filename

        push    ds si es di

        mov     si, offset Disk_Image_File_Path

        push    ds si
        pop     di es
        mov     si, offset Search_Dirs_Path
        mov     cx, PATH_LENGTH
        rep     movsb

; Search for last "\"
        mov     cx, PATH_LENGTH                 ; Search length
        std                                     ; Search direction is down
        or      ax, ax                          ; Reset ax
        mov     al, BACKSLASH                   ; Search for the "\" character
        repne   scasb                           ; Search equal "\" uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; Move next to the "\"

; Append Filename from entry
        pop     si ds
        mov     cx, FILE_NAME_LENGTH
        rep     movsb

        pop     si ds

; Open file
        mov     dx, offset Disk_Image_File_Path
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@99                            ; Open ERROR!

        mov     [Disk_Handler], ax              ; Load handle

        cmp     [Disk_Image_ATR], LOGIC_YES     ; ATR Disk Image?
        jne     @@20                            ; No
                                                ; Yes, so
; Read file header
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, ATR_HEADER_SIZE             ; Header size
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Read header
        jc      @@90                            ; Stop on error
        or      ax, ax                          ; End of file?
        jz      @@90                            ; Yes
                                                ; No, so
        mov     si, offset Disk_I_O_Buffer
        mov     cx, ATR_HEADER_SIZE_COMPARE
        push    cx ds si                        ; Save compare info

; Check file header single
        mov     [Disk_Image], 1

        mov     si, offset Disk_ATR_Single_Header
        push    ds si
        pop     di es

        pop     si ds cx
        push    cx ds si
        rep     cmpsb                           ; Header is .ATR Single?
        je      @@10                            ; Yes
                                                ; No, so
; Check file header medium
        mov     [Disk_Image], 2

        mov     si, offset Disk_ATR_Medium_Header
        push    ds si
        pop     di es

        pop     si ds cx
        push    cx ds si
        rep     cmpsb                           ; Header is .ATR Medium?
        je      @@10                            ; Yes
                                                ; No, so
; Check file header enhanced
        mov     [Disk_Image], 3

        mov     si, offset Disk_ATR_Enhanced_Header
        push    ds si
        pop     di es

        pop     si ds cx
        push    cx ds si
        rep     cmpsb                           ; Header is .ATR Enhanced?
        je      @@10                            ; Yes,
                                                ; No, so
; Check file header double
        mov     [Disk_Image], 4

        mov     si, offset Disk_ATR_Double_Header
        push    ds si
        pop     di es

        pop     si ds cx
        push    cx ds si
        rep     cmpsb                           ; Header is .ATR Double?
        je      @@10                            ; Yes
                                                ; No, so
        pop     si ds cx
        mov     [Disk_Image], 0
        jmp     @@90

@@10:
        pop     si ds cx

;---------------------------------------------------------------
; From now on, the disk image can be treated as a XFD disk image
;---------------------------------------------------------------
@@20:
;----------------------------------------------
; Get field size of 8 bit VTOC files table item
;----------------------------------------------
        mov     si, offset Ws_XL_F_XL_File_1
        push    ds si
        pop     di es

        mov     ax, EIGHTBIT_VTOC_FILES_MAX
        xor     bx, bx
        xor     cx, cx
        mov     cl, [byte (Wsio_Field ptr di).Size]

        mov     si, offset Ws_XL_F_XL_Size_1
        push    ds si
        pop     di es

        add     cl, [byte (Wsio_Field ptr di).Size]

        mov     [Save_cx], cx
        xor     dx, dx
        mul     cx

;-----------------------------
; Clear 8 bit VTOC files Table
;-----------------------------
        mov     si, offset XDisk_File_Info_1
        push    ds si

        push    ds si
        pop     di es

        mov     cx, ax
        xor     ax, ax                          ; Reset ax
        mov     al, SPACE                       ; Fill character
        rep     stosb

;
; Assume bootdisk
;
        pop     di es
        mov     si, offset XDisk_Image_Is_Bootdisk
        mov     cx, FILE_NAME_LENGTH + 1
        rep     movsb

;
; Reset attributes - Filename
;
        mov     si, offset XDisk_Attrib_Info_1
        push    ds si
        pop     di es
        mov     cx, EIGHTBIT_VTOC_FILES_MAX
        mov     al, ATTRIB_CYAN_WHITE
        rep     stosb                           ; Initialize to Cyan White

;
; Reset attributes - Filesize
;
        mov     si, offset XDisk_Attrib_Size_1
        push    ds si
        pop     di es
        mov     cx, EIGHTBIT_VTOC_FILES_MAX
        mov     al, ATTRIB_CYAN_WHITE
        rep     stosb                           ; Initialize to Cyan White

;
; Move to 8bit vtoc location (offset B400h, 8 sectors wide) for Single, Medium and Enhanced
;
        xor     cx, cx                          ; Reset Offset cx:dx
        mov     dx, EIGHTBIT_VTOC_OFFSET

        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@21                            ; No
                                                ; Yes, so
;
; Move to 8bit vtoc location (offset 16680h, 8 sectors wide) for Double
;
        mov     cx, EIGHTBIT_VTOC_OFFSET_DOUBLE_CX
        mov     dx, EIGHTBIT_VTOC_OFFSET_DOUBLE_DX

@@21:
        mov     ah, DOS_MOVE_FILE_POINTER
        mov     al, DOS_MOVE_FILE_POINTER_CURR
        mov     bx, [Disk_Handler]
        int     DOS_SERVICE                     ; Position in dx:ax

;
; Read 8bit vtoc
;
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_VTOC_SIZE          ; Sector size
        mov     dx, offset Disk_VTOC_Buffer
        int     DOS_SERVICE                     ; Read VTOC
        jc      @@90                            ; Stop on error
        or      ax, ax                          ; End of file?
        jz      @@90                            ; Yes

; Move 8bit vtoc files to field area
        mov     cx, EIGHTBIT_VTOC_FILES_MAX     ; Maximum nr of 8bit vtoc files
        mov     si, offset XDisk_File_Info_1

        push    ds si
        pop     di es

        mov     [Sectors_To_Extract], NULL
        mov     si, offset Disk_VTOC_Buffer

        xor     ax, ax                          ; Reset ax
        mov     ah, [byte ds:si + 2]            ; Load File Size high byte
        cmp     ah, 05                          ; Filesize > 05FFh don't exist
        jnle    @@90                            ; We have a "boot disk"
                                                ; No, so regular vtoc
        mov     [XL_VTOC_File_Nr], 0            ; Reset number of entries

@@30:
        xor     ax, ax
        mov     al, [byte ds:si]                ; Get file status
        cmp     ax, 08Fh                        ; Entry present
        jnle    @@31                            ; No
                                                ; Maybe
        cmp     ax, 001h                        ; Entry present?
        jle     @@31                            ; No
                                                ; Maybe
        mov     al, [byte ds:si + 15]           ; Get last byte of filename
        cmp     ax, NULL                        ; Filename exist?
        jne     @@32                            ; Yes
                                                ; No
@@31:
        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@90                            ; No
                                                ; Yes, so
        add     si, EIGHTBIT_SECTOR_SIZE        ; Skip 1 sector of 128 bytes

        mov     al, [byte ds:si]                ; Get file status
        cmp     ax, 08Fh                        ; Entry present
        jnle    @@90                            ; No
                                                ; Maybe
        cmp     ax, 001h                        ; Entry present?
        jle     @@90                            ; No
                                                ; Maybe
        mov     al, [byte ds:si + 15]           ; Get last byte of filename
        cmp     ax, NULL                        ; Filename exist?
        je      @@90                            ; Yes
                                                ; Yes, so
@@32:
        inc     [XL_VTOC_File_Nr]

        mov     [XFile_Deleted], LOGIC_NO
        mov     [XFile_Locked], LOGIC_NO
        mov     [XFile_Extended], LOGIC_NO
        mov     [XFile_Inverse], LOGIC_NO

        push    ds si es di cx

; Check File Status
        xor     ax, ax                          ; Reset ax
        mov     al, [byte ds:si]                ; Load File Status
        and     al, 080h                        ; Check Delete Status
        cmp     al, 080h                        ; File Deleted?
        jne     @@61                            ; No
                                                ; Yes, so
        mov     [XFile_Deleted], LOGIC_YES

@@61:
        mov     al, [byte ds:si]                ; Load File Status
        and     al, 020h                        ; Check Lock Status
        cmp     al, 020h                        ; File Locked?
        jne     @@62                            ; No
                                                ; Yes, so
        mov     [XFile_Locked], LOGIC_YES

@@62:
        mov     al, [byte ds:si]                ; Load File Status
        and     al, 001h                        ; Check Extended Status
        cmp     al, 001h                        ; File Extended?
        jne     @@63                            ; No
                                                ; Yes, so
        mov     [XFile_Extended], LOGIC_YES

@@63:
        add     si, 1                           ; Begin of filesize
        mov     ah, [byte ds:si + 1]
        mov     al, [byte ds:si]

        cmp     ah, 05                          ; Filesize > 05FFh don't exist
        jnle    @@73                            ; We have a "comment" entry
                                                ; No, so regular file
        cmp     [XFile_Deleted], LOGIC_YES
        je      @@70                            ; Yes
                                                ; No, so
        sub     [XDisk_Sectors_Free], ax
        jmp     @@71

;
; Number of sectors to extract if we are ordered to extract the files
;
@@70:
        cmp     [Config_Field_Deleted_Extract], LOGIC_NO ; Extract deleted?
        je      @@72                            ; No
                                                ; Yes, so
@@71:
        add     [Sectors_To_Extract], ax

;
; XFile size
;
@@72:
        mov     si, offset Hex2digi_Requested_Format
        push    ds si                           ; Parameter 1

        mov     si, offset XFile_Size_Text
        mov     [byte ds:si], NULL
        mov     [byte ds:si + 1], NULL
        mov     [byte ds:si + 2], ah
        mov     [byte ds:si + 3], al

        push    ds si
        call    HEX2DIGI
        pop     ax ax ax ax

        mov     si, offset XFile_Size_Text
        cmp     [byte ds:si + 10], SPACE        ; File size present?
        jne     @@75                            ; Yes
                                                ; No, so
@@73:
        mov     [XFile_Inverse], LOGIC_YES      ; We have a "comment" entry

;
; Move xl file info to table
;
@@75:
        pop     cx di es si ds
        push    ds si es di cx

;
; Check Filename for special "comment" editing, and strip high bits if so
;
        push    ds si
        mov     cx, FILE_NAME_LENGTH - 1
        add     si, 5                           ; Begin of filename, i.e. MYFILE  TXT

@@76:
        mov     al, [byte ds:si]                ; load character
        and     al, 080h                        ; Check high bit
        cmp     al, NULL                        ; High bit set?
        je      @@77                            ; No
                                                ; Yes, so
        and     [byte ds:si], 07Fh              ; Reset high bit
        
@@77:
        inc     si
        loop    @@76

        pop     si ds

; Move XFilename
        add     si, 5                           ; Begin of filename, i.e. MYFILE  TXT
        mov     cx, 8                           ; Size of filename
        rep     movsb                           ; Move "MYFILE" part
        mov     [byte es:di], DOT               ; Insert a "."
        inc     di                              ; Move to extender part
        mov     cx, 3                           ; Size of extender
        rep     movsb                           ; Move "TXT" part

; Move XSize
        mov     si, offset XFile_Size_Text
        add     si, 7                           ; To skip 7 spaces
        mov     cx, 4
        rep     movsb                           ; Move "  43" File Size part

;---------------------------------------------
; Check if we have to change screen attributes
;--------------------------------------------
@@80:
        mov     ah, ATTRIB_RED_WHITE            ; Assume deleted file
        cmp     [XFile_Deleted], LOGIC_YES
        je      @@85                            ; Yes
                                                ; No, so
        mov     ah, ATTRIB_GREEN_WHITE          ; Assume locked file
        cmp     [XFile_Locked], LOGIC_YES
        je      @@85                            ; Yes
                                                ; No, so
        mov     ah, ATTRIB_MAGENTA_WHITE        ; Assume Comment
        cmp     [XFile_Inverse], LOGIC_YES
        je      @@85                            ; Yes
                                                ; No, so
        mov     ah, ATTRIB_CYAN_WHITE           ; Assume default

@@85:
;
; Move attribute to tables (filename + filesize)
;
        mov     si, offset XDisk_Attrib_Info_1
        xor     bx, bx
        mov     bl, [XL_VTOC_File_Nr]
        dec     bx
        add     si, bx
        mov     [byte ds:si], ah

        mov     si, offset XDisk_Attrib_Size_1
        add     si, bx
        mov     [byte ds:si], ah

;
; If file extended, mark it accordingly
;
        cmp     [XFile_Extended], LOGIC_YES
        jne     @@88                            ; No
                                                ; Yes, so
        mov     ah, ATTRIB_RED_BLUE             ; Assume deleted file
        cmp     [XFile_Deleted], LOGIC_YES
        je      @@87                            ; Yes
                                                ; No, so
        mov     ah, ATTRIB_GREEN_BLUE           ; Assume locked file
        cmp     [XFile_Locked], LOGIC_YES
        je      @@87                            ; Yes
                                                ; No, so
        mov     ah, ATTRIB_CYAN_BLUE            ; Assume default

@@87:
; Move attribute to table (filesize only)
        mov     si, offset XDisk_Attrib_Size_1
        mov     bx, EIGHTBIT_VTOC_FILES_MAX
        sub     bx, cx
        add     si, bx
        mov     [byte ds:si], ah

@@88:
        pop     cx di es si ds

        add     di, [Save_cx]                   ; Move to next file entry
        add     si, EIGHTBIT_FILE_ENTRY_SIZE    ; Move to next xl vtoc entry
        loop    @@30

;-----------------
; Close Disk image
;-----------------
@@90:
        mov     bx, [Disk_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

;--------------------------------------
; Show number of free sectors remaining
;--------------------------------------
@@95:
        mov     si, offset Hex2digi_Requested_Format
        push    ds si                           ; Parameter 1

        mov     ax, [XDisk_Sectors_Free]

        mov     si, offset XFile_Size_Text
        mov     [byte ds:si], NULL
        mov     [byte ds:si + 1], NULL
        mov     [byte ds:si + 2], ah
        mov     [byte ds:si + 3], al

        push    ds si
        call    HEX2DIGI
        pop     ax ax ax ax

; Move Free sectors
        mov     si, offset Xdisk_Free_Sectors
        push    ds si
        pop     di es
        mov     si, offset XFile_Size_Text
        add     si, 7                           ; To skip 7 spaces
        mov     cx, 4
        rep     movsb                           ; Move "  43" File Size part

@@99:
        ret

ENDP    Retrieve_Disk_Image_VTOC



;**********************************************************************
PROC    Extract_Disk_Image_Files
;**********************************************************************
;---------------------------------
; Reset progress bar to Cyan White
;---------------------------------
        mov     si, offset XDisk_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0B0h
        xor     cx, cx
        mov     cl, [XDisk_Progress_Cnt_Max]
        rep     stosb

        mov     [XDisk_Progress_Cnt_Prev], 0
        mov     [Sectors_Extracted], 0

;--------------------
; Open extract window
;--------------------
        mov     si, offset Ws_XF
        mov     [byte ds:si], WSIO_OPEN
        push    ds si
        call    WSIO
        pop     si ds

;----------------------------------------
; Show that we are going to extract stuff
;----------------------------------------
        mov     si, offset Ws_XF
        mov     [byte ds:si], WSIO_DISPLAY_ONLY
        push    ds si
        call    WSIO
        pop     si ds

;---------------------
; Open disk image file
;---------------------
        mov     dx, offset Disk_Image_File_Path
        mov     ah, DOS_OPEN_FILE
        mov     al, DOS_FILE_READ_ONLY
        int     DOS_SERVICE
        jc      @@99                            ; Open ERROR!

        mov     [Disk_Handler], ax              ; Load handle

;------------------
; Process 8bit VTOC
;------------------
        mov     cx, EIGHTBIT_VTOC_FILES_MAX     ; Maximum nr of 8bit vtoc files
        mov     si, offset Disk_VTOC_Buffer

@@10:
        push    ds si cx

        mov     [XFile_Deleted], LOGIC_NO

        cmp     [byte ds:si + 15], NULL         ; Entry present?
        jne     @@15                            ; Yes
                                                ; No
        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@80                            ; No
                                                ; Yes, so
        pop     cx si ds
        add     si, EIGHTBIT_SECTOR_SIZE        ; Skip 1 sector of 128 bytes
        push    ds si cx
        
        cmp     [byte ds:si + 15], NULL         ; Entry present?
        je      @@80                            ; No
                                                ; Yes, so
@@15:
;
; Check for File or Comment
;
        xor     ax, ax                          ; Reset ax
        mov     al, [byte ds:si]                ; Load File Status
        and     al, 083h                        ; Check File Status
        cmp     al, 000h                        ; Comment?
        je      @@80                            ; Yes
                                                ; No , so
;
; Check File Status
;
        xor     ax, ax                          ; Reset ax
        mov     al, [byte ds:si]                ; Load File Status
        and     al, 080h                        ; Check Delete Status
        cmp     al, 080h                        ; File Deleted?
        jne     @@20                            ; No
                                                ; Yes , so
        mov     [XFile_Deleted], LOGIC_YES
        cmp     [Config_Field_Deleted_Extract], LOGIC_NO ; Extract deleted?
        je      @@80                            ; No
                                                ; Yes, so
;--------------------
; Set up pc file path
;--------------------
@@20:
;
; Set Up Path - Volume and Directories
;
        push    ds si                           ; Save pointer into VTOC

        mov     si, offset Extraction_File_Path
        push    ds si                           ; Save file path

        push    ds si
        pop     di es

        mov     si, offset Config_Field_Extract_To_Path

        cmp     [XFile_Deleted], LOGIC_YES      ; File Deleted?
        jne     @@25                            ; No
                                                ; Yes, so
        mov     si, offset Config_Field_Deleted_Path

@@25:
        mov     cx, PATH_LENGTH
        rep     movsb

;
; Search for last "\"
;
        pop     di es                           ; Restore file path

        mov     cx, PATH_LENGTH                 ; Search length
        add     di, cx                          ; Go to end of Path
        std                                     ; Search direction is down
        or      ax, ax                          ; Reset ax
        mov     al, BACKSLASH                   ; Search for the "\" character
        repne   scasb                           ; Search equal "\" uses es:di
        cld                                     ; Cancel the std setting
        inc     di                              ; Pointer adjustment after search
        inc     di                              ; Move next to the "\"

        pop     si ds                           ; Restore pointer into VTOC

;
; Set Up Path - Append 8 bit Filename
;
        push    ds si                           ; Save pointer into VTOC again

        mov     cl, [byte ds:si + 3]            ; Low portion of Start Sector
        mov     ch, [byte ds:si + 4]            ; High portion of Start Sector
        mov     [XDisk_Next_Sector], cx
        add     si, 5                           ; Begin of filename, i.e. MYFILE  TXT
        mov     cx, 8                           ; Size of filename
        rep     movsb                           ; Move "MYFILE" part
        mov     [byte es:di], DOT               ; Insert a "."
        inc     di                              ; Move to extender part
        mov     cx, 3                           ; Size of extender
        rep     movsb                           ; Move "TXT" part

;------------------------------
; Set up file we are extracting
;------------------------------
        mov     si, offset XDisk_Extract_File
        push    ds si
        pop     di es

        pop     si ds                           ; Restore pointer into VTOC again

        mov     ah, [byte ds:si + 2]            ; Nr of sectors according to VTOC
        mov     al, [byte ds:si + 1]
        mov     [Sectors_For_This_File], ax

        add     si, 5                           ; Begin of filename, i.e. MYFILE  TXT
        mov     cx, 8                           ; Size of filename
        rep     movsb                           ; Move "MYFILE" part
        mov     [byte es:di], DOT               ; Insert a "."
        inc     di                              ; Move to extender part
        mov     cx, 3                           ; Size of extender
        rep     movsb                           ; Move "TXT" part

;----------------------------------
; Show which file we are extracting
;----------------------------------
        mov     si, offset Ws_XF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY
        push    ds si
        call    WSIO
        pop     si ds

;----------------------------
; Create 8 bit file on the pc
;----------------------------
        mov     dx, offset Extraction_File_Path
        xor     cx, cx                          ; Normal attributes
        mov     ah, DOS_CREATE_FILE
        int     DOS_SERVICE
        jc      @@80                            ; Skip processing on error
        mov     [File_Handler], ax              ; Store handle

;----------------------------------------
; Position to "Next" Sector in File Chain
;----------------------------------------
@@40:
        xor     ax, ax                          ; Reset ax
        xor     bx, bx                          ; Reset bx
        xor     dx, dx                          ; Reset dx
        mov     ax, [XDisk_Next_Sector]
        cmp     ax, NULL                        ; More sectors to read?
        je      @@70                            ; No
                                                ; Yes, so
        sub     ax, 4                           ; Skip bootsectors and
                                                ; position before wanted sector
        mov     cx, EIGHTBIT_SECTOR_SIZE
        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@41                            ; No
                                                ; Yes, so
        mov     cx, EIGHTBIT_SECTOR_SIZE_DOUBLE

@@41:
        mul     cx

        mov     cx, dx
        mov     dx, ax
        mov     ah, DOS_MOVE_FILE_POINTER
        mov     al, DOS_MOVE_FILE_POINTER_BEGIN
        mov     bx, [Disk_Handler]

        clc                                     ; Clear carry
        add     dx, EIGHTBIT_BOOT_SECTOR_SIZE
        adc     cx, 0                           ; If overflow increment
                                                ; high sector
        cmp     [Disk_Image_ATR], LOGIC_YES     ; ATR Disk Image?
        jne     @@50                            ; No
                                                ; Yes, so
        add     dx, ATR_HEADER_SIZE

;---------------------------
; Process xl disk image file
;---------------------------
@@50:
        int     DOS_SERVICE                     ; Position in dx:ax
        jc      @@70                            ; Skip Entry on error
        or      ax, ax                          ; End of file?
        jz      @@70                            ; Yes
                                                ; No, so
        xor     ax, ax
        mov     ah, DOS_READ_FROM_HANDLE
        mov     bx, [Disk_Handler]
        mov     cx, EIGHTBIT_SECTOR_SIZE

        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@51                            ; No
                                                ; Yes, so
        mov     cx, EIGHTBIT_SECTOR_SIZE_DOUBLE

@@51:
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Read 1 sector
        jc      @@70                            ; Skip Entry on error
        or      ax, ax                          ; End of input file?
        jz      @@70                            ; Yes
                                                ; No, so
        dec     [Sectors_For_This_File]

;---------------------------------------------
; Determine Next Sector from sector link chain
;---------------------------------------------
        mov     si, offset Disk_I_O_Buffer
        mov     ch, [byte ds:si + 125]          ; Low portion of Start Sector
        mov     cl, [byte ds:si + 126]          ; High portion of Start Sector

        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@52                            ; No
                                                ; Yes, so
        mov     ch, [byte ds:si + 253]          ; Low portion of Start Sector
        mov     cl, [byte ds:si + 254]          ; High portion of Start Sector

@@52:
        and     cx, 003FFh                      ; Reset 6 left bits
        mov     [XDisk_Next_Sector], cx

;-------------------------------------------------------------
; Write sector (without sector link chain info) to the pc file
;-------------------------------------------------------------
        xor     ax, ax
        mov     ah, DOS_WRITE_TO_HANDLE
        mov     bx, [File_Handler]
        xor     cx, cx                          ; Reset cx
        mov     cl, [byte ds:si + 127]          ; Byte Count

        cmp     [Disk_Image], 4                 ; Double density disk?
        jne     @@53                            ; No
                                                ; Yes, so
        mov     cl, [byte ds:si + 255]          ; Byte Count

@@53:
        mov     dx, offset Disk_I_O_Buffer
        int     DOS_SERVICE                     ; Write cx characters
        jc      @@70                            ; Close files on error
        or      ax, ax                          ; Disk full?
        jz      @@70                            ; Yes
                                                ; No, so
        inc     [Sectors_Extracted]             ; Another sector accounted for

;------------------------------------------------------
; Calculate progress bar size, and show it if necessary
;------------------------------------------------------
        mov     ax, [Sectors_Extracted]
        xor     bx, bx
        xor     cx, cx
        mov     cl, [XDisk_Progress_Cnt_Max]
        xor     dx, dx
        mul     cx

        xor     cx, cx
        mov     bx, [Sectors_To_Extract]
        div     bx

        cmp     al, [XDisk_Progress_Cnt_Prev]
        je      @@40

;---------------------------------
; Update progress bar, and show it
;---------------------------------
        mov     [Xdisk_Progress_Cnt_Prev], al
        mov     cx, ax

        mov     si, offset XDisk_Progress_Bar
        push    ds si
        pop     di es
        xor     ax, ax
        mov     al, 0DBh
        rep     stosb

        mov     si, offset Ws_XF
        mov     [byte ds:si], WSIO_DISPLAY_FIELDS_ONLY
        push    ds si
        call    WSIO
        pop     si ds

        jmp     @@40

;--------------
; Close pc file
;--------------
@@70:
        mov     cx, [Sectors_For_This_File]     ; In case a deleted file was extracted
        add     [Sectors_Extracted], cx         ; and not all sectors were acoounted for

        mov     bx, [File_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

;-------------------------------
; Select next xl file vtoc entry
;-------------------------------
@@80:
        pop     cx si ds

        add     si, EIGHTBIT_FILE_ENTRY_SIZE    ; Move to next vtoc entry
        loop    @@10                            ; Complete VTOC scanned?

;----------------------------
; Close Atari disk image file
;----------------------------
@@90:
        mov     bx, [Disk_Handler]
        mov     ah, DOS_CLOSE_FILE
        int     DOS_SERVICE

;----------------------------------
; Close progress bar message screen
;----------------------------------
@@99:
        mov     si, offset Ws_XF
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Extract_Disk_Image_Files



;**********************************************************************
PROC    Close_Ws_BG
;**********************************************************************
        mov     si, offset Ws_BG
        mov     [byte ds:si], WSIO_CLOSE
        push    ds si
        call    WSIO
        pop     si ds

        ret

ENDP    Close_Ws_BG



;**********************************************************************
PROC    Exit_Program
;**********************************************************************
        mov     ah, DOS_TERMINATE_EXE
        mov     al, [Return_Code]           ; Return code value
        int     DOS_SERVICE

ENDP    Exit_Program



ENDS    CSeg                                ; End of Code segment

END     Main
