/*==========================================================================
 * Project: atari cross assembler
 * File: symbol.h
 *
 * Contains typedefs and prototypes for the assembler
 *==========================================================================*/
#define MAJOR_VER 0
#define MINOR_VER 90

typedef struct symbol {  /* Symbol table entry */
  char *name;
  /* tp:
     0: opcode
     1: directive
     2: user label
     3: user transitory equate 
     4: macro
     5: macro label/equate
     6: equate
     7: macro transitory label
   */     
  short tp;
  unsigned short addr;
  unsigned short ref;
  unsigned short num, sz, *invoked;
  struct symbol *nxt;
  struct symbol *lnk, *mlnk;
} symbol;

/* Some defines for symbol types -- see above comment */
#define OPCODE 0
#define DIRECT 1
#define LABEL  2
#define TEQUATE 3
#define MACRON 4
#define MACROL 5
#define EQUATE 6
#define MACROQ 7
/*==========================================================================*/
typedef struct file_stack { /* File process entry */
  char *name;
  FILE *in;
  int line;
  struct file_stack *nxt;
} file_stack;
/*==========================================================================*/
typedef struct macro_line { /* an entry in a macro */
  char *line;
  struct macro_line *nxt;
} macro_line;
/*==========================================================================*/
typedef struct macro {  /* a macro */
  char *name;           /* name */
  int tp,param, num;       /* number of parameters, # lines */
  short times;          /* number of invokations */
  macro_line *lines;    /* The actual text */
  symbol *mlabels;      /* assembled labels */
  struct macro *nxt;
} macro;
/*==========================================================================*/
typedef struct macro_call {
  int argc;             /* number of arguments passed to macro */
  macro *orig;          /* pointer to original macro */
  macro_line *cmd;      /* parameters */
  macro_line *line;     /* pointer to next macro line */
  struct macro_call *nxt;
} macro_call;

/*==========================================================================*
 * some symbols
 *==========================================================================*/
extern unsigned short pc;   /* program counter */
extern int pass; /* pass number */
extern int eq, verbose;  /* assignment flag, verbosity flag */
extern int local,warn,bsize;

extern file_stack *fin;
extern macro *macro_list;
extern macro_call *invoked;

extern unsigned char *memmap, *bitmap;  /* memory snapshot, and bitmap */
extern char *outline;  /* the line of text written out in verbose mode */

#define HSIZE 128
extern symbol *hash[HSIZE];

/*==========================================================================*
 * some prototypes 
 *==========================================================================*/
int error(char *err, int tp);
char *get_nxt_word(int tp);
int squeeze_str(char *str);
int num_cvt(char *num);

short get_expression(char *str, int tp);
int get_name(char *src, char *dst);

symbol *findsym(char *name);
int addsym(symbol *wrd);
symbol *get_sym();
int dump_symbols();
macro_call *get_macro_call(char *name);
int macro_subst(char *name, char *in, macro_line *cmd, int max);
int create_macro(symbol *sym);
int macro_param(macro_call *mc, char *cmd);
int skip_macro();
int clear_ref();
int do_rept(symbol *sym);
int del_rept(macro_call *kill);

int save_state(char *fin, char *fout);
