#include <stdio.h>
#include "assm.d1"
#include "assm.d2"


newlc_obj(newlc,wrapup)   /* location counter has changed, update binary file */
unsigned int newlc;
int wrapup;   /* non-zero means this is last block */
{
   static long endlc_offset= -1; /* offset for ending adr of prev. block */
   static unsigned int oldlc=0;
   long cur_offset;
   unsigned int blockend;


   if ( (pass == LAST_PASS) && (aflag != 0) ) {

      /* write new loc ptr at current file position (lo,hi byte)*/
      fputc( (newlc & 0xff),aptr);
      fputc( (newlc >> 8),aptr);
      cur_offset = ftell(aptr);

      /* write ending address for previous block */
      if (endlc_offset != -1) {
         fseek(aptr,endlc_offset,SEEK_SET);
         blockend = (cur_offset-endlc_offset-5) + oldlc;
         fputc( (blockend & 0xff) ,aptr);
         fputc( (blockend >> 8) ,aptr);
      }

      endlc_offset = cur_offset;
      fseek(aptr,cur_offset+2,SEEK_SET);  /* leave space for end addr */
      oldlc = newlc;
   }

   if (wrapup) {
      /* write ending address for final block */
      if (endlc_offset != -1) {
         cur_offset = ftell(aptr);
         fseek(aptr,endlc_offset,SEEK_SET);
         blockend = (cur_offset-endlc_offset-3) + oldlc;
         fputc( (blockend & 0xff) ,aptr);
         fputc( (blockend >> 8) ,aptr);
      }
   }

   
   return 0;
}


out_obj(val,outflg)
   int  val;
   int  outflg;         /* flag to output object bytes */
{
   if ((pass == LAST_PASS) && (aflag != 0) && (outflg != 0))
      fputc(val,aptr);
}
