;
; System equates
;
; OS EQUATES
; ----------
; 
; Syntax:
; Use '=' for addresses
; and '#' for values
; 
; IO EQUATES
; 
ICHID    = $0000
ICDNO    = $0001
ICCOM    = $0002
ICSTA    = $0003
ICBAL    = $0004
ICBAH    = $0005
ICPTL    = $0006
ICPTH    = $0007
ICBLL    = $0008
ICBLH    = $0009
ICAX1    = $000A
ICAX2    = $000B
ICAX3    = $000C
ICAX4    = $000D
ICAX5    = $000E
ICAX6    = $000F
; 
; OS VARIABLES FOR XL/XE
; 
; PAGE 0
; 
DOSVEC   = $000A
DOSINI   = $000C
STATUS   = $0030
CHKSUM   = $0031
BUFRLO   = $0032
BUFRHI   = $0033
BFENLO   = $0034
BFENHI   = $0035
LTEMP    = $0036
BUFRFL   = $0038
RECVDN   = $0039
XMTDON   = $003A
CHKSNT   = $003B
NOCKSM   = $003C
BPTR     = $003D
FTYPE    = $003E
FEOF     = $003F
;
; PAGE 2
;
MEMLO    = $02E7
DVSTAT   = $02EA
; 
; PAGE 3
; 
DDEVIC   = $0300
DUNIT    = $0301
DCOMND   = $0302
DSTATS   = $0303
DBUFLO   = $0304
DBUFHI   = $0305
DTIMLO   = $0306
DUNUSE   = $0307
DBYTLO   = $0308
DBYTHI   = $0309
DAUX1    = $030A
DAUX2    = $030B
TIMER1   = $030C
ADDCOR   = $030E
CASFLG   = $030F
; 
; HARDWARE REGISTERS
; 
; ANTIC
;
NMIEN    = $D40E
;
; PIA
; 
PORTA    = $D300
PORTB    = $D301
PACTL    = $D302
PBCTL    = $D303
; 
; Code equates
;
SECBUF   = $0400
L06F0    = $06F0
L06F1    = $06F1
L06F2    = $06F2
L06F3    = $06F3
L06F4    = $06F4
L06F5    = $06F5
;
; Start of code
;
         *= $4000
;
JMPVEC   JSR $FFFF
SETMEMLO LDA # <INIT
         STA MEMLO
         LDA # >INIT
         STA MEMLO+1
         RTS
NOTRDSK  JMP $FFFF
CHKDRV   LDA DDEVIC
         CMP #$31
         BNE NOTRDSK
         LDA DUNIT
         CMP DRVID
         BNE NOTRDSK
         LDA DCOMND
         CMP #$52
         BEQ READ
         CMP #$57
         BEQ WRITE
         CMP #$50
         BEQ WRITE
         CMP #$53
         BEQ STAT
         CMP #$3F
         BEQ GETCFG
         LDY #$92
         STY DSTATS
         RTS
GETCFG   LDA #$01
         TAY
         STY DSTATS
         RTS
STAT     LDA #$01
         STA DVSTAT
         LDA #$FF
         STA DVSTAT+1
         LDA #$00
         STA DVSTAT+2
         LDA MAXBANK
         STA DVSTAT+3
         LDY #$01
         STY DSTATS
         RTS
READ     SEI
         LDA #$00
         STA NMIEN
         JSR SETUP
         LDY #$7F
RDL1     LDA (BUFRLO),Y
         STA SECBUF,Y
         DEY
         BPL RDL1
         LDA PRTBSAV
         STA PORTB
         LDA DBUFLO
         STA BFENLO
         LDA DBUFHI
         STA BFENHI
         LDY #$7F
RDL2     LDA SECBUF,Y
         STA (BFENLO),Y
         DEY
         BPL RDL2
         LDA #$E0
         STA NMIEN
         CLI
         LDY #$01
         STY DSTATS
         RTS
WRITE    SEI
         LDA #$00
         STA NMIEN
         LDA DBUFLO
         STA BFENLO
         LDA DBUFHI
         STA BFENHI
         LDY #$7F
WRITEL1  LDA (BFENLO),Y
         STA SECBUF,Y
         DEY
         BPL WRITEL1
         JSR SETUP
         LDY #$7F
WRITEL2  LDA SECBUF,Y
         STA (BUFRLO),Y
         DEY
         BPL WRITEL2
         LDA PRTBSAV
         STA PORTB
         LDA #$E0
         STA NMIEN
         CLI
         LDY #$01
         STY DSTATS
         RTS
SETUP    SEC
         LDA DAUX1
         SBC #$01
         STA STATUS
         LDA DAUX2
         SBC #$00
         STA CHKSUM
         LDA #$00
         STA BUFRLO
         STA BUFRHI
         LDX #$07
SETUPL1  LSR CHKSUM
         ROR STATUS
         ROR BUFRLO
         DEX
         BNE SETUPL1
         LDX #$06
SETUPL2  ASL BUFRLO
         ROL BUFRHI
         DEX
         BNE SETUPL2
         LDA BUFRHI
         ORA #$40
         STA BUFRHI
         LDA PORTB
         STA PRTBSAV
         LDA STATUS
         CMP MAXBANK
         BPL ERR
         TAY
         LDA BANKTBL,Y
         AND #$FE
         STA PORTB
         RTS
ERR      PLA
         PLA
         LDY #$8A
         STY DSTATS
         RTS
PRTBSAV  .BYTE $00
DRVID    .BYTE $00
MAXBANK  .BYTE $00
BANKTBL  .DC 128 0
INIT     LDA #$60
         STA INIT
         LDA DOSINI
         STA JMPVEC+1
         LDA DOSINI+1
         STA JMPVEC+2
         LDA #$00
         STA DOSINI
         LDA #$40
         STA DOSINI+1
         LDA #<DRVID
         STA L06F0
         LDA #>DRVID
         STA L06F1
         LDA #<MAXBANK
         STA L06F2
         LDA #>MAXBANK
         STA L06F3
         LDA #<BANKTBL
         STA L06F4
         LDA #>BANKTBL
         STA L06F5
         SEC
         LDA DOSVEC
         SBC #$0A
         STA PUT1+1
         STA PUT2+1
         STA PUT3+1
         STA PUT4+1
         LDA DOSVEC+1
         SBC #$00
         STA PUT1+2
         STA PUT2+2
         STA PUT3+2
         STA PUT4+2
         LDX #$00
PUT1     LDA $FFFF,X
         STA NOTRDSK+1
         LDA #<CHKDRV
PUT3     STA $FFFF,X
         INX
PUT2     LDA $FFFF,X
         STA NOTRDSK+2
         LDA #>CHKDRV
PUT4     STA $FFFF,X
         JMP SETMEMLO