; $Id: action.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; Action Code and List processing Routines

; >>>>>>> DOSSTR <<<<<<<
; n -- addr
; ( creates DOS Filename )
.IF FORTH

NFA_DOSSTR .CBYTE $86, "DOSSTR"
LFA_DOSSTR .WORD NFA_PREV  ; UPLINK
CFA_DOSSTR .WORD PFA_DOSSTR
NFA_PREV .= NFA_DOSSTR
PFA_DOSSTR

    JSR DOSSTR
    JMP NEXT

.ENDIF

DOSSTR
    JSR DOSSTR0
    LDA P_DSTR
    STA 0,X
    LDA P_DSTR+1
    STA 1,X
    RTS

DOSSTR0
    JSR CALCLINE0
    JSR ADDONE

    LDA P_DSTR
    STA N
    LDA P_DSTR+1
    STA N+1

    LDY ACTFR
    LDA DNU,Y
    LDY #$0
    STY N+3             ; charcount
    INY
    JSR PUTCHAR1
    INY 
     
DOSSTR1
    JSR ADDONE
    INC N+3
    LDA N+3
    CMP #9
    BNE DOSSTR2
    LDA #'.             ; dot
    JSR PUTCHAR1
DOSSTR2
    LDA N+3
    CMP #12             ; ende?
    BEQ DOSSTR4

    LDA (0,X)
    CMP #$20            ; leerzeichen ?
    BEQ DOSSTR1
    JSR PUTCHAR         ; nein = Zeichen setzen
    JMP DOSSTR1

DOSSTR4
    LDA #155            ; lineend
    BNE PUTCHAR1

PUTCHAR
    LDA (0,X)
    AND #$7F
PUTCHAR1
    STA (N),Y
    INY

DOSSTR3
    RTS


; >>>>>>> MARKENTRY <<<<<<<
; n --
.IF FORTH
NFA_MARKENTRY .CBYTE $89, "MARKENTRY"
LFA_MARKENTRY .WORD NFA_PREV  ; UPLINK
CFA_MARKENTRY .WORD PFA_MARKENTRY
NFA_PREV .= NFA_MARKENTRY
PFA_MARKENTRY
    JSR MARKENTRY
    JMP POP
.ENDIF

MARKENTRY
    JSR GETMARK
    ORA CURC
    STA (0,X)
    RTS

DELETEENTRY
    JSR GETMARK
    AND #bl
    STA (0,X)
    RTS

TOGGLEENTRY
    JSR GETMARK
    EOR CURC
    STA (0,X)
    RTS

GETMARK
    JSR CALCLINE0
    JSR ADDONE
    LDA (0,X)
    RTS

GETLOCK
    JSR CALCLINE0
    LDA (0,X)
    RTS

; >>>>>>> COUNTMARK <<<<<<<
; -- n
; ( count all marked direntries )
.IF FORTH
NFA_COUNTMARK .CBYTE $89, "COUNTMARK"
LFA_COUNTMARK .WORD NFA_GETKEY  ; LINK TO "GETKEY"
CFA_COUNTMARK .WORD PFA_COUNTMARK
PFA_COUNTMARK
    DEX
    DEX
    JSR COUNTMARK
    JMP NEXT
.ENDIF

merk        .BYTE 0
COUNTMARK
    LDA #0
    STA CABSA

    LDY NUMDA
COUNTMARK1
    STY 0,X
    TYA
    STA merk

    JSR GETMARK
    CMP #$20     ; Mark = Blank?
    BEQ COUNTMARK2
    INC CABSA
COUNTMARK2
    LDA merk            ; weg faktorieren WORK!!!!
    TAY
    DEY
    BPL COUNTMARK1
    LDA CABSA
    STA 0,X
    LDA #0
    STA 1,X
    JSR CALCCABS 
    RTS     
    
; >>>>>>> GETACTIONCODE <<<<<<<
; keycode -- n
.IF FORTH
NFA_GETAC .CBYTE $85, "GETAC"
LFA_GETAC .WORD NFA_PREV  ; UPLINK
CFA_GETAC .WORD PFA_GETAC
NFA_PREV .= NFA_GETAC
PFA_GETAC
    JSR GETAC
    JMP NEXT
.ENDIF
GETAC
    LDY 0,X
    LDA ACTAB-1,Y
    STA 0,X
    RTS

; >>>>>>> ACTION <<<<<<<
; n -- rc
.IF FORTH
NFA_ACTION .CBYTE $86, "ACTION"
LFA_ACTION .WORD NFA_PREV  ; UPLINK
CFA_ACTION .WORD PFA_ACTION
NFA_PREV .= NFA_ACTION
PFA_ACTION
    JSR ACTION
    JMP NEXT
.ENDIF

ACTION
    STX XSAVE
    JSR CALCCABS
    JSR SETACTFR

    LDA 0,X
    CMP #10         ; Quit ?
    BNE L1200

.IF FORTH
    LDY #0
    LDA #<CFA_QUIT  ; QUIT LOBYTE
    STA 0,X
    LDA #>CFA_QUIT  ; QUIT HIBYTE
    STA 1,X
    JMP PFA_EXECUTE        ; EXECUTE
    JMP NEXT
.ELSE
    JMP (DOSVEC)
.ENDIF
    

L1200
    CMP #61         ; Cursor down
    BNE L1220

    LDA #1
    JSR CRSDOWN
    JMP L1299
    
L1220
    CMP #60         ; Cursor up
    BNE L1221

    LDA #1
    JSR CRSUP
    JMP L1299

L1221
    CMP #62
    BNE L1223       ; Cursor 5 up
    JSR CRSHIDE
    LDA #5
    JSR CRSUP
    JMP L1299
    
L1223
    CMP #63
    BNE L1230       ; Cursor 5 down ?
    JSR CRSHIDE
    LDA #5
    JSR CRSDOWN
    JMP L1299

L1230
    LDA 0,X
    CMP #64             ; TAB - change Panel
    BNE L1240

    JSR TOGGLEACT
    JSR SETACTFR
    JSR CALCCABS

    JSR L_UPDLEFT
    JSR L_UPDRIGHT
    JMP L1299

L1240
    LDA 0,X
    CMP #30             ; sort filename
    BNE L1250

    LDA #8
    STA FLENKEY         ; 1st key = filename
    LDA #3
    STA FLENSEC         ; 2nd key = extender
    LDA #2
    STA OFFSETKEY
    LDA #10
    STA OFFSETSEC

    JSR SORTACT
    JMP L1299           ; and exit

L1250
    LDA 0,X
    CMP #31             ; sort externder
    BNE L1252

    LDA #3
    STA FLENKEY         ; 1st key = externder
    LDA #8
    STA FLENSEC         ; 2nd key = filename
    LDA #10
    STA OFFSETKEY
    LDA #2
    STA OFFSETSEC

    JSR SORTACT
    JMP L1299           ; end exit

L1252
    LDA 0,X
    CMP #32             ; sort size
    BNE L1270

    
    LDA #3
    STA FLENKEY         ; 1st key = size
    LDA #11
    STA FLENSEC         ; 2nd key = filename
    LDA #14
    STA OFFSETKEY
    LDA #2
    STA OFFSETSEC

    JSR SORTACT
    JMP L1299           ; end exit
    
L1270
    LDA 0,X
    CMP #11             ; left panel new dir
    BNE L1271

    LDA #5
    STA COLCRS
    JSR GETDRIVE
    BEQ L1270a          ; valid drive ?
    STA DNU0
    JSR L_READLEFT
L1270a
    JSR REFFRM
    JSR CLRFRMLEFT
    JSR L_UPDLEFT
    JMP L1299

L1271
    LDA 0,X
    CMP #12             ; right panel new dir
    BNE L1273

    LDA #25
    STA COLCRS
    JSR GETDRIVE
    BEQ L1271a          ; valid drive ?
    STA DNU1
    JSR L_READRIGHT
L1271a
    JSR CLRFRMRIGHT
    JSR REFFRM
    JSR L_UPDRIGHT
    JMP L1299

L1273                   
    LDA 0,X
    CMP #13
    BNE L1275

    JSR L_READACT
    JSR CLRFRMACT
    JSR L_UPDACT
    JMP L1299

L1275
    LDA 0,X
    CMP #20             ; mark entry
    BNE L1276
    
    LDA CABSA
    STA 0,X
    JSR TOGGLEENTRY
    LDA #1
    JSR CRSDOWN
    JSR L_UPDCRS
    JMP L1299

L1276
    LDA 0,X
    CMP #21             ; mark all entries
    BNE L1278
    
    LDY NUMDA

L1277
    STY 0,X
    TYA
    PHA
    JSR MARKENTRY
    PLA
    TAY
    DEY
    BNE L1277

    STY 0,X
    JSR MARKENTRY
    JSR L_UPDACT
    JMP L1299

L1278
    LDA 0,X
    CMP #22             ; unmark all entries
    BNE L1280
    
    LDY NUMDA

L1279
    STY 0,X
    TYA
    PHA
    JSR DELETEENTRY
    PLA
    TAY
    DEY
    BNE L1279

    STY 0,X
    JSR DELETEENTRY
    JSR L_UPDACT
    JMP L1299

L1280
    LDA 0,X
    CMP #23             ; toggle all entries
    BNE L1282
    
    LDY NUMDA

L1281
    STY 0,X
    TYA
    PHA
    JSR TOGGLEENTRY
    PLA
    TAY
    DEY
    BNE L1281

    STY 0,X
    JSR TOGGLEENTRY
    JSR L_UPDACT
    JMP L1299

L1282
    LDA 0,X
    CMP #15         ; lock / unlock
    BNE L1285

    LDA P_LOC0
    STA P_PROC
    LDA P_LOC0+1
    STA P_PROC+1

    LDA LOCVEC
    STA AJMVEC
    LDA LOCVEC+1
    STA AJMVEC+1
    JSR PROCESS
    JMP L1299

L1285
    LDA 0,X
    CMP #8          ; delete
    BNE L1286

    LDA P_DEL0
    STA P_PROC
    LDA P_DEL0+1
    STA P_PROC+1

    LDA DELVEC
    STA AJMVEC
    LDA DELVEC+1
    STA AJMVEC+1
    JSR PROCESS
    JMP L1299

L1286
    LDA 0,X
    CMP #17         ; start COM Programm
    BNE L1287

    LDA P_LOA0
    STA P_PROC
    LDA P_LOA0+1
    STA P_PROC+1

    LDA RUNVEC
    STA AJMVEC
    LDA RUNVEC+1
    STA AJMVEC+1
    JSR PROCESS
    JMP L1299

L1287
    LDA 0,X
    CMP #5          ; copy file
    BNE L1288
    LDA P_COP0
    STA P_PROC
    LDA P_LOC0+1
    STA P_PROC+1

    LDA COPVEC
    STA AJMVEC
    LDA COPVEC+1
    STA AJMVEC+1
    JSR PROCESS

    JMP L1299

L1288
    LDA 0,X
    CMP #6          ; move file
    BNE L1289
    LDA P_MOV0
    STA P_PROC
    LDA P_MOV0+1
    STA P_PROC+1

    LDA MOVVEC
    STA AJMVEC
    LDA MOVVEC+1
    STA AJMVEC+1
    JSR PROCESS
    JMP L1299

L1289

L1299
    LDA #0
    STA 0,X
    STA 1,X         ; Returncode --> WORK!!!
   
    LDX XSAVE
    RTS

; >>>>>>> PROCESS <<<<<<<
; --
.IF FORTH
NFA_PROCESS .CBYTE $87, "PROCESS"
LFA_PROCESS .WORD NFA_PREV  ; UPLINK
LFA_PROCESS .WORD NFA_PREV
CFA_PROCESS .WORD PFA_PROCESS
PFA_PROCESS
    JSR PROCESS
    JMP NEXT
.ENDIF

count .BYTE 0

PROCESS
    M_FRAME 4,5,28,4

    LDA #0
    STA ERRORCD 
    JSR COUNTMARK
    LDA 0,X
    BNE PROCESS3
    LDA CABSA
    STA 0,X
    JSR TOGGLEENTRY

PROCESS3
    LDY NUMDA

PROCESS1
    STY COUNT
    STY 0,X
    JSR GETMARK
    CMP #$20    ; blank ?
    BEQ PROCESS4

    LDA COUNT
    STA 0,X
    JSR GETLOCK
    STA ACTLOCK

    LDA COUNT
    STA 0,X
    JSR DOSSTR
    JSR PROCESSTEXT

    LDA ERRORCD
    BEQ PROCESS2    ; Abort
    CMP #1          ; Skip File ?
    BEQ PROCESS4

    STX XSAVE
    JSR DOVEC       ; jump through vector
    LDX XSAVE
PROCESS4
    LDY COUNT
    BEQ PROCESS2
    DEY
    JMP PROCESS1

PROCESS2
    JSR REFFRM

    JSR L_READLEFT
    JSR L_READRIGHT

PROCESS5
    JSR SETACTFR
    JSR CALCCABS
    SEC
    LDA NUMDA
    SBC CABSA
    BPL PROCESS6
    LDA #1
    JSR CRSUP
    JMP PROCESS5

PROCESS6
    JSR CLRFRMLEFT
    JSR CLRFRMRIGHT

    JSR L_UPDLEFT
    JSR L_UPDRIGHT
    RTS

PROCESSTEXT
    M_POS 5,6
    M_PRINT P_PROC
    M_POS 5,7
    LDA #bl
    LDY #17
    JSR XTIMES
    M_POS 5,7
    M_PRINT P_DSTR
    LDA ERRORCD
    CMP #3              ; Yes to all?
    BEQ PROCESSTEXT1
    M_POS 5,8
    M_PRINT P_ASTR
    JSR GETCH
    LDY #4
PROCESSTEXT2
    DEY
    BEQ PROCESSTEXT3
    CMP QSTR,Y
    BNE PROCESSTEXT2
PROCESSTEXT3    
    TYA
    STA ERRORCD    
PROCESSTEXT1
    RTS

DOVEC
    LDA AJMVEC      ; get current action vector
    STA N
    LDA AJMVEC+1    
    STA N+1
    JMP (N)         ; and jump through vector


    

